/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import io.horizen.params.MainNetParams;
import io.horizen.params.NetworkParams;
import io.horizen.utils.CompactSize;
import io.horizen.utils.Utils;
import java.util.Arrays;
import java.util.Collection;
import sparkz.util.encode.Base58;

public final class BytesUtils {
    public static final int HORIZEN_PUBLIC_KEY_ADDRESS_HASH_LENGTH = 20;
    public static final int HORIZEN_MC_TRANSPARENT_ADDRESS_BASE_58_LENGTH = 35;
    public static final int HORIZEN_MC_SIGNATURE_BASE_64_LENGTH = 88;
    private static final int HORIZEN_PUBLIC_KEY_ADDRESS_PREFIX_LENGTH = 2;
    private static final int HORIZEN_PUBLIC_KEY_ADDRESS_CHECKSUM_LENGTH = 4;
    private static final byte[] PUBLIC_KEY_MAINNET_PREFIX = BytesUtils.fromHexString("2089");
    private static final byte[] PUBLIC_KEY_MAINNET_PREFIX_OLD = BytesUtils.fromHexString("1CB8");
    private static final byte[] PUBLIC_KEY_TESTNET_PREFIX = BytesUtils.fromHexString("2098");
    private static final byte[] PUBLIC_KEY_TESTNET_PREFIX_OLD = BytesUtils.fromHexString("1D25");

    private BytesUtils() {
    }

    public static short getShort(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 2) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Shorts.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1]);
    }

    public static short getReversedShort(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 2) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Shorts.fromBytes((byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static int getInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 4) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Ints.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3]);
    }

    public static int getReversedInt(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 4) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Ints.fromBytes((byte)bytes[offset + 3], (byte)bytes[offset + 2], (byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static long getLong(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 8) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Longs.fromBytes((byte)bytes[offset], (byte)bytes[offset + 1], (byte)bytes[offset + 2], (byte)bytes[offset + 3], (byte)bytes[offset + 4], (byte)bytes[offset + 5], (byte)bytes[offset + 6], (byte)bytes[offset + 7]);
    }

    public static long getReversedLong(byte[] bytes, int offset) {
        if (offset < 0 || bytes.length < offset + 8) {
            throw new IllegalArgumentException("Value is out of array bounds");
        }
        return Longs.fromBytes((byte)bytes[offset + 7], (byte)bytes[offset + 6], (byte)bytes[offset + 5], (byte)bytes[offset + 4], (byte)bytes[offset + 3], (byte)bytes[offset + 2], (byte)bytes[offset + 1], (byte)bytes[offset]);
    }

    public static CompactSize getCompactSize(byte[] bytes, int offset) {
        long value;
        int size;
        if (offset < 0 || bytes.length < offset + 1) {
            throw new IllegalArgumentException("CompactSize: Value is out of array bounds");
        }
        byte first = bytes[offset];
        switch (first) {
            case -3: {
                size = 3;
                value = BytesUtils.getReversedShort(bytes, offset + 1) & 0xFFFF;
                if (value >= 253L) break;
                throw new IllegalArgumentException("CompactSize: non-canonical value");
            }
            case -2: {
                size = 5;
                value = (long)BytesUtils.getReversedInt(bytes, offset + 1) & 0xFFFFFFFFL;
                if (value >= 65536L) break;
                throw new IllegalArgumentException("CompactSize: non-canonical value");
            }
            case -1: {
                size = 9;
                value = BytesUtils.getReversedLong(bytes, offset + 1);
                if (value >= 0x100000000L) break;
                throw new IllegalArgumentException("CompactSize: non-canonical value");
            }
            default: {
                size = 1;
                value = first & 0xFF;
            }
        }
        if (value > CompactSize.MAX_SERIALIZED_COMPACT_SIZE) {
            throw new IllegalArgumentException("CompactSize: size too large");
        }
        return new CompactSize(value, size);
    }

    public static byte[] toCompactSizeBytes(CompactSize vi) {
        byte[] res = new byte[vi.size()];
        switch (vi.size()) {
            case 1: {
                res[0] = (byte)(vi.value() & 0xFFL);
                break;
            }
            case 3: {
                res[0] = -3;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                break;
            }
            case 5: {
                res[0] = -2;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                res[3] = (byte)(vi.value() >> 16 & 0xFFL);
                res[4] = (byte)(vi.value() >> 24 & 0xFFL);
                break;
            }
            case 9: {
                res[0] = -1;
                res[1] = (byte)(vi.value() & 0xFFL);
                res[2] = (byte)(vi.value() >> 8 & 0xFFL);
                res[3] = (byte)(vi.value() >> 16 & 0xFFL);
                res[4] = (byte)(vi.value() >> 24 & 0xFFL);
                res[5] = (byte)(vi.value() >> 32 & 0xFFL);
                res[6] = (byte)(vi.value() >> 40 & 0xFFL);
                res[7] = (byte)(vi.value() >> 48 & 0xFFL);
                res[8] = (byte)(vi.value() >> 56 & 0xFFL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect size of CompactSize had been detected:" + vi.size());
            }
        }
        return res;
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] res = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[bytes.length - 1 - i];
        }
        return res;
    }

    public static byte[] fromHexString(String hex) {
        return BaseEncoding.base16().lowerCase().decode((CharSequence)hex.toLowerCase());
    }

    public static String toHexString(byte[] bytes) {
        return BaseEncoding.base16().lowerCase().encode(bytes);
    }

    public static boolean contains(Collection<byte[]> collection, byte[] value) {
        for (byte[] v : collection) {
            if (!Arrays.equals(v, value)) continue;
            return true;
        }
        return false;
    }

    public static byte[] fromHorizenMcTransparentAddress(String address, NetworkParams params) {
        if (address.length() != 35) {
            throw new IllegalArgumentException(String.format("Incorrect Horizen mc transparent address length %d", address.length()));
        }
        byte[] addressBytesWithChecksum = (byte[])Base58.decode((String)address).get();
        byte[] addressBytes = Arrays.copyOfRange(addressBytesWithChecksum, 0, 22);
        byte[] prefix = Arrays.copyOfRange(addressBytes, 0, 2);
        if (params instanceof MainNetParams) {
            if (!Arrays.equals(prefix, PUBLIC_KEY_MAINNET_PREFIX) && !Arrays.equals(prefix, PUBLIC_KEY_MAINNET_PREFIX_OLD)) {
                throw new IllegalArgumentException("Incorrect Horizen public key address format, MainNet format expected.");
            }
        } else if (!Arrays.equals(prefix, PUBLIC_KEY_TESTNET_PREFIX) && !Arrays.equals(prefix, PUBLIC_KEY_TESTNET_PREFIX_OLD)) {
            throw new IllegalArgumentException("Incorrect Horizen public key address format, TestNet format expected.");
        }
        byte[] publicKeyHash = Arrays.copyOfRange(addressBytes, 2, 22);
        byte[] checksum = Arrays.copyOfRange(addressBytesWithChecksum, 22, addressBytesWithChecksum.length);
        byte[] calculatedChecksum = Arrays.copyOfRange(Utils.doubleSHA256Hash(addressBytes), 0, 4);
        if (!Arrays.equals(calculatedChecksum, checksum)) {
            throw new IllegalArgumentException("Broken Horizen public key address: checksum is wrong.");
        }
        return publicKeyHash;
    }

    public static String toHorizenPublicKeyAddress(byte[] publicKeyHashBytes, NetworkParams params) {
        if (publicKeyHashBytes.length != 20) {
            throw new IllegalArgumentException("Incorrect Horizen public key address bytes length.");
        }
        byte[] prefix = params instanceof MainNetParams ? PUBLIC_KEY_MAINNET_PREFIX : PUBLIC_KEY_TESTNET_PREFIX;
        byte[] addressBytes = Bytes.concat((byte[][])new byte[][]{prefix, publicKeyHashBytes});
        byte[] checksum = Arrays.copyOfRange(Utils.doubleSHA256Hash(addressBytes), 0, 4);
        return Base58.encode((byte[])Bytes.concat((byte[][])new byte[][]{addressBytes, checksum}));
    }

    public static int getBytesFromBits(int nbits) {
        if (nbits < 0) {
            return 0;
        }
        int reminder = nbits % 8;
        int bytes = nbits / 8;
        if (reminder > 0) {
            ++bytes;
        }
        return bytes;
    }

    public static byte[] padWithZeroBytes(byte[] src, int destSize) {
        if (src != null && src.length < destSize) {
            byte[] padded_s = new byte[destSize];
            System.arraycopy(src, 0, padded_s, destSize - src.length, src.length);
            return padded_s;
        }
        return src;
    }
}

