/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage.leveldb;

import io.horizen.storage.Storage;
import io.horizen.storage.StorageIterator;
import io.horizen.storage.leveldb.LDBFactory$;
import io.horizen.storage.leveldb.VersionedLDBKVStore;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.package$;
import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001\u0002\r\u001a\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)A\b\u0001C\u0001{!)A\b\u0001C\u0001\u0005\"9A\t\u0001b\u0001\n\u0013)\u0005BB%\u0001A\u0003%a\tC\u0004K\u0001\t\u0007I\u0011B&\t\rI\u0003\u0001\u0015!\u0003M\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015\u0019\u0006\u0001\"\u0011c\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u0015i\b\u0001\"\u0003\u007f\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\u0012\u0001!\t%!\u0006\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0002bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\ty\u0003\u0001C!\u0003c\u0011aDV3sg&|g.\u001a3MKZ,G\u000e\u00122Ti>\u0014\u0018mZ3BI\u0006\u0004H/\u001a:\u000b\u0005iY\u0012a\u00027fm\u0016dGM\u0019\u0006\u00039u\tqa\u001d;pe\u0006<WM\u0003\u0002\u001f?\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u0011\u0002\u0005%|7\u0001A\n\u0004\u0001\rZ\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011a\u0017M\\4\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u00051jS\"A\u000e\n\u00059Z\"aB*u_J\fw-Z\u0001\ta\u0006$\b\u000eV8E\u0005B\u0011\u0011gM\u0007\u0002e)\u0011\u0001eJ\u0005\u0003iI\u0012AAR5mK\u0006qa/\u001a:tS>t7\u000fV8LK\u0016\u0004\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi\u00061A(\u001b8jiz\"2A\u0010!B!\ty\u0004!D\u0001\u001a\u0011\u0015y3\u00011\u00011\u0011\u0015)4\u00011\u00017)\tq4\tC\u00030\t\u0001\u0007\u0001'\u0001\u0005eCR\f')Y:f+\u00051\u0005CA H\u0013\tA\u0015DA\nWKJ\u001c\u0018n\u001c8fI2#%i\u0013,Ti>\u0014X-A\u0005eCR\f')Y:fA\u0005Ya/\u001a:tS>t7oS3z+\u0005a\u0005CA'Q\u001b\u0005q%BA(\u001e\u0003\u0015)H/\u001b7t\u0013\t\tfJ\u0001\tCsR,\u0017I\u001d:bs^\u0013\u0018\r\u001d9fe\u0006aa/\u001a:tS>t7oS3zA\u0005\u0019q-\u001a;\u0015\u0005U[\u0006c\u0001,Z\u00196\tqK\u0003\u0002YO\u0005!Q\u000f^5m\u0013\tQvK\u0001\u0005PaRLwN\\1m\u0011\u0015a\u0016\u00021\u0001M\u0003\rYW-_\u0001\nO\u0016$xJ]#mg\u0016$2\u0001T0a\u0011\u0015a&\u00021\u0001M\u0011\u0015\t'\u00021\u0001M\u00031!WMZ1vYR4\u0016\r\\;f)\t\u0019\u0017\u000eE\u0002WI\u001aL!!Z,\u0003\t1K7\u000f\u001e\t\u0005\u001b\u001edU+\u0003\u0002i\u001d\n!\u0001+Y5s\u0011\u0015Q7\u00021\u0001l\u0003\u0011YW-_:\u0011\u0007Y#G*\u0001\u0004hKR\fE\u000e\u001c\u000b\u0002]B\u0019a\u000bZ8\u0011\t5;G\nT\u0001\u000eY\u0006\u001cHOV3sg&|g.\u0013#\u0015\u0003U\u000ba!\u001e9eCR,G\u0003\u0002;xsn\u0004\"aN;\n\u0005YD$\u0001B+oSRDQ\u0001\u001f\bA\u00021\u000bqA^3sg&|g\u000eC\u0003{\u001d\u0001\u0007a.\u0001\u0005u_V\u0003H-\u0019;f\u0011\u0015ah\u00021\u0001l\u0003!!xNU3n_Z,\u0017AD5t-\u0016\u00148/[8o\u000bbL7\u000f\u001e\u000b\u0004\u007f\u0006\u0015\u0001cA\u001c\u0002\u0002%\u0019\u00111\u0001\u001d\u0003\u000f\t{w\u000e\\3b]\"1\u0011qA\bA\u00021\u000b\u0001C^3sg&|gNR8s'\u0016\f'o\u00195\u0002\u0011I|G\u000e\u001c2bG.$2\u0001^A\u0007\u0011\u0019\ty\u0001\u0005a\u0001\u0019\u0006Ia/\u001a:tS>t\u0017\nR\u0001\u0011e>dGNY1dWZ+'o]5p]N$\u0012a\u001b\u000b\u0004W\u0006]\u0001BBA\r%\u0001\u0007a'\u0001\tnCbtU/\u001c2fe>3\u0017\n^3ng\u0006)1\r\\8tKR\tA/\u0001\u0005de\u0016\fG/\u001a#c)\r1\u00151\u0005\u0005\u0007\u0003K!\u0002\u0019\u0001\u0019\u0002\tA\fG\u000f[\u0001\bSN,U\u000e\u001d;z)\u0005y\u0018\u0001\u00058v[\n,'o\u00144WKJ\u001c\u0018n\u001c8t)\u00051\u0014aC4fi&#XM]1u_J$\"!a\r\u0011\u00071\n)$C\u0002\u00028m\u0011qb\u0015;pe\u0006<W-\u0013;fe\u0006$xN\u001d")
public class VersionedLevelDbStorageAdapter
implements Storage {
    private final int versionsToKeep;
    private final VersionedLDBKVStore dataBase;
    private final ByteArrayWrapper versionsKey;

    private VersionedLDBKVStore dataBase() {
        return this.dataBase;
    }

    private ByteArrayWrapper versionsKey() {
        return this.versionsKey;
    }

    @Override
    public Optional<ByteArrayWrapper> get(ByteArrayWrapper key) {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.dataBase().get(package$.MODULE$.wrapperToByteArray(key)).map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray))));
    }

    @Override
    public ByteArrayWrapper getOrElse(ByteArrayWrapper key, ByteArrayWrapper defaultValue) {
        return package$.MODULE$.byteArrayToWrapper(this.dataBase().getOrElse(package$.MODULE$.wrapperToByteArray(key), (Function0<byte[]>)(Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.wrapperToByteArray(defaultValue)));
    }

    @Override
    public java.util.List<Pair<ByteArrayWrapper, Optional<ByteArrayWrapper>>> get(java.util.List<ByteArrayWrapper> keys) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.dataBase().get((Seq<byte[]>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(keys).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data(), Buffer$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] key = (byte[])tuple2._1();
            Option value = (Option)tuple2._2();
            Pair<ByteArrayWrapper, Optional> pair = new Pair<ByteArrayWrapper, Optional>(package$.MODULE$.byteArrayToWrapper(key), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(value.map((Function1 & Serializable & scala.Serializable)v -> package$.MODULE$.byteArrayToWrapper((byte[])v)))));
            return pair;
        }, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<Pair<ByteArrayWrapper, ByteArrayWrapper>> getAll() {
        ByteArrayWrapper byteArrayWrapper = this.versionsKey();
        Set excludedKeys = ((TraversableOnce)((SeqLike)this.dataBase().versions().map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)byteArrayWrapper, Seq$.MODULE$.canBuildFrom())).toSet();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableViewLike)this.dataBase().getAll().view().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] key = (byte[])tuple2._1();
            byte[] value = (byte[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)package$.MODULE$.byteArrayToWrapper(key), (Object)package$.MODULE$.byteArrayToWrapper(value));
            return tuple22;
        }, SeqView$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)VersionedLevelDbStorageAdapter.$anonfun$getAll$3(excludedKeys, x0$2))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ByteArrayWrapper key = (ByteArrayWrapper)tuple2._1();
            ByteArrayWrapper value = (ByteArrayWrapper)tuple2._2();
            Pair<ByteArrayWrapper, ByteArrayWrapper> pair = new Pair<ByteArrayWrapper, ByteArrayWrapper>(package$.MODULE$.byteArrayToWrapper(package$.MODULE$.wrapperToByteArray(key)), package$.MODULE$.byteArrayToWrapper(package$.MODULE$.wrapperToByteArray(value)));
            return pair;
        }, SeqView$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public Optional<ByteArrayWrapper> lastVersionID() {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.dataBase().versions().headOption().map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray))));
    }

    @Override
    public void update(ByteArrayWrapper version, java.util.List<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate, java.util.List<ByteArrayWrapper> toRemove) {
        List toUpdateAsScala = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(toUpdate).asScala()).toList();
        List toRemoveAsScala = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(toRemove).asScala()).toList();
        Predef$.MODULE$.require(!toUpdateAsScala.exists((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)VersionedLevelDbStorageAdapter.$anonfun$update$1(version, pair))) && !toRemoveAsScala.contains((Object)version));
        Predef$.MODULE$.require(((TraversableOnce)toUpdateAsScala.map((Function1 & Serializable & scala.Serializable)x$3 -> (ByteArrayWrapper)x$3.getKey(), List$.MODULE$.canBuildFrom())).toSet().size() == toUpdateAsScala.size(), (Function0 & Serializable & scala.Serializable)() -> "duplicate key in `toUpdate`");
        Predef$.MODULE$.require(toRemoveAsScala.toSet().size() == toRemoveAsScala.size(), (Function0 & Serializable & scala.Serializable)() -> "duplicate key in `toRemove`");
        Predef$.MODULE$.require(!this.isVersionExist(version), (Function0 & Serializable & scala.Serializable)() -> "Version is already exist in storage");
        List convertedToUpdate = (List)toUpdateAsScala.map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2((Object)((ByteArrayWrapper)pair.getKey()).data(), (Object)((ByteArrayWrapper)pair.getValue()).data()), List$.MODULE$.canBuildFrom());
        List convertedToRemove = (List)toRemoveAsScala.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.data(), List$.MODULE$.canBuildFrom());
        this.dataBase().update((Seq<Tuple2<byte[], byte[]>>)convertedToUpdate, (Seq<byte[]>)convertedToRemove, package$.MODULE$.wrapperToByteArray(version));
    }

    private boolean isVersionExist(ByteArrayWrapper versionForSearch) {
        return ((SeqLike)this.dataBase().versions().map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray), Seq$.MODULE$.canBuildFrom())).contains((Object)versionForSearch);
    }

    @Override
    public void rollback(ByteArrayWrapper versionID) {
        if (!this.isVersionExist(versionID)) {
            throw new IllegalArgumentException("Rollback to non exist version");
        }
        this.dataBase().rollbackTo(package$.MODULE$.wrapperToByteArray(versionID));
    }

    @Override
    public java.util.List<ByteArrayWrapper> rollbackVersions() {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.dataBase().versions().map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public java.util.List<ByteArrayWrapper> rollbackVersions(int maxNumberOfItems) {
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)this.dataBase().versions().slice(0, maxNumberOfItems)).map((Function1 & Serializable & scala.Serializable)byArray -> package$.MODULE$.byteArrayToWrapper((byte[])byArray), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Override
    public void close() {
        this.dataBase().close();
    }

    private VersionedLDBKVStore createDb(File path) {
        path.mkdirs();
        Options options = new Options();
        options.createIfMissing(true);
        DB db = LDBFactory$.MODULE$.factory().open(path, options);
        return new VersionedLDBKVStore(db, this.versionsToKeep);
    }

    @Override
    public boolean isEmpty() {
        return this.dataBase().versions().isEmpty();
    }

    @Override
    public int numberOfVersions() {
        return this.dataBase().versions().size();
    }

    @Override
    public StorageIterator getIterator() {
        return this.dataBase().getIterator();
    }

    public static final /* synthetic */ boolean $anonfun$getAll$3(Set excludedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ByteArrayWrapper key = (ByteArrayWrapper)tuple2._1();
        boolean bl = excludedKeys$1.contains((Object)key);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$1(ByteArrayWrapper version$1, Pair pair) {
        Object k = pair.getKey();
        ByteArrayWrapper byteArrayWrapper = version$1;
        return !(k != null ? !k.equals(byteArrayWrapper) : byteArrayWrapper != null);
    }

    public VersionedLevelDbStorageAdapter(File pathToDB, int versionsToKeep) {
        this.versionsToKeep = versionsToKeep;
        this.dataBase = this.createDb(pathToDB);
        this.versionsKey = new ByteArrayWrapper(this.dataBase().VersionsKey());
    }

    public VersionedLevelDbStorageAdapter(File pathToDB) {
        this(pathToDB, 1441);
    }
}

