/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.secret;

import io.horizen.secret.SchnorrSecret;
import io.horizen.secret.SecretSerializer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public class SchnorrSecretSerializer
implements SecretSerializer<SchnorrSecret> {
    private static SchnorrSecretSerializer serializer = new SchnorrSecretSerializer();

    private SchnorrSecretSerializer() {
    }

    public static SchnorrSecretSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(SchnorrSecret secret, Writer writer) {
        writer.putBytes(secret.secretBytes);
        writer.putBytes(secret.publicBytes);
    }

    @Override
    public SchnorrSecret parse(Reader reader) {
        byte[] publicKey;
        byte[] secretKey = reader.getBytes(SchnorrSecret.SECRET_KEY_LENGTH);
        SchnorrSecret schnorrSecret = new SchnorrSecret(secretKey, publicKey = reader.getBytes(SchnorrSecret.PUBLIC_KEY_LENGTH));
        if (!schnorrSecret.isPublicKeyValid().booleanValue()) {
            throw new IllegalArgumentException("The public key is not corresponds to the secret key.");
        }
        return schnorrSecret;
    }
}

