/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.cryptolibprovider.CryptoLibProvider;
import io.horizen.json.Views;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.PropositionSerializer;
import io.horizen.proposition.SchnorrPropositionSerializer;
import io.horizen.proposition.SingleSecretProofOfKnowledgeProposition;
import io.horizen.secret.SchnorrSecret;
import java.util.Arrays;
import java.util.Objects;

@JsonView(value={Views.Default.class})
@JsonIgnoreProperties(value={"valid"})
public class SchnorrProposition
implements SingleSecretProofOfKnowledgeProposition<SchnorrSecret> {
    public static final int KEY_LENGTH = CryptoLibProvider.schnorrFunctions().schnorrPublicKeyLength();
    private final byte[] publicBytes;

    public SchnorrProposition(byte[] publicKey) {
        this(publicKey, false);
    }

    public SchnorrProposition(byte[] publicKey, boolean checkPublicKey) {
        Objects.requireNonNull(publicKey, "Public key can't be null");
        if (publicKey.length != KEY_LENGTH) {
            throw new IllegalArgumentException(String.format("Incorrect pubKey length, %d expected, %d found", KEY_LENGTH, publicKey.length));
        }
        if (checkPublicKey && !CryptoLibProvider.schnorrFunctions().publicKeyIsValid(publicKey)) {
            throw new IllegalArgumentException("Public key is not valid.");
        }
        this.publicBytes = Arrays.copyOf(publicKey, publicKey.length);
    }

    public boolean verify(byte[] message, SchnorrProof signature) {
        return CryptoLibProvider.schnorrFunctions().verify(message, this.pubKeyBytes(), signature.bytes());
    }

    @Override
    @JsonProperty(value="publicKey")
    public byte[] pubKeyBytes() {
        return Arrays.copyOf(this.publicBytes, this.publicBytes.length);
    }

    @Override
    public PropositionSerializer serializer() {
        return SchnorrPropositionSerializer.getSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchnorrProposition that = (SchnorrProposition)o;
        return Arrays.equals(this.publicBytes, that.publicBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.publicBytes);
    }

    public String toString() {
        return "SchnorrPublicKey{publicBytes=" + Arrays.toString(this.publicBytes) + "}";
    }

    public boolean isValid() {
        return CryptoLibProvider.schnorrFunctions().publicKeyIsValid(this.pubKeyBytes());
    }
}

