/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proposition;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.horizen.json.Views;
import io.horizen.json.serializer.JsonHorizenPublicKeyHashSerializer;
import io.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PropositionSerializer;
import io.horizen.utils.BytesUtils;
import java.util.Arrays;

@JsonView(value={Views.Default.class})
public final class MCPublicKeyHashProposition
implements Proposition {
    public static final int KEY_LENGTH = 20;
    @JsonProperty(value="mainchainAddress")
    @JsonSerialize(using=JsonHorizenPublicKeyHashSerializer.class)
    final byte[] pubKeyHashBytes;

    public MCPublicKeyHashProposition(byte[] bytes) {
        if (bytes.length != 20) {
            throw new IllegalArgumentException(String.format("Incorrect pubKeyHash length, %d expected, %d found", 20, bytes.length));
        }
        this.pubKeyHashBytes = Arrays.copyOf(bytes, 20);
    }

    @Override
    public PropositionSerializer serializer() {
        return MCPublicKeyHashPropositionSerializer.getSerializer();
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubKeyHashBytes);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MCPublicKeyHashProposition)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return Arrays.equals(this.pubKeyHashBytes, ((MCPublicKeyHashProposition)obj).bytes());
    }

    public String toString() {
        return BytesUtils.toHexString(this.pubKeyHashBytes);
    }

    public static int getLength() {
        return 20;
    }
}

