/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.json.serializer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule;
import io.horizen.json.Views;
import io.horizen.json.serializer.ByteArrayWrapperSerializer;
import io.horizen.json.serializer.BytesSerializer;
import io.horizen.utils.ByteArrayWrapper;

public class ApplicationJsonSerializer {
    private Class<?> defaultView = Views.Default.class;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static ApplicationJsonSerializer instance;

    private ApplicationJsonSerializer() {
    }

    public static ApplicationJsonSerializer getInstance() {
        if (instance == null) {
            instance = new ApplicationJsonSerializer();
            instance.setDefaultConfiguration();
        }
        return instance;
    }

    public static ApplicationJsonSerializer newInstance() {
        ApplicationJsonSerializer newInstance = new ApplicationJsonSerializer();
        newInstance.setDefaultConfiguration();
        return newInstance;
    }

    public Class<?> getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(Class<?> defaultView) {
        this.defaultView = defaultView;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setDefaultConfiguration() {
        this.objectMapper.registerModule((Module)new DefaultScalaModule());
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        SimpleModule module = new SimpleModule();
        module.addSerializer(byte[].class, (JsonSerializer)new BytesSerializer());
        module.addSerializer(ByteArrayWrapper.class, (JsonSerializer)new ByteArrayWrapperSerializer());
        this.objectMapper.registerModule((Module)module);
    }

    public String serialize(Object value) throws Exception {
        return this.objectMapper.writerWithView(this.defaultView).writeValueAsString(value);
    }
}

