/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.fork;

import io.horizen.fork.ForkConfigurator;
import io.horizen.fork.ForkUtil$;
import io.horizen.fork.MainchainFork;
import io.horizen.fork.MainchainFork$;
import io.horizen.fork.MandatorySidechainFork;
import io.horizen.fork.OptionalSidechainFork;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.reflect.Manifest;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class ForkManager$ {
    public static ForkManager$ MODULE$;
    private boolean initialized;
    private Map<Object, MainchainFork> mainchainForks;
    private Map<Object, MandatorySidechainFork> sidechainForks;
    private Seq<Tuple2<Object, OptionalSidechainFork>> optionalSidechainForks;

    static {
        new ForkManager$();
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Map<Object, MainchainFork> mainchainForks() {
        return this.mainchainForks;
    }

    private void mainchainForks_$eq(Map<Object, MainchainFork> x$1) {
        this.mainchainForks = x$1;
    }

    private Map<Object, MandatorySidechainFork> sidechainForks() {
        return this.sidechainForks;
    }

    private void sidechainForks_$eq(Map<Object, MandatorySidechainFork> x$1) {
        this.sidechainForks = x$1;
    }

    private Seq<Tuple2<Object, OptionalSidechainFork>> optionalSidechainForks() {
        return this.optionalSidechainForks;
    }

    private void optionalSidechainForks_$eq(Seq<Tuple2<Object, OptionalSidechainFork>> x$1) {
        this.optionalSidechainForks = x$1;
    }

    private <T> Option<T> findActiveFork(Traversable<Tuple2<Object, T>> forks, int height) {
        Option option;
        Object object = new Object();
        try {
            option = (Option)forks.foldLeft((Object)Option$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option active = (Option)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 == null) throw new MatchError((Object)tuple2);
                int activation = tuple22._1$mcI$sp();
                Object fork = tuple22._2();
                if (activation > height) throw new NonLocalReturnControl(object, (Object)active);
                return new Some(fork);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private void assertInitialized() {
        if (!this.initialized()) {
            throw new RuntimeException("Forkmanager hasn't been initialized.");
        }
    }

    public MainchainFork getMainchainFork(int mainchainHeight) {
        this.assertInitialized();
        return (MainchainFork)this.findActiveFork((Traversable)this.mainchainForks(), mainchainHeight).orNull(Predef$.MODULE$.$conforms());
    }

    public MandatorySidechainFork getSidechainFork(int consensusEpoch) {
        this.assertInitialized();
        return (MandatorySidechainFork)this.findActiveFork((Traversable)this.sidechainForks(), consensusEpoch).orNull(Predef$.MODULE$.$conforms());
    }

    public <T extends OptionalSidechainFork> Option<T> getOptionalSidechainFork(int consensusEpoch, Manifest<T> evidence$1) {
        this.assertInitialized();
        Seq forksOfTypeT = (Seq)this.optionalSidechainForks().collect((PartialFunction)new scala.Serializable(evidence$1){
            public static final long serialVersionUID = 0L;
            private final Manifest evidence$1$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, OptionalSidechainFork>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    int i = A1._1$mcI$sp();
                    OptionalSidechainFork fork = (OptionalSidechainFork)A1._2();
                    Option option = this.evidence$1$1.unapply((Object)fork);
                    if (!option.isEmpty() && option.get() != null) {
                        object = new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)fork);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, OptionalSidechainFork> x1) {
                OptionalSidechainFork fork;
                Option option;
                Tuple2<Object, OptionalSidechainFork> tuple2 = x1;
                boolean bl = tuple2 != null && !(option = this.evidence$1$1.unapply((Object)(fork = (OptionalSidechainFork)tuple2._2()))).isEmpty() && option.get() != null;
                return bl;
            }
            {
                this.evidence$1$1 = evidence$1$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return this.findActiveFork((Traversable<Tuple2<Object, T>>)forksOfTypeT, consensusEpoch);
    }

    public void init(ForkConfigurator forkConfigurator, String networkName) {
        if (this.initialized()) {
            throw new IllegalStateException("ForkManager is already initialized.");
        }
        ForkUtil$.MODULE$.validate(MainchainFork$.MODULE$.forks());
        forkConfigurator.check();
        this.mainchainForks_$eq((Map<Object, MainchainFork>)ForkUtil$.MODULE$.selectNetwork(networkName, MainchainFork$.MODULE$.forks()).toMap(Predef$.MODULE$.$conforms()));
        this.sidechainForks_$eq((Map<Object, MandatorySidechainFork>)ForkUtil$.MODULE$.selectNetwork(networkName, forkConfigurator.mandatorySidechainForks()).toMap(Predef$.MODULE$.$conforms()));
        this.optionalSidechainForks_$eq((Seq<Tuple2<Object, OptionalSidechainFork>>)ForkUtil$.MODULE$.selectNetwork(networkName, forkConfigurator.optionalSidechainForks()).toSeq());
        this.initialized_$eq(true);
    }

    public void reset() {
        this.initialized_$eq(false);
    }

    private ForkManager$() {
        MODULE$ = this;
        this.initialized = false;
    }
}

