/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.certificatesubmitter.strategies;

import com.horizen.certnative.BackwardTransfer;
import io.horizen.AbstractState;
import io.horizen.SidechainSettings;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.AbstractCertificateSubmitter;
import io.horizen.certificatesubmitter.dataproof.CertificateDataWithKeyRotation;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.SchnorrKeysSignatures;
import io.horizen.certificatesubmitter.strategies.CircuitStrategy;
import io.horizen.cryptolibprovider.ThresholdSignatureCircuitWithKeyRotation;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.transaction.Transaction;
import io.horizen.utils.Pair;
import java.io.Serializable;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0005\u000b\u0001MA\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\tK\u0002\u0011\t\u0011)A\u0005M\"A1\u000e\u0001B\u0001B\u0003%A\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002<\u0001!\t%!\u0010\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011Q\u0015\u0001\u0005\n\u0005\u001d&AH,ji\"\\U-\u001f*pi\u0006$\u0018n\u001c8DSJ\u001cW/\u001b;TiJ\fG/Z4z\u0015\tYA\"\u0001\u0006tiJ\fG/Z4jKNT!!\u0004\b\u0002)\r,'\u000f^5gS\u000e\fG/Z:vE6LG\u000f^3s\u0015\ty\u0001#A\u0004i_JL'0\u001a8\u000b\u0003E\t!![8\u0004\u0001U1AcG\u00166yQ\u001b\"\u0001A\u000b\u0011\u0011Y9\u0012D\u000b\u001b<'nk\u0011AC\u0005\u00031)\u0011qbQ5sGVLGo\u0015;sCR,w-\u001f\t\u00035ma\u0001\u0001B\u0003\u001d\u0001\t\u0007QD\u0001\u0002U1F\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\b\u001d>$\b.\u001b8h!\t)\u0003&D\u0001'\u0015\t9c\"A\u0006ue\u0006t7/Y2uS>t\u0017BA\u0015'\u0005-!&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005iYC!\u0002\u0017\u0001\u0005\u0004i#!\u0001%\u0012\u0005yq\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u000f\u0003\u0015\u0011Gn\\2l\u0013\t\u0019\u0004G\u0001\rTS\u0012,7\r[1j]\ncwnY6IK\u0006$WM\u001d\"bg\u0016\u0004\"AG\u001b\u0005\u000bY\u0002!\u0019A\u001c\u0003\u0005Ak\u0015C\u0001\u00109!\u0011y\u0013(\u0007\u0016\n\u0005i\u0002$AE*jI\u0016\u001c\u0007.Y5o\u00052|7m\u001b\"bg\u0016\u0004\"A\u0007\u001f\u0005\u000bu\u0002!\u0019\u0001 \u0003\u0007!K5+\u0005\u0002\u001f\u007fA\"\u0001i\u0012(R!!\tE)\u0007\u00165\r6\u0003V\"\u0001\"\u000b\u0005\rs\u0011a\u00025jgR|'/_\u0005\u0003\u000b\n\u0013q\"\u00112tiJ\f7\r\u001e%jgR|'/\u001f\t\u00035\u001d#\u0011\u0002\u0013\u001f\u0002\u0002\u0003\u0005)\u0011A%\u0003\u0007}#\u0013'\u0005\u0002\u001f\u0015B\u0011qdS\u0005\u0003\u0019\u0002\u00121!\u00118z!\tQb\nB\u0005Py\u0005\u0005\t\u0011!B\u0001\u0013\n\u0019q\f\n\u001a\u0011\u0005i\tF!\u0003*=\u0003\u0003\u0005\tQ!\u0001J\u0005\ryFe\r\t\u00035Q#Q!\u0016\u0001C\u0002Y\u0013!!T*\u0012\u0005y9\u0006C\u0002-Z3)\"4+D\u0001\u000f\u0013\tQfBA\u0007BEN$(/Y2u'R\fG/\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=2\t\u0011\u0002Z1uCB\u0014xn\u001c4\n\u0005\u0001l&AH\"feRLg-[2bi\u0016$\u0015\r^1XSRD7*Z=S_R\fG/[8o\u0003!\u0019X\r\u001e;j]\u001e\u001c\bC\u0001-d\u0013\t!gBA\tTS\u0012,7\r[1j]N+G\u000f^5oON\fa\u0001]1sC6\u001c\bCA4j\u001b\u0005A'BA3\u000f\u0013\tQ\u0007NA\u0007OKR<xN]6QCJ\fWn]\u0001\bG&\u00148-^5u!\ti\u0007/D\u0001o\u0015\tyg\"A\tdef\u0004Ho\u001c7jEB\u0014xN^5eKJL!!\u001d8\u0003QQC'/Z:i_2$7+[4oCR,(/Z\"je\u000e,\u0018\u000e^,ji\"\\U-\u001f*pi\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0011!XO^<\u0011\u000fY\u0001\u0011D\u000b\u001b<'\")\u0011\r\u0002a\u0001E\")Q\r\u0002a\u0001M\")1\u000e\u0002a\u0001Y\u0006iq-\u001a8fe\u0006$X\r\u0015:p_\u001a$RA_A\u000f\u0003C\u0001ba\u001f@\u0002\u0002\u00055Q\"\u0001?\u000b\u0005ut\u0011!B;uS2\u001c\u0018BA@}\u0005\u0011\u0001\u0016-\u001b:\u0011\u000b}\t\u0019!a\u0002\n\u0007\u0005\u0015\u0001EA\u0003BeJ\f\u0017\u0010E\u0002 \u0003\u0013I1!a\u0003!\u0005\u0011\u0011\u0015\u0010^3\u0011\t\u0005=\u0011\u0011D\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u0005!A.\u00198h\u0015\t\t9\"\u0001\u0003kCZ\f\u0017\u0002BA\u000e\u0003#\u0011A\u0001T8oO\"1\u0011qD\u0003A\u0002m\u000bqbY3si&4\u0017nY1uK\u0012\u000bG/\u0019\u0005\b\u0003G)\u0001\u0019AA\u0013\u0003]\u0001(o\u001c<j]\u001e4\u0015\u000e\\3BEN|G.\u001e;f!\u0006$\b\u000e\u0005\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003c\u00012!a\u000b!\u001b\t\tiCC\u0002\u00020I\ta\u0001\u0010:p_Rt\u0014bAA\u001aA\u00051\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\r!\u0003Q\u0011W/\u001b7e\u0007\u0016\u0014H/\u001b4jG\u0006$X\rR1uCR91,a\u0010\u0002B\u0005\u0015\u0003\"B\"\u0007\u0001\u0004Y\u0004BBA\"\r\u0001\u00071+A\u0003ti\u0006$X\rC\u0004\u0002H\u0019\u0001\r!!\u0013\u0002\rM$\u0018\r^;t!\u0011\tY%!\u0018\u000f\t\u00055\u0013\u0011\f\b\u0005\u0003\u001f\n9F\u0004\u0003\u0002R\u0005Uc\u0002BA\u0016\u0003'J\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0007\u0005mC\"\u0001\u000fBEN$(/Y2u\u0007\u0016\u0014H/\u001b4jG\u0006$XmU;c[&$H/\u001a:\n\t\u0005}\u0013\u0011\r\u0002\u0011'&<g.\u0019;ve\u0016\u001c8\u000b^1ukNT1!a\u0017\r\u0003u9W\r^'fgN\fw-\u001a+p'&<g.\u00118e!V\u0014G.[2LKf\u001cH\u0003CA4\u0003/\u000bI*a'\u0011\r\u0005%\u0014qNA:\u001b\t\tYGC\u0002\u0002n\u0001\nA!\u001e;jY&!\u0011\u0011OA6\u0005\r!&/\u001f\t\b?\u0005U\u0014\u0011AA=\u0013\r\t9\b\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\r\u0005m\u0014QQAF\u001d\u0011\ti(!!\u000f\t\u0005-\u0012qP\u0005\u0002C%\u0019\u00111\u0011\u0011\u0002\u000fA\f7m[1hK&!\u0011qQAE\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0007\u0003\u0003\u0003BAG\u0003'k!!a$\u000b\u0007\u0005Ee\"A\u0006qe>\u0004xn]5uS>t\u0017\u0002BAK\u0003\u001f\u0013!cU2i]>\u0014(\u000f\u0015:pa>\u001c\u0018\u000e^5p]\")1i\u0002a\u0001w!1\u00111I\u0004A\u0002MCq!!(\b\u0001\u0004\ty*A\u0010sK\u001a,'/\u001a8dK\u0012<\u0016\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eDg*^7cKJ\u00042aHAQ\u0013\r\t\u0019\u000b\t\u0002\u0004\u0013:$\u0018\u0001G4fiN\u001b\u0007N\\8se.+\u0017p]*jO:\fG/\u001e:fgR1\u0011\u0011VA[\u0003o\u0003B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_c\u0011\u0001B6fsNLA!a-\u0002.\n)2k\u00195o_J\u00148*Z=t'&<g.\u0019;ve\u0016\u001c\bBBA\"\u0011\u0001\u00071\u000bC\u0004\u0002\u001e\"\u0001\r!a(")
public class WithKeyRotationCircuitStrategy<TX extends Transaction, H extends SidechainBlockHeaderBase, PM extends SidechainBlockBase<TX, H>, HIS extends AbstractHistory<TX, H, PM, ?, ?, ?>, MS extends AbstractState<TX, H, PM, MS>>
extends CircuitStrategy<TX, H, PM, HIS, MS, CertificateDataWithKeyRotation> {
    private final NetworkParams params;
    private final ThresholdSignatureCircuitWithKeyRotation circuit;

    @Override
    public Pair<byte[], Long> generateProof(CertificateDataWithKeyRotation certificateData, String provingFileAbsolutePath) {
        BoxedUnit boxedUnit;
        Seq seq;
        Seq signaturesBytes;
        block6: {
            Tuple2 tuple2;
            block5: {
                tuple2 = ((GenericTraversableTemplate)certificateData.schnorrKeyPairs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SchnorrProposition proposition = (SchnorrProposition)tuple2._1();
                    Option proof = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)proposition.bytes(), (Object)OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(proof.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.bytes()))));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple2 == null) break block5;
                signaturesBytes = (Seq)tuple2._2();
                if (tuple2._1() != null && signaturesBytes != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = seq = signaturesBytes;
        Seq signaturesBytes2 = seq2;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info(new StringBuilder(101).append("Start generating proof with parameters: certificateData = ").append(certificateData).append(", ").append("signersThreshold = ").append(this.params.signersThreshold()).append(". ").append("It can take a while.").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Enumeration.Value sidechainCreationVersion = this.params.sidechainCreationVersion();
        return this.circuit.createProof((List)JavaConverters$.MODULE$.seqAsJavaListConverter(certificateData.backwardTransfers()).asJava(), certificateData.sidechainId(), certificateData.referencedEpochNumber(), certificateData.endEpochCumCommTreeHash(), certificateData.btrFee(), certificateData.ftMinAmount(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(signaturesBytes2).asJava(), certificateData.schnorrKeysSignatures(), this.params.signersThreshold(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(certificateData.previousCertificateOption())), sidechainCreationVersion.id(), certificateData.genesisKeysRootHash(), provingFileAbsolutePath, true, true);
    }

    @Override
    public CertificateDataWithKeyRotation buildCertificateData(HIS history, MS state, AbstractCertificateSubmitter.SignaturesStatus status) {
        Seq<BackwardTransfer> backwardTransfers = ((AbstractState)state).backwardTransfers(status.referencedEpoch());
        long btrFee = this.getBtrFee(status.referencedEpoch());
        long ftMinAmount = this.getFtMinAmount(status.referencedEpoch());
        byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, status.referencedEpoch());
        byte[] sidechainId = this.params.sidechainId();
        Option<WithdrawalEpochCertificate> previousCertificateOption = ((AbstractState)state).certificate(status.referencedEpoch() - 1);
        SchnorrKeysSignatures schnorrKeysSignatures = this.getSchnorrKeysSignatures(state, status.referencedEpoch());
        Seq signersPublicKeyWithSignatures = (Seq)((TraversableLike)schnorrKeysSignatures.schnorrSigners().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SchnorrProposition pubKey = (SchnorrProposition)tuple2._1();
            int pubKeyIndex = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)new SchnorrProposition(pubKey.pubKeyBytes()), (Object)status.knownSigs().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)WithKeyRotationCircuitStrategy.$anonfun$buildCertificateData$2(pubKeyIndex, info))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.signature()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom());
        return new CertificateDataWithKeyRotation(status.referencedEpoch(), sidechainId, backwardTransfers, endEpochCumCommTreeHash, btrFee, ftMinAmount, (Seq<Tuple2<SchnorrProposition, Option<SchnorrProof>>>)signersPublicKeyWithSignatures, schnorrKeysSignatures, previousCertificateOption, this.circuit.generateKeysRootHash((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.params.signersPublicKeys().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.pubKeyBytes(), Seq$.MODULE$.canBuildFrom())).toList()).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)this.params.mastersPublicKeys().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.pubKeyBytes(), Seq$.MODULE$.canBuildFrom())).toList()).asJava()));
    }

    @Override
    public Try<Tuple2<byte[], Seq<SchnorrProposition>>> getMessageToSignAndPublicKeys(HIS history, MS state, int referencedWithdrawalEpochNumber) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq<BackwardTransfer> backwardTransfers = state.backwardTransfers(referencedWithdrawalEpochNumber);
            long btrFee = this.getBtrFee(referencedWithdrawalEpochNumber);
            long ftMinAmount = this.getFtMinAmount(referencedWithdrawalEpochNumber);
            byte[] endEpochCumCommTreeHash = this.lastMainchainBlockCumulativeCommTreeHashForWithdrawalEpochNumber(history, state, referencedWithdrawalEpochNumber);
            byte[] sidechainId = $this.params.sidechainId();
            SchnorrKeysSignatures keysAndSignatures = this.getSchnorrKeysSignatures(state, referencedWithdrawalEpochNumber);
            byte[] keysRootHash = $this.circuit.getSchnorrKeysHash(keysAndSignatures);
            byte[] message = $this.circuit.generateMessageToBeSigned((List)JavaConverters$.MODULE$.seqAsJavaListConverter(backwardTransfers).asJava(), sidechainId, referencedWithdrawalEpochNumber, endEpochCumCommTreeHash, btrFee, ftMinAmount, keysRootHash);
            return new Tuple2((Object)message, keysAndSignatures.schnorrSigners());
        });
    }

    private SchnorrKeysSignatures getSchnorrKeysSignatures(MS state, int referencedWithdrawalEpochNumber) {
        CertifiersKeys prevCertifierKeys = (CertifiersKeys)((AbstractState)state).certifiersKeys(referencedWithdrawalEpochNumber - 1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Certifiers keys for previous withdrawal epoch are not present");
        });
        CertifiersKeys newCertifierKeys = (CertifiersKeys)((AbstractState)state).certifiersKeys(referencedWithdrawalEpochNumber).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Certifiers keys for current withdrawal epoch are not present");
        });
        Tuple2 tuple2 = ((GenericTraversableTemplate)newCertifierKeys.signingKeys().indices().map((Function1 & Serializable & scala.Serializable)i -> WithKeyRotationCircuitStrategy.$anonfun$getSchnorrKeysSignatures$3(prevCertifierKeys, newCertifierKeys, state, referencedWithdrawalEpochNumber, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq updatedSigningKeysSkSignatures = (IndexedSeq)tuple2._1();
        IndexedSeq updatedSigningKeysMkSignatures = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)updatedSigningKeysSkSignatures, (Object)updatedSigningKeysMkSignatures);
        Tuple2 tuple23 = tuple22;
        IndexedSeq updatedSigningKeysSkSignatures2 = (IndexedSeq)tuple23._1();
        IndexedSeq updatedSigningKeysMkSignatures2 = (IndexedSeq)tuple23._2();
        Tuple2 tuple24 = ((GenericTraversableTemplate)newCertifierKeys.masterKeys().indices().map((Function1 & Serializable & scala.Serializable)i -> WithKeyRotationCircuitStrategy.$anonfun$getSchnorrKeysSignatures$4(prevCertifierKeys, newCertifierKeys, state, referencedWithdrawalEpochNumber, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        IndexedSeq updatedMasterKeysSkSignatures = (IndexedSeq)tuple24._1();
        IndexedSeq updatedMasterKeysMkSignatures = (IndexedSeq)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)updatedMasterKeysSkSignatures, (Object)updatedMasterKeysMkSignatures);
        Tuple2 tuple26 = tuple25;
        IndexedSeq updatedMasterKeysSkSignatures2 = (IndexedSeq)tuple26._1();
        IndexedSeq updatedMasterKeysMkSignatures2 = (IndexedSeq)tuple26._2();
        return new SchnorrKeysSignatures((Seq<SchnorrProposition>)prevCertifierKeys.signingKeys(), (Seq<SchnorrProposition>)prevCertifierKeys.masterKeys(), (Seq<SchnorrProposition>)newCertifierKeys.signingKeys(), (Seq<SchnorrProposition>)newCertifierKeys.masterKeys(), (Seq<Option<SchnorrProof>>)updatedSigningKeysSkSignatures2, (Seq<Option<SchnorrProof>>)updatedSigningKeysMkSignatures2, (Seq<Option<SchnorrProof>>)updatedMasterKeysSkSignatures2, (Seq<Option<SchnorrProof>>)updatedMasterKeysMkSignatures2);
    }

    public static final /* synthetic */ boolean $anonfun$buildCertificateData$2(int pubKeyIndex$1, AbstractCertificateSubmitter.CertificateSignatureInfo info) {
        return info.pubKeyIndex() == pubKeyIndex$1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSchnorrKeysSignatures$3(CertifiersKeys prevCertifierKeys$1, CertifiersKeys newCertifierKeys$1, AbstractState state$2, int referencedWithdrawalEpochNumber$2, int i) {
        Tuple2 tuple2;
        if (!BoxesRunTime.equals((Object)prevCertifierKeys$1.signingKeys().apply(i), (Object)newCertifierKeys$1.signingKeys().apply(i))) {
            Some some;
            KeyRotationProof keyRotationProof;
            Option<KeyRotationProof> option = state$2.keyRotationProof(referencedWithdrawalEpochNumber$2, i, 0);
            if (!(option instanceof Some) || (keyRotationProof = (KeyRotationProof)(some = (Some)option).value()) == null) {
                throw new RuntimeException(new StringBuilder(74).append("Key rotation proof of signing key is not present for certifier with index ").append(i).toString());
            }
            KeyRotationProof keyRotationProof2 = keyRotationProof;
            Tuple2 tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)keyRotationProof2.signingKeySignature()), (Object)Option$.MODULE$.apply((Object)keyRotationProof2.masterKeySignature()));
            tuple2 = tuple22;
        } else {
            tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        }
        return tuple2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getSchnorrKeysSignatures$4(CertifiersKeys prevCertifierKeys$1, CertifiersKeys newCertifierKeys$1, AbstractState state$2, int referencedWithdrawalEpochNumber$2, int i) {
        Tuple2 tuple2;
        if (!BoxesRunTime.equals((Object)prevCertifierKeys$1.masterKeys().apply(i), (Object)newCertifierKeys$1.masterKeys().apply(i))) {
            Some some;
            KeyRotationProof keyRotationProof;
            Option<KeyRotationProof> option = state$2.keyRotationProof(referencedWithdrawalEpochNumber$2, i, 1);
            if (!(option instanceof Some) || (keyRotationProof = (KeyRotationProof)(some = (Some)option).value()) == null) {
                throw new RuntimeException(new StringBuilder(73).append("Key rotation proof of master key is not present for certifier with index ").append(i).toString());
            }
            KeyRotationProof keyRotationProof2 = keyRotationProof;
            Tuple2 tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)keyRotationProof2.signingKeySignature()), (Object)Option$.MODULE$.apply((Object)keyRotationProof2.masterKeySignature()));
            tuple2 = tuple22;
        } else {
            tuple2 = new Tuple2((Object)Option$.MODULE$.empty(), (Object)Option$.MODULE$.empty());
        }
        return tuple2;
    }

    public WithKeyRotationCircuitStrategy(SidechainSettings settings, NetworkParams params, ThresholdSignatureCircuitWithKeyRotation circuit) {
        this.params = params;
        this.circuit = circuit;
        super(settings, params);
    }
}

