/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.block;

import com.google.common.primitives.UnsignedInts;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.OmmersContainer;
import io.horizen.block.ProofOfWorkVerifier;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.params.NetworkParams;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.control.Breaks$;

public final class ProofOfWorkVerifier$ {
    public static ProofOfWorkVerifier$ MODULE$;

    static {
        new ProofOfWorkVerifier$();
    }

    public boolean checkProofOfWork(MainchainHeader header, NetworkParams params) {
        BigInteger target = Utils.decodeCompactBits(UnsignedInts.toLong((int)header.bits()));
        BigInteger hashTarget = new BigInteger(1, header.hash());
        if (target.signum() <= 0 || target.compareTo(params.powLimit()) > 0) {
            return false;
        }
        return hashTarget.compareTo(target) <= 0;
    }

    public <H extends SidechainBlockHeaderBase, PMOD extends SidechainBlockBase<? extends Transaction, H>, FPI extends AbstractFeePaymentsInfo, HSTOR extends AbstractHistoryStorage<PMOD, FPI, HSTOR>> boolean checkNextWorkRequired(PMOD block, HSTOR historyStorage, NetworkParams params) {
        boolean bl;
        Object object = new Object();
        try {
            if (block.mainchainHeaders().isEmpty()) {
                return true;
            }
            ObjectRef timeBitsData = ObjectRef.create((Object)Nil$.MODULE$);
            ObjectRef currentHeader = ObjectRef.create((Object)((MainchainHeader)block.mainchainHeaders().head()));
            ObjectRef currentBlock = ObjectRef.create(block);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                while (true) {
                    if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(((MainchainHeader)currentHeader$1.elem).hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(params.genesisMainchainBlockHash()))) {
                        ((IterableLike)params.genesisPoWData().reverse()).foreach((Function1 & Serializable & scala.Serializable)timeBitsTuple -> {
                            ProofOfWorkVerifier$.$anonfun$checkNextWorkRequired$2(timeBitsData, params, timeBitsTuple);
                            return BoxedUnit.UNIT;
                        });
                        throw Breaks$.MODULE$.break();
                    }
                    Option option = historyStorage.blockById(((SidechainBlockBase)currentBlock$1.elem).parentId());
                    if (!(option instanceof Some)) {
                        throw new NonLocalReturnControl.mcZ.sp(object, false);
                    }
                    Some some = (Some)option;
                    SidechainBlockBase sidechainBlockBase = (SidechainBlockBase)some.get();
                    currentBlock$1.elem = sidechainBlockBase;
                    if (!((SidechainBlockBase)currentBlock$1.elem).mainchainHeaders().nonEmpty()) continue;
                    ((IterableLike)((SidechainBlockBase)currentBlock$1.elem).mainchainHeaders().reverse()).foreach((Function1 & Serializable & scala.Serializable)header -> {
                        ProofOfWorkVerifier$.$anonfun$checkNextWorkRequired$3(currentHeader, object, timeBitsData, params, header);
                        return BoxedUnit.UNIT;
                    });
                }
            });
            if (((List)timeBitsData.elem).size() != params.nPowAveragingWindow() + params.nMedianTimeSpan()) {
                return false;
            }
            ObjectRef bitsTotal = ObjectRef.create((Object)BigInteger.ZERO);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(((List)timeBitsData.elem).size() - params.nPowAveragingWindow()), ((List)timeBitsData.elem).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                bitsTotal$1.elem = ((BigInteger)bitsTotal$1.elem).add(Utils.decodeCompactBits(UnsignedInts.toLong((int)((Tuple2)((List)timeBitsData$1.elem).apply(i))._2$mcI$sp())));
            });
            if (!this.checkOmmersContainerNextWorkRequired(block, (List<Tuple2<Object, Object>>)((List)timeBitsData.elem), (BigInteger)bitsTotal.elem, params).isValid()) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private <H extends SidechainBlockHeaderBase> ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult checkOmmersContainerNextWorkRequired(OmmersContainer<H> ommersContainer, List<Tuple2<Object, Object>> initialTimeBitsData, BigInteger initialBitsTotal, NetworkParams params) {
        ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult ommersContainerNextWorkRequiredResult;
        Object object = new Object();
        try {
            ObjectRef timeBitsData = ObjectRef.create(initialTimeBitsData);
            ObjectRef bitsTotal = ObjectRef.create((Object)initialBitsTotal);
            ommersContainer.mainchainHeaders().foreach((Function1 & Serializable & scala.Serializable)mainchainHeader -> {
                ProofOfWorkVerifier$.$anonfun$checkOmmersContainerNextWorkRequired$1(timeBitsData, bitsTotal, params, object, mainchainHeader);
                return BoxedUnit.UNIT;
            });
            ObjectRef ommersTimeBitsData = ObjectRef.create(initialTimeBitsData);
            ObjectRef ommersBitsTotal = ObjectRef.create((Object)initialBitsTotal);
            ommersContainer.ommers().foreach((Function1 & Serializable & scala.Serializable)ommer -> {
                ProofOfWorkVerifier$.$anonfun$checkOmmersContainerNextWorkRequired$3(ommersTimeBitsData, ommersBitsTotal, params, object, ommer);
                return BoxedUnit.UNIT;
            });
            ommersContainerNextWorkRequiredResult = new ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult(true, (List<Tuple2<Object, Object>>)((List)timeBitsData.elem), (BigInteger)bitsTotal.elem);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ommersContainerNextWorkRequiredResult = (ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult)ex.value();
            }
            throw ex;
        }
        return ommersContainerNextWorkRequiredResult;
    }

    public int geMedianTimePast(Seq<Object> times, int index, NetworkParams params) {
        Seq median = (Seq)((SeqLike)times.slice(index - params.nMedianTimeSpan(), index)).sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(a, b) -> a < b);
        return BoxesRunTime.unboxToInt((Object)median.apply(params.nMedianTimeSpan() / 2));
    }

    public int calculateNextWorkRequired(BigInteger bitsAvg, int firstBlockTime, int lastBlockTime, NetworkParams params) {
        BigInteger bitsNew;
        block2: {
            int actualTimespan = lastBlockTime - firstBlockTime;
            actualTimespan = params.averagingWindowTimespan() + (actualTimespan - params.averagingWindowTimespan()) / 4;
            if (actualTimespan < params.MinActualTimespan()) {
                actualTimespan = params.MinActualTimespan();
            }
            if (actualTimespan > params.MaxActualTimespan()) {
                actualTimespan = params.MaxActualTimespan();
            }
            if ((bitsNew = bitsAvg.multiply(BigInteger.valueOf(actualTimespan)).divide(BigInteger.valueOf(params.averagingWindowTimespan()))).compareTo(params.powLimit()) <= 0) break block2;
            bitsNew = params.powLimit();
        }
        return (int)Utils.encodeCompactBits(bitsNew);
    }

    public Seq<Tuple2<Object, Object>> parsePowData(String powData) {
        Seq res = (Seq)Nil$.MODULE$;
        byte[] powDataBytes = BytesUtils.fromHexString(powData);
        for (int offset = 0; offset < powDataBytes.length; offset += 8) {
            res = (Seq)res.$colon$plus((Object)new Tuple2.mcII.sp(BytesUtils.getReversedInt(powDataBytes, offset), BytesUtils.getReversedInt(powDataBytes, offset + 4)), Seq$.MODULE$.canBuildFrom());
        }
        return (Seq)res.reverse();
    }

    public static final /* synthetic */ void $anonfun$checkNextWorkRequired$2(ObjectRef timeBitsData$1, NetworkParams params$1, Tuple2 timeBitsTuple) {
        Tuple2 tuple2 = timeBitsTuple;
        timeBitsData$1.elem = ((List)timeBitsData$1.elem).$colon$colon((Object)tuple2);
        if (((List)timeBitsData$1.elem).size() == params$1.nPowAveragingWindow() + params$1.nMedianTimeSpan()) {
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$checkNextWorkRequired$3(ObjectRef currentHeader$1, Object nonLocalReturnKey1$1, ObjectRef timeBitsData$1, NetworkParams params$1, MainchainHeader header) {
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(header.hash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(((MainchainHeader)currentHeader$1.elem).hashPrevBlock()))) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(header.time(), header.bits());
        timeBitsData$1.elem = ((List)timeBitsData$1.elem).$colon$colon((Object)sp2);
        currentHeader$1.elem = header;
        if (((List)timeBitsData$1.elem).size() == params$1.nPowAveragingWindow() + params$1.nMedianTimeSpan()) {
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$checkOmmersContainerNextWorkRequired$1(ObjectRef timeBitsData$2, ObjectRef bitsTotal$2, NetworkParams params$2, Object nonLocalReturnKey2$1, MainchainHeader mainchainHeader) {
        Seq timeData = (Seq)((List)timeBitsData$2.elem).map((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToInteger((int)data._1$mcI$sp()), List$.MODULE$.canBuildFrom());
        BigInteger bitsAvg = ((BigInteger)bitsTotal$2.elem).divide(BigInteger.valueOf(params$2.nPowAveragingWindow()));
        int res = MODULE$.calculateNextWorkRequired(bitsAvg, MODULE$.geMedianTimePast((Seq<Object>)timeData, timeData.size() - params$2.nPowAveragingWindow(), params$2), MODULE$.geMedianTimePast((Seq<Object>)timeData, timeData.size(), params$2), params$2);
        if (Math.abs(res - mainchainHeader.bits()) > 1) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult(false, (List<Tuple2<Object, Object>>)((List)timeBitsData$2.elem), (BigInteger)bitsTotal$2.elem));
        }
        bitsTotal$2.elem = ((BigInteger)bitsTotal$2.elem).subtract(Utils.decodeCompactBits(UnsignedInts.toLong((int)((Tuple2)((List)timeBitsData$2.elem).apply(((List)timeBitsData$2.elem).size() - params$2.nPowAveragingWindow()))._2$mcI$sp()))).add(Utils.decodeCompactBits(UnsignedInts.toLong((int)mainchainHeader.bits())));
        timeBitsData$2.elem = (List)((SeqLike)((List)timeBitsData$2.elem).tail()).$colon$plus((Object)new Tuple2.mcII.sp(mainchainHeader.time(), mainchainHeader.bits()), List$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$checkOmmersContainerNextWorkRequired$3(ObjectRef ommersTimeBitsData$1, ObjectRef ommersBitsTotal$1, NetworkParams params$2, Object nonLocalReturnKey2$1, Ommer ommer) {
        ProofOfWorkVerifier.OmmersContainerNextWorkRequiredResult res = MODULE$.checkOmmersContainerNextWorkRequired(ommer, (List<Tuple2<Object, Object>>)((List)ommersTimeBitsData$1.elem), (BigInteger)ommersBitsTotal$1.elem, params$2);
        if (!res.isValid()) {
            throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)res);
        }
        ommersTimeBitsData$1.elem = res.actualTimeBitsData();
        ommersBitsTotal$1.elem = res.actualBitsTotal();
    }

    private ProofOfWorkVerifier$() {
        MODULE$ = this;
    }
}

