/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.block;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.MainchainHeader$;
import io.horizen.block.MainchainTransaction;
import io.horizen.block.MainchainTransaction$;
import io.horizen.block.MainchainTxBwtRequestCrosschainOutput;
import io.horizen.block.MainchainTxCrosschainOutput;
import io.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import io.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import io.horizen.block.SidechainCommitmentTree;
import io.horizen.block.SidechainsVersionsManager;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.block.WithdrawalEpochCertificate$;
import io.horizen.params.NetworkParams;
import io.horizen.proposition.Proposition;
import io.horizen.transaction.MC2SCAggregatedTransaction;
import io.horizen.transaction.mainchain.BwtRequest;
import io.horizen.transaction.mainchain.ForwardTransfer;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.CompactSize;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

public final class MainchainBlockReference$
implements SparkzLogging,
scala.Serializable {
    public static MainchainBlockReference$ MODULE$;
    private final int MAX_MAINCHAIN_BLOCK_SIZE;
    private final int SC_CERT_BLOCK_VERSION;
    private final Logger logger;

    static {
        new MainchainBlockReference$();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int MAX_MAINCHAIN_BLOCK_SIZE() {
        return this.MAX_MAINCHAIN_BLOCK_SIZE;
    }

    public int SC_CERT_BLOCK_VERSION() {
        return this.SC_CERT_BLOCK_VERSION;
    }

    public Try<MainchainBlockReference> create(byte[] mainchainBlockBytes, NetworkParams params, SidechainsVersionsManager versionsManager) {
        Failure failure;
        Failure failure2;
        Success success;
        Tuple4 tuple4;
        Predef$.MODULE$.require(mainchainBlockBytes.length < this.MAX_MAINCHAIN_BLOCK_SIZE());
        Predef$.MODULE$.require(params.sidechainId().length == 32);
        Try<Tuple4<MainchainHeader, Seq<MainchainTransaction>, Seq<WithdrawalEpochCertificate>, Object>> try_ = this.parseMainchainBlockBytes(mainchainBlockBytes);
        if (try_ instanceof Success && (tuple4 = (Tuple4)(success = (Success)try_).value()) != null) {
            MainchainBlockReferenceData mainchainBlockReferenceData;
            Seq lowerCertificateLeaves;
            MainchainHeader header = (MainchainHeader)tuple4._1();
            Seq mainchainTxs = (Seq)tuple4._2();
            Seq certificates = (Seq)tuple4._3();
            int blockSize = BoxesRunTime.unboxToInt((Object)tuple4._4());
            if (blockSize < mainchainBlockBytes.length) {
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Input data corrupted. There are unprocessed %d bytes.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(mainchainBlockBytes.length - blockSize))})));
            }
            if (header.version() != this.SC_CERT_BLOCK_VERSION()) {
                MainchainBlockReferenceData data = new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)None$.MODULE$, (Option<byte[]>)None$.MODULE$, (Option<byte[]>)None$.MODULE$, (Seq<byte[]>)((Seq)Nil$.MODULE$), (Option<WithdrawalEpochCertificate>)None$.MODULE$);
                return new Success((Object)new MainchainBlockReference(header, data));
            }
            Set scIds = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
            ByteArrayWrapper sidechainId = new ByteArrayWrapper(params.sidechainId());
            SidechainCommitmentTree commitmentTree = new SidechainCommitmentTree();
            ListBuffer cswInputs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            mainchainTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
                cswInputs.appendAll(tx.cswInputs());
                return BoxedUnit.UNIT;
            });
            Map sidechainRelatedCswInputs = cswInputs.groupBy((Function1 & Serializable & scala.Serializable)input -> new ByteArrayWrapper(input.sidechainId()));
            scIds = (Set)scIds.$plus$plus((GenTraversableOnce)sidechainRelatedCswInputs.keys());
            cswInputs.foreach((Function1 & Serializable & scala.Serializable)input -> BoxesRunTime.boxToBoolean((boolean)commitmentTree.addCswInput(input)));
            ListBuffer crosschainOutputs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            mainchainTxs.foreach((Function1 & Serializable & scala.Serializable)tx -> {
                crosschainOutputs.appendAll(MainchainBlockReference$.MODULE$.getSidechainRelatedTransactionsOutputs(tx));
                return BoxedUnit.UNIT;
            });
            Map sidechainRelatedCrosschainOutputs = crosschainOutputs.groupBy((Function1 & Serializable & scala.Serializable)output -> new ByteArrayWrapper(output.sidechainId()));
            scIds = (Set)scIds.$plus$plus((GenTraversableOnce)sidechainRelatedCrosschainOutputs.keys());
            crosschainOutputs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReference$.$anonfun$create$6(commitmentTree, x0$1)));
            Seq certScIds = (Seq)((SeqLike)certificates.map((Function1 & Serializable & scala.Serializable)c -> new ByteArrayWrapper(c.sidechainId()), Seq$.MODULE$.canBuildFrom())).distinct();
            scIds = (Set)scIds.$plus$plus((GenTraversableOnce)certScIds);
            Map<ByteArrayWrapper, Enumeration.Value> scVersions = versionsManager.getVersions((Seq<ByteArrayWrapper>)certScIds);
            certificates.foreach((Function1 & Serializable & scala.Serializable)cert -> BoxesRunTime.boxToBoolean((boolean)commitmentTree.addCertificate(cert, (Enumeration.Value)scVersions.apply((Object)new ByteArrayWrapper(cert.sidechainId())))));
            Option mc2scTransaction = sidechainRelatedCrosschainOutputs.get((Object)sidechainId).map((Function1 & Serializable & scala.Serializable)outputs -> new MC2SCAggregatedTransaction((List)JavaConverters$.MODULE$.seqAsJavaListConverter(outputs).asJava(), 1));
            Option topQualityCertificate = ((IterableLike)certificates.reverse()).find((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)MainchainBlockReference$.$anonfun$create$10(sidechainId, c)));
            Seq<byte[]> certLeaves = commitmentTree.getCertLeaves(sidechainId.data());
            Seq seq = lowerCertificateLeaves = certLeaves.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)certLeaves.init();
            if (scIds.contains((Object)sidechainId)) {
                Option<byte[]> scExistenceProof = commitmentTree.getExistenceProof(sidechainId.data());
                mainchainBlockReferenceData = new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)mc2scTransaction, scExistenceProof, (Option<byte[]>)None$.MODULE$, (Seq<byte[]>)lowerCertificateLeaves, (Option<WithdrawalEpochCertificate>)topQualityCertificate);
            } else {
                Option<byte[]> scAbsenceProof = commitmentTree.getAbsenceProof(sidechainId.data());
                mainchainBlockReferenceData = new MainchainBlockReferenceData(header.hash(), (Option<MC2SCAggregatedTransaction>)None$.MODULE$, (Option<byte[]>)None$.MODULE$, scAbsenceProof, (Seq<byte[]>)((Seq)Nil$.MODULE$), (Option<WithdrawalEpochCertificate>)None$.MODULE$);
            }
            MainchainBlockReferenceData data = mainchainBlockReferenceData;
            commitmentTree.free();
            failure2 = new Success((Object)new MainchainBlockReference(header, data));
        } else if (try_ instanceof Failure) {
            Failure failure3 = (Failure)try_;
            Throwable e = failure3.exception();
            failure2 = new Failure(e);
        } else {
            throw new MatchError(try_);
        }
        Failure tryBlock = failure2;
        if (tryBlock.isFailure()) {
            failure = tryBlock;
        } else {
            ((MainchainBlockReference)tryBlock.get()).semanticValidity(params).get();
            failure = tryBlock;
        }
        return failure;
    }

    private Seq<SidechainRelatedMainchainOutput<? extends Box<? extends Proposition>>> getSidechainRelatedTransactionsOutputs(MainchainTransaction tx) {
        IntRef indexInTx = IntRef.create((int)-1);
        return (Seq)tx.getCrosschainOutputs().map((Function1 & Serializable & scala.Serializable)output -> {
            SidechainRelatedMainchainOutput<ForgerBox> sidechainRelatedMainchainOutput;
            ++indexInTx$1.elem;
            MainchainTxCrosschainOutput mainchainTxCrosschainOutput = output;
            if (mainchainTxCrosschainOutput instanceof MainchainTxSidechainCreationCrosschainOutput) {
                MainchainTxSidechainCreationCrosschainOutput mainchainTxSidechainCreationCrosschainOutput = (MainchainTxSidechainCreationCrosschainOutput)mainchainTxCrosschainOutput;
                sidechainRelatedMainchainOutput = new SidechainCreation(mainchainTxSidechainCreationCrosschainOutput, tx.hash(), indexInTx$1.elem);
            } else if (mainchainTxCrosschainOutput instanceof MainchainTxForwardTransferCrosschainOutput) {
                MainchainTxForwardTransferCrosschainOutput mainchainTxForwardTransferCrosschainOutput = (MainchainTxForwardTransferCrosschainOutput)mainchainTxCrosschainOutput;
                sidechainRelatedMainchainOutput = new ForwardTransfer(mainchainTxForwardTransferCrosschainOutput, tx.hash(), indexInTx$1.elem);
            } else if (mainchainTxCrosschainOutput instanceof MainchainTxBwtRequestCrosschainOutput) {
                MainchainTxBwtRequestCrosschainOutput mainchainTxBwtRequestCrosschainOutput = (MainchainTxBwtRequestCrosschainOutput)mainchainTxCrosschainOutput;
                sidechainRelatedMainchainOutput = new BwtRequest(mainchainTxBwtRequestCrosschainOutput, tx.hash(), indexInTx$1.elem);
            } else {
                throw new MatchError((Object)mainchainTxCrosschainOutput);
            }
            return sidechainRelatedMainchainOutput;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Try<Tuple4<MainchainHeader, Seq<MainchainTransaction>, Seq<WithdrawalEpochCertificate>, Object>> parseMainchainBlockBytes(byte[] mainchainBlockBytes) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq certificates;
            Seq transactions;
            MainchainHeader header;
            int offset = 0;
            Try<MainchainHeader> try_ = MainchainHeader$.MODULE$.create(mainchainBlockBytes, offset);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                header = (MainchainHeader)success.value();
                CompactSize transactionsCount = BytesUtils.getCompactSize(mainchainBlockBytes, offset += header.mainchainHeaderBytes().length);
                offset += transactionsCount.size();
                transactions = (Seq)Nil$.MODULE$;
                while ((long)transactions.size() < transactionsCount.value()) {
                    MainchainTransaction tx = (MainchainTransaction)MainchainTransaction$.MODULE$.create(mainchainBlockBytes, offset).get();
                    transactions = (Seq)transactions.$colon$plus((Object)tx, Seq$.MODULE$.canBuildFrom());
                    offset += tx.size();
                }
                certificates = (Seq)Nil$.MODULE$;
                if (header.version() == MODULE$.SC_CERT_BLOCK_VERSION()) {
                    CompactSize certificatesCount = BytesUtils.getCompactSize(mainchainBlockBytes, offset);
                    offset += certificatesCount.size();
                    while ((long)certificates.size() < certificatesCount.value()) {
                        BoxedUnit boxedUnit;
                        if (MODULE$.log().underlying().isDebugEnabled()) {
                            MODULE$.log().underlying().debug("Parse Mainchain certificate: {}", new Object[]{BytesUtils.toHexString(Arrays.copyOfRange(mainchainBlockBytes, offset, mainchainBlockBytes.length))});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        WithdrawalEpochCertificate c = WithdrawalEpochCertificate$.MODULE$.parse(mainchainBlockBytes, offset);
                        certificates = (Seq)certificates.$colon$plus((Object)c, Seq$.MODULE$.canBuildFrom());
                        offset += c.size();
                    }
                }
            } else {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    throw e;
                }
                throw new MatchError(try_);
            }
            Tuple4 tuple4 = new Tuple4((Object)header, (Object)transactions, (Object)certificates, (Object)BoxesRunTime.boxToInteger((int)offset));
            return tuple4;
        });
    }

    public MainchainBlockReference apply(MainchainHeader header, MainchainBlockReferenceData data) {
        return new MainchainBlockReference(header, data);
    }

    public Option<Tuple2<MainchainHeader, MainchainBlockReferenceData>> unapply(MainchainBlockReference x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.header(), (Object)x$0.data()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$create$6(SidechainCommitmentTree commitmentTree$1, SidechainRelatedMainchainOutput x0$1) {
        boolean bl;
        SidechainRelatedMainchainOutput sidechainRelatedMainchainOutput = x0$1;
        if (sidechainRelatedMainchainOutput instanceof SidechainCreation) {
            SidechainCreation sidechainCreation = (SidechainCreation)sidechainRelatedMainchainOutput;
            bl = commitmentTree$1.addSidechainCreation(sidechainCreation);
        } else if (sidechainRelatedMainchainOutput instanceof ForwardTransfer) {
            ForwardTransfer forwardTransfer = (ForwardTransfer)sidechainRelatedMainchainOutput;
            bl = commitmentTree$1.addForwardTransfer(forwardTransfer);
        } else if (sidechainRelatedMainchainOutput instanceof BwtRequest) {
            BwtRequest bwtRequest = (BwtRequest)sidechainRelatedMainchainOutput;
            bl = commitmentTree$1.addBwtRequest(bwtRequest);
        } else {
            throw new MatchError((Object)sidechainRelatedMainchainOutput);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$create$10(ByteArrayWrapper sidechainId$1, WithdrawalEpochCertificate c) {
        return Arrays.equals(c.sidechainId(), sidechainId$1.data());
    }

    private MainchainBlockReference$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.MAX_MAINCHAIN_BLOCK_SIZE = 4000000;
        this.SC_CERT_BLOCK_VERSION = 3;
    }
}

