/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.utils;

import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountPayment;
import io.horizen.evm.StateDB;
import io.horizen.evm.TrieHasher;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class AccountFeePaymentsUtils$ {
    public static AccountFeePaymentsUtils$ MODULE$;
    private final byte[] DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH;

    static {
        new AccountFeePaymentsUtils$();
    }

    public byte[] DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH() {
        return this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH;
    }

    public byte[] calculateFeePaymentsHash(Seq<AccountPayment> feePayments) {
        return feePayments.isEmpty() ? this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH() : TrieHasher.Root((byte[][])((byte[][])((TraversableOnce)feePayments.map((Function1 & Serializable & scala.Serializable)payment -> payment.bytes(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))))).toBytes();
    }

    public Seq<AccountPayment> getForgersRewards(Seq<AccountBlockFeeInfo> blockFeeInfoSeq) {
        if (blockFeeInfoSeq.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        ObjectRef poolFee = ObjectRef.create((Object)BigInteger.ZERO);
        Seq forgersBlockRewards = (Seq)blockFeeInfoSeq.map((Function1 & Serializable & scala.Serializable)feeInfo -> {
            poolFee$1.elem = ((BigInteger)poolFee$1.elem).add(feeInfo.baseFee());
            return new AccountPayment(feeInfo.forgerAddress(), feeInfo.forgerTips());
        }, Seq$.MODULE$.canBuildFrom());
        BigInteger[] divAndRem = ((BigInteger)poolFee.elem).divideAndRemainder(BigInteger.valueOf(forgersBlockRewards.size()));
        BigInteger forgerPoolFee = divAndRem[0];
        long rest = divAndRem[1].longValueExact();
        Seq allForgersRewards = (Seq)((TraversableLike)forgersBlockRewards.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int index;
            AccountPayment forgerBlockReward;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    forgerBlockReward = (AccountPayment)tuple2._1();
                    index = tuple2._2$mcI$sp();
                    if (forgerBlockReward != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            AccountPayment accountPayment = forgerBlockReward;
            int n = index;
            BigInteger finalForgerFee = accountPayment.value().add(forgerPoolFee).add((long)n < rest ? BigInteger.ONE : BigInteger.ZERO);
            AccountPayment accountPayment2 = new AccountPayment(accountPayment.address(), finalForgerFee);
            return accountPayment2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq forgerKeys = (Seq)((SeqLike)allForgersRewards.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.address(), Seq$.MODULE$.canBuildFrom())).distinct();
        return (Seq)forgerKeys.map((Function1 & Serializable & scala.Serializable)forgerKey -> {
            BigInteger forgerTotalFee = (BigInteger)((TraversableOnce)allForgersRewards.filter((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)forgerKey.equals(info.address())))).foldLeft((Object)BigInteger.ZERO, (Function2 & Serializable & scala.Serializable)(sum, info) -> sum.add(info.value()));
            return new AccountPayment((AddressProposition)forgerKey, forgerTotalFee);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private AccountFeePaymentsUtils$() {
        MODULE$ = this;
        this.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH = StateDB.EMPTY_ROOT_HASH.toBytes();
    }
}

