/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.transaction;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonView;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.GasUtil;
import io.horizen.account.state.Message;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.AccountTransactionsIdsEnum;
import io.horizen.account.transaction.EthereumTransactionSerializer;
import io.horizen.account.utils.BigIntegerUtil;
import io.horizen.account.utils.EthereumTransactionEncoder;
import io.horizen.account.utils.Secp256k1;
import io.horizen.evm.Address;
import io.horizen.json.Views;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;
import org.web3j.utils.Numeric;
import sparkz.crypto.hash.Keccak256;
import sparkz.util.ByteArrayBuilder;
import sparkz.util.serialization.VLQByteBufferWriter;
import sparkz.util.serialization.Writer;

@JsonPropertyOrder(value={"id", "from", "to", "value", "nonce", "data", "gasPrice", "gasLimit", "maxFeePerGas", "maxPriorityFeePerGas", "eip1559", "version", "chainId", "signed", "signature", "size"})
@JsonIgnoreProperties(value={"transaction", "encoder", "modifierTypeId"})
@JsonView(value={Views.Default.class})
public class EthereumTransaction
extends AccountTransaction<AddressProposition, SignatureSecp256k1> {
    private final EthereumTransactionType type;
    private final BigInteger nonce;
    @JsonProperty(value="to")
    private final AddressProposition to;
    @JsonProperty(value="gasPrice")
    private final BigInteger gasPrice;
    private final BigInteger gasLimit;
    private final BigInteger value;
    private final Long chainId;
    private final byte[] data;
    @JsonProperty(value="maxPriorityFeePerGas")
    private final BigInteger maxPriorityFeePerGas;
    @JsonProperty(value="maxFeePerGas")
    private final BigInteger maxFeePerGas;
    private final SignatureSecp256k1 signature;
    private AddressProposition from;
    private String hashString;
    private BigInteger txCost;
    private byte[] messageToSign;
    private long size = -1L;

    private synchronized String getTxHash() {
        if (this.hashString == null) {
            byte[] encodedMessage = this.isSigned() ? this.encode(true) : this.messageToSign();
            this.hashString = BytesUtils.toHexString(Keccak256.hash((byte[])encodedMessage));
        }
        return this.hashString;
    }

    @Override
    public synchronized BigInteger maxCost() {
        if (this.txCost == null) {
            this.txCost = super.maxCost();
        }
        return this.txCost;
    }

    public EthereumTransaction(@NotNull Optional<AddressProposition> to, @NotNull BigInteger nonce, @NotNull BigInteger gasPrice, @NotNull BigInteger gasLimit, @NotNull BigInteger value, @NotNull byte[] data, @Nullable SignatureSecp256k1 inSignature) {
        this.type = EthereumTransactionType.LegacyTxType;
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.value = value;
        this.chainId = null;
        this.maxPriorityFeePerGas = null;
        this.maxFeePerGas = null;
        this.to = to.orElse(null);
        this.data = data;
        this.signature = inSignature;
    }

    public EthereumTransaction(@NotNull Long chainId, @NotNull Optional<AddressProposition> to, @NotNull BigInteger nonce, @NotNull BigInteger gasPrice, @NotNull BigInteger gasLimit, @NotNull BigInteger value, @NotNull byte[] data, @Nullable SignatureSecp256k1 inSignature) {
        this.type = EthereumTransactionType.LegacyTxType;
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.value = value;
        this.chainId = chainId;
        this.maxPriorityFeePerGas = null;
        this.maxFeePerGas = null;
        this.to = to.orElse(null);
        this.data = data;
        this.signature = inSignature;
    }

    public EthereumTransaction(@NotNull Long chainId, @NotNull Optional<AddressProposition> to, @NotNull BigInteger nonce, @NotNull BigInteger gasLimit, @NotNull BigInteger maxPriorityFeePerGas, @NotNull BigInteger maxFeePerGas, @NotNull BigInteger value, @NotNull byte[] data, @Nullable SignatureSecp256k1 inSignature) {
        this.type = EthereumTransactionType.DynamicFeeTxType;
        this.nonce = nonce;
        this.gasPrice = null;
        this.gasLimit = gasLimit;
        this.value = value;
        this.chainId = chainId;
        this.maxPriorityFeePerGas = maxPriorityFeePerGas;
        this.maxFeePerGas = maxFeePerGas;
        this.to = to.orElse(null);
        this.data = data;
        this.signature = inSignature;
    }

    public EthereumTransaction(EthereumTransaction txToSign, @Nullable SignatureSecp256k1 inSignature) {
        this.type = txToSign.type;
        this.nonce = txToSign.nonce;
        this.gasPrice = txToSign.gasPrice;
        this.gasLimit = txToSign.gasLimit;
        this.to = txToSign.to;
        this.value = txToSign.value;
        this.data = txToSign.data;
        this.chainId = txToSign.chainId;
        this.maxPriorityFeePerGas = txToSign.maxPriorityFeePerGas;
        this.maxFeePerGas = txToSign.maxFeePerGas;
        this.signature = inSignature;
    }

    public boolean isSigned() {
        return this.signature != null;
    }

    @Override
    public byte transactionTypeId() {
        return AccountTransactionsIdsEnum.EthereumTransactionId.id();
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.getTxHash();
    }

    @Override
    @JsonProperty(value="version")
    public byte version() {
        return (byte)this.type.ordinal();
    }

    public TransactionSerializer serializer() {
        return EthereumTransactionSerializer.getSerializer();
    }

    @Override
    public void semanticValidity() throws TransactionSemanticValidityException {
        if (!this.isSigned()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is not signed", this.id()));
        }
        if (this.getChainId() != null && this.getChainId() < 1L) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] has invalid chainId set: %d", this.id(), this.getChainId()));
        }
        if (this.getTo().isEmpty() && this.getData().length == 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: smart contract declaration transaction without data", this.id()));
        }
        if (this.getValue().signum() < 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: negative value", this.id()));
        }
        if (this.getNonce().signum() < 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: negative nonce", this.id()));
        }
        if (!BigIntegerUtil.isUint64(this.getNonce())) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: nonce uint64 overflow", this.id()));
        }
        if (this.getGasLimit().signum() <= 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: non-positive gas limit", this.id()));
        }
        if (!BigIntegerUtil.isUint64(this.getGasLimit())) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: gas limit uint64 overflow", this.id()));
        }
        if (this.isEIP1559()) {
            if (this.getMaxFeePerGas().signum() < 0) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: eip1559 transaction with negative maxFeePerGas", this.id()));
            }
            if (this.getMaxPriorityFeePerGas().signum() < 0) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: eip1559 transaction with negative maxPriorityFeePerGas", this.id()));
            }
            if (!BigIntegerUtil.isUint256(this.getMaxFeePerGas())) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: eip1559 transaction maxFeePerGas bit length [%d] is too high", this.id(), this.getMaxFeePerGas().bitLength()));
            }
            if (!BigIntegerUtil.isUint256(this.getMaxPriorityFeePerGas())) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: eip1559 transaction maxPriorityFeePerGas bit length [%d] is too high", this.id(), this.getMaxPriorityFeePerGas().bitLength()));
            }
            if (this.getMaxFeePerGas().compareTo(this.getMaxPriorityFeePerGas()) < 0) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: eip1559 transaction maxPriorityFeePerGas [%s] higher than maxFeePerGas [%s]", this.id(), this.getMaxPriorityFeePerGas(), this.getMaxFeePerGas()));
            }
        } else {
            if (this.getGasPrice().signum() < 0) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: legacy transaction with negative gasPrice", this.id()));
            }
            if (!BigIntegerUtil.isUint256(this.getGasPrice())) {
                throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: legacy transaction gasPrice bit length [%d] is too high", this.id(), this.getGasPrice().bitLength()));
            }
        }
        if (this.getGasLimit().compareTo(GasUtil.intrinsicGas(this.getData(), this.getTo().isEmpty())) < 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: gas limit %s is below intrinsic gas %s", this.id(), this.getGasLimit(), GasUtil.intrinsicGas(this.getData(), this.getTo().isEmpty())));
        }
        if (this.getFrom() == null) {
            throw new TransactionSemanticValidityException("Invalid signature: " + this.getSignature().toString());
        }
    }

    @Override
    @JsonProperty(value="size")
    public synchronized long size() {
        if (this.size == -1L) {
            this.size = this.serializer().toBytes(this).length;
        }
        return this.size;
    }

    @Override
    public BigInteger getNonce() {
        return this.nonce;
    }

    @Override
    @JsonIgnore
    public BigInteger getGasPrice() {
        if (this.isLegacy()) {
            return this.gasPrice;
        }
        return this.maxFeePerGas;
    }

    @Override
    @JsonIgnore
    public BigInteger getMaxFeePerGas() {
        if (this.isEIP1559()) {
            return this.maxFeePerGas;
        }
        return this.gasPrice;
    }

    @Override
    @JsonIgnore
    public BigInteger getMaxPriorityFeePerGas() {
        if (this.isEIP1559()) {
            return this.maxPriorityFeePerGas;
        }
        return this.gasPrice;
    }

    @Override
    @JsonIgnore
    public BigInteger getPriorityFeePerGas(BigInteger base) {
        if (this.isEIP1559()) {
            return this.getMaxFeePerGas().subtract(base).min(this.getMaxPriorityFeePerGas());
        }
        return this.getGasPrice().subtract(base);
    }

    @Override
    @JsonIgnore
    public BigInteger getEffectiveGasPrice(BigInteger base) {
        if (this.isEIP1559()) {
            return base.add(this.getMaxPriorityFeePerGas()).min(this.getMaxFeePerGas());
        }
        return this.getGasPrice();
    }

    public Long getChainId() {
        if (this.isEIP1559() || this.isEIP155()) {
            return this.chainId;
        }
        return null;
    }

    public boolean isEIP1559() {
        return this.type == EthereumTransactionType.DynamicFeeTxType;
    }

    public boolean isLegacy() {
        return this.type == EthereumTransactionType.LegacyTxType;
    }

    public boolean isEIP155() {
        return this.isLegacy() && this.chainId != null;
    }

    @Override
    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    @Override
    @JsonIgnore
    public Optional<AddressProposition> getTo() {
        return Optional.ofNullable(this.to);
    }

    @JsonIgnore
    public Address getToAddress() {
        if (this.to == null) {
            return null;
        }
        return this.to.address();
    }

    @Override
    public synchronized AddressProposition getFrom() {
        if (this.from == null && this.signature != null) {
            try {
                byte[] message = this.messageToSign();
                this.from = new AddressProposition(Secp256k1.signedMessageToAddress(message, this.signature.getV(), this.signature.getR(), this.signature.getS()));
            }
            catch (Exception e) {
                LogManager.getLogger().info("Could not find from address, Signature not valid:", (Throwable)e);
                this.from = null;
            }
        }
        return this.from;
    }

    @JsonIgnore
    public Address getFromAddress() {
        if (this.getFrom() == null) {
            return null;
        }
        return this.getFrom().address();
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @JsonIgnore
    public String getDataString() {
        if (this.data != null) {
            return BytesUtils.toHexString(this.data);
        }
        return "";
    }

    @Override
    public SignatureSecp256k1 getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.isEIP1559()) {
            return String.format("EthereumTransaction{id=%s, from=%s, nonce=%s, gasLimit=%s, to=%s, value=%s, data=%s, maxFeePerGas=%s, maxPriorityFeePerGas=%s, chainId=%s, version=%d, Signature=%s}", this.id(), this.getFromAddress(), Numeric.toHexStringWithPrefix((BigInteger)(this.getNonce() != null ? this.getNonce() : BigInteger.ONE.negate())), Numeric.toHexStringWithPrefix((BigInteger)(this.getGasLimit() != null ? this.getGasLimit() : BigInteger.ZERO)), this.getToAddress(), Numeric.toHexStringWithPrefix((BigInteger)(this.getValue() != null ? this.getValue() : BigInteger.ZERO)), this.getDataString(), Numeric.toHexStringWithPrefix((BigInteger)(this.getMaxFeePerGas() != null ? this.getMaxFeePerGas() : BigInteger.ZERO)), Numeric.toHexStringWithPrefix((BigInteger)(this.getMaxPriorityFeePerGas() != null ? this.getMaxPriorityFeePerGas() : BigInteger.ZERO)), this.getChainId() != null ? this.getChainId() : "", (int)this.version(), this.isSigned() ? this.signature.toString() : "");
        }
        return String.format("EthereumTransaction{id=%s, from=%s, nonce=%s, gasPrice=%s, gasLimit=%s, to=%s, value=%s, data=%s, chainId=%s, version=%d, Signature=%s}", this.id(), this.getFromAddress(), Numeric.toHexStringWithPrefix((BigInteger)(this.getNonce() != null ? this.getNonce() : BigInteger.ONE.negate())), Numeric.toHexStringWithPrefix((BigInteger)(this.getGasPrice() != null ? this.getGasPrice() : BigInteger.ZERO)), Numeric.toHexStringWithPrefix((BigInteger)(this.getGasLimit() != null ? this.getGasLimit() : BigInteger.ZERO)), this.getToAddress(), Numeric.toHexStringWithPrefix((BigInteger)(this.getValue() != null ? this.getValue() : BigInteger.ZERO)), this.getDataString(), this.getChainId() != null ? this.getChainId() : "", (int)this.version(), this.isSigned() ? this.signature.toString() : "");
    }

    public synchronized byte[] messageToSign() {
        if (this.messageToSign == null) {
            this.messageToSign = this.encode(false);
        }
        return this.messageToSign;
    }

    public Message asMessage(BigInteger baseFee) {
        return new Message(this.getFrom() == null ? Address.ZERO : this.getFrom().address(), this.getTo().map(AddressProposition::address), this.getEffectiveGasPrice(baseFee), this.getMaxFeePerGas(), this.getMaxPriorityFeePerGas(), this.getGasLimit(), this.getValue(), this.getNonce(), this.getData(), false);
    }

    public byte[] encode(boolean accountSignature) {
        VLQByteBufferWriter writer = new VLQByteBufferWriter(new ByteArrayBuilder());
        this.encode(accountSignature, (Writer)writer);
        return writer.toBytes();
    }

    public void encode(boolean accountSignature, Writer writer) {
        EthereumTransactionEncoder.encodeAsRlpValues(this, accountSignature, writer);
    }

    public static enum EthereumTransactionType {
        LegacyTxType,
        AccessListTxType,
        DynamicFeeTxType;

    }
}

