/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.transaction;

import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.transaction.Transaction;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import java.math.BigInteger;
import java.util.Optional;

public abstract class AccountTransaction<P extends Proposition, PR extends Proof<P>>
extends Transaction {
    @Override
    public abstract void semanticValidity() throws TransactionSemanticValidityException;

    public abstract BigInteger getNonce();

    public abstract BigInteger getGasPrice();

    public abstract BigInteger getGasLimit();

    public abstract P getFrom();

    public abstract Optional<P> getTo();

    public abstract BigInteger getValue();

    public abstract byte[] getData();

    public abstract PR getSignature();

    public abstract BigInteger getMaxFeePerGas();

    public abstract BigInteger getMaxPriorityFeePerGas();

    public abstract BigInteger getEffectiveGasPrice(BigInteger var1);

    public abstract BigInteger getPriorityFeePerGas(BigInteger var1);

    public BigInteger maxCost() {
        return this.getValue().add(this.getGasLimit().multiply(this.getGasPrice()));
    }
}

