/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.storage.AccountStateMetadataStorageReader;
import io.horizen.account.storage.AccountStateMetadataStorageView;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.WithdrawalEpochInfo;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\n\u0014\u0001qA\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006o\u0001!\t\u0001\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u00063\u0002!\tA\u0017\u0005\u0006E\u0002!\ta\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006Y\u0002!\t%\u001c\u0005\u0006s\u0002!\tE\u001f\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\ty\u0001\u0001C!\u0003#Aq!!\u000b\u0001\t\u0003\nY\u0003\u0003\u0004\u0002L\u0001!\te\u0019\u0005\b\u0003\u001b\u0002A\u0011IA(\u0011\u001d\t\t\u0006\u0001C!\u0003'Bq!!\u0019\u0001\t\u0003\n\u0019GA\u000eBG\u000e|WO\u001c;Ti\u0006$X-T3uC\u0012\fG/Y*u_J\fw-\u001a\u0006\u0003)U\tqa\u001d;pe\u0006<WM\u0003\u0002\u0017/\u00059\u0011mY2pk:$(B\u0001\r\u001a\u0003\u001dAwN]5{K:T\u0011AG\u0001\u0003S>\u001c\u0001aE\u0003\u0001;\r:C\u0006\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VM\u001a\t\u0003I\u0015j\u0011aE\u0005\u0003MM\u0011\u0011%Q2d_VtGo\u0015;bi\u0016lU\r^1eCR\f7\u000b^8sC\u001e,'+Z1eKJ\u0004\"\u0001\u000b\u0016\u000e\u0003%R!\u0001F\f\n\u0005-J#\u0001F*jI\u0016\u001c\u0007.Y5o'R|'/Y4f\u0013:4w\u000e\u0005\u0002.e5\taF\u0003\u00020a\u0005!Q\u000f^5m\u0015\u0005\t\u0014AB:qCJ\\'0\u0003\u00024]\ti1\u000b]1sWjdunZ4j]\u001e\u0004\"\u0001K\u001b\n\u0005YJ#aB*u_J\fw-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005eR\u0004C\u0001\u0013\u0001\u0011\u0015!\"\u00011\u00015\u0003\u001d9W\r\u001e,jK^,\u0012!\u0010\t\u0003IyJ!aP\n\u0003?\u0005\u001b7m\\;oiN#\u0018\r^3NKR\fG-\u0019;b'R|'/Y4f-&,w/A\u0007mCN$h+\u001a:tS>t\u0017\nZ\u000b\u0002\u0005B\u0019adQ#\n\u0005\u0011{\"AB(qi&|g\u000e\u0005\u0002G\u00136\tqI\u0003\u0002I/\u0005)Q\u000f^5mg&\u0011!j\u0012\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJ\f\u0001C]8mY\n\f7m\u001b,feNLwN\\:\u0016\u00035\u00032A\u0014,F\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S7\u00051AH]8pizJ\u0011\u0001I\u0005\u0003+~\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u00191+Z9\u000b\u0005U{\u0012\u0001\u0003:pY2\u0014\u0017mY6\u0015\u0005m\u0003\u0007c\u0001/_s5\tQL\u0003\u00020?%\u0011q,\u0018\u0002\u0004)JL\b\"B1\u0007\u0001\u0004)\u0015a\u0002<feNLwN\\\u0001\bSN,U\u000e\u001d;z+\u0005!\u0007C\u0001\u0010f\u0013\t1wDA\u0004C_>dW-\u00198\u0002-\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>,\u0012!\u001b\t\u0003\r*L!a[$\u0003']KG\u000f\u001b3sC^\fG.\u00129pG\"LeNZ8\u0002\u001d\u001d,GOR3f!\u0006LX.\u001a8ugR\u0011a\u000e\u001e\t\u0004\u001dZ{\u0007C\u00019s\u001b\u0005\t(B\u0001%\u0016\u0013\t\u0019\u0018OA\nBG\u000e|WO\u001c;CY>\u001c7NR3f\u0013:4w\u000eC\u0003v\u0013\u0001\u0007a/A\u000bxSRDGM]1xC2,\u0005o\\2i\u001dVl'-\u001a:\u0011\u0005y9\u0018B\u0001= \u0005\rIe\u000e^\u0001\u0019O\u0016$Hk\u001c9Rk\u0006d\u0017\u000e^=DKJ$\u0018NZ5dCR,GcA>\u0002\u0006A\u0019ad\u0011?\u0011\u0007u\f\t!D\u0001\u007f\u0015\tyx#A\u0003cY>\u001c7.C\u0002\u0002\u0004y\u0014!dV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[\"feRLg-[2bi\u0016Da!a\u0002\u000b\u0001\u00041\u0018!\u0007:fM\u0016\u0014XM\\2fI^KG\u000f\u001b3sC^\fG.\u00129pG\"\fa\u0004\\1ti\u000e+'\u000f^5gS\u000e\fG/\u001a*fM\u0016\u0014XM\\2fI\u0016\u0003xn\u00195\u0016\u0005\u00055\u0001c\u0001\u0010Dm\u0006yB.Y:u\u0007\u0016\u0014H/\u001b4jG\u0006$XmU5eK\u000eD\u0017-\u001b8CY>\u001c7.\u00133\u0016\u0005\u0005M\u0001\u0003\u0002\u0010D\u0003+\u0001B!a\u0006\u0002$9!\u0011\u0011DA\u0011\u001d\u0011\tY\"a\b\u000f\u0007A\u000bi\"C\u00012\u0013\ty\u0003'\u0003\u0002V]%!\u0011QEA\u0014\u0005)iu\u000eZ5gS\u0016\u0014\u0018\n\u001a\u0006\u0003+:\nqcZ3u\u0007>t7/\u001a8tkN,\u0005o\\2i\u001dVl'-\u001a:\u0016\u0005\u00055\u0002\u0003\u0002\u0010D\u0003_\u0001B!!\r\u0002F9!\u00111GA!\u001d\u0011\t)$!\u0010\u000f\t\u0005]\u00121\b\b\u0004!\u0006e\u0012\"\u0001\u000e\n\u0005aI\u0012bAA /\u0005I1m\u001c8tK:\u001cXo]\u0005\u0004+\u0006\r#bAA /%!\u0011qIA%\u0005Q\u0019uN\\:f]N,8/\u00129pG\"tU/\u001c2fe*\u0019Q+a\u0011\u0002\u0013!\f7oQ3bg\u0016$\u0017!C4fi\"+\u0017n\u001a5u+\u00051\u0018aE4fi\u0006\u001b7m\\;oiN#\u0018\r^3S_>$XCAA+!\u0015q\u0012qKA.\u0013\r\tIf\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004=\u0005u\u0013bAA0?\t!!)\u001f;f\u0003U9W\r\u001e+sC:\u001c\u0018m\u0019;j_:\u0014VmY3jaR$B!!\u001a\u0002xA!adQA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\nqA]3dK&\u0004HOC\u0002\u0002rU\tQa\u001d;bi\u0016LA!!\u001e\u0002l\tyQ\t\u001e5fe\u0016,XNU3dK&\u0004H\u000fC\u0004\u0002zE\u0001\r!!\u0016\u0002\rQD\b*Y:i\u0001")
public class AccountStateMetadataStorage
implements AccountStateMetadataStorageReader,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AccountStateMetadataStorageView getView() {
        return new AccountStateMetadataStorageView(this.storage);
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<AccountStateMetadataStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return this.getView().getWithdrawalEpochInfo();
    }

    @Override
    public Seq<AccountBlockFeeInfo> getFeePayments(int withdrawalEpochNumber) {
        return this.getView().getFeePayments(withdrawalEpochNumber);
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        return this.getView().getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.getView().lastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.getView().lastCertificateSidechainBlockId();
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.getView().getConsensusEpochNumber();
    }

    @Override
    public boolean hasCeased() {
        return this.getView().hasCeased();
    }

    @Override
    public int getHeight() {
        return this.getView().getHeight();
    }

    @Override
    public byte[] getAccountStateRoot() {
        return this.getView().getAccountStateRoot();
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        return this.getView().getTransactionReceipt(txHash);
    }

    public AccountStateMetadataStorage(Storage storage) {
        this.storage = storage;
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

