/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state.events;

import io.horizen.account.state.events.annotation.Anonymous;
import io.horizen.account.state.events.annotation.Indexed;
import io.horizen.account.state.events.annotation.Parameter;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.utils.Numeric;
import sparkz.crypto.hash.Keccak256;

public class EthereumEvent {
    private EthereumEvent() {
    }

    private static ArrayList<EventParameterData> getEventParameterData(Object eventInstance) throws IllegalAccessException, InvocationTargetException {
        TreeMap<Integer, EventParameterData> annotatedParams = new TreeMap<Integer, EventParameterData>();
        ArrayList<AccessibleObject> parameterCandidates = new ArrayList<AccessibleObject>();
        for (Constructor<?> constructor : eventInstance.getClass().getDeclaredConstructors()) {
            if (!Arrays.stream(constructor.getParameterAnnotations()).flatMap(Arrays::stream).anyMatch(x -> x instanceof Parameter)) continue;
            throw new IllegalArgumentException("Error while trying the get the parameter data: Parameter annotation not allowed in constructor");
        }
        parameterCandidates.addAll(List.of(eventInstance.getClass().getDeclaredMethods()));
        parameterCandidates.addAll(List.of(eventInstance.getClass().getDeclaredFields()));
        for (AccessibleObject acObj : parameterCandidates) {
            boolean indexed;
            if (acObj.getAnnotation(Parameter.class) == null) continue;
            if (!acObj.canAccess(eventInstance)) {
                throw new IllegalAccessException("Error: No access to object, check access modifiers");
            }
            boolean bl = indexed = acObj.getAnnotation(Indexed.class) != null;
            if (annotatedParams.containsKey(acObj.getAnnotation(Parameter.class).value())) {
                throw new IllegalArgumentException("Error: Duplicate parameter annotation value");
            }
            if (acObj instanceof Field) {
                Field field = (Field)acObj;
                annotatedParams.put(acObj.getAnnotation(Parameter.class).value(), new EventParameterData(indexed, field.getType(), (Type)field.get(eventInstance)));
                continue;
            }
            Method method = (Method)acObj;
            annotatedParams.put(acObj.getAnnotation(Parameter.class).value(), new EventParameterData(indexed, method.getReturnType(), (Type)method.invoke(eventInstance, new Object[0])));
        }
        return new ArrayList<EventParameterData>(annotatedParams.values());
    }

    private static EthereumConsensusDataLog createEthereumConsensusDataLog(Address contractAddress, Function eventFunction, Boolean anonymous) throws IOException {
        ArrayList<Hash> topics = new ArrayList<Hash>();
        ByteArrayOutputStream dataOutputStream = new ByteArrayOutputStream();
        List outputParameters = eventFunction.getOutputParameters();
        if (!anonymous.booleanValue()) {
            topics.add(new Hash(EventEncoder.encode((Event)new Event(eventFunction.getName(), new ArrayList(outputParameters)))));
        }
        for (int i = 0; i < outputParameters.size(); ++i) {
            byte[] encodedValue = Numeric.hexStringToByteArray((String)TypeEncoder.encode((Type)((Type)eventFunction.getInputParameters().get(i))));
            if (((TypeReference)outputParameters.get(i)).isIndexed()) {
                if (topics.size() > 3) {
                    throw new IllegalArgumentException("Error: More than four topics defined - defined topics: " + topics.size());
                }
                if (encodedValue.length > 32) {
                    encodedValue = Keccak256.hash((byte[])encodedValue);
                }
                topics.add(new Hash(encodedValue));
                continue;
            }
            dataOutputStream.write(encodedValue);
        }
        return new EthereumConsensusDataLog(contractAddress, topics.toArray(new Hash[0]), dataOutputStream.toByteArray());
    }

    public static EthereumConsensusDataLog getEthereumConsensusDataLog(Address contractAddress, Object eventInstance) throws ClassNotFoundException, IOException, IllegalAccessException, InvocationTargetException {
        ArrayList<TypeReference> parametersTypeRef = new ArrayList<TypeReference>();
        ArrayList<Type> convertedParams = new ArrayList<Type>();
        ArrayList<EventParameterData> annotatedParameters = EthereumEvent.getEventParameterData(eventInstance);
        for (EventParameterData parameterData : annotatedParameters) {
            convertedParams.add(parameterData.value);
            parametersTypeRef.add(TypeReference.makeTypeReference((String)parameterData.value.getTypeAsString(), (boolean)parameterData.indexed, (boolean)false));
        }
        Class<?> classRef = eventInstance.getClass();
        return EthereumEvent.createEthereumConsensusDataLog(contractAddress, new Function(classRef.getSimpleName(), convertedParams, parametersTypeRef), classRef.getAnnotation(Anonymous.class) != null);
    }

    private static class EventParameterData {
        Boolean indexed;
        Class<?> annotatedParam;
        Type value;

        public EventParameterData(Boolean indexed, Class<?> annotatedParam, Type value) {
            this.indexed = indexed;
            this.annotatedParam = annotatedParam;
            this.value = value;
        }
    }
}

