/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.AddWithdrawalRequestCmdInput;
import io.horizen.account.state.AddWithdrawalRequestCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GetListOfWithdrawalRequestsCmdInput;
import io.horizen.account.state.GetListOfWithdrawalRequestsCmdInputDecoder$;
import io.horizen.account.state.Message;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.WithdrawalRequestProvider;
import io.horizen.account.state.WithdrawalRequestSerializer$;
import io.horizen.account.state.WithdrawalRequestsListEncoder$;
import io.horizen.account.state.events.AddWithdrawalRequest;
import io.horizen.account.state.events.AddWithdrawalRequest$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.utils.WithdrawalEpochUtils$;
import io.horizen.utils.ZenCoinsUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.web3j.utils.Numeric;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

public final class WithdrawalMsgProcessor$
extends NativeSmartContractMsgProcessor
implements WithdrawalRequestProvider {
    public static WithdrawalMsgProcessor$ MODULE$;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final String GetListOfWithdrawalReqsCmdSig;
    private final String AddNewWithdrawalReqCmdSig;
    private final BigInteger DustThresholdInWei;

    static {
        new WithdrawalMsgProcessor$();
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public String GetListOfWithdrawalReqsCmdSig() {
        return this.GetListOfWithdrawalReqsCmdSig;
    }

    public String AddNewWithdrawalReqCmdSig() {
        return this.AddNewWithdrawalReqCmdSig;
    }

    public BigInteger DustThresholdInWei() {
        return this.DustThresholdInWei;
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(gas);
        String string = ABIUtil.getFunctionSignature(msg.getData());
        String string2 = this.GetListOfWithdrawalReqsCmdSig();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.execGetListOfWithdrawalReqRecords(msg, gasView);
        } else {
            String string4 = this.AddNewWithdrawalReqCmdSig();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.execAddWithdrawalRequest(msg, gasView, blockContext.withdrawalEpochNumber);
            } else {
                throw new ExecutionRevertedException(new StringBuilder(55).append("Requested function does not exist. Function signature: ").append(string).toString());
            }
        }
        return byArray;
    }

    private int getWithdrawalEpochCounter(BaseAccountStateView view, int epochNum) {
        byte[] key = this.getWithdrawalEpochCounterKey(epochNum);
        byte[] wrCounterInBytesPadded = view.getAccountStorage(this.contractAddress(), key);
        return Numeric.toBigInt((byte[])wrCounterInBytesPadded).intValueExact();
    }

    public void setWithdrawalEpochCounter(BaseAccountStateView view, int currentEpochNum, int nextNumOfWithdrawalReqs) {
        byte[] paddedNextNumOfWithdrawalReqs = Numeric.toBytesPadded((BigInteger)BigInteger.valueOf(nextNumOfWithdrawalReqs), (int)32);
        byte[] wrCounterKey = this.getWithdrawalEpochCounterKey(currentEpochNum);
        view.updateAccountStorage(this.contractAddress(), wrCounterKey, paddedNextNumOfWithdrawalReqs);
    }

    @Override
    public Seq<WithdrawalRequest> getListOfWithdrawalReqRecords(int epochNum, BaseAccountStateView view) {
        int numOfWithdrawalReqs = this.getWithdrawalEpochCounter(view, epochNum);
        IndexedSeq listOfWithdrawalReqs = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numOfWithdrawalReqs).map((Function1 & Serializable & scala.Serializable)index -> WithdrawalMsgProcessor$.$anonfun$getListOfWithdrawalReqRecords$1(epochNum, view, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
        return listOfWithdrawalReqs;
    }

    public byte[] execGetListOfWithdrawalReqRecords(Message msg, BaseAccountStateView view) {
        GetListOfWithdrawalRequestsCmdInput decodedBytes;
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        if (msg.getData().length != 4 + GetListOfWithdrawalRequestsCmdInputDecoder$.MODULE$.getABIDataParamsLengthInBytes()) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Wrong message data field length: ").append(msg.getData().length).toString());
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (GetListOfWithdrawalRequestsCmdInput)GetListOfWithdrawalRequestsCmdInputDecoder$.MODULE$.decode(ABIUtil.getArgumentsFromData(msg.getData())));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(31).append("Could not decode input params: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        GetListOfWithdrawalRequestsCmdInput getListOfWithdrawalRequestsCmdInput = decodedBytes = (GetListOfWithdrawalRequestsCmdInput)success.value();
        GetListOfWithdrawalRequestsCmdInput inputParams = getListOfWithdrawalRequestsCmdInput;
        Seq<WithdrawalRequest> listOfWithdrawalReqs = this.getListOfWithdrawalReqRecords(inputParams.epochNum(), view);
        return WithdrawalRequestsListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(listOfWithdrawalReqs).asJava());
    }

    public void checkWithdrawalRequestValidity(Message msg) {
        BigInteger withdrawalAmount = msg.getValue();
        if (msg.getData().length != 4 + AddWithdrawalRequestCmdInputDecoder$.MODULE$.getABIDataParamsLengthInBytes()) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Wrong message data field length: ").append(msg.getData().length).toString());
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(withdrawalAmount)) {
            throw new ExecutionRevertedException(new StringBuilder(45).append("Withdrawal amount is not a valid Zen amount: ").append(withdrawalAmount).toString());
        }
        if (withdrawalAmount.compareTo(this.DustThresholdInWei()) < 0) {
            throw new ExecutionRevertedException(new StringBuilder(47).append("Withdrawal amount is under the dust threshold: ").append(withdrawalAmount).toString());
        }
    }

    public byte[] execAddWithdrawalRequest(Message msg, BaseAccountStateView view, int currentEpochNum) {
        this.checkWithdrawalRequestValidity(msg);
        int numOfWithdrawalReqs = this.getWithdrawalEpochCounter(view, currentEpochNum);
        if (numOfWithdrawalReqs >= WithdrawalEpochUtils$.MODULE$.MaxWithdrawalReqsNumPerEpoch()) {
            throw new ExecutionRevertedException("Reached maximum number of Withdrawal Requests per epoch: request is invalid");
        }
        int nextNumOfWithdrawalReqs = numOfWithdrawalReqs + 1;
        this.setWithdrawalEpochCounter(view, currentEpochNum, nextNumOfWithdrawalReqs);
        AddWithdrawalRequestCmdInput inputParams = (AddWithdrawalRequestCmdInput)AddWithdrawalRequestCmdInputDecoder$.MODULE$.decode(ABIUtil.getArgumentsFromData(msg.getData()));
        BigInteger withdrawalAmount = msg.getValue();
        WithdrawalRequest request = new WithdrawalRequest(inputParams.mcAddr(), withdrawalAmount);
        byte[] requestInBytes = request.bytes();
        view.updateAccountStorageBytes(this.contractAddress(), this.getWithdrawalRequestsKey(currentEpochNum, nextNumOfWithdrawalReqs), requestInBytes);
        view.subBalance(msg.getFrom(), withdrawalAmount);
        AddWithdrawalRequest withdrawalEvent = AddWithdrawalRequest$.MODULE$.apply(msg.getFrom(), request.proposition(), withdrawalAmount, currentEpochNum);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(withdrawalEvent);
        view.addLog(evmLog);
        return request.encode();
    }

    public byte[] calculateKey(byte[] keySeed) {
        return Keccak256$.MODULE$.hash(keySeed);
    }

    public byte[] getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public byte[] getWithdrawalRequestsKey(int withdrawalEpoch, int counter) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public static final /* synthetic */ WithdrawalRequest $anonfun$getListOfWithdrawalReqRecords$1(int epochNum$1, BaseAccountStateView view$1, int index) {
        byte[] currentKey = MODULE$.getWithdrawalRequestsKey(epochNum$1, index);
        return (WithdrawalRequest)WithdrawalRequestSerializer$.MODULE$.parseBytes(view$1.getAccountStorageBytes(MODULE$.contractAddress(), currentKey));
    }

    private WithdrawalMsgProcessor$() {
        MODULE$ = this;
        this.contractAddress = WellKnownAddresses$.MODULE$.WITHDRAWAL_REQ_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("WithdrawalRequestSmartContractCode");
        this.GetListOfWithdrawalReqsCmdSig = ABIUtil.getABIMethodId("getBackwardTransfers(uint32)");
        this.AddNewWithdrawalReqCmdSig = ABIUtil.getABIMethodId("backwardTransfer(bytes20)");
        this.DustThresholdInWei = ZenWeiConverter$.MODULE$.convertZenniesToWei(ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE));
    }
}

