/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.FeeCapTooLowException;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.InsufficientFundsException;
import io.horizen.account.state.IntrinsicGasException;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceMaxException;
import io.horizen.account.state.NonceTooHighException;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.evm.Address;
import java.io.Serializable;
import java.math.BigInteger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001A4AAC\u0006\u0001)!A1\u0005\u0001B\u0001B\u0003%A\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0001\u0003A\u0011A!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000b\t\u0004A\u0011B2\t\u000b!\u0004A\u0011B5\t\u000b-\u0004A\u0011\u00027\u0003\u001fM#\u0018\r^3Ue\u0006t7/\u001b;j_:T!\u0001D\u0007\u0002\u000bM$\u0018\r^3\u000b\u00059y\u0011aB1dG>,h\u000e\u001e\u0006\u0003!E\tq\u0001[8sSj,gNC\u0001\u0013\u0003\tIwn\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039\u0005j\u0011!\b\u0006\u0003=}\tA!\u001e;jY*\t\u0001%\u0001\u0004ta\u0006\u00148N_\u0005\u0003Eu\u0011Qb\u00159be.THj\\4hS:<\u0017\u0001\u0002<jK^\u0004\"!\n\u0014\u000e\u0003-I!aJ\u0006\u0003/M#\u0018\r^3EE\u0006\u001b7m\\;oiN#\u0018\r^3WS\u0016<\u0018!E7fgN\fw-\u001a)s_\u000e,7o]8sgB\u0019!FM\u001b\u000f\u0005-\u0002dB\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0014\u0003\u0019a$o\\8u}%\t\u0001$\u0003\u00022/\u00059\u0001/Y2lC\u001e,\u0017BA\u001a5\u0005\r\u0019V-\u001d\u0006\u0003c]\u0001\"!\n\u001c\n\u0005]Z!\u0001E'fgN\fw-\u001a)s_\u000e,7o]8s\u00031\u0011Gn\\2l\u000f\u0006\u001c\bk\\8m!\t)#(\u0003\u0002<\u0017\t9q)Y:Q_>d\u0017\u0001\u00042m_\u000e\\7i\u001c8uKb$\bCA\u0013?\u0013\ty4B\u0001\u0007CY>\u001c7nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0006\u0005\u000e#UI\u0012\t\u0003K\u0001AQaI\u0003A\u0002\u0011BQ\u0001K\u0003A\u0002%BQ\u0001O\u0003A\u0002eBQ\u0001P\u0003A\u0002u\n!\u0002\u001e:b]NLG/[8o)\tIu\nE\u0002\u0017\u00152K!aS\f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Yi\u0015B\u0001(\u0018\u0005\u0011\u0011\u0015\u0010^3\t\u000bA3\u0001\u0019A)\u0002\u00075\u001cx\r\u0005\u0002&%&\u00111k\u0003\u0002\b\u001b\u0016\u001c8/Y4fQ\r1Qk\u0017\t\u0004-YC\u0016BA,\u0018\u0005\u0019!\bN]8xgB\u0011Q%W\u0005\u00035.\u0011\u0001$\u0012=fGV$\u0018n\u001c8GC&dW\rZ#yG\u0016\u0004H/[8oG\u0005A\u0006f\u0001\u0004^CB\u0019aC\u00160\u0011\u0005\u0015z\u0016B\u00011\f\u0005]IeN^1mS\u0012lUm]:bO\u0016,\u0005pY3qi&|gnI\u0001_\u0003!\u0001(/Z\"iK\u000e\\GC\u00013h!\t1R-\u0003\u0002g/\t!QK\\5u\u0011\u0015\u0001v\u00011\u0001R\u0003\u0019\u0011W/_$bgR\u0011\u0011H\u001b\u0005\u0006!\"\u0001\r!U\u0001\ne\u00164WO\u001c3HCN$2\u0001Z7o\u0011\u0015\u0001\u0016\u00021\u0001R\u0011\u0015y\u0017\u00021\u0001:\u0003\r9\u0017m\u001d")
public class StateTransition
implements SparkzLogging {
    private final StateDbAccountStateView view;
    private final Seq<MessageProcessor> messageProcessors;
    private final GasPool blockGasPool;
    private final BlockContext blockContext;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public byte[] transition(Message msg) throws InvalidMessageException, ExecutionFailedException {
        byte[] byArray;
        this.preCheck(msg);
        BigInteger initialBlockGas = this.blockGasPool.getGas();
        int initialRevision = this.view.snapshot();
        try {
            byte[] byArray2;
            block16: {
                GasPool gasPool = this.buyGas(msg);
                BigInteger intrinsicGas = GasUtil$.MODULE$.intrinsicGas(msg.getData(), msg.getTo().isEmpty());
                if (gasPool.getGas().compareTo(intrinsicGas) < 0) {
                    throw new IntrinsicGasException(gasPool.getGas(), intrinsicGas);
                }
                gasPool.subGas(intrinsicGas);
                this.view.setupAccessList(msg);
                Option option = this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canProcess(msg, this.view, this.blockContext.consensusEpochNumber)));
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("No message processor found for executing message {}", new Object[]{msg});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(new StringBuilder(50).append("No message processor found for executing message: ").append(msg).toString());
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    MessageProcessor processor = (MessageProcessor)some.value();
                    this.view.increaseNonce(msg.getFrom());
                    int revisionProcessor = this.view.snapshot();
                    boolean skipRefund = false;
                    try {
                        try {
                            byArray2 = processor.process(msg, this.view, gasPool, this.blockContext);
                            break block16;
                        }
                        catch (ExecutionRevertedException err) {
                            this.view.revertToSnapshot(revisionProcessor);
                            throw err;
                        }
                        catch (ExecutionFailedException err) {
                            this.view.revertToSnapshot(revisionProcessor);
                            gasPool.subGas(gasPool.getGas());
                            throw err;
                        }
                        catch (Throwable err) {
                            skipRefund = true;
                            throw err;
                        }
                    }
                    finally {
                        if (!skipRefund) {
                            this.refundGas(msg, gasPool);
                        }
                    }
                }
                throw new MatchError((Object)option);
            }
            byte[] byArray3 = byArray2;
            byArray = byArray3;
        }
        catch (ExecutionFailedException err) {
            throw err;
        }
        catch (Throwable err) {
            this.view.revertToSnapshot(initialRevision);
            this.blockGasPool.addGas(initialBlockGas.subtract(this.blockGasPool.getGas()));
            throw err;
        }
        return byArray;
    }

    private void preCheck(Message msg) {
        Address sender = msg.getFrom();
        if (!msg.getIsFakeMsg()) {
            BigInteger stateNonce = this.view.getNonce(sender);
            int n = msg.getNonce().compareTo(stateNonce);
            switch (n) {
                default: 
            }
            if (n < 0) {
                throw new NonceTooLowException(sender, msg.getNonce(), stateNonce);
            }
            if (n > 0) {
                throw new NonceTooHighException(sender, msg.getNonce(), stateNonce);
            }
            if (!BigIntegerUtil$.MODULE$.isUint64(stateNonce.add(BigInteger.ONE))) {
                throw new NonceMaxException(sender, stateNonce);
            }
            if (!this.view.isEoaAccount(sender)) {
                throw new SenderNotEoaException(sender, this.view.getCodeHash(sender));
            }
        }
        if (!(msg.getIsFakeMsg() && msg.getGasFeeCap().bitLength() <= 0 || msg.getGasFeeCap().compareTo(this.blockContext.baseFee) >= 0)) {
            throw new FeeCapTooLowException(sender, msg.getGasFeeCap(), this.blockContext.baseFee);
        }
    }

    private GasPool buyGas(Message msg) {
        BigInteger want;
        BigInteger gas = msg.getGasLimit();
        BigInteger effectiveFees = gas.multiply(msg.getGasPrice());
        BigInteger maxFees = msg.getGasFeeCap() == null ? effectiveFees : gas.multiply(msg.getGasFeeCap());
        Address sender = msg.getFrom();
        BigInteger have = this.view.getBalance(sender);
        if (have.compareTo(want = maxFees.add(msg.getValue())) < 0) {
            throw new InsufficientFundsException(sender, have, want);
        }
        if (this.blockGasPool.getGas().compareTo(gas) < 0) {
            throw new GasLimitReached();
        }
        this.blockGasPool.subGas(gas);
        this.view.subBalance(sender, effectiveFees);
        return new GasPool(gas);
    }

    private void refundGas(Message msg, GasPool gas) {
        gas.addGas(this.view.getRefund().min(gas.getUsedGas().divide(GasUtil$.MODULE$.RefundQuotientEIP3529())));
        BigInteger remaining = gas.getGas().multiply(msg.getGasPrice());
        this.view.addBalance(msg.getFrom(), remaining);
        this.blockGasPool.addGas(gas.getGas());
    }

    public StateTransition(StateDbAccountStateView view, Seq<MessageProcessor> messageProcessors, GasPool blockGasPool, BlockContext blockContext) {
        this.view = view;
        this.messageProcessors = messageProcessors;
        this.blockGasPool = blockGasPool;
        this.blockContext = blockContext;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

