/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateReader;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.InvalidMessageException;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.McAddrOwnershipsProvider;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.StateDbAccountStateViewGasTracked;
import io.horizen.account.state.StateTransition;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.WithdrawalRequestProvider;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt$ReceiptStatus$;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.BigIntegerUtil$;
import io.horizen.account.utils.MainchainTxCrosschainOutputAddressUtil$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainTxForwardTransferCrosschainOutput;
import io.horizen.block.MainchainTxSidechainCreationCrosschainOutput;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.evm.results.EvmLog;
import io.horizen.evm.results.ProofAccountResult;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.transaction.mainchain.ForwardTransfer;
import io.horizen.transaction.mainchain.SidechainCreation;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\rue\u0001B\u001c9\u0001\u0005C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005I\")1\u000f\u0001C\u0001i\"A\u0001\u0010\u0001EC\u0002\u0013\u0005\u0011\u0010\u0003\u0005~\u0001!\u0015\r\u0011\"\u0001\u007f\u0011)\t)\u0001\u0001EC\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005\u0002\u0005E\u0001bBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!!\u0019\u0001\t\u0003\n\u0019\u0007C\u0004\u0002\u0002\u0002!\t%a!\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBAO\u0001\u0011\u0005\u0013q\u0014\u0005\b\u0003_\u0003A\u0011IAY\u0011\u001d\tY\f\u0001C!\u0003{Cq!a4\u0001\t\u0003\t\t\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005m\b\u0001\"\u0001\u0002~\"9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002BB\u0001\u0011\u0005#Q\u0011\u0005\b\u0005#\u0003A\u0011\tBJ\u0011\u001d\u00119\n\u0001C!\u00053CqA!(\u0001\t\u0003\u0012y\nC\u0004\u0003(\u0002!\tE!+\t\u000f\t5\u0006\u0001\"\u0011\u00030\"9!Q\u0019\u0001\u0005B\t\u001d\u0007b\u0002Bh\u0001\u0011\u0005#\u0011\u001b\u0005\b\u00053\u0004A\u0011\tBn\u0011\u001d\u0011)\u000f\u0001C#\u0005OD\u0011B!<\u0001\u0005\u0004%IAa<\t\u0011\tE\b\u0001)A\u0005\u0003\u0007DqAa=\u0001\t\u0013\u0011)\u0010C\u0004\u0003~\u0002!)Ea@\t\u000f\r\u0015\u0001\u0001\"\u0012\u0004\b!91q\u0002\u0001\u0005F\rE\u0001bBB\f\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007[\u0001A\u0011IB\u0018\u0011\u001d\u0019\u0019\u0004\u0001C!\u0007kAqa!\u000f\u0001\t\u0003\u001aY\u0004C\u0004\u0004@\u0001!\te!\u0011\t\u000f\r\u0015\u0003\u0001\"\u0011\u0004H!91Q\u000b\u0001\u0005B\r]\u0003bBB/\u0001\u0011\u00053q\f\u0005\b\u0007C\u0002A\u0011IB2\u0011\u001d\u0019Y\u0007\u0001C!\u0005_Dqa!\u001c\u0001\t\u0003\u0019y\u0007C\u0004\u0004~\u0001!\taa \t\u000f\r\r\u0005\u0001\"\u0001\u0004\u0006\"91q\u0011\u0001\u0005\u0002\r%\u0005bBBF\u0001\u0011\u00051q\f\u0005\b\u0007\u001b\u0003A\u0011ABH\u0011\u001d\u0019)\n\u0001C!\u0007/\u0013qc\u0015;bi\u0016$%-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\u000b\u0005eR\u0014!B:uCR,'BA\u001e=\u0003\u001d\t7mY8v]RT!!\u0010 \u0002\u000f!|'/\u001b>f]*\tq(\u0001\u0002j_\u000e\u00011#\u0002\u0001C\u00112#\u0006CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00156\t\u0001(\u0003\u0002Lq\t!\")Y:f\u0003\u000e\u001cw.\u001e8u'R\fG/\u001a,jK^\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA!\u001e;jY*\t\u0011,\u0001\u0004ta\u0006\u00148N_\u0005\u00037Z\u0013Qb\u00159be.THj\\4hS:<\u0017aB:uCR,GI\u0019\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Ar\n1!\u001a<n\u0013\t\u0011wLA\u0004Ti\u0006$X\r\u0012\"\u0002#5,7o]1hKB\u0013xnY3tg>\u00148\u000fE\u0002f[Bt!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%\u0004\u0015A\u0002\u001fs_>$h(C\u0001F\u0013\taG)A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011A\u000e\u0012\t\u0003\u0013FL!A\u001d\u001d\u0003!5+7o]1hKB\u0013xnY3tg>\u0014\u0018A\u0002\u001fj]&$h\bF\u0002vm^\u0004\"!\u0013\u0001\t\u000bq\u001b\u0001\u0019A/\t\u000b\r\u001c\u0001\u0019\u00013\u0002+]LG\u000f\u001b3sC^\fGNU3r!J|g/\u001b3feV\t!\u0010\u0005\u0002Jw&\u0011A\u0010\u000f\u0002\u001a/&$\b\u000e\u001a:bo\u0006d'+Z9vKN$\bK]8wS\u0012,'/\u0001\u000bg_J<WM]*uC.,7\u000f\u0015:pm&$WM]\u000b\u0002\u007fB\u0019\u0011*!\u0001\n\u0007\u0005\r\u0001H\u0001\u000bG_J<WM]*uC.,7\u000f\u0015:pm&$WM]\u0001\u0018G\u0016\u0014H/\u001b4jG\u0006$XmS3zgB\u0013xN^5eKJ,\"!!\u0003\u0011\u0007%\u000bY!C\u0002\u0002\u000ea\u0012qcQ3si&4\u0017nY1uK.+\u0017p\u001d)s_ZLG-\u001a:\u0002/5\u001c\u0017\t\u001a3s\u001f^tWM]:iSB\u0004&o\u001c<jI\u0016\u0014XCAA\n!\rI\u0015QC\u0005\u0004\u0003/A$\u0001G'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9t!J|g/\u001b3fe\u0006\u00012.Z=S_R\fG/[8o!J|wN\u001a\u000b\t\u0003;\t\u0019$!\u0010\u0002BA)1)a\b\u0002$%\u0019\u0011\u0011\u0005#\u0003\r=\u0003H/[8o!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\tAa[3zg*\u0019\u0011Q\u0006\u001f\u0002)\r,'\u000f^5gS\u000e\fG/Z:vE6LG\u000f^3s\u0013\u0011\t\t$a\n\u0003!-+\u0017PU8uCRLwN\u001c)s_>4\u0007bBA\u001b\u0011\u0001\u0007\u0011qG\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQB\u00191)!\u000f\n\u0007\u0005mBIA\u0002J]RDq!a\u0010\t\u0001\u0004\t9$A\u0007j]\u0012,\u0007p\u00144TS\u001etWM\u001d\u0005\b\u0003\u0007B\u0001\u0019AA\u001c\u0003\u001dYW-\u001f+za\u0016\fabY3si&4\u0017.\u001a:t\u0017\u0016L8\u000f\u0006\u0003\u0002J\u0005E\u0003#B\"\u0002 \u0005-\u0003\u0003BA\u0013\u0003\u001bJA!a\u0014\u0002(\tq1)\u001a:uS\u001aLWM]:LKf\u001c\bbBA\u001b\u0013\u0001\u0007\u0011qG\u0001\u0016O\u0016$x+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;t)\u0011\t9&a\u0018\u0011\t\u0015l\u0017\u0011\f\t\u0004\u0013\u0006m\u0013bAA/q\t\tr+\u001b;iIJ\fw/\u00197SKF,Xm\u001d;\t\u000f\u0005U\"\u00021\u0001\u00028\u0005\u0011r-\u001a;G_J<WM]*uC.,G)\u0019;b)\u0011\t)'!\u001c\u0011\u000b\r\u000by\"a\u001a\u0011\u0007%\u000bI'C\u0002\u0002la\u0012qBR8sO\u0016\u00148\u000b^1lK\u0012\u000bG/\u0019\u0005\b\u0003_Z\u0001\u0019AA9\u0003\u001d\u0019H/Y6f\u0013\u0012\u0004B!a\u001d\u0002|9!\u0011QOA<!\t9G)C\u0002\u0002z\u0011\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA?\u0003\u007f\u0012aa\u0015;sS:<'bAA=\t\u0006i\u0011n\u001d$pe\u001eLgnZ(qK:,\"!!\"\u0011\u0007\r\u000b9)C\u0002\u0002\n\u0012\u0013qAQ8pY\u0016\fg.\u0001\fhKRd\u0015n\u001d;PM\u001a{'oZ3sgN#\u0018m[3t+\t\ty\t\u0005\u0003f[\u0006E\u0005cA%\u0002\u0014&\u0019\u0011Q\u0013\u001d\u0003/\u0005\u001b7m\\;oi\u001a{'oZ5oON#\u0018m[3J]\u001a|\u0017\u0001F4fi\u0006cGn\\<fI\u001a{'oZ3s\u0019&\u001cH/\u0006\u0002\u0002\u001cB!Q-\\A\u001c\u0003e9W\r\u001e'jgR|e-T2BI\u0012\u0014xj\u001e8feND\u0017\u000e]:\u0015\t\u0005\u0005\u0016\u0011\u0016\t\u0005K6\f\u0019\u000bE\u0002J\u0003KK1!a*9\u0005Mi5-\u00113ee>;h.\u001a:tQ&\u0004H)\u0019;b\u0011%\tYk\u0004I\u0001\u0002\u0004\ti+\u0001\u0007tG\u0006#GM]3tg>\u0003H\u000fE\u0003D\u0003?\t\t(A\rhKRd\u0015n\u001d;PM>;h.\u001a:TG\u0006#GM]3tg\u0016\u001cHCAAZ!\u0011)W.!.\u0011\u0007%\u000b9,C\u0002\u0002:b\u0012abT<oKJ\u001c6-\u00113ee\u0016\u001c8/\u0001\npo:,'o\u001d5ja\u0012\u000bG/Y#ySN$H\u0003BAC\u0003\u007fCq!!1\u0012\u0001\u0004\t\u0019-A\u0006po:,'o\u001d5ja&#\u0007#B\"\u0002F\u0006%\u0017bAAd\t\n)\u0011I\u001d:bsB\u00191)a3\n\u0007\u00055GI\u0001\u0003CsR,\u0017\u0001I1qa2LX*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006$B!a5\u0002ZB\u00191)!6\n\u0007\u0005]GI\u0001\u0003V]&$\bbBAn%\u0001\u0007\u0011Q\\\u0001\be\u00164G)\u0019;b!\u0011\ty.!:\u000e\u0005\u0005\u0005(bAAry\u0005)!\r\\8dW&!\u0011q]Aq\u0005mi\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC\u0006qr-\u001a;Pe\u0012,'/\u001a3G_J<\u0017N\\4Ti\u0006\\Wm]%oM>\u001cV-]\u000b\u0003\u0003[\u0004B!Z7\u0002pB!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002\u0002vr\n\u0011bY8og\u0016t7/^:\n\t\u0005e\u00181\u001f\u0002\u0011\r>\u0014x-\u001b8h'R\f7.Z%oM>\fA\"\u00199qYflUm]:bO\u0016$\u0002\"a1\u0002\u0000\n%!1\u0003\u0005\b\u0005\u0003!\u0002\u0019\u0001B\u0002\u0003\ri7o\u001a\t\u0004\u0013\n\u0015\u0011b\u0001B\u0004q\t9Q*Z:tC\u001e,\u0007b\u0002B\u0006)\u0001\u0007!QB\u0001\rE2|7m[$bgB{w\u000e\u001c\t\u0004\u0013\n=\u0011b\u0001B\tq\t9q)Y:Q_>d\u0007b\u0002B\u000b)\u0001\u0007!qC\u0001\rE2|7m[\"p]R,\u0007\u0010\u001e\t\u0004\u0013\ne\u0011b\u0001B\u000eq\ta!\t\\8dW\u000e{g\u000e^3yi\"*ACa\b\u0003,A)1I!\t\u0003&%\u0019!1\u0005#\u0003\rQD'o\\<t!\rI%qE\u0005\u0004\u0005SA$\u0001G#yK\u000e,H/[8o\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!Q\u0005\u0015\u0006)\t=\"q\u0007\t\u0006\u0007\n\u0005\"\u0011\u0007\t\u0004\u0013\nM\u0012b\u0001B\u001bq\t9\u0012J\u001c<bY&$W*Z:tC\u001e,W\t_2faRLwN\\\u0012\u0003\u0005c\t\u0001#\u00199qYf$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0015\tu\"1\u000bB>\u0005\u007f\u0012\t\t\u0005\u0004\u0003@\t\r#qI\u0007\u0003\u0005\u0003R!a\u0016#\n\t\t\u0015#\u0011\t\u0002\u0004)JL\b\u0003\u0002B%\u0005\u001fj!Aa\u0013\u000b\u0007\t5\u0003(A\u0004sK\u000e,\u0017\u000e\u001d;\n\t\tE#1\n\u0002\u001d\u000bRDWM]3v[\u000e{gn]3ogV\u001cH)\u0019;b%\u0016\u001cW-\u001b9u\u0011\u001d\u0011)&\u0006a\u0001\u0005/\n!\u0001\u001e=\u0011\u0011\te#q\fB2\u0005_j!Aa\u0017\u000b\u0007\tu#(A\u0006ue\u0006t7/Y2uS>t\u0017\u0002\u0002B1\u00057\u0012!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B!!Q\rB6\u001b\t\u00119GC\u0002\u0003jq\n1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!!Q\u000eB4\u0005-\u0001&o\u001c9pg&$\u0018n\u001c8\u0011\r\tE$q\u000fB2\u001b\t\u0011\u0019HC\u0002\u0003vq\nQ\u0001\u001d:p_\u001aLAA!\u001f\u0003t\t)\u0001K]8pM\"9!QP\u000bA\u0002\u0005]\u0012a\u0002;y\u0013:$W\r\u001f\u0005\b\u0005\u0017)\u0002\u0019\u0001B\u0007\u0011\u001d\u0011)\"\u0006a\u0001\u0005/\tA\"[:F_\u0006\f5mY8v]R$B!!\"\u0003\b\"9!\u0011\u0012\fA\u0002\t-\u0015aB1eIJ,7o\u001d\t\u0004=\n5\u0015b\u0001BH?\n9\u0011\t\u001a3sKN\u001c\u0018AF5t'6\f'\u000f^\"p]R\u0014\u0018m\u0019;BG\u000e|WO\u001c;\u0015\t\u0005\u0015%Q\u0013\u0005\b\u0005\u0013;\u0002\u0019\u0001BF\u00035\t7mY8v]R,\u00050[:ugR!\u0011Q\u0011BN\u0011\u001d\u0011I\t\u0007a\u0001\u0005\u0017\u000b!\"\u00193e\u0003\u000e\u001cw.\u001e8u)\u0019\t\u0019N!)\u0003$\"9!\u0011R\rA\u0002\t-\u0005b\u0002BS3\u0001\u0007\u00111Y\u0001\u0005G>$W-A\u0007j]\u000e\u0014X-Y:f\u001d>t7-\u001a\u000b\u0005\u0003'\u0014Y\u000bC\u0004\u0003\nj\u0001\rAa#\u0002\u0015\u0005$GMQ1mC:\u001cW\r\u0006\u0004\u0002T\nE&1\u0017\u0005\b\u0005\u0013[\u0002\u0019\u0001BF\u0011\u001d\u0011)l\u0007a\u0001\u0005o\u000ba!Y7pk:$\b\u0003\u0002B]\u0005\u007fk!Aa/\u000b\u0007\tu\u0006+\u0001\u0003nCRD\u0017\u0002\u0002Ba\u0005w\u0013!BQ5h\u0013:$XmZ3sQ\u0015Y\"q\u0004B\u0016\u0003)\u0019XO\u0019\"bY\u0006t7-\u001a\u000b\u0007\u0003'\u0014IMa3\t\u000f\t%E\u00041\u0001\u0003\f\"9!Q\u0017\u000fA\u0002\t]\u0006&\u0002\u000f\u0003 \t-\u0012!E4fi\u0006\u001b7m\\;oiN#xN]1hKR1\u00111\u0019Bj\u0005+DqA!#\u001e\u0001\u0004\u0011Y\tC\u0004\u0003Xv\u0001\r!a1\u0002\u0007-,\u00170\u0001\u000bva\u0012\fG/Z!dG>,h\u000e^*u_J\fw-\u001a\u000b\t\u0003'\u0014iNa8\u0003b\"9!\u0011\u0012\u0010A\u0002\t-\u0005b\u0002Bl=\u0001\u0007\u00111\u0019\u0005\b\u0005Gt\u0002\u0019AAb\u0003\u00151\u0018\r\\;f\u0003Q\u0011X-\\8wK\u0006\u001b7m\\;oiN#xN]1hKR1\u00111\u001bBu\u0005WDqA!# \u0001\u0004\u0011Y\tC\u0004\u0003X~\u0001\r!a1\u0002\u0019\rDWO\\6LKf\u001c\u0016\r\u001c;\u0016\u0005\u0005\r\u0017!D2ik:\\7*Z=TC2$\b%A\u0006hKR\u001c\u0005.\u001e8l\u0017\u0016LHCBAb\u0005o\u0014I\u0010C\u0004\u0003X\n\u0002\r!a1\t\u000f\tm(\u00051\u0001\u00028\u0005Q1\r[;oW&sG-\u001a=\u0002-\u001d,G/Q2d_VtGo\u0015;pe\u0006<WMQ=uKN$b!a1\u0004\u0002\r\r\u0001b\u0002BEG\u0001\u0007!1\u0012\u0005\b\u0005/\u001c\u0003\u0019AAb\u0003e)\b\u000fZ1uK\u0006\u001b7m\\;oiN#xN]1hK\nKH/Z:\u0015\u0011\u0005M7\u0011BB\u0006\u0007\u001bAqA!#%\u0001\u0004\u0011Y\tC\u0004\u0003X\u0012\u0002\r!a1\t\u000f\t\rH\u00051\u0001\u0002D\u0006I\"/Z7pm\u0016\f5mY8v]R\u001cFo\u001c:bO\u0016\u0014\u0015\u0010^3t)\u0019\t\u0019na\u0005\u0004\u0016!9!\u0011R\u0013A\u0002\t-\u0005b\u0002BlK\u0001\u0007\u00111Y\u0001\tO\u0016$\bK]8pMR111DB\u0014\u0007S\u0001Ba!\b\u0004$5\u00111q\u0004\u0006\u0004\u0007Cy\u0016a\u0002:fgVdGo]\u0005\u0005\u0007K\u0019yB\u0001\nQe>|g-Q2d_VtGOU3tk2$\bb\u0002BEM\u0001\u0007!1\u0012\u0005\b\u0003S1\u0003\u0019AB\u0016!\u0015\u0019\u0015QYAb\u0003!9W\r\u001e(p]\u000e,G\u0003\u0002B\\\u0007cAqA!#(\u0001\u0004\u0011Y)\u0001\u0006hKR\u0014\u0015\r\\1oG\u0016$BAa.\u00048!9!\u0011\u0012\u0015A\u0002\t-\u0015aC4fi\u000e{G-\u001a%bg\"$B!a1\u0004>!9!\u0011R\u0015A\u0002\t-\u0015aB4fi\u000e{G-\u001a\u000b\u0005\u0003\u0007\u001c\u0019\u0005C\u0004\u0003\n*\u0002\rAa#\u0002\u000f\u001d,G\u000fT8hgR!1\u0011JB)!\u0015\u0019\u0015QYB&!\u0011\u0011Ie!\u0014\n\t\r=#1\n\u0002\u0019\u000bRDWM]3v[\u000e{gn]3ogV\u001cH)\u0019;b\u0019><\u0007bBB*W\u0001\u0007\u00111Y\u0001\u0007ibD\u0015m\u001d5\u0002\r\u0005$G\rT8h)\u0011\t\u0019n!\u0017\t\u000f\rmC\u00061\u0001\u0004L\u0005\u0019An\\4\u0002\u000b\rdwn]3\u0015\u0005\u0005M\u0017\u0001E4fiN#\u0018\r^3EE\"\u000bg\u000e\u001a7f+\t\u0019)\u0007E\u0002_\u0007OJ1a!\u001b`\u00059\u0011Vm]8ve\u000e,\u0007*\u00198eY\u0016\f1cZ3u\u0013:$XM]7fI&\fG/\u001a*p_R\fab]3ukB$\u0006pQ8oi\u0016DH\u000f\u0006\u0004\u0002T\u000eE41\u000f\u0005\b\u0007'\u0002\u0004\u0019AAb\u0011\u001d\u0019)\b\ra\u0001\u0007o\n1!\u001b3y!\ri5\u0011P\u0005\u0004\u0007wr%aB%oi\u0016<WM]\u0001\u0010g\u0016$X\u000f]!dG\u0016\u001c8\u000fT5tiR!\u00111[BA\u0011\u001d\u0011\t!\ra\u0001\u0005\u0007\t\u0011bZ3u%\u00164WO\u001c3\u0016\u0005\t]\u0016\u0001C:oCB\u001c\bn\u001c;\u0016\u0005\u0005]\u0012a\u00044j]\u0006d\u0017N_3DQ\u0006tw-Z:\u0002!I,g/\u001a:u)>\u001cf.\u00199tQ>$H\u0003BAj\u0007#Cqaa%6\u0001\u0004\t9$\u0001\u0006sKZL7/[8o\u0013\u0012\f\u0011cZ3u\u000f\u0006\u001cHK]1dW\u0016$g+[3x)\rA5\u0011\u0014\u0005\b\u000773\u0004\u0019\u0001B\u0007\u0003\r9\u0017m\u001d")
public class StateDbAccountStateView
implements BaseAccountStateView,
AutoCloseable,
SparkzLogging {
    private WithdrawalRequestProvider withdrawalReqProvider;
    private ForgerStakesProvider forgerStakesProvider;
    private CertificateKeysProvider certificateKeysProvider;
    private McAddrOwnershipsProvider mcAddrOwnershipProvider;
    private final StateDB stateDb;
    private final Seq<MessageProcessor> messageProcessors;
    private final byte[] chunkKeySalt;
    private final Logger logger;
    private volatile byte bitmap$0;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$1() {
        return AccountStateReader.getListOfMcAddrOwnerships$default$1$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private WithdrawalRequestProvider withdrawalReqProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.withdrawalReqProvider = (WithdrawalRequestProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$withdrawalReqProvider$1(x$1))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.withdrawalReqProvider;
    }

    public WithdrawalRequestProvider withdrawalReqProvider() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.withdrawalReqProvider$lzycompute() : this.withdrawalReqProvider;
    }

    private ForgerStakesProvider forgerStakesProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.forgerStakesProvider = (ForgerStakesProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$forgerStakesProvider$1(x$2))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.forgerStakesProvider;
    }

    public ForgerStakesProvider forgerStakesProvider() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.forgerStakesProvider$lzycompute() : this.forgerStakesProvider;
    }

    private CertificateKeysProvider certificateKeysProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.certificateKeysProvider = (CertificateKeysProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$certificateKeysProvider$1(x$3))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.certificateKeysProvider;
    }

    public CertificateKeysProvider certificateKeysProvider() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.certificateKeysProvider$lzycompute() : this.certificateKeysProvider;
    }

    private McAddrOwnershipsProvider mcAddrOwnershipProvider$lzycompute() {
        StateDbAccountStateView stateDbAccountStateView = this;
        synchronized (stateDbAccountStateView) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mcAddrOwnershipProvider = (McAddrOwnershipsProvider)this.messageProcessors.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StateDbAccountStateView.$anonfun$mcAddrOwnershipProvider$1(x$4))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mcAddrOwnershipProvider;
    }

    public McAddrOwnershipsProvider mcAddrOwnershipProvider() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mcAddrOwnershipProvider$lzycompute() : this.mcAddrOwnershipProvider;
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return this.certificateKeysProvider().getKeyRotationProof(withdrawalEpoch, indexOfSigner, KeyRotationProofTypes$.MODULE$.apply(keyType), this);
    }

    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        return new Some((Object)this.certificateKeysProvider().getCertifiersKeys(withdrawalEpoch, this));
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return this.withdrawalReqProvider().getListOfWithdrawalReqRecords(withdrawalEpoch, this);
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return this.forgerStakesProvider().findStakeData(this, BytesUtils.fromHexString(stakeId));
    }

    @Override
    public boolean isForgingOpen() {
        return this.forgerStakesProvider().isForgerListOpen(this);
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return this.forgerStakesProvider().getListOfForgersStakes(this);
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return this.forgerStakesProvider().getAllowedForgerListIndexes(this);
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(Option<String> scAddressOpt) {
        return this.mcAddrOwnershipProvider().getListOfMcAddrOwnerships(this, scAddressOpt);
    }

    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses() {
        return this.mcAddrOwnershipProvider().getListOfOwnerScAddresses(this);
    }

    @Override
    public boolean ownershipDataExist(byte[] ownershipId) {
        return this.mcAddrOwnershipProvider().ownershipDataExist(this, ownershipId);
    }

    public void applyMainchainBlockReferenceData(MainchainBlockReferenceData refData) {
        refData.sidechainRelatedAggregatedTransaction().foreach((Function1 & Serializable & scala.Serializable)aggTx -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(aggTx.mc2scTransactionsOutputs()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StateDbAccountStateView.$anonfun$applyMainchainBlockReferenceData$2(this, x0$1);
            return BoxedUnit.UNIT;
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)((TraversableOnce)this.getListOfForgersStakes().view().groupBy((Function1 & Serializable & scala.Serializable)stake -> new Tuple2((Object)stake.forgerStakeData().forgerPublicKeys().blockSignPublicKey(), (Object)stake.forgerStakeData().forgerPublicKeys().vrfPublicKey())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SeqView stakes;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    stakes = (SeqView)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            PublicKey25519Proposition blockSignKey = (PublicKey25519Proposition)tuple2._1();
            VrfPublicKey vrfKey = (VrfPublicKey)tuple2._2();
            ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(blockSignKey, vrfKey, BoxesRunTime.unboxToLong((Object)((TraversableOnce)stakes.map((Function1 & Serializable & scala.Serializable)stake -> BoxesRunTime.boxToLong((long)ZenWeiConverter$.MODULE$.convertWeiToZennies(stake.forgerStakeData().stakedAmount())), SeqView$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return forgingStakeInfo;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted(package$.MODULE$.Ordering().apply(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reverse());
    }

    public byte[] applyMessage(Message msg, GasPool blockGasPool, BlockContext blockContext) throws InvalidMessageException, ExecutionFailedException {
        return new StateTransition(this, this.messageProcessors, blockGasPool, blockContext).transition(msg);
    }

    public Try<EthereumConsensusDataReceipt> applyTransaction(AccountTransaction<Proposition, Proof<Proposition>> tx, int txIndex, GasPool blockGasPool, BlockContext blockContext) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Enumeration.Value value;
            BoxedUnit boxedUnit3;
            if (!(tx instanceof EthereumTransaction)) {
                throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported transaction type ").append(tx.getClass().getName()).toString());
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if (!ethTx.isSigned()) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Transaction is not signed: ").append(ethTx.id()).toString());
            }
            byte[] txHash = BytesUtils.fromHexString(ethTx.id());
            Message msg = ethTx.asMessage(blockContext$1.baseFee);
            this.setupTxContext(txHash, Predef$.MODULE$.int2Integer(txIndex));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applying msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            try {
                try {
                    this.applyMessage(msg, blockGasPool, blockContext);
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.SUCCESSFUL();
                }
                catch (ExecutionFailedException err) {
                    BoxedUnit boxedUnit4;
                    if (this.log().underlying().isDebugEnabled()) {
                        this.log().underlying().debug("applying message failed, tx id: {}, reason: {}", (Object[])new String[]{ethTx.id(), err.getMessage()});
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit4 = BoxedUnit.UNIT;
                    }
                    value = EthereumConsensusDataReceipt$ReceiptStatus$.MODULE$.FAILED();
                }
            }
            finally {
                $this.stateDb.finalizeChanges();
            }
            Enumeration.Value status = value;
            EthereumConsensusDataReceipt consensusDataReceipt = new EthereumConsensusDataReceipt(ethTx.version(), status.id(), blockGasPool.getUsedGas(), (Seq<EthereumConsensusDataLog>)Predef$.MODULE$.wrapRefArray((Object[])this.getLogs(txHash)));
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("Returning consensus data receipt: {}", new Object[]{consensusDataReceipt.toString()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("applied msg: used pool gas {}", new Object[]{blockGasPool.getUsedGas()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return consensusDataReceipt;
        });
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return this.stateDb.isEoaAccount(address);
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return this.stateDb.isSmartContractAccount(address);
    }

    @Override
    public boolean accountExists(Address address) {
        return !this.stateDb.isEmpty(address);
    }

    @Override
    public void addAccount(Address address, byte[] code) {
        this.stateDb.setCode(address, code);
    }

    @Override
    public void increaseNonce(Address address) {
        this.stateDb.setNonce(address, this.getNonce(address).add(BigInteger.ONE));
    }

    @Override
    public void addBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block3: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block3;
            if (n < 0) {
                throw new ExecutionFailedException("cannot add negative amount to balance");
            }
            this.stateDb.addBalance(address, amount);
        }
    }

    @Override
    public void subBalance(Address address, BigInteger amount) throws ExecutionFailedException {
        block3: {
            int n = amount.signum();
            switch (n) {
                default: 
            }
            if (n == 0) break block3;
            if (n < 0) {
                throw new ExecutionFailedException("cannot subtract negative amount from balance");
            }
            this.stateDb.subBalance(address, amount);
        }
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return this.stateDb.getStorage(address, new Hash(key)).toBytes();
    }

    @Override
    public void updateAccountStorage(Address address, byte[] key, byte[] value) {
        this.stateDb.setStorage(address, new Hash(key), new Hash(value));
    }

    @Override
    public final void removeAccountStorage(Address address, byte[] key) {
        this.updateAccountStorage(address, key, Hash.ZERO.toBytes());
    }

    private byte[] chunkKeySalt() {
        return this.chunkKeySalt;
    }

    private byte[] getChunkKey(byte[] key, int chunkIndex) {
        return Keccak256$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.chunkKeySalt(), key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(chunkIndex))}));
    }

    @Override
    public final byte[] getAccountStorageBytes(Address address, byte[] key) {
        int length = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        byte[] data = new byte[length];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (length + 32 - 1) / 32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)chunkIndex -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.getAccountStorage(address, this.getChunkKey(key, chunkIndex)))).copyToArray((Object)data, chunkIndex * 32));
        return data;
    }

    @Override
    public final void updateAccountStorageBytes(Address address, byte[] key, byte[] value) {
        int oldLength = new BigInteger(1, this.getAccountStorage(address, key)).intValueExact();
        int newLength = value.length;
        this.updateAccountStorage(address, key, BigIntegerUtil$.MODULE$.toUint256Bytes(BigInteger.valueOf(newLength)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.max(newLength, oldLength)).by(32).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
            int chunkIndex = start / 32;
            byte[] chunkKey = this.getChunkKey(key, chunkIndex);
            if (start < newLength) {
                this.updateAccountStorage(address, chunkKey, (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value)).slice(start, start + 32))).padTo(32, (Object)BoxesRunTime.boxToByte((byte)((byte)0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())));
            } else {
                this.removeAccountStorage(address, chunkKey);
            }
        });
    }

    @Override
    public final void removeAccountStorageBytes(Address address, byte[] key) {
        this.updateAccountStorageBytes(address, key, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
    }

    public ProofAccountResult getProof(Address address, byte[][] keys) {
        return this.stateDb.getProof(address, (Hash[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).map((Function1 & Serializable & scala.Serializable)x$5 -> new Hash(x$5), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Hash.class))));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return this.stateDb.getNonce(address);
    }

    @Override
    public BigInteger getBalance(Address address) {
        return this.stateDb.getBalance(address);
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return this.stateDb.getCodeHash(address).toBytes();
    }

    @Override
    public byte[] getCode(Address address) {
        return this.stateDb.getCode(address);
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.stateDb.getLogs(new Hash(txHash)))).map((Function1 & Serializable & scala.Serializable)log -> new EthereumConsensusDataLog(log.address, log.topics, log.data), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(EthereumConsensusDataLog.class)));
    }

    @Override
    public void addLog(EthereumConsensusDataLog log) {
        this.stateDb.addLog(new EvmLog(log.address(), log.topics(), log.data()));
    }

    @Override
    public void close() {
        this.stateDb.close();
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return this.stateDb;
    }

    @Override
    public byte[] getIntermediateRoot() {
        return this.stateDb.getIntermediateRoot().toBytes();
    }

    public void setupTxContext(byte[] txHash, Integer idx) {
        this.stateDb.setTxContext(new Hash(txHash), Predef$.MODULE$.Integer2int(idx));
    }

    public void setupAccessList(Message msg) {
        this.stateDb.accessSetup(msg.getFrom(), msg.getTo().orElse(Address.ZERO));
    }

    public BigInteger getRefund() {
        return this.stateDb.getRefund();
    }

    public int snapshot() {
        return this.stateDb.snapshot();
    }

    public void finalizeChanges() {
        this.stateDb.finalizeChanges();
    }

    public void revertToSnapshot(int revisionId) {
        this.stateDb.revertToSnapshot(revisionId);
    }

    @Override
    public BaseAccountStateView getGasTrackedView(GasPool gas) {
        return new StateDbAccountStateViewGasTracked(this.stateDb, this.messageProcessors, gas);
    }

    public static final /* synthetic */ boolean $anonfun$withdrawalReqProvider$1(MessageProcessor x$1) {
        return x$1 instanceof WithdrawalRequestProvider;
    }

    public static final /* synthetic */ boolean $anonfun$forgerStakesProvider$1(MessageProcessor x$2) {
        return x$2 instanceof ForgerStakesProvider;
    }

    public static final /* synthetic */ boolean $anonfun$certificateKeysProvider$1(MessageProcessor x$3) {
        return x$3 instanceof CertificateKeysProvider;
    }

    public static final /* synthetic */ boolean $anonfun$mcAddrOwnershipProvider$1(MessageProcessor x$4) {
        return x$4 instanceof McAddrOwnershipsProvider;
    }

    public static final /* synthetic */ void $anonfun$applyMainchainBlockReferenceData$2(StateDbAccountStateView $this, SidechainRelatedMainchainOutput x0$1) {
        SidechainRelatedMainchainOutput sidechainRelatedMainchainOutput = x0$1;
        if (sidechainRelatedMainchainOutput instanceof SidechainCreation) {
            BoxedUnit boxedUnit;
            SidechainCreation sidechainCreation = (SidechainCreation)sidechainRelatedMainchainOutput;
            MainchainTxSidechainCreationCrosschainOutput scOut = sidechainCreation.getScCrOutput();
            BigInteger stakedAmount = ZenWeiConverter$.MODULE$.convertZenniesToWei(scOut.amount());
            Address ownerAddress = MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(scOut.address());
            VrfPublicKey vrfPublicKey = new VrfPublicKey((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).take(VrfPublicKey.KEY_LENGTH));
            PublicKey25519Proposition blockSignerProposition = new PublicKey25519Proposition((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(scOut.customCreationData())).slice(VrfPublicKey.KEY_LENGTH, VrfPublicKey.KEY_LENGTH + PublicKey25519Proposition.KEY_LENGTH));
            AddNewStakeCmdInput cmdInput = new AddNewStakeCmdInput(new ForgerPublicKeys(blockSignerProposition, vrfPublicKey), ownerAddress);
            byte[] data = Bytes.concat((byte[][])new byte[][]{BytesUtils.fromHexString(ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd()), cmdInput.encode()});
            Message message = new Message(ownerAddress, Optional.of(WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS()), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, stakedAmount, BigInteger.ONE.negate(), data, false);
            byte[] returnData = $this.forgerStakesProvider().addScCreationForgerStake(message, $this);
            if ($this.log().underlying().isDebugEnabled()) {
                $this.log().underlying().debug("sc creation forging stake added with stakeid: {}", new Object[]{BytesUtils.toHexString(returnData)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (sidechainRelatedMainchainOutput instanceof ForwardTransfer) {
            BoxedUnit boxedUnit;
            ForwardTransfer forwardTransfer = (ForwardTransfer)sidechainRelatedMainchainOutput;
            MainchainTxForwardTransferCrosschainOutput ftOut = forwardTransfer.getFtOutput();
            BigInteger value = ZenWeiConverter$.MODULE$.convertZenniesToWei(ftOut.amount());
            AddressProposition recipientProposition = new AddressProposition(MainchainTxCrosschainOutputAddressUtil$.MODULE$.getAccountAddress(ftOut.propositionBytes()));
            if ($this.isEoaAccount(recipientProposition.address())) {
                $this.addBalance(recipientProposition.address(), value);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("added FT amount = {} to address={}", new Object[]{value, recipientProposition});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                BoxedUnit boxedUnit3;
                Address burnAddress = Address.ZERO;
                if ($this.log().underlying().isWarnEnabled()) {
                    $this.log().underlying().warn("ignored FT to non-EOA account, amount={} to address={} (the amount was burned by sending balance to {} address)", new Object[]{value, recipientProposition, burnAddress});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                $this.addBalance(burnAddress, value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError((Object)sidechainRelatedMainchainOutput);
        }
    }

    public StateDbAccountStateView(StateDB stateDb, Seq<MessageProcessor> messageProcessors) {
        this.stateDb = stateDb;
        this.messageProcessors = messageProcessors;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.chunkKeySalt = BytesUtils.fromHexString("fa09428dd8121ea57327c9f21af74ffad8bfd5e6e39dc3dc6c53241a85ec5b0d");
    }
}

