/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.events.EthereumEvent;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.evm.Address;
import java.io.Serializable;
import scala.Function1;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u0007\u000f\u0003\u00039\u0002\"\u0002\u0017\u0001\t\u0003i\u0003bB\u0018\u0001\u0005\u00045\t\u0001\r\u0005\bo\u0001\u0011\rQ\"\u00019\u0011!\u0011\u0005\u0001#b\u0001\n\u0003A\u0004\"B\"\u0001\t\u0003\"\u0005BB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\b\u000f\u0005Eb\u0002#\u0001\u00024\u00191QB\u0004E\u0001\u0003kAa\u0001L\u0005\u0005\u0002\u0005u\u0002\u0002CA \u0013\t\u0007I\u0011\u0001\u001d\t\u000f\u0005\u0005\u0013\u0002)A\u0005s\tyb*\u0019;jm\u0016\u001cV.\u0019:u\u0007>tGO]1di6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005=\u0001\u0012!B:uCR,'BA\t\u0013\u0003\u001d\t7mY8v]RT!a\u0005\u000b\u0002\u000f!|'/\u001b>f]*\tQ#\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u0019A\u0011\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0003C\tj\u0011AD\u0005\u0003G9\u0011\u0001#T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001B;uS2T\u0011!K\u0001\u0007gB\f'o\u001b>\n\u0005-2#!D*qCJ\\'\u0010T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002]A\u0011\u0011\u0005A\u0001\u0010G>tGO]1di\u0006#GM]3tgV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025%\u0005\u0019QM^7\n\u0005Y\u001a$aB!eIJ,7o]\u0001\rG>tGO]1di\u000e{G-Z\u000b\u0002sA\u0019!(P \u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012Q!\u0011:sCf\u0004\"A\u000f!\n\u0005\u0005[$\u0001\u0002\"zi\u0016\f\u0001cY8oiJ\f7\r^\"pI\u0016D\u0015m\u001d5\u0002\t%t\u0017\u000e\u001e\u000b\u0004\u000b\"k\u0005C\u0001\u001eG\u0013\t95H\u0001\u0003V]&$\b\"B%\u0006\u0001\u0004Q\u0015\u0001\u0002<jK^\u0004\"!I&\n\u00051s!\u0001\u0006\"bg\u0016\f5mY8v]R\u001cF/\u0019;f-&,w\u000fC\u0003O\u000b\u0001\u0007q*\u0001\u000bd_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\t\u0003uAK!!U\u001e\u0003\u0007%sG\u000fK\u0002\u0006'f\u00032A\u000f+W\u0013\t)6H\u0001\u0004uQJ|wo\u001d\t\u0003C]K!\u0001\u0017\b\u0003O5+7o]1hKB\u0013xnY3tg>\u0014\u0018J\\5uS\u0006d\u0017N_1uS>tW\t_2faRLwN\\\u0019\u0005=i+g\u0010\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;nj\u0011A\u0018\u0006\u0003?Z\ta\u0001\u0010:p_Rt\u0014BA1<\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\\\u0014'B\u0012gUf\\WCA4i+\u0005QF!B5\u0017\u0005\u0004q'!\u0001+\n\u0005-d\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002nw\u00051A\u000f\u001b:poN\f\"a\u001c:\u0011\u0005i\u0002\u0018BA9<\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u001d<\u000f\u0005i\"\u0018BA;<\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\u0013QC'o\\<bE2,'BA;<c\u0015\u0019#p\u001f?n\u001d\tQ40\u0003\u0002nwE\"!EO\u001e~\u0005\u0015\u00198-\u00197bc\t1c+\u0001\u0006dC:\u0004&o\\2fgN$\u0002\"a\u0001\u0002\n\u0005M\u0011Q\u0003\t\u0004u\u0005\u0015\u0011bAA\u0004w\t9!i\\8mK\u0006t\u0007bBA\u0006\r\u0001\u0007\u0011QB\u0001\u0004[N<\u0007cA\u0011\u0002\u0010%\u0019\u0011\u0011\u0003\b\u0003\u000f5+7o]1hK\")\u0011J\u0002a\u0001\u0015\")aJ\u0002a\u0001\u001f\u0006Yr-\u001a;Fi\",'/Z;n\u0007>t7/\u001a8tkN$\u0015\r^1M_\u001e$B!a\u0007\u0002(A!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"9\tqA]3dK&\u0004H/\u0003\u0003\u0002&\u0005}!\u0001G#uQ\u0016\u0014X-^7D_:\u001cXM\\:vg\u0012\u000bG/\u0019'pO\"9\u0011\u0011F\u0004A\u0002\u0005-\u0012!B3wK:$\bc\u0001\u001e\u0002.%\u0019\u0011qF\u001e\u0003\u0007\u0005s\u00170A\u0010OCRLg/Z*nCJ$8i\u001c8ue\u0006\u001cG/T:h!J|7-Z:t_J\u0004\"!I\u0005\u0014\u0007%\t9\u0004E\u0002;\u0003sI1!a\u000f<\u0005\u0019\te.\u001f*fMR\u0011\u00111G\u0001\u0013\u001dVcEj\u0018%F1~\u001bFKU%O\u000f~\u001b$'A\nO+2cu\fS#Y?N#&+\u0013(H?N\u0012\u0004\u0005")
public abstract class NativeSmartContractMsgProcessor
implements MessageProcessor,
SparkzLogging {
    private byte[] contractCodeHash;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static byte[] NULL_HEX_STRING_32() {
        return NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public abstract Address contractAddress();

    public abstract byte[] contractCode();

    private byte[] contractCodeHash$lzycompute() {
        NativeSmartContractMsgProcessor nativeSmartContractMsgProcessor = this;
        synchronized (nativeSmartContractMsgProcessor) {
            if (!this.bitmap$0) {
                this.contractCodeHash = Keccak256$.MODULE$.hash(this.contractCode());
                this.bitmap$0 = true;
            }
        }
        return this.contractCodeHash;
    }

    public byte[] contractCodeHash() {
        return !this.bitmap$0 ? this.contractCodeHash$lzycompute() : this.contractCodeHash;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) throws MessageProcessorInitializationException {
        if (!view.accountExists(this.contractAddress())) {
            BoxedUnit boxedUnit;
            view.addAccount(this.contractAddress(), this.contractCode());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("created Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            BoxedUnit boxedUnit;
            String errorMsg = new StringBuilder(23).append("Account ").append(this.contractAddress()).append(" already exists").toString();
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(errorMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new MessageProcessorInitializationException(errorMsg);
        }
    }

    @Override
    public boolean canProcess(Message msg, BaseAccountStateView view, int consensusEpochNumber) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(msg.getTo())).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)NativeSmartContractMsgProcessor.$anonfun$canProcess$1(this, x$1)));
    }

    public EthereumConsensusDataLog getEthereumConsensusDataLog(Object event) {
        return EthereumEvent.getEthereumConsensusDataLog(this.contractAddress(), event);
    }

    public static final /* synthetic */ boolean $anonfun$canProcess$1(NativeSmartContractMsgProcessor $this, Address x$1) {
        return $this.contractAddress().equals((Object)x$1);
    }

    public NativeSmartContractMsgProcessor() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

