/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.state.AddNewOwnershipCmdInput;
import io.horizen.account.state.AddNewOwnershipCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GetOwnershipsCmdInput;
import io.horizen.account.state.GetOwnershipsCmdInputDecoder$;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.McAddrOwnershipDataListEncoder$;
import io.horizen.account.state.McAddrOwnershipDataSerializer$;
import io.horizen.account.state.McAddrOwnershipLinkedList$;
import io.horizen.account.state.McAddrOwnershipMsgProcessor$;
import io.horizen.account.state.McAddrOwnershipsProvider;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OutOfGasException;
import io.horizen.account.state.OwnerScAddrListEncoder$;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.RemoveOwnershipCmdInput;
import io.horizen.account.state.RemoveOwnershipCmdInputDecoder$;
import io.horizen.account.state.ScAddrOwnershipLinkedList;
import io.horizen.account.state.ScAddrOwnershipLinkedList$;
import io.horizen.account.state.ScAddressRefsLinkedList$;
import io.horizen.account.state.events.AddMcAddrOwnership;
import io.horizen.account.state.events.AddMcAddrOwnership$;
import io.horizen.account.state.events.RemoveMcAddrOwnership;
import io.horizen.account.state.events.RemoveMcAddrOwnership$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.account.utils.Secp256k1;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r=b\u0001\u0002\"D\u00012C\u0001\"\u0018\u0001\u0003\u0016\u0004%\tA\u0018\u0005\tI\u0002\u0011\t\u0012)A\u0005?\")Q\r\u0001C\u0001M\"9\u0011\u000e\u0001b\u0001\n\u0003R\u0007BB9\u0001A\u0003%1\u000eC\u0004s\u0001\t\u0007I\u0011I:\t\ri\u0004\u0001\u0015!\u0003u\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\f\u0001\t\u0013\ty\u0003C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a'\u0001\t\u0003\ti\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\"9\u0011\u0011\u001a\u0001\u0005B\u0005-\u0007\"CAq\u0001E\u0005I\u0011AAr\u0011\u001d\tI\u0010\u0001C\u0005\u0003wDqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\tE\u0001\u0001\"\u0011\u0003\u0014!I!Q\b\u0001\u0002\u0002\u0013\u0005!q\b\u0005\n\u0005\u0007\u0002\u0011\u0013!C\u0001\u0005\u000bB\u0011B!\u0013\u0001\u0003\u0003%\tEa\u0013\t\u0013\tm\u0003!!A\u0005\u0002\tu\u0003\"\u0003B0\u0001\u0005\u0005I\u0011\u0001B1\u0011%\u0011i\u0007AA\u0001\n\u0003\u0012y\u0007C\u0005\u0003~\u0001\t\t\u0011\"\u0001\u0003\u0000!I!1\u0011\u0001\u0002\u0002\u0013\u0005#Q\u0011\u0005\n\u0005\u000f\u0003\u0011\u0011!C!\u0005\u0013C\u0011Ba#\u0001\u0003\u0003%\tE!$\b\u000f\tE5\t#\u0001\u0003\u0014\u001a1!i\u0011E\u0001\u0005+Ca!Z\u0013\u0005\u0002\t5\u0006\u0002\u0003BXK\t\u0007I\u0011A:\t\u000f\tEV\u0005)A\u0005i\"A!1W\u0013C\u0002\u0013\u00051\u000fC\u0004\u00036\u0016\u0002\u000b\u0011\u0002;\t\u0011\t]VE1A\u0005\u0002MDqA!/&A\u0003%A\u000f\u0003\u0005\u0003<\u0016\u0012\r\u0011\"\u0001t\u0011\u001d\u0011i,\nQ\u0001\nQD\u0011Ba0&\u0005\u0004%\tA!1\t\u0011\t\rW\u0005)A\u0005\u0003\u007fA\u0011B!2&\u0005\u0004%\tA!1\t\u0011\t\u001dW\u0005)A\u0005\u0003\u007fA\u0011B!3&\u0005\u0004%\tA!1\t\u0011\t-W\u0005)A\u0005\u0003\u007fA\u0011B!4&\u0005\u0004%\tA!1\t\u0011\t=W\u0005)A\u0005\u0003\u007fA\u0011B!5&\u0005\u0004%\tA!1\t\u0011\tMW\u0005)A\u0005\u0003\u007fA\u0011B!6&\u0005\u0004%\tAa6\t\u0011\tEX\u0005)A\u0005\u00053DqAa=&\t\u0003\u0011)\u0010C\u0004\u0003|\u0016\"\tA!@\t\u000f\r\rQ\u0005\"\u0001\u0004\u0006!91\u0011B\u0013\u0005\u0002\r-\u0001\"CB\u000bK\u0005\u0005I\u0011QB\f\u0011%\u0019Y\"JA\u0001\n\u0003\u001bi\u0002C\u0005\u0004&\u0015\n\t\u0011\"\u0003\u0004(\tYRjY!eIJ|uO\\3sg\"L\u0007/T:h!J|7-Z:t_JT!\u0001R#\u0002\u000bM$\u0018\r^3\u000b\u0005\u0019;\u0015aB1dG>,h\u000e\u001e\u0006\u0003\u0011&\u000bq\u0001[8sSj,gNC\u0001K\u0003\tIwn\u0001\u0001\u0014\u000b\u0001i\u0015\u000b\u0016.\u0011\u00059{U\"A\"\n\u0005A\u001b%a\b(bi&4XmU7beR\u001cuN\u001c;sC\u000e$Xj]4Qe>\u001cWm]:peB\u0011aJU\u0005\u0003'\u000e\u0013\u0001$T2BI\u0012\u0014xj\u001e8feND\u0017\u000e]:Qe>4\u0018\u000eZ3s!\t)\u0006,D\u0001W\u0015\u00059\u0016!B:dC2\f\u0017BA-W\u0005\u001d\u0001&o\u001c3vGR\u0004\"!V.\n\u0005q3&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001`!\t\u0001'-D\u0001b\u0015\tiv)\u0003\u0002dC\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003O\"\u0004\"A\u0014\u0001\t\u000bu\u001b\u0001\u0019A0\u0002\u001f\r|g\u000e\u001e:bGR\fE\r\u001a:fgN,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001e\u000b1!\u001a<n\u0013\t\u0001XNA\u0004BI\u0012\u0014Xm]:\u0002!\r|g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#\u0001;\u0011\u0007U+x/\u0003\u0002w-\n)\u0011I\u001d:bsB\u0011Q\u000b_\u0005\u0003sZ\u0013AAQ=uK\u0006i1m\u001c8ue\u0006\u001cGoQ8eK\u0002\nA!\u001b8jiR)Q0!\u0001\u0002\fA\u0011QK`\u0005\u0003\u007fZ\u0013A!\u00168ji\"9\u00111\u0001\u0005A\u0002\u0005\u0015\u0011\u0001\u0002<jK^\u00042ATA\u0004\u0013\r\tIa\u0011\u0002\u0015\u0005\u0006\u001cX-Q2d_VtGo\u0015;bi\u00164\u0016.Z<\t\u000f\u00055\u0001\u00021\u0001\u0002\u0010\u0005!2m\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJ\u00042!VA\t\u0013\r\t\u0019B\u0016\u0002\u0004\u0013:$\u0018AC2b]B\u0013xnY3tgRA\u0011\u0011DA\u0010\u0003S\tY\u0003E\u0002V\u00037I1!!\bW\u0005\u001d\u0011un\u001c7fC:Dq!!\t\n\u0001\u0004\t\u0019#A\u0002ng\u001e\u00042ATA\u0013\u0013\r\t9c\u0011\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u001d\t\u0019!\u0003a\u0001\u0003\u000bAq!!\u0004\n\u0001\u0004\ty!\u0001\nbI\u0012l5-\u00113ee>;h.\u001a:tQ&\u0004H#C?\u00022\u0005M\u0012qGA\u001e\u0011\u001d\t\u0019A\u0003a\u0001\u0003\u000bAa!!\u000e\u000b\u0001\u0004!\u0018aC8x]\u0016\u00148\u000f[5q\u0013\u0012Da!!\u000f\u000b\u0001\u0004Y\u0017!C:d\u0003\u0012$'/Z:t\u0011\u001d\tiD\u0003a\u0001\u0003\u007f\tA#\\2Ue\u0006t7\u000f]1sK:$\u0018\t\u001a3sKN\u001c\b\u0003BA!\u0003\u001frA!a\u0011\u0002LA\u0019\u0011Q\t,\u000e\u0005\u0005\u001d#bAA%\u0017\u00061AH]8pizJ1!!\u0014W\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011KA*\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\n,\u0002=Ut7\r[3dW\u0016$'+Z7pm\u0016l5-\u00113ee>;h.\u001a:tQ&\u0004H#C?\u0002Z\u0005m\u0013QLA1\u0011\u001d\t\u0019a\u0003a\u0001\u0003\u000bAa!!\u000e\f\u0001\u0004!\bbBA0\u0017\u0001\u0007\u0011qH\u0001\rg\u000e\fE\r\u001a:fgN\u001cFO\u001d\u0005\b\u0003{Y\u0001\u0019AA \u0003eI7OV1mS\u0012|uO\\3sg\"L\u0007oU5h]\u0006$XO]3\u0015\u0011\u0005e\u0011qMA5\u0003WBa!!\u000f\r\u0001\u0004Y\u0007bBA\u001f\u0019\u0001\u0007\u0011q\b\u0005\b\u0003[b\u0001\u0019AA8\u0003-i7mU5h]\u0006$XO]3\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gR1!!\u001eF\u0003\u0015\u0001(o\\8g\u0013\u0011\tI(a\u001d\u0003%MKwM\\1ukJ,7+Z2qeU24.M\u0001\u000fO\u0016$Xj\u0019%bg\",G-T:h)\r!\u0018q\u0010\u0005\b\u0003\u0003k\u0001\u0019AA \u0003MiWm]:bO\u0016$vnU5h]N#(/\u001b8h\u0003Q!w.\u00113e\u001d\u0016<xj\u001e8feND\u0017\u000e]\"nIR)A/a\"\u0002\n\"9\u0011\u0011\u0005\bA\u0002\u0005\r\u0002bBA\u0002\u001d\u0001\u0007\u0011QA\u0001\u0015I>\u0014V-\\8wK>;h.\u001a:tQ&\u00048)\u001c3\u0015\u000bQ\fy)!%\t\u000f\u0005\u0005r\u00021\u0001\u0002$!9\u00111A\bA\u0002\u0005\u0015\u0011\u0001\u00073p\u000f\u0016$H*[:u\u001f\u001a|uO\\3sg\"L\u0007o]\"nIR)A/a&\u0002\u001a\"9\u0011\u0011\u0005\tA\u0002\u0005\r\u0002bBA\u0002!\u0001\u0007\u0011QA\u0001\u001cI><U\r\u001e'jgR|e-\u00117m\u001f^tWM]:iSB\u001c8)\u001c3\u0015\u000bQ\fy*!)\t\u000f\u0005\u0005\u0012\u00031\u0001\u0002$!9\u00111A\tA\u0002\u0005\u0015\u0011A\b3p\u000f\u0016$H*[:u\u001f\u001a|uO\\3s'\u000e\fE\r\u001a:fgN,7oQ7e)\u0015!\u0018qUAU\u0011\u001d\t\tC\u0005a\u0001\u0003GAq!a\u0001\u0013\u0001\u0004\t)!A\rhKRd\u0015n\u001d;PM>;h.\u001a:TG\u0006#GM]3tg\u0016\u001cH\u0003BAX\u0003\u000f\u0004b!!-\u0002<\u0006\u0005g\u0002BAZ\u0003osA!!\u0012\u00026&\tq+C\u0002\u0002:Z\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0006}&aA*fc*\u0019\u0011\u0011\u0018,\u0011\u00079\u000b\u0019-C\u0002\u0002F\u000e\u0013abT<oKJ\u001c6-\u00113ee\u0016\u001c8\u000fC\u0004\u0002\u0004M\u0001\r!!\u0002\u00023\u001d,G\u000fT5ti>3WjY!eIJ|uO\\3sg\"L\u0007o\u001d\u000b\u0007\u0003\u001b\f).a6\u0011\r\u0005E\u00161XAh!\rq\u0015\u0011[\u0005\u0004\u0003'\u001c%aE'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9ECR\f\u0007bBA\u0002)\u0001\u0007\u0011Q\u0001\u0005\n\u00033$\u0002\u0013!a\u0001\u00037\fAb]2BI\u0012\u0014Xm]:PaR\u0004R!VAo\u0003\u007fI1!a8W\u0005\u0019y\u0005\u000f^5p]\u0006\u0019s-\u001a;MSN$xJZ'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9tI\u0011,g-Y;mi\u0012\u0012TCAAsU\u0011\tY.a:,\u0005\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a=W\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\fiOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqdZ3u'\u000e\fE\r\u001a:MSN$xJZ'd\u0003\u0012$'oT<oKJ\u001c\b.\u001b9t)\u0019\ti-!@\u0002\u0000\"9\u00111\u0001\fA\u0002\u0005\u0015\u0001bBA\u001d-\u0001\u0007\u0011qH\u0001\u0013_^tWM]:iSB$\u0015\r^1Fq&\u001cH\u000f\u0006\u0004\u0002\u001a\t\u0015!q\u0001\u0005\b\u0003\u00079\u0002\u0019AA\u0003\u0011\u0019\t)d\u0006a\u0001i\u00061r-\u001a;Fq&\u001cH/\u001b8h\u0003N\u001cxnY5bi&|g\u000e\u0006\u0004\u0002\\\n5!q\u0002\u0005\b\u0003\u0007A\u0002\u0019AA\u0003\u0011\u0019\t)\u0004\u0007a\u0001i\u00069\u0001O]8dKN\u001cH#\u0003;\u0003\u0016\t]!\u0011\u0004B\u0012\u0011\u001d\t\t#\u0007a\u0001\u0003GAq!a\u0001\u001a\u0001\u0004\t)\u0001C\u0004\u0003\u001ce\u0001\rA!\b\u0002\u0007\u001d\f7\u000fE\u0002O\u0005?I1A!\tD\u0005\u001d9\u0015m\u001d)p_2DqA!\n\u001a\u0001\u0004\u00119#\u0001\u0007cY>\u001c7nQ8oi\u0016DH\u000fE\u0002O\u0005SI1Aa\u000bD\u00051\u0011En\\2l\u0007>tG/\u001a=uQ\u0015I\"q\u0006B\u001e!\u0015)&\u0011\u0007B\u001b\u0013\r\u0011\u0019D\u0016\u0002\u0007i\"\u0014xn^:\u0011\u00079\u00139$C\u0002\u0003:\r\u0013\u0001$\u0012=fGV$\u0018n\u001c8GC&dW\rZ#yG\u0016\u0004H/[8oG\t\u0011)$\u0001\u0003d_BLHcA4\u0003B!9QL\u0007I\u0001\u0002\u0004y\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000fR3aXAt\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\n\t\u0005\u0005\u001f\u0012I&\u0004\u0002\u0003R)!!1\u000bB+\u0003\u0011a\u0017M\\4\u000b\u0005\t]\u0013\u0001\u00026bm\u0006LA!!\u0015\u0003R\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qB\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019G!\u001b\u0011\u0007U\u0013)'C\u0002\u0003hY\u00131!\u00118z\u0011%\u0011YGHA\u0001\u0002\u0004\ty!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005c\u0002bAa\u001d\u0003z\t\rTB\u0001B;\u0015\r\u00119HV\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B>\u0005k\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0004BA\u0011%\u0011Y\u0007IA\u0001\u0002\u0004\u0011\u0019'\u0001\u0005iCND7i\u001c3f)\t\ty!\u0001\u0005u_N#(/\u001b8h)\t\u0011i%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\u0011y\tC\u0005\u0003l\r\n\t\u00111\u0001\u0003d\u0005YRjY!eIJ|uO\\3sg\"L\u0007/T:h!J|7-Z:t_J\u0004\"AT\u0013\u0014\r\u0015\u00129J!([!\r)&\u0011T\u0005\u0004\u000573&AB!osJ+g\r\u0005\u0003\u0003 \n%VB\u0001BQ\u0015\u0011\u0011\u0019K!*\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005O\u000baa\u001d9be.T\u0018\u0002\u0002BV\u0005C\u0013Qb\u00159be.THj\\4hS:<GC\u0001BJ\u0003iyuO\\3sg\"L\u0007o\u001d'j].,G\rT5tiRK\u0007oS3z\u0003myuO\\3sg\"L\u0007o\u001d'j].,G\rT5tiRK\u0007oS3zA\u0005arj\u001e8feND\u0017\u000e\u001d'j].,G\rT5ti:+H\u000e\u001c,bYV,\u0017!H(x]\u0016\u00148\u000f[5q\u0019&t7.\u001a3MSN$h*\u001e7m-\u0006dW/\u001a\u0011\u0002;M\u001b\u0017\t\u001a3sKN\u001c(+\u001a4t\u0019&t7.\u001a3MSN$H+\u001b9LKf\fadU2BI\u0012\u0014Xm]:SK\u001a\u001cH*\u001b8lK\u0012d\u0015n\u001d;USB\\U-\u001f\u0011\u0002AM\u001b\u0017\t\u001a3sKN\u001c(+\u001a4t\u0019&t7.\u001a3MSN$h*\u001e7m-\u0006dW/Z\u0001\"'\u000e\fE\r\u001a:fgN\u0014VMZ:MS:\\W\r\u001a'jgRtU\u000f\u001c7WC2,X\rI\u0001\u0013\u0003\u0012$g*Z<Po:,'o\u001d5ja\u000ekG-\u0006\u0002\u0002@\u0005\u0019\u0012\t\u001a3OK^|uO\\3sg\"L\u0007oQ7eA\u0005\u0011\"+Z7pm\u0016|uO\\3sg\"L\u0007oQ7e\u0003M\u0011V-\\8wK>;h.\u001a:tQ&\u00048)\u001c3!\u0003e9U\r\u001e'jgR|e-\u00117m\u001f^tWM]:iSB\u001c8)\u001c3\u00025\u001d+G\u000fT5ti>3\u0017\t\u001c7Po:,'o\u001d5jaN\u001cU\u000e\u001a\u0011\u0002-\u001d+G\u000fT5ti>3wj\u001e8feND\u0017\u000e]:D[\u0012\fqcR3u\u0019&\u001cHo\u00144Po:,'o\u001d5jaN\u001cU\u000e\u001a\u0011\u00029\u001d+G\u000fT5ti>3wj\u001e8feN\u001b\u0017\t\u001a3sKN\u001cXm]\"nI\u0006ir)\u001a;MSN$xJZ(x]\u0016\u00148kY!eIJ,7o]3t\u00076$\u0007%\u0001\u0007fGB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0003ZB!!1\u001cBw\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018A\u0001=:\u0015\u0011\u0011\u0019O!:\u0002\t\u0005\u001ch.\r\u0006\u0005\u0005O\u0014I/\u0001\u0007c_Vt7-_2bgRdWM\u0003\u0002\u0003l\u0006\u0019qN]4\n\t\t=(Q\u001c\u0002\u000f1f*5\tU1sC6,G/\u001a:t\u00035)7\rU1sC6,G/\u001a:tA\u0005qq-\u001a;Po:,'o\u001d5ja&#Gc\u0001;\u0003x\"9!\u0011`\u001eA\u0002\u0005}\u0012!C7d\u0003\u0012$'/Z:t\u000399W\r^'d'&<g.\u0019;ve\u0016$B!a\u001c\u0003\u0000\"91\u0011\u0001\u001fA\u0002\u0005}\u0012!E7d'&<g.\u0019;ve\u0016\u001cFO]5oO\u0006A\u0011N\\5u\t>tW\r\u0006\u0003\u0002\u001a\r\u001d\u0001bBA\u0002{\u0001\u0007\u0011QA\u0001\rSN4uN]6BGRLg/\u001a\u000b\u0005\u00033\u0019i\u0001C\u0004\u0002\u000ey\u0002\raa\u0004\u0011\t\t=3\u0011C\u0005\u0005\u0007'\u0011\tFA\u0004J]R,w-\u001a:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u001d\u001cI\u0002C\u0003^\u007f\u0001\u0007q,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}1\u0011\u0005\t\u0005+\u0006uw\f\u0003\u0005\u0004$\u0001\u000b\t\u00111\u0001h\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004*A!!qJB\u0016\u0013\u0011\u0019iC!\u0015\u0003\r=\u0013'.Z2u\u0001")
public class McAddrOwnershipMsgProcessor
extends NativeSmartContractMsgProcessor
implements McAddrOwnershipsProvider,
Product,
Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;

    public static Option<NetworkParams> unapply(McAddrOwnershipMsgProcessor mcAddrOwnershipMsgProcessor) {
        return McAddrOwnershipMsgProcessor$.MODULE$.unapply(mcAddrOwnershipMsgProcessor);
    }

    public static McAddrOwnershipMsgProcessor apply(NetworkParams networkParams) {
        return McAddrOwnershipMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static boolean isForkActive(Integer n) {
        return McAddrOwnershipMsgProcessor$.MODULE$.isForkActive(n);
    }

    public static boolean initDone(BaseAccountStateView baseAccountStateView) {
        return McAddrOwnershipMsgProcessor$.MODULE$.initDone(baseAccountStateView);
    }

    public static SignatureSecp256k1 getMcSignature(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.getMcSignature(string);
    }

    public static byte[] getOwnershipId(String string) {
        return McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(string);
    }

    public static X9ECParameters ecParameters() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ecParameters();
    }

    public static String GetListOfOwnerScAddressesCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnerScAddressesCmd();
    }

    public static String GetListOfOwnershipsCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnershipsCmd();
    }

    public static String GetListOfAllOwnershipsCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.GetListOfAllOwnershipsCmd();
    }

    public static String RemoveOwnershipCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.RemoveOwnershipCmd();
    }

    public static String AddNewOwnershipCmd() {
        return McAddrOwnershipMsgProcessor$.MODULE$.AddNewOwnershipCmd();
    }

    public static byte[] ScAddressRefsLinkedListNullValue() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListNullValue();
    }

    public static byte[] ScAddressRefsLinkedListTipKey() {
        return McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey();
    }

    public static byte[] OwnershipLinkedListNullValue() {
        return McAddrOwnershipMsgProcessor$.MODULE$.OwnershipLinkedListNullValue();
    }

    public static byte[] OwnershipsLinkedListTipKey() {
        return McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        if (!McAddrOwnershipMsgProcessor$.MODULE$.isForkActive(Predef$.MODULE$.int2Integer(consensusEpochNumber))) {
            BoxedUnit boxedUnit4;
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn("Can not perform {} initialization, fork is not active", new Object[]{this.getClass().getName()});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            return;
        }
        if (McAddrOwnershipMsgProcessor$.MODULE$.initDone(view)) {
            throw new MessageProcessorInitializationException("McAddrOwnership msg processor already initialized");
        }
        if (!view.accountExists(this.contractAddress())) {
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("creating Message Processor account {}", new Object[]{this.contractAddress()});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
        } else {
            String errorMsg = new StringBuilder(68).append("Account ").append(this.contractAddress()).append(" already exists!! Overwriting account with contract code ").append(BytesUtils.toHexString(this.contractCode())).append("...").toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errorMsg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
        }
        view.addAccount(this.contractAddress(), this.contractCode());
        byte[] initialTip = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            String warnMsg = "Initial tip already set, overwriting it!! ";
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(warnMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        view.updateAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipLinkedListNullValue());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            String warnMsg = "Sc Initial tip already set, overwriting it!! ";
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(warnMsg);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        view.updateAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListNullValue());
    }

    @Override
    public boolean canProcess(Message msg, BaseAccountStateView view, int consensusEpochNumber) {
        boolean bl;
        if (super.canProcess(msg, view, consensusEpochNumber)) {
            if (McAddrOwnershipMsgProcessor$.MODULE$.isForkActive(Predef$.MODULE$.int2Integer(consensusEpochNumber))) {
                if (!McAddrOwnershipMsgProcessor$.MODULE$.initDone(view)) {
                    this.init(view, consensusEpochNumber);
                }
                bl = true;
            } else {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Can not process message in {}, fork is not active: msg = {}", new Object[]{this.getClass().getName(), msg});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private void addMcAddrOwnership(BaseAccountStateView view, byte[] ownershipId, Address scAddress, String mcTransparentAddress) {
        McAddrOwnershipLinkedList$.MODULE$.addNewNode(view, ownershipId, this.contractAddress());
        McAddrOwnershipData mcAddrOwnershipData = new McAddrOwnershipData(scAddress.toStringNoPrefix(), mcTransparentAddress);
        byte[] serializedOwnershipData = McAddrOwnershipDataSerializer$.MODULE$.toBytes(mcAddrOwnershipData);
        view.updateAccountStorageBytes(this.contractAddress(), ownershipId, serializedOwnershipData);
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddress.toStringNoPrefix());
        byte[] dataId = scAddrList.getDataId(mcTransparentAddress);
        scAddrList.addNewNode(view, dataId, this.contractAddress());
        byte[] serializedData = mcTransparentAddress.getBytes(StandardCharsets.UTF_8);
        view.updateAccountStorageBytes(this.contractAddress(), dataId, serializedData);
    }

    private void uncheckedRemoveMcAddrOwnership(BaseAccountStateView view, byte[] ownershipId, String scAddressStr, String mcTransparentAddress) {
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddressStr);
        byte[] dataId = scAddrList.getDataId(mcTransparentAddress);
        scAddrList.removeNode(view, dataId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), dataId);
        McAddrOwnershipLinkedList$.MODULE$.removeNode(view, ownershipId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), ownershipId);
    }

    public boolean isValidOwnershipSignature(Address scAddress, String mcTransparentAddress, SignatureSecp256k1 mcSignature) {
        byte[] v_barr = BigIntegerUInt256.getUnsignedByteArray(mcSignature.getV());
        byte[] r_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getR()), 32);
        byte[] s_barr = BytesUtils.padWithZeroBytes(BigIntegerUInt256.getUnsignedByteArray(mcSignature.getS()), 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v_barr, r_barr, s_barr);
        byte[] hashedMsg = this.getMcHashedMsg(Keys.toChecksumAddress((String)Numeric.toHexString((byte[])scAddress.toBytes())));
        BigInteger recPubKey = Sign.signedMessageHashToKey((byte[])hashedMsg, (Sign.SignatureData)signatureData);
        byte[] recUncompressedPubKeyBytes = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{4}), ClassTag$.MODULE$.Byte()), Numeric.toBytesPadded((BigInteger)recPubKey, (int)Secp256k1.PUBLIC_KEY_SIZE)});
        ECPoint ecpointRec = McAddrOwnershipMsgProcessor$.MODULE$.ecParameters().getCurve().decodePoint(recUncompressedPubKeyBytes);
        byte[] recCompressedPubKeyBytes = ecpointRec.getEncoded(true);
        byte[] mcPubkeyhash = Utils.Ripemd160Sha256Hash(recCompressedPubKeyBytes);
        String computedTaddr = BytesUtils.toHorizenPublicKeyAddress(mcPubkeyhash, this.params());
        return computedTaddr.equals(mcTransparentAddress);
    }

    private byte[] getMcHashedMsg(String messageToSignString) {
        String strMessageMagic = "Zcash Signed Message:\n";
        byte[] messageMagicBytes = strMessageMagic.getBytes(StandardCharsets.UTF_8);
        byte[] mmb2 = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)messageMagicBytes.length}), ClassTag$.MODULE$.Byte()), messageMagicBytes});
        byte[] messageToSignBytes = messageToSignString.getBytes(StandardCharsets.UTF_8);
        byte[] mts2 = Bytes.concat((byte[][])new byte[][]{(byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)messageToSignBytes.length}), ClassTag$.MODULE$.Byte()), messageToSignBytes});
        return Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{mmb2, mts2}));
    }

    public byte[] doAddNewOwnershipCmd(Message msg, BaseAccountStateView view) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            BoxedUnit boxedUnit2;
            String errMsg = new StringBuilder(33).append("Call must include a nonce: msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (msg.getValue().signum() != 0) {
            BoxedUnit boxedUnit3;
            String errMsg = new StringBuilder(26).append("Value must be zero: msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!view.accountExists(msg.getFrom())) {
            BoxedUnit boxedUnit4;
            String errMsg = new StringBuilder(37).append("Sender account does not exist: msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        AddNewOwnershipCmdInput cmdInput = (AddNewOwnershipCmdInput)AddNewOwnershipCmdInputDecoder$.MODULE$.decode(inputParams);
        String mcTransparentAddress = cmdInput.mcTransparentAddress();
        String mcSignature = cmdInput.mcSignature();
        byte[] newOwnershipId = McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(mcTransparentAddress);
        SignatureSecp256k1 mcSignSecp256k1 = McAddrOwnershipMsgProcessor$.MODULE$.getMcSignature(mcSignature);
        if (!this.isValidOwnershipSignature(msg.getFrom(), mcTransparentAddress, mcSignSecp256k1)) {
            BoxedUnit boxedUnit5;
            String errMsg = new StringBuilder(29).append("Invalid mc signature ").append(mcSignature).append(": msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        Option<String> option = this.getExistingAssociation(view, newOwnershipId);
        if (option instanceof Some) {
            BoxedUnit boxedUnit6;
            Some some = (Some)option;
            String scAddrStr = (String)some.value();
            String errMsg = new StringBuilder(56).append("MC address ").append(mcTransparentAddress).append(" is already associated to sc address ").append(scAddrStr).append(": msg = ").append(msg).toString();
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(errMsg);
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(errMsg);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
        this.addMcAddrOwnership(view, newOwnershipId, msg.getFrom(), mcTransparentAddress);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug(new StringBuilder(85).append("Added ownership to stateDb: newOwnershipId=").append(BytesUtils.toHexString(newOwnershipId)).append(",").append(" scAddress=").append(msg.getFrom()).append(", mcPubKeyBytes=").append(mcTransparentAddress).append(", mcSignature=").append(mcSignature).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        AddMcAddrOwnership addNewMcAddrOwnershipEvt = AddMcAddrOwnership$.MODULE$.apply(msg.getFrom(), mcTransparentAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewMcAddrOwnershipEvt);
        view.addLog(evmLog);
        return newOwnershipId;
    }

    public byte[] doRemoveOwnershipCmd(Message msg, BaseAccountStateView view) {
        byte[] ownershipId;
        String mcTransparentAddress;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Value must be zero");
        }
        if (!view.accountExists(msg.getFrom())) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(msg.getFrom()).toString());
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        RemoveOwnershipCmdInput cmdInput = (RemoveOwnershipCmdInput)RemoveOwnershipCmdInputDecoder$.MODULE$.decode(inputParams);
        Option<String> option = cmdInput.mcTransparentAddressOpt();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            mcTransparentAddress = (String)some.value();
            ownershipId = McAddrOwnershipMsgProcessor$.MODULE$.getOwnershipId(mcTransparentAddress);
            Option<String> option2 = this.getExistingAssociation(view, ownershipId);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String scAddrStr = (String)some2.value();
                if (!msg.getFrom().toStringNoPrefix().equals(scAddrStr)) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(40).append("sc address ").append(scAddrStr).append(" is not the owner of ").append(mcTransparentAddress).append(": msg = ").append(msg).toString();
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new ExecutionRevertedException(errMsg);
                }
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new ExecutionRevertedException(new StringBuilder(26).append("Ownership ").append(BytesUtils.toHexString(ownershipId)).append(" does not exists").toString());
                }
                throw new MatchError(option2);
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            this.uncheckedRemoveMcAddrOwnership(view, ownershipId, msg.getFrom().toStringNoPrefix(), mcTransparentAddress);
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(72).append("Removed ownership from stateDb: ownershipId=").append(BytesUtils.toHexString(ownershipId)).append(",").append(" scAddress=").append(msg.getFrom()).append(", mcPubKeyBytes=").append(mcTransparentAddress).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new ExecutionRevertedException("Invalid null mc address");
            }
            throw new MatchError(option);
        }
        RemoveMcAddrOwnership removeMcAddrOwnershipEvt = RemoveMcAddrOwnership$.MODULE$.apply(msg.getFrom(), mcTransparentAddress);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeMcAddrOwnershipEvt);
        view.addLog(evmLog);
        byte[] byArray = ownershipId;
        return byArray;
    }

    public byte[] doGetListOfOwnershipsCmd(Message msg, BaseAccountStateView view) {
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        GetOwnershipsCmdInput cmdInput = (GetOwnershipsCmdInput)GetOwnershipsCmdInputDecoder$.MODULE$.decode(inputParams);
        Seq<McAddrOwnershipData> ownershipList = this.getScAddrListOfMcAddrOwnerships(view, cmdInput.scAddress().toStringNoPrefix());
        return McAddrOwnershipDataListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    public byte[] doGetListOfAllOwnershipsCmd(Message msg, BaseAccountStateView view) {
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        if (ABIUtil.getArgumentsFromData(msg.getData()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(msg.getData().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        Seq<McAddrOwnershipData> ownershipList = this.getListOfMcAddrOwnerships(view, this.getListOfMcAddrOwnerships$default$2());
        return McAddrOwnershipDataListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    public byte[] doGetListOfOwnerScAddressesCmd(Message msg, BaseAccountStateView view) {
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        if (ABIUtil.getArgumentsFromData(msg.getData()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(msg.getData().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
        Seq<OwnerScAddress> ownershipList = this.getListOfOwnerScAddresses(view);
        return OwnerScAddrListEncoder$.MODULE$.encode((List)CollectionConverters$.MODULE$.seqAsJavaListConverter(ownershipList).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses(BaseAccountStateView view) {
        void var3_2;
        BoxedUnit boxedUnit;
        Seq ownerScAddresses = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.ScAddressRefsLinkedListTipKey());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(nodeReference)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            return ownerScAddresses;
        }
        try {
            while (!ScAddressRefsLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
                OwnerScAddress ownerScAddress;
                byte[] prevNodeReference;
                block10: {
                    Tuple2<OwnerScAddress, byte[]> tuple2;
                    block9: {
                        tuple2 = ScAddressRefsLinkedList$.MODULE$.getScAddresRefsListItem(view, nodeReference);
                        if (tuple2 == null) break block9;
                        OwnerScAddress item = (OwnerScAddress)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block9;
                        ownerScAddress = item;
                        if (prevNodeReference != null) break block10;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)ownerScAddress, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                OwnerScAddress item = (OwnerScAddress)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                OwnerScAddress ownerScAddress2 = item;
                ownerScAddresses = (Seq)ownerScAddresses.$plus$colon((Object)ownerScAddress2, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownerScAddresses.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_2;
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(BaseAccountStateView view, Option<String> scAddressOpt) {
        BoxedUnit boxedUnit;
        Seq ownershipsList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey());
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(nodeReference)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            return ownershipsList;
        }
        Option<String> option = scAddressOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String scAddr = (String)some.value();
            return this.getScAddrListOfMcAddrOwnerships(view, scAddr);
        }
        if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        try {
            while (!McAddrOwnershipLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
                McAddrOwnershipData mcAddrOwnershipData;
                byte[] prevNodeReference;
                block12: {
                    Tuple2<McAddrOwnershipData, byte[]> tuple2;
                    block11: {
                        tuple2 = McAddrOwnershipLinkedList$.MODULE$.getOwnershipListItem(view, nodeReference);
                        if (tuple2 == null) break block11;
                        McAddrOwnershipData item = (McAddrOwnershipData)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block11;
                        mcAddrOwnershipData = item;
                        if (prevNodeReference != null) break block12;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)mcAddrOwnershipData, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                McAddrOwnershipData item = (McAddrOwnershipData)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                McAddrOwnershipData mcAddrOwnershipData2 = item;
                ownershipsList = (Seq)ownershipsList.$plus$colon((Object)mcAddrOwnershipData2, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownershipsList.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return ownershipsList;
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$2() {
        return None$.MODULE$;
    }

    private Seq<McAddrOwnershipData> getScAddrListOfMcAddrOwnerships(BaseAccountStateView view, String scAddress) {
        BoxedUnit boxedUnit;
        ScAddrOwnershipLinkedList scAddrList = ScAddrOwnershipLinkedList$.MODULE$.apply(view, scAddress);
        byte[] nodeReference = scAddrList.getTip(view);
        Seq ownershipsList = (Seq)Nil$.MODULE$;
        try {
            while (!scAddrList.linkedListNodeRefIsNull(nodeReference)) {
                String string;
                byte[] prevNodeReference;
                block8: {
                    Tuple2<String, byte[]> tuple2;
                    block7: {
                        tuple2 = scAddrList.getItem(view, nodeReference);
                        if (tuple2 == null) break block7;
                        String item = (String)tuple2._1();
                        prevNodeReference = (byte[])tuple2._2();
                        if (item == null) break block7;
                        string = item;
                        if (prevNodeReference != null) break block8;
                    }
                    throw new MatchError(tuple2);
                }
                byte[] byArray = prevNodeReference;
                Tuple2 tuple2 = new Tuple2((Object)string, (Object)byArray);
                Tuple2 tuple22 = tuple2;
                String item = (String)tuple22._1();
                byte[] prevNodeReference2 = (byte[])tuple22._2();
                McAddrOwnershipData mcAddrOwnershipData = new McAddrOwnershipData(scAddress, item);
                ownershipsList = (Seq)ownershipsList.$plus$colon((Object)mcAddrOwnershipData, Seq$.MODULE$.canBuildFrom());
                nodeReference = prevNodeReference2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (OutOfGasException e) {
            if (this.log().underlying().isWarnEnabled()) {
                this.log().underlying().warn(new StringBuilder(45).append("OOG exception thrown after getting ").append(ownershipsList.length()).append(" elements!").toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return ownershipsList;
    }

    @Override
    public boolean ownershipDataExist(BaseAccountStateView view, byte[] ownershipId) {
        byte[] data = view.getAccountStorage(this.contractAddress(), ownershipId);
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    private Option<String> getExistingAssociation(BaseAccountStateView view, byte[] ownershipId) {
        None$ none$;
        Option<McAddrOwnershipData> option = McAddrOwnershipLinkedList$.MODULE$.getOwnershipData(view, ownershipId);
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            McAddrOwnershipData obj = (McAddrOwnershipData)some.value();
            none$ = new Some((Object)obj.scAddress());
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        byte[] byArray;
        if (!McAddrOwnershipMsgProcessor$.MODULE$.isForkActive(Predef$.MODULE$.int2Integer(blockContext.consensusEpochNumber))) {
            throw new ExecutionRevertedException("zenDao fork not active");
        }
        BaseAccountStateView gasView = view.getGasTrackedView(gas);
        if (!McAddrOwnershipMsgProcessor$.MODULE$.initDone(gasView)) {
            throw new ExecutionRevertedException("zenDao native smart contract init not done");
        }
        if (msg.getData().length == 0) {
            throw new ExecutionRevertedException(new StringBuilder(17).append("No data in msg = ").append(msg).toString());
        }
        String string = ABIUtil.getFunctionSignature(msg.getData());
        String string2 = McAddrOwnershipMsgProcessor$.MODULE$.AddNewOwnershipCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.doAddNewOwnershipCmd(msg, gasView);
        } else {
            String string4 = McAddrOwnershipMsgProcessor$.MODULE$.RemoveOwnershipCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doRemoveOwnershipCmd(msg, gasView);
            } else {
                String string6 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfAllOwnershipsCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doGetListOfAllOwnershipsCmd(msg, gasView);
                } else {
                    String string8 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnershipsCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doGetListOfOwnershipsCmd(msg, gasView);
                    } else {
                        String string10 = McAddrOwnershipMsgProcessor$.MODULE$.GetListOfOwnerScAddressesCmd();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            byArray = this.doGetListOfOwnerScAddressesCmd(msg, gasView);
                        } else {
                            throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                        }
                    }
                }
            }
        }
        return byArray;
    }

    public McAddrOwnershipMsgProcessor copy(NetworkParams params) {
        return new McAddrOwnershipMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "McAddrOwnershipMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof McAddrOwnershipMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof McAddrOwnershipMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        McAddrOwnershipMsgProcessor mcAddrOwnershipMsgProcessor = (McAddrOwnershipMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = mcAddrOwnershipMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!mcAddrOwnershipMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public McAddrOwnershipMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("McAddrOwnershipSmartContractCode");
    }
}

