/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.fork.ZenDAOFork$;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.McAddrOwnershipMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.params.NetworkParams;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.crypto.hash.Keccak256$;
import sparkz.util.SparkzLogging;
import sparkz.util.encode.Base64$;

public final class McAddrOwnershipMsgProcessor$
implements SparkzLogging,
Serializable {
    public static McAddrOwnershipMsgProcessor$ MODULE$;
    private final byte[] OwnershipsLinkedListTipKey;
    private final byte[] OwnershipLinkedListNullValue;
    private final byte[] ScAddressRefsLinkedListTipKey;
    private final byte[] ScAddressRefsLinkedListNullValue;
    private final String AddNewOwnershipCmd;
    private final String RemoveOwnershipCmd;
    private final String GetListOfAllOwnershipsCmd;
    private final String GetListOfOwnershipsCmd;
    private final String GetListOfOwnerScAddressesCmd;
    private final X9ECParameters ecParameters;
    private final Logger logger;

    static {
        new McAddrOwnershipMsgProcessor$();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public byte[] OwnershipsLinkedListTipKey() {
        return this.OwnershipsLinkedListTipKey;
    }

    public byte[] OwnershipLinkedListNullValue() {
        return this.OwnershipLinkedListNullValue;
    }

    public byte[] ScAddressRefsLinkedListTipKey() {
        return this.ScAddressRefsLinkedListTipKey;
    }

    public byte[] ScAddressRefsLinkedListNullValue() {
        return this.ScAddressRefsLinkedListNullValue;
    }

    public String AddNewOwnershipCmd() {
        return this.AddNewOwnershipCmd;
    }

    public String RemoveOwnershipCmd() {
        return this.RemoveOwnershipCmd;
    }

    public String GetListOfAllOwnershipsCmd() {
        return this.GetListOfAllOwnershipsCmd;
    }

    public String GetListOfOwnershipsCmd() {
        return this.GetListOfOwnershipsCmd;
    }

    public String GetListOfOwnerScAddressesCmd() {
        return this.GetListOfOwnerScAddressesCmd;
    }

    public X9ECParameters ecParameters() {
        return this.ecParameters;
    }

    public byte[] getOwnershipId(String mcAddress) {
        return Keccak256$.MODULE$.hash(mcAddress.getBytes(StandardCharsets.UTF_8));
    }

    public SignatureSecp256k1 getMcSignature(String mcSignatureString) {
        byte[] decodedMcSignature = (byte[])Base64$.MODULE$.decode(mcSignatureString).get();
        BigInteger v = BigInteger.valueOf(decodedMcSignature[0] - 4);
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(decodedMcSignature, 1, 33));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(decodedMcSignature, 33, 65));
        return new SignatureSecp256k1(v, r, s);
    }

    public boolean initDone(BaseAccountStateView view) {
        byte[] initialTip = view.getAccountStorage(WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS(), this.OwnershipsLinkedListTipKey());
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isForkActive(Integer consensusEpochNumber) {
        void var2_2;
        BoxedUnit boxedUnit;
        String strVal;
        boolean forkIsActive = ZenDAOFork$.MODULE$.get(Predef$.MODULE$.Integer2int(consensusEpochNumber)).active();
        String string = strVal = forkIsActive ? "YES" : "NO";
        if (this.log().underlying().isTraceEnabled()) {
            this.log().underlying().trace("Epoch {}: ZenDAO fork active={}", new Object[]{consensusEpochNumber, strVal});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (boolean)var2_2;
    }

    public McAddrOwnershipMsgProcessor apply(NetworkParams params) {
        return new McAddrOwnershipMsgProcessor(params);
    }

    public Option<NetworkParams> unapply(McAddrOwnershipMsgProcessor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.params());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private McAddrOwnershipMsgProcessor$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.OwnershipsLinkedListTipKey = Blake2b256$.MODULE$.hash("OwnershipTipKey");
        this.OwnershipLinkedListNullValue = Blake2b256$.MODULE$.hash("OwnershipTipNullValue");
        this.ScAddressRefsLinkedListTipKey = Blake2b256$.MODULE$.hash("ScAddrRefsTip");
        this.ScAddressRefsLinkedListNullValue = Blake2b256$.MODULE$.hash("ScAddressRefsLinkedListNull");
        this.AddNewOwnershipCmd = ABIUtil.getABIMethodId("sendKeysOwnership(bytes3,bytes32,bytes24,bytes32,bytes32)");
        this.RemoveOwnershipCmd = ABIUtil.getABIMethodId("removeKeysOwnership(bytes3,bytes32)");
        this.GetListOfAllOwnershipsCmd = ABIUtil.getABIMethodId("getAllKeyOwnerships()");
        this.GetListOfOwnershipsCmd = ABIUtil.getABIMethodId("getKeyOwnerships(address)");
        this.GetListOfOwnerScAddressesCmd = ABIUtil.getABIMethodId("getKeyOwnerScAddresses()");
        this.ecParameters = SECNamedCurves.getByName((String)"secp256k1");
        Predef$.MODULE$.require(this.AddNewOwnershipCmd().length() == 8 && this.RemoveOwnershipCmd().length() == 8 && this.GetListOfAllOwnershipsCmd().length() == 8 && this.GetListOfOwnershipsCmd().length() == 8 && this.GetListOfOwnerScAddressesCmd().length() == 8);
    }
}

