/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.McAddrOwnershipDataSerializer$;
import io.horizen.account.state.McAddrOwnershipMsgProcessor$;
import io.horizen.account.state.MessageProcessorUtil;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.evm.Address;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class McAddrOwnershipLinkedList$
implements MessageProcessorUtil.NativeSmartContractLinkedList {
    public static McAddrOwnershipLinkedList$ MODULE$;
    private final byte[] listTipKey;
    private final byte[] listTipNullValue;

    static {
        new McAddrOwnershipLinkedList$();
    }

    @Override
    public Option<MessageProcessorUtil.LinkedListNode> getLinkedListNode(BaseAccountStateView view, byte[] nodeId, Address contract_address) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.getLinkedListNode$(this, view, nodeId, contract_address);
    }

    @Override
    public void addNewNode(BaseAccountStateView view, byte[] dataId, Address contract_address) {
        MessageProcessorUtil.NativeSmartContractLinkedList.addNewNode$(this, view, dataId, contract_address);
    }

    @Override
    public Option<BoxedUnit> modifyNode(BaseAccountStateView view, byte[] nodeId, Address contract_address, Function1<MessageProcessorUtil.LinkedListNode, MessageProcessorUtil.LinkedListNode> modify) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.modifyNode$(this, view, nodeId, contract_address, modify);
    }

    @Override
    public void removeNode(BaseAccountStateView view, byte[] dataId, Address contract_address) {
        MessageProcessorUtil.NativeSmartContractLinkedList.removeNode$(this, view, dataId, contract_address);
    }

    @Override
    public boolean linkedListNodeRefIsNull(byte[] ref) {
        return MessageProcessorUtil.NativeSmartContractLinkedList.linkedListNodeRefIsNull$(this, ref);
    }

    @Override
    public byte[] listTipKey() {
        return this.listTipKey;
    }

    @Override
    public byte[] listTipNullValue() {
        return this.listTipNullValue;
    }

    public Option<McAddrOwnershipData> getOwnershipData(BaseAccountStateView view, byte[] ownershipId) {
        None$ none$;
        byte[] data = view.getAccountStorageBytes(WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS(), ownershipId);
        if (data.length == 0) {
            none$ = None$.MODULE$;
        } else {
            Try<McAddrOwnershipData> try_ = McAddrOwnershipDataSerializer$.MODULE$.parseBytesTry(data);
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable exception = failure.exception();
                    throw new ExecutionRevertedException("Error while parsing forger data.", exception);
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            McAddrOwnershipData obj = (McAddrOwnershipData)success.value();
            Some some = new Some((Object)obj);
            none$ = some;
        }
        return none$;
    }

    public Tuple2<McAddrOwnershipData, byte[]> getOwnershipListItem(BaseAccountStateView view, byte[] nodeRef) {
        if (this.linkedListNodeRefIsNull(nodeRef)) {
            throw new ExecutionRevertedException("Tip has the null value, no list here");
        }
        Option node = this.getLinkedListNode(view, nodeRef, WellKnownAddresses$.MODULE$.MC_ADDR_OWNERSHIP_SMART_CONTRACT_ADDRESS()).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("Could not find a valid node");
        });
        Option ownershipData = this.getOwnershipData(view, ((MessageProcessorUtil.LinkedListNode)node.get()).dataKey()).orElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("Could not find valid data");
        });
        McAddrOwnershipData listItem = new McAddrOwnershipData(((McAddrOwnershipData)ownershipData.get()).scAddress(), ((McAddrOwnershipData)ownershipData.get()).mcTransparentAddress());
        byte[] prevNodeKey = ((MessageProcessorUtil.LinkedListNode)node.get()).previousNodeKey();
        return new Tuple2((Object)listItem, (Object)prevNodeKey);
    }

    private McAddrOwnershipLinkedList$() {
        MODULE$ = this;
        MessageProcessorUtil.NativeSmartContractLinkedList.$init$(this);
        this.listTipKey = McAddrOwnershipMsgProcessor$.MODULE$.OwnershipsLinkedListTipKey();
        this.listTipNullValue = McAddrOwnershipMsgProcessor$.MODULE$.OwnershipLinkedListNullValue();
    }
}

