/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountForgingStakeInfoListEncoder$;
import io.horizen.account.state.AddNewStakeCmdInput;
import io.horizen.account.state.AddNewStakeCmdInputDecoder$;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.ForgerPublicKeys;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.ForgerStakeDataSerializer$;
import io.horizen.account.state.ForgerStakeLinkedList$;
import io.horizen.account.state.ForgerStakeMsgProcessor$;
import io.horizen.account.state.ForgerStakesProvider;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessorInitializationException;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.NativeSmartContractMsgProcessor$;
import io.horizen.account.state.OpenStakeForgerListCmdInput;
import io.horizen.account.state.OpenStakeForgerListCmdInputDecoder$;
import io.horizen.account.state.RemoveStakeCmdInput;
import io.horizen.account.state.RemoveStakeCmdInputDecoder$;
import io.horizen.account.state.events.DelegateForgerStake;
import io.horizen.account.state.events.DelegateForgerStake$;
import io.horizen.account.state.events.OpenForgerList;
import io.horizen.account.state.events.OpenForgerList$;
import io.horizen.account.state.events.WithdrawForgerStake;
import io.horizen.account.state.events.WithdrawForgerStake$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.utils.WellKnownAddresses$;
import io.horizen.account.utils.ZenWeiConverter$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.utils.BytesUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001\u0002 @\u0001\"C\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00057\")\u0011\r\u0001C\u0001E\"9Q\r\u0001b\u0001\n\u00032\u0007BB7\u0001A\u0003%q\rC\u0004o\u0001\t\u0007I\u0011I8\t\rY\u0004\u0001\u0015!\u0003q\u0011\u001d9\bA1A\u0005\u0002iCa\u0001\u001f\u0001!\u0002\u0013Y\u0006\"B=\u0001\t\u0003Q\bbBA\u0001\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u001b\u0001\t\u0013\tY\u0007C\u0004\u0002r\u0001!\t%a\u001d\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0011\u0005\b\u0003;\u0003A\u0011BAP\u0011\u001d\t\u0019\u000b\u0001C!\u0003KCq!a2\u0001\t\u0003\tI\rC\u0004\u0002N\u0002!\t!a4\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0003W\u0004A\u0011IAw\u0011!\u00119\u0002\u0001C!\u0007\ne\u0001\u0002\u0003B\u0016\u0001\u0011\u00053I!\f\t\u000f\tE\u0002\u0001\"\u0003\u00034!A!\u0011\b\u0001\u0005B\r\u0013Y\u0004C\u0005\u0003B\u0001\t\t\u0011\"\u0001\u0003D!I!q\t\u0001\u0012\u0002\u0013\u0005!\u0011\n\u0005\n\u0005\u001b\u0002\u0011\u0011!C!\u0005\u001fB\u0011B!\u0018\u0001\u0003\u0003%\tAa\u0018\t\u0013\t\u0005\u0004!!A\u0005\u0002\t\r\u0004\"\u0003B8\u0001\u0005\u0005I\u0011\tB9\u0011%\u0011y\bAA\u0001\n\u0003\u0011\t\tC\u0005\u0003\u0006\u0002\t\t\u0011\"\u0011\u0003\b\"I!\u0011\u0012\u0001\u0002\u0002\u0013\u0005#1\u0012\u0005\n\u0005\u001b\u0003\u0011\u0011!C!\u0005\u001f;qAa%@\u0011\u0003\u0011)J\u0002\u0004?\u007f!\u0005!q\u0013\u0005\u0007C&\"\tAa(\t\u0011\t\u0005\u0016F1A\u0005\u0002=DqAa)*A\u0003%\u0001\u000f\u0003\u0005\u0003&&\u0012\r\u0011\"\u0001p\u0011\u001d\u00119+\u000bQ\u0001\nAD\u0001B!+*\u0005\u0004%\ta\u001c\u0005\b\u0005WK\u0003\u0015!\u0003q\u0011%\u0011i+\u000bb\u0001\n\u0003\u0011y\u000b\u0003\u0005\u0003@&\u0002\u000b\u0011\u0002BY\u0011%\u0011\t-\u000bb\u0001\n\u0003\u0011y\u000b\u0003\u0005\u0003D&\u0002\u000b\u0011\u0002BY\u0011%\u0011)-\u000bb\u0001\n\u0003\u0011y\u000b\u0003\u0005\u0003H&\u0002\u000b\u0011\u0002BY\u0011%\u0011I-\u000bb\u0001\n\u0003\u0011y\u000b\u0003\u0005\u0003L&\u0002\u000b\u0011\u0002BY\u0011\u001d\u0011i-\u000bC\u0001\u0005\u001fDqAa7*\t\u0003\u0011i\u000eC\u0005\u0003h&\n\t\u0011\"!\u0003j\"I!Q^\u0015\u0002\u0002\u0013\u0005%q\u001e\u0005\n\u0005oL\u0013\u0011!C\u0005\u0005s\u0014qCR8sO\u0016\u00148\u000b^1lK6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u000b\u0005\u0001\u000b\u0015!B:uCR,'B\u0001\"D\u0003\u001d\t7mY8v]RT!\u0001R#\u0002\u000f!|'/\u001b>f]*\ta)\u0001\u0002j_\u000e\u00011#\u0002\u0001J\u001bB3\u0006C\u0001&L\u001b\u0005y\u0014B\u0001'@\u0005}q\u0015\r^5wKNk\u0017M\u001d;D_:$(/Y2u\u001bN<\u0007K]8dKN\u001cxN\u001d\t\u0003\u0015:K!aT \u0003)\u0019{'oZ3s'R\f7.Z:Qe>4\u0018\u000eZ3s!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u001d\u0001&o\u001c3vGR\u0004\"!U,\n\u0005a\u0013&\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00029be\u0006l7/F\u0001\\!\taf,D\u0001^\u0015\tI6)\u0003\u0002`;\nia*\u001a;x_J\\\u0007+\u0019:b[N\fq\u0001]1sC6\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0012\u0004\"A\u0013\u0001\t\u000be\u001b\u0001\u0019A.\u0002\u001f\r|g\u000e\u001e:bGR\fE\r\u001a:fgN,\u0012a\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u000e\u000b1!\u001a<n\u0013\ta\u0017NA\u0004BI\u0012\u0014Xm]:\u0002!\r|g\u000e\u001e:bGR\fE\r\u001a:fgN\u0004\u0013\u0001D2p]R\u0014\u0018m\u0019;D_\u0012,W#\u00019\u0011\u0007E\u000b8/\u0003\u0002s%\n)\u0011I\u001d:bsB\u0011\u0011\u000b^\u0005\u0003kJ\u0013AAQ=uK\u0006i1m\u001c8ue\u0006\u001cGoQ8eK\u0002\nQB\\3uo>\u00148\u000eU1sC6\u001c\u0018A\u00048fi^|'o\u001b)be\u0006l7\u000fI\u0001\u000bO\u0016$8\u000b^1lK&#GC\u00019|\u0011\u0015a(\u00021\u0001~\u0003\ri7o\u001a\t\u0003\u0015zL!a` \u0003\u000f5+7o]1hK\u0006!\u0011N\\5u)\u0019\t)!a\u0003\u0002\u0016A\u0019\u0011+a\u0002\n\u0007\u0005%!K\u0001\u0003V]&$\bbBA\u0007\u0017\u0001\u0007\u0011qB\u0001\u0005m&,w\u000fE\u0002K\u0003#I1!a\u0005@\u0005Q\u0011\u0015m]3BG\u000e|WO\u001c;Ti\u0006$XMV5fo\"9\u0011qC\u0006A\u0002\u0005e\u0011\u0001F2p]N,gn];t\u000bB|7\r\u001b(v[\n,'\u000fE\u0002R\u00037I1!!\bS\u0005\rIe\u000e^\u0001\u0010KbL7\u000f^:Ti\u0006\\W\rR1uCR1\u00111EA\u0015\u0003W\u00012!UA\u0013\u0013\r\t9C\u0015\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001fAa!!\f\r\u0001\u0004\u0001\u0018aB:uC.,\u0017\nZ\u0001\u000fC\u0012$gi\u001c:hKJ\u001cF/Y6f)9\t)!a\r\u00026\u0005]\u0012qIA)\u0003+Bq!!\u0004\u000e\u0001\u0004\ty\u0001\u0003\u0004\u0002.5\u0001\r\u0001\u001d\u0005\b\u0003si\u0001\u0019AA\u001e\u0003Q\u0011Gn\\2l'&<g\u000e\u0015:pa>\u001c\u0018\u000e^5p]B!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\r\u000b1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&!\u0011QIA \u0005e\u0001VO\u00197jG.+\u0017PM\u001b6ce\u0002&o\u001c9pg&$\u0018n\u001c8\t\u000f\u0005%S\u00021\u0001\u0002L\u0005aaO\u001d4Qk\nd\u0017nY&fsB!\u0011QHA'\u0013\u0011\ty%a\u0010\u0003\u0019Y\u0013h\rU;cY&\u001c7*Z=\t\r\u0005MS\u00021\u0001h\u00039ywO\\3s!V\u0014G.[2LKfDq!a\u0016\u000e\u0001\u0004\tI&\u0001\u0007ti\u0006\\W\rZ!n_VtG\u000f\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\t5\fG\u000f\u001b\u0006\u0003\u0003G\nAA[1wC&!\u0011qMA/\u0005)\u0011\u0015nZ%oi\u0016<WM]\u0001\u0012e\u0016lwN^3G_J<WM]*uC.,GCBA\u0003\u0003[\ny\u0007C\u0004\u0002\u000e9\u0001\r!a\u0004\t\r\u00055b\u00021\u0001q\u0003a\tG\rZ*d\u0007J,\u0017\r^5p]\u001a{'oZ3s'R\f7.\u001a\u000b\u0006a\u0006U\u0014q\u000f\u0005\u0006y>\u0001\r! \u0005\b\u0003\u001by\u0001\u0019AA\b\u0003A!w.\u00113e\u001d\u0016<8\u000b^1lK\u000ekG\rF\u0004q\u0003{\ny(!!\t\u000bq\u0004\u0002\u0019A?\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010!I\u00111\u0011\t\u0011\u0002\u0003\u0007\u00111E\u0001\u0014SN<UM\\3tSN\u001c6m\u0011:fCRLwN\\\u0001\u001bI>\fE\r\u001a(foN#\u0018m[3D[\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003\u0013SC!a\t\u0002\f.\u0012\u0011Q\u0012\t\u0005\u0003\u001f\u000bI*\u0004\u0002\u0002\u0012*!\u00111SAK\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018J\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY*!%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\rdQ\u0016\u001c7nR3u\u0019&\u001cHo\u00144G_J<WM]:D[\u0012$B!!\u0002\u0002\"\")AP\u0005a\u0001{\u00061r-\u001a;MSN$xJ\u001a$pe\u001e,'o]*uC.,7\u000f\u0006\u0003\u0002(\u0006\u0015\u0007CBAU\u0003s\u000byL\u0004\u0003\u0002,\u0006Uf\u0002BAW\u0003gk!!a,\u000b\u0007\u0005Ev)\u0001\u0004=e>|GOP\u0005\u0002'&\u0019\u0011q\u0017*\u0002\u000fA\f7m[1hK&!\u00111XA_\u0005\r\u0019V-\u001d\u0006\u0004\u0003o\u0013\u0006c\u0001&\u0002B&\u0019\u00111Y \u0003/\u0005\u001b7m\\;oi\u001a{'oZ5oON#\u0018m[3J]\u001a|\u0007bBA\u0007'\u0001\u0007\u0011qB\u0001%I>,fn\u00195fG.,GmR3u\u0019&\u001cHo\u00144G_J<WM]:Ti\u0006\\Wm]\"nIR\u0019\u0001/a3\t\u000f\u00055A\u00031\u0001\u0002\u0010\u0005)Bm\\$fi2K7\u000f^(g\r>\u0014x-\u001a:t\u00076$G#\u00029\u0002R\u0006M\u0007\"\u0002?\u0016\u0001\u0004i\bbBA\u0007+\u0001\u0007\u0011qB\u0001\u0011I>\u0014V-\\8wKN#\u0018m[3D[\u0012$R\u0001]Am\u00037DQ\u0001 \fA\u0002uDq!!\u0004\u0017\u0001\u0004\ty!\u0001\u000ehKR\fE\u000e\\8xK\u00124uN]4feNLe\u000eZ3y\u0019&\u001cH\u000fF\u0002q\u0003CDq!!\u0004\u0018\u0001\u0004\ty!\u0001\re_>\u0003XM\\*uC.,gi\u001c:hKJd\u0015n\u001d;D[\u0012$R\u0001]At\u0003SDQ\u0001 \rA\u0002uDq!!\u0004\u0019\u0001\u0004\ty!A\u0004qe>\u001cWm]:\u0015\u0013A\fy/!=\u0002t\u0006u\b\"\u0002?\u001a\u0001\u0004i\bbBA\u00073\u0001\u0007\u0011q\u0002\u0005\b\u0003kL\u0002\u0019AA|\u0003\r9\u0017m\u001d\t\u0004\u0015\u0006e\u0018bAA~\u007f\t9q)Y:Q_>d\u0007bBA\u00003\u0001\u0007!\u0011A\u0001\rE2|7m[\"p]R,\u0007\u0010\u001e\t\u0004\u0015\n\r\u0011b\u0001B\u0003\u007f\ta!\t\\8dW\u000e{g\u000e^3yi\"*\u0011D!\u0003\u0003\u0016A)\u0011Ka\u0003\u0003\u0010%\u0019!Q\u0002*\u0003\rQD'o\\<t!\rQ%\u0011C\u0005\u0004\u0005'y$\u0001G#yK\u000e,H/[8o\r\u0006LG.\u001a3Fq\u000e,\u0007\u000f^5p]\u000e\u0012!qB\u0001\u000eM&tGm\u0015;bW\u0016$\u0015\r^1\u0015\r\tm!q\u0005B\u0015!\u0015\t&Q\u0004B\u0011\u0013\r\u0011yB\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\u0013\u0019#C\u0002\u0003&}\u0012qBR8sO\u0016\u00148\u000b^1lK\u0012\u000bG/\u0019\u0005\b\u0003\u001bQ\u0002\u0019AA\b\u0011\u0019\tiC\u0007a\u0001a\u0006\u0001\u0012n\u001d$pe\u001e,'\u000fT5ti>\u0003XM\u001c\u000b\u0005\u0003G\u0011y\u0003C\u0004\u0002\u000em\u0001\r!a\u0004\u00023%\u001chi\u001c:hKJd\u0015n\u001d;Pa\u0016tWK\\2iK\u000e\\W\r\u001a\u000b\u0005\u0003G\u0011)\u0004\u0003\u0004\u00038q\u0001\r\u0001]\u0001\u0005Y&\u001cH/A\u000ehKR\fE\u000e\\8xK\u00124uN]4fe2K7\u000f^%oI\u0016DXm\u001d\u000b\u0005\u0005{\u0011y\u0004\u0005\u0004\u0002*\u0006e\u0016\u0011\u0004\u0005\b\u0003\u001bi\u0002\u0019AA\b\u0003\u0011\u0019w\u000e]=\u0015\u0007\r\u0014)\u0005C\u0004Z=A\u0005\t\u0019A.\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\n\u0016\u00047\u0006-\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003RA!!1\u000bB-\u001b\t\u0011)F\u0003\u0003\u0003X\u0005\u0005\u0014\u0001\u00027b]\u001eLAAa\u0017\u0003V\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0007\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\rB6!\r\t&qM\u0005\u0004\u0005S\u0012&aA!os\"I!Q\u000e\u0012\u0002\u0002\u0003\u0007\u0011\u0011D\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tM\u0004C\u0002B;\u0005w\u0012)'\u0004\u0002\u0003x)\u0019!\u0011\u0010*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003~\t]$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\t\u0003\u0004\"I!Q\u000e\u0013\u0002\u0002\u0003\u0007!QM\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011D\u0001\ti>\u001cFO]5oOR\u0011!\u0011K\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\r\"\u0011\u0013\u0005\n\u0005[:\u0013\u0011!a\u0001\u0005K\nqCR8sO\u0016\u00148\u000b^1lK6\u001bx\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005)K3\u0003B\u0015\u0003\u001aZ\u00032!\u0015BN\u0013\r\u0011iJ\u0015\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tU\u0015\u0001\u0005'j].,G\rT5tiRK\u0007oS3z\u0003Ea\u0015N\\6fI2K7\u000f\u001e+ja.+\u0017\u0010I\u0001\u0014\u0019&t7.\u001a3MSN$h*\u001e7m-\u0006dW/Z\u0001\u0015\u0019&t7.\u001a3MSN$h*\u001e7m-\u0006dW/\u001a\u0011\u00023I+7\u000f\u001e:jGR,GMR8sO\u0016\u0014h\t\\1hg2K7\u000f^\u0001\u001b%\u0016\u001cHO]5di\u0016$gi\u001c:hKJ4E.Y4t\u0019&\u001cH\u000fI\u0001\u0014\u000f\u0016$H*[:u\u001f\u001a4uN]4feN\u001cU\u000eZ\u000b\u0003\u0005c\u0003BAa-\u0003<:!!Q\u0017B\\!\r\tiKU\u0005\u0004\u0005s\u0013\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003\\\tu&b\u0001B]%\u0006!r)\u001a;MSN$xJ\u001a$pe\u001e,'o]\"nI\u0002\na\"\u00113e\u001d\u0016<8\u000b^1lK\u000ekG-A\bBI\u0012tUm^*uC.,7)\u001c3!\u00039\u0011V-\\8wKN#\u0018m[3D[\u0012\fqBU3n_Z,7\u000b^1lK\u000ekG\rI\u0001\u0017\u001fB,gn\u0015;bW\u00164uN]4fe2K7\u000f^\"nI\u00069r\n]3o'R\f7.\u001a$pe\u001e,'\u000fT5ti\u000ekG\rI\u0001\u001fO\u0016$(+Z7pm\u0016\u001cF/Y6f\u00076$W*Z:tC\u001e,Gk\\*jO:$r\u0001\u001dBi\u0005'\u00149\u000e\u0003\u0004\u0002.e\u0002\r\u0001\u001d\u0005\u0007\u0005+L\u0004\u0019A4\u0002\t\u0019\u0014x.\u001c\u0005\u0007\u00053L\u0004\u0019\u00019\u0002\u000b9|gnY3\u0002M\u001d,Go\u00149f]N#\u0018m[3G_J<WM\u001d'jgR\u001cU\u000eZ'fgN\fw-\u001a+p'&<g\u000eF\u0004q\u0005?\u0014\u0019O!:\t\u000f\t\u0005(\b1\u0001\u0002\u001a\u0005Yam\u001c:hKJLe\u000eZ3y\u0011\u0019\u0011)N\u000fa\u0001O\"1!\u0011\u001c\u001eA\u0002A\fQ!\u00199qYf$2a\u0019Bv\u0011\u0015I6\b1\u0001\\\u0003\u001d)h.\u00199qYf$BA!=\u0003tB!\u0011K!\b\\\u0011!\u0011)\u0010PA\u0001\u0002\u0004\u0019\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0010\u0005\u0003\u0003T\tu\u0018\u0002\u0002B\u0000\u0005+\u0012aa\u00142kK\u000e$\b")
public class ForgerStakeMsgProcessor
extends NativeSmartContractMsgProcessor
implements ForgerStakesProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;
    private final NetworkParams networkParams;

    public static Option<NetworkParams> unapply(ForgerStakeMsgProcessor forgerStakeMsgProcessor) {
        return ForgerStakeMsgProcessor$.MODULE$.unapply(forgerStakeMsgProcessor);
    }

    public static ForgerStakeMsgProcessor apply(NetworkParams networkParams) {
        return ForgerStakeMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static byte[] getOpenStakeForgerListCmdMessageToSign(int n, Address address, byte[] byArray) {
        return ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(n, address, byArray);
    }

    public static byte[] getRemoveStakeCmdMessageToSign(byte[] byArray, Address address, byte[] byArray2) {
        return ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(byArray, address, byArray2);
    }

    public static String OpenStakeForgerListCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
    }

    public static String RemoveStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
    }

    public static String AddNewStakeCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
    }

    public static String GetListOfForgersCmd() {
        return ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
    }

    public static byte[] RestrictedForgerFlagsList() {
        return ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList();
    }

    public static byte[] LinkedListNullValue() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue();
    }

    public static byte[] LinkedListTipKey() {
        return ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    public NetworkParams networkParams() {
        return this.networkParams;
    }

    public byte[] getStakeId(Message msg) {
        return Keccak256$.MODULE$.hash(Bytes.concat((byte[][])new byte[][]{msg.getFrom().toBytes(), msg.getNonce().toByteArray(), msg.getValue().toByteArray(), msg.getData()}));
    }

    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
        super.init(view, consensusEpochNumber);
        byte[] initialTip = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(initialTip)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("initial tip already set");
        }
        view.updateAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey(), ForgerStakeMsgProcessor$.MODULE$.LinkedListNullValue());
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()))) {
            throw new MessageProcessorInitializationException("restrictForgerList already set");
        }
    }

    public boolean existsStakeData(BaseAccountStateView view, byte[] stakeId) {
        byte[] data = view.getAccountStorage(this.contractAddress(), stakeId);
        return !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32()));
    }

    public void addForgerStake(BaseAccountStateView view, byte[] stakeId, PublicKey25519Proposition blockSignProposition, VrfPublicKey vrfPublicKey, Address ownerPublicKey, BigInteger stakedAmount) {
        ForgerStakeLinkedList$.MODULE$.addNewNode(view, stakeId, this.contractAddress());
        ForgerStakeData forgerStakeData = new ForgerStakeData(new ForgerPublicKeys(blockSignProposition, vrfPublicKey), new AddressProposition(ownerPublicKey), stakedAmount);
        view.updateAccountStorageBytes(this.contractAddress(), stakeId, ForgerStakeDataSerializer$.MODULE$.toBytes(forgerStakeData));
    }

    private void removeForgerStake(BaseAccountStateView view, byte[] stakeId) {
        ForgerStakeLinkedList$.MODULE$.removeNode(view, stakeId, this.contractAddress());
        view.removeAccountStorageBytes(this.contractAddress(), stakeId);
    }

    @Override
    public byte[] addScCreationForgerStake(Message msg, BaseAccountStateView view) {
        return this.doAddNewStakeCmd(msg, view, true);
    }

    public byte[] doAddNewStakeCmd(Message msg, BaseAccountStateView view, boolean isGenesisScCreation) {
        BoxedUnit boxedUnit;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (msg.getValue().signum() <= 0) {
            throw new ExecutionRevertedException("Value must not be zero");
        }
        if (!ZenWeiConverter$.MODULE$.isValidZenAmount(msg.getValue())) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Value is not a legal wei amount: ").append(msg.getValue().toString()).toString());
        }
        if (!view.accountExists(msg.getFrom()) && !isGenesisScCreation) {
            throw new ExecutionRevertedException(new StringBuilder(31).append("Sender account does not exist: ").append(msg.getFrom()).toString());
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        AddNewStakeCmdInput cmdInput = (AddNewStakeCmdInput)AddNewStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        PublicKey25519Proposition blockSignPublicKey = cmdInput.forgerPublicKeys().blockSignPublicKey();
        VrfPublicKey vrfPublicKey = cmdInput.forgerPublicKeys().vrfPublicKey();
        Address ownerAddress = cmdInput.ownerAddress();
        if (!view.isEoaAccount(cmdInput.ownerAddress())) {
            throw new ExecutionRevertedException("Owner account is not an EOA");
        }
        if (!(isGenesisScCreation || this.isForgerListOpen(view) || this.networkParams().allowedForgersList().contains((Object)new Tuple2((Object)blockSignPublicKey, (Object)vrfPublicKey)))) {
            throw new ExecutionRevertedException("Forger is not in the allowed list");
        }
        byte[] newStakeId = this.getStakeId(msg);
        if (this.existsStakeData(view, newStakeId)) {
            throw new ExecutionRevertedException(new StringBuilder(21).append("Stake ").append(BytesUtils.toHexString(newStakeId)).append(" already exists").toString());
        }
        BigInteger stakedAmount = msg.getValue();
        this.addForgerStake(view, newStakeId, blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount);
        if (this.log().underlying().isDebugEnabled()) {
            this.log().underlying().debug("Added stake to stateDb: newStakeId={}, blockSignPublicKey={}, vrfPublicKey={}, ownerAddress={}, stakedAmount={}", new Object[]{BytesUtils.toHexString(newStakeId), blockSignPublicKey, vrfPublicKey, ownerAddress, stakedAmount});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DelegateForgerStake addNewStakeEvt = DelegateForgerStake$.MODULE$.apply(msg.getFrom(), ownerAddress, newStakeId, stakedAmount);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addNewStakeEvt);
        view.addLog(evmLog);
        if (isGenesisScCreation) {
            view.addBalance(this.contractAddress(), stakedAmount);
        } else {
            view.subBalance(msg.getFrom(), stakedAmount);
            view.addBalance(this.contractAddress(), stakedAmount);
        }
        return newStakeId;
    }

    public boolean doAddNewStakeCmd$default$3() {
        return false;
    }

    private void checkGetListOfForgersCmd(Message msg) {
        if (ABIUtil.getArgumentsFromData(msg.getData()).length > 0) {
            BoxedUnit boxedUnit;
            String msgStr = new StringBuilder(36).append("invalid msg data length: ").append(msg.getData().length).append(", expected ").append(4).toString();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(msgStr);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw new ExecutionRevertedException(msgStr);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes(BaseAccountStateView view) {
        void var3_2;
        Seq stakeList = (Seq)Nil$.MODULE$;
        byte[] nodeReference = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.LinkedListTipKey());
        while (!ForgerStakeLinkedList$.MODULE$.linkedListNodeRefIsNull(nodeReference)) {
            AccountForgingStakeInfo accountForgingStakeInfo;
            byte[] prevNodeReference;
            block4: {
                Tuple2<AccountForgingStakeInfo, byte[]> tuple2;
                block3: {
                    tuple2 = ForgerStakeLinkedList$.MODULE$.getStakeListItem(view, nodeReference);
                    if (tuple2 == null) break block3;
                    AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple2._1();
                    prevNodeReference = (byte[])tuple2._2();
                    if (item == null) break block3;
                    accountForgingStakeInfo = item;
                    if (prevNodeReference != null) break block4;
                }
                throw new MatchError(tuple2);
            }
            byte[] byArray = prevNodeReference;
            Tuple2 tuple2 = new Tuple2((Object)accountForgingStakeInfo, (Object)byArray);
            Tuple2 tuple22 = tuple2;
            AccountForgingStakeInfo item = (AccountForgingStakeInfo)tuple22._1();
            byte[] prevNodeReference2 = (byte[])tuple22._2();
            AccountForgingStakeInfo accountForgingStakeInfo2 = item;
            stakeList = (Seq)stakeList.$plus$colon((Object)accountForgingStakeInfo2, Seq$.MODULE$.canBuildFrom());
            nodeReference = prevNodeReference2;
        }
        return var3_2;
    }

    public byte[] doUncheckedGetListOfForgersStakesCmd(BaseAccountStateView view) {
        Seq<AccountForgingStakeInfo> stakeList = this.getListOfForgersStakes(view);
        return AccountForgingStakeInfoListEncoder$.MODULE$.encode((List)JavaConverters$.MODULE$.seqAsJavaListConverter(stakeList).asJava());
    }

    public byte[] doGetListOfForgersCmd(Message msg, BaseAccountStateView view) {
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        this.checkGetListOfForgersCmd(msg);
        return this.doUncheckedGetListOfForgersStakesCmd(view);
    }

    public byte[] doRemoveStakeCmd(Message msg, BaseAccountStateView view) {
        boolean result;
        byte[] msgToSign;
        ForgerStakeData stakeData;
        if (msg.getNonce() == null) {
            throw new ExecutionRevertedException("Call must include a nonce");
        }
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        RemoveStakeCmdInput cmdInput = (RemoveStakeCmdInput)RemoveStakeCmdInputDecoder$.MODULE$.decode(inputParams);
        byte[] stakeId = cmdInput.stakeId();
        SignatureSecp256k1 signature = cmdInput.signature();
        Try try_ = Try$.MODULE$.apply((Function0)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ForgerStakeMsgProcessor.$anonfun$doRemoveStakeCmd$2(signature, stakeData = (ForgerStakeData)this.findStakeData(view, stakeId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ExecutionRevertedException("No such stake id in state-db");
        }), msgToSign = ForgerStakeMsgProcessor$.MODULE$.getRemoveStakeCmdMessageToSign(stakeId, msg.getFrom(), msg.getNonce().toByteArray()))));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(39).append("Could not verify ill-formed signature: ").append(ex.getMessage()).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        boolean bl = result = BoxesRunTime.unboxToBoolean((Object)success.value());
        boolean isValid = bl;
        if (!isValid) {
            throw new ExecutionRevertedException("Invalid signature");
        }
        this.removeForgerStake(view, stakeId);
        WithdrawForgerStake removeStakeEvt = WithdrawForgerStake$.MODULE$.apply(stakeData.ownerPublicKey().address(), stakeId);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(removeStakeEvt);
        view.addLog(evmLog);
        view.subBalance(this.contractAddress(), stakeData.stakedAmount());
        view.addBalance(stakeData.ownerPublicKey().address(), stakeData.stakedAmount());
        return stakeId;
    }

    private byte[] getAllowedForgersIndexList(BaseAccountStateView view) {
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new IllegalStateException("Illegal call when list of forger is empty");
        }
        byte[] restrictForgerList = view.getAccountStorage(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(NativeSmartContractMsgProcessor$.MODULE$.NULL_HEX_STRING_32())) ? new byte[this.networkParams().allowedForgersList().size()] : view.getAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList());
    }

    public byte[] doOpenStakeForgerListCmd(Message msg, BaseAccountStateView view) {
        byte[] msgToSign;
        if (!this.networkParams().restrictForgers()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is not restricted");
        }
        if (this.networkParams().allowedForgersList().isEmpty()) {
            throw new ExecutionRevertedException("Illegal call when list of forger is empty");
        }
        if (msg.getValue().signum() != 0) {
            throw new ExecutionRevertedException("Call value must be zero");
        }
        byte[] inputParams = ABIUtil.getArgumentsFromData(msg.getData());
        OpenStakeForgerListCmdInput cmdInput = (OpenStakeForgerListCmdInput)OpenStakeForgerListCmdInputDecoder$.MODULE$.decode(inputParams);
        int forgerIndex = cmdInput.forgerIndex();
        Signature25519 signature = cmdInput.signature();
        if (this.networkParams().allowedForgersList().size() < forgerIndex + 1) {
            throw new ExecutionRevertedException(new StringBuilder(46).append("Invalid forgerIndex=").append(forgerIndex).append(": allowedForgersList size=").append(this.networkParams().allowedForgersList().size()).toString());
        }
        PublicKey25519Proposition blockSignerProposition = (PublicKey25519Proposition)((Tuple2)this.networkParams().allowedForgersList().apply(forgerIndex))._1();
        if (!signature.isValid(blockSignerProposition, msgToSign = ForgerStakeMsgProcessor$.MODULE$.getOpenStakeForgerListCmdMessageToSign(forgerIndex, msg.getFrom(), msg.getNonce().toByteArray()))) {
            throw new ExecutionRevertedException(new StringBuilder(69).append("Invalid signature, could not validate against blockSignerProposition=").append(blockSignerProposition).toString());
        }
        byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
        if (this.isForgerListOpenUnchecked(restrictForgerList)) {
            throw new ExecutionRevertedException("Forger list already open");
        }
        if (restrictForgerList[forgerIndex] == 1) {
            throw new ExecutionRevertedException("Forger index already processed");
        }
        restrictForgerList[forgerIndex] = 1;
        view.updateAccountStorageBytes(this.contractAddress(), ForgerStakeMsgProcessor$.MODULE$.RestrictedForgerFlagsList(), restrictForgerList);
        OpenForgerList addOpenStakeForgerListEvt = OpenForgerList$.MODULE$.apply(forgerIndex, msg.getFrom(), blockSignerProposition);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(addOpenStakeForgerListEvt);
        view.addLog(evmLog);
        return restrictForgerList;
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        byte[] byArray;
        BaseAccountStateView gasView = view.getGasTrackedView(gas);
        String string = ABIUtil.getFunctionSignature(msg.getData());
        String string2 = ForgerStakeMsgProcessor$.MODULE$.GetListOfForgersCmd();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            byArray = this.doGetListOfForgersCmd(msg, gasView);
        } else {
            String string4 = ForgerStakeMsgProcessor$.MODULE$.AddNewStakeCmd();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                byArray = this.doAddNewStakeCmd(msg, gasView, this.doAddNewStakeCmd$default$3());
            } else {
                String string6 = ForgerStakeMsgProcessor$.MODULE$.RemoveStakeCmd();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    byArray = this.doRemoveStakeCmd(msg, gasView);
                } else {
                    String string8 = ForgerStakeMsgProcessor$.MODULE$.OpenStakeForgerListCmd();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        byArray = this.doOpenStakeForgerListCmd(msg, gasView);
                    } else {
                        throw new ExecutionRevertedException(new StringBuilder(23).append("op code not supported: ").append(string).toString());
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public Option<ForgerStakeData> findStakeData(BaseAccountStateView view, byte[] stakeId) {
        return ForgerStakeLinkedList$.MODULE$.findStakeData(view, stakeId);
    }

    @Override
    public boolean isForgerListOpen(BaseAccountStateView view) {
        boolean bl;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            bl = this.isForgerListOpenUnchecked(restrictForgerList);
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean isForgerListOpenUnchecked(byte[] list) {
        return BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(list)).sum((Numeric)Numeric.ByteIsIntegral$.MODULE$)) > list.length / 2;
    }

    @Override
    public Seq<Object> getAllowedForgerListIndexes(BaseAccountStateView view) {
        Seq seq;
        if (this.params().restrictForgers()) {
            byte[] restrictForgerList = this.getAllowedForgersIndexList(view);
            seq = (Seq)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(restrictForgerList)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$3)), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    public ForgerStakeMsgProcessor copy(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "ForgerStakeMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ForgerStakeMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ForgerStakeMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ForgerStakeMsgProcessor forgerStakeMsgProcessor = (ForgerStakeMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = forgerStakeMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!forgerStakeMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$doRemoveStakeCmd$2(SignatureSecp256k1 signature$1, ForgerStakeData stakeData$1, byte[] msgToSign$1) {
        return signature$1.isValid(stakeData$1.ownerPublicKey(), msgToSign$1);
    }

    public ForgerStakeMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = WellKnownAddresses$.MODULE$.FORGER_STAKE_SMART_CONTRACT_ADDRESS();
        this.contractCode = Keccak256$.MODULE$.hash("ForgerStakeSmartContractCode");
        this.networkParams = params;
    }
}

