/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.ForgerStakeMsgProcessor;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import sparkz.crypto.hash.Blake2b256$;

public final class ForgerStakeMsgProcessor$
implements Serializable {
    public static ForgerStakeMsgProcessor$ MODULE$;
    private final byte[] LinkedListTipKey;
    private final byte[] LinkedListNullValue;
    private final byte[] RestrictedForgerFlagsList;
    private final String GetListOfForgersCmd;
    private final String AddNewStakeCmd;
    private final String RemoveStakeCmd;
    private final String OpenStakeForgerListCmd;

    static {
        new ForgerStakeMsgProcessor$();
    }

    public byte[] LinkedListTipKey() {
        return this.LinkedListTipKey;
    }

    public byte[] LinkedListNullValue() {
        return this.LinkedListNullValue;
    }

    public byte[] RestrictedForgerFlagsList() {
        return this.RestrictedForgerFlagsList;
    }

    public String GetListOfForgersCmd() {
        return this.GetListOfForgersCmd;
    }

    public String AddNewStakeCmd() {
        return this.AddNewStakeCmd;
    }

    public String RemoveStakeCmd() {
        return this.RemoveStakeCmd;
    }

    public String OpenStakeForgerListCmd() {
        return this.OpenStakeForgerListCmd;
    }

    public byte[] getRemoveStakeCmdMessageToSign(byte[] stakeId, Address from, byte[] nonce) {
        return Bytes.concat((byte[][])new byte[][]{from.toBytes(), nonce, stakeId});
    }

    public byte[] getOpenStakeForgerListCmdMessageToSign(int forgerIndex, Address from, byte[] nonce) {
        Predef$.MODULE$.require(forgerIndex >= 0);
        return Bytes.concat((byte[][])new byte[][]{Ints.toByteArray((int)forgerIndex), from.toBytes(), nonce});
    }

    public ForgerStakeMsgProcessor apply(NetworkParams params) {
        return new ForgerStakeMsgProcessor(params);
    }

    public Option<NetworkParams> unapply(ForgerStakeMsgProcessor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.params());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ForgerStakeMsgProcessor$() {
        MODULE$ = this;
        this.LinkedListTipKey = Blake2b256$.MODULE$.hash("Tip");
        this.LinkedListNullValue = Blake2b256$.MODULE$.hash("Null");
        this.RestrictedForgerFlagsList = Blake2b256$.MODULE$.hash("ClosedForgerList");
        this.GetListOfForgersCmd = ABIUtil.getABIMethodId("getAllForgersStakes()");
        this.AddNewStakeCmd = ABIUtil.getABIMethodId("delegate(bytes32,bytes32,bytes1,address)");
        this.RemoveStakeCmd = ABIUtil.getABIMethodId("withdraw(bytes32,bytes1,bytes32,bytes32)");
        this.OpenStakeForgerListCmd = ABIUtil.getABIMethodId("openStakeForgerList(uint32,bytes32,bytes32");
        Predef$.MODULE$.require(this.GetListOfForgersCmd().length() == 8 && this.AddNewStakeCmd().length() == 8 && this.RemoveStakeCmd().length() == 8 && this.OpenStakeForgerListCmd().length() == 8);
    }
}

