/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.Message;
import io.horizen.account.state.MessageProcessor;
import io.horizen.evm.Address;
import io.horizen.evm.BlockHashCallback;
import io.horizen.evm.Evm;
import io.horizen.evm.EvmContext;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.TraceOptions;
import io.horizen.evm.results.EvmResult;
import io.horizen.utils.BytesUtils;
import java.math.BigInteger;
import java.util.Optional;
import scala.compat.java8.OptionConverters;

public class EvmMessageProcessor
implements MessageProcessor {
    @Override
    public void init(BaseAccountStateView view, int consensusEpochNumber) {
    }

    @Override
    public boolean canProcess(Message msg, BaseAccountStateView view, int consensusEpochNumber) {
        Optional<Address> to = msg.getTo();
        if (to.isEmpty()) {
            return true;
        }
        return view.isSmartContractAccount(to.get());
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        EvmContext context = new EvmContext();
        context.chainID = BigInteger.valueOf(blockContext.chainID);
        context.coinbase = blockContext.forgerAddress;
        context.gasLimit = blockContext.blockGasLimit;
        context.blockNumber = BigInteger.valueOf(blockContext.blockNumber);
        context.time = BigInteger.valueOf(blockContext.timestamp);
        context.baseFee = blockContext.baseFee;
        context.random = blockContext.random;
        try (BlockHashGetter blockHashGetter = new BlockHashGetter(blockContext.blockHashProvider);){
            context.blockHashCallback = blockHashGetter;
            EvmResult result = Evm.Apply((ResourceHandle)view.getStateDbHandle(), (Address)msg.getFrom(), (Address)msg.getTo().orElse(null), (BigInteger)msg.getValue(), (byte[])msg.getData(), (BigInteger)gas.getGas(), (BigInteger)msg.getGasPrice(), (EvmContext)context, (TraceOptions)blockContext.getTraceOptions());
            blockContext.setEvmResult(result);
            gas.subGas(result.usedGas);
            if (result.reverted.booleanValue()) {
                throw new ExecutionRevertedException(result.returnData);
            }
            if (!result.evmError.isEmpty()) {
                throw new ExecutionFailedException(result.evmError);
            }
            byte[] byArray = result.returnData;
            return byArray;
        }
    }

    private static class BlockHashGetter
    extends BlockHashCallback {
        private final HistoryBlockHashProvider provider;

        private BlockHashGetter(HistoryBlockHashProvider provider) {
            this.provider = provider;
        }

        protected Hash getBlockHash(BigInteger blockNumber) {
            return OptionConverters.toJava(this.provider.blockIdByHeight(blockNumber.intValueExact())).map(hex -> new Hash(BytesUtils.fromHexString(hex))).orElse(Hash.ZERO);
        }
    }
}

