/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.account.abi.ABIUtil;
import io.horizen.account.state.BaseAccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.CertificateKeyRotationMsgProcessor$;
import io.horizen.account.state.CertificateKeysProvider;
import io.horizen.account.state.ExecutionFailedException;
import io.horizen.account.state.ExecutionRevertedException;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.KeyRotationHistory;
import io.horizen.account.state.KeyRotationHistorySerializer$;
import io.horizen.account.state.Message;
import io.horizen.account.state.NativeSmartContractMsgProcessor;
import io.horizen.account.state.SubmitKeyRotationCmdInput;
import io.horizen.account.state.SubmitKeyRotationCmdInputDecoder$;
import io.horizen.account.state.events.SubmitKeyRotation;
import io.horizen.account.state.events.SubmitKeyRotation$;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofSerializer$;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes$;
import io.horizen.cryptolibprovider.CryptoLibProvider$;
import io.horizen.evm.Address;
import io.horizen.params.NetworkParams;
import io.horizen.proof.SchnorrProof;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.proposition.SchnorrPropositionSerializer;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.crypto.hash.Keccak256$;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001\u0002\u00192\u0001jB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t%\u0002\u0011\t\u0012)A\u0005\u001b\")1\u000b\u0001C\u0001)\"9q\u000b\u0001b\u0001\n\u0003B\u0006BB0\u0001A\u0003%\u0011\fC\u0004a\u0001\t\u0007I\u0011I1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u0015I\u0007\u0001\"\u0011k\u0011!\ty\u0001\u0001C!k\u0005E\u0001bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011!\tI\u0006\u0001C!k\u0005m\u0003\u0002CAL\u0001\u0011\u0005Q'!'\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDqAa\u0002\u0001\t\u0013\u0011I\u0001C\u0004\u0003\u0012\u0001!IAa\u0005\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!q\u0004\u0001\u0005\n\t\u0005\u0002b\u0002B\u0016\u0001\u0011%!Q\u0006\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fA\u0011B!\u0012\u0001\u0003\u0003%\tAa\u0012\t\u0013\t-\u0003!%A\u0005\u0002\t5\u0003\"\u0003B2\u0001\u0005\u0005I\u0011\tB3\u0011%\u00119\bAA\u0001\n\u0003\u0011I\bC\u0005\u0003|\u0001\t\t\u0011\"\u0001\u0003~!I!\u0011\u0012\u0001\u0002\u0002\u0013\u0005#1\u0012\u0005\n\u00053\u0003\u0011\u0011!C\u0001\u00057C\u0011B!*\u0001\u0003\u0003%\tEa*\t\u0013\t%\u0006!!A\u0005B\t-\u0006\"\u0003BW\u0001\u0005\u0005I\u0011\tBX\u000f\u001d\u0011\u0019,\rE\u0001\u0005k3a\u0001M\u0019\t\u0002\t]\u0006BB*&\t\u0003\u0011y\f\u0003\u0005\u0003B\u0016\u0012\r\u0011\"\u0001Y\u0011\u001d\u0011\u0019-\nQ\u0001\neC\u0011B!2&\u0005\u0004%\tAa2\t\u0011\t=X\u0005)A\u0005\u0005\u0013D\u0011B!=&\u0005\u0004%\tAa=\t\u0011\r\rQ\u0005)A\u0005\u0005kD\u0011b!\u0002&\u0003\u0003%\tia\u0002\t\u0013\r-Q%!A\u0005\u0002\u000e5\u0001\"CB\u000bK\u0005\u0005I\u0011BB\f\u0005\t\u001aUM\u001d;jM&\u001c\u0017\r^3LKf\u0014v\u000e^1uS>tWj]4Qe>\u001cWm]:pe*\u0011!gM\u0001\u0006gR\fG/\u001a\u0006\u0003iU\nq!Y2d_VtGO\u0003\u00027o\u00059\u0001n\u001c:ju\u0016t'\"\u0001\u001d\u0002\u0005%|7\u0001A\n\u0006\u0001mz$\t\u0013\t\u0003yuj\u0011!M\u0005\u0003}E\u0012qDT1uSZ,7+\\1si\u000e{g\u000e\u001e:bGRl5o\u001a)s_\u000e,7o]8s!\ta\u0004)\u0003\u0002Bc\t92)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L8\u000f\u0015:pm&$WM\u001d\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0002\u000b\u0006)1oY1mC&\u0011q\t\u0012\u0002\b!J|G-^2u!\t\u0019\u0015*\u0003\u0002K\t\na1+\u001a:jC2L'0\u00192mK\u00061\u0001/\u0019:b[N,\u0012!\u0014\t\u0003\u001dBk\u0011a\u0014\u0006\u0003\u0017VJ!!U(\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\na\u0001P5oSRtDCA+W!\ta\u0004\u0001C\u0003L\u0007\u0001\u0007Q*A\bd_:$(/Y2u\u0003\u0012$'/Z:t+\u0005I\u0006C\u0001.^\u001b\u0005Y&B\u0001/6\u0003\r)g/\\\u0005\u0003=n\u0013q!\u00113ee\u0016\u001c8/\u0001\td_:$(/Y2u\u0003\u0012$'/Z:tA\u0005a1m\u001c8ue\u0006\u001cGoQ8eKV\t!\rE\u0002DG\u0016L!\u0001\u001a#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\r3\u0017BA4E\u0005\u0011\u0011\u0015\u0010^3\u0002\u001b\r|g\u000e\u001e:bGR\u001cu\u000eZ3!\u0003\u001d\u0001(o\\2fgN$RAY6qkjDQ\u0001\u001c\u0005A\u00025\f1!\\:h!\tad.\u0003\u0002pc\t9Q*Z:tC\u001e,\u0007\"B9\t\u0001\u0004\u0011\u0018\u0001\u0002<jK^\u0004\"\u0001P:\n\u0005Q\f$\u0001\u0006\"bg\u0016\f5mY8v]R\u001cF/\u0019;f-&,w\u000fC\u0003w\u0011\u0001\u0007q/A\u0002hCN\u0004\"\u0001\u0010=\n\u0005e\f$aB$bgB{w\u000e\u001c\u0005\u0006w\"\u0001\r\u0001`\u0001\rE2|7m[\"p]R,\u0007\u0010\u001e\t\u0003yuL!A`\u0019\u0003\u0019\tcwnY6D_:$X\r\u001f;)\u000b!\t\t!!\u0004\u0011\u000b\r\u000b\u0019!a\u0002\n\u0007\u0005\u0015AI\u0001\u0004uQJ|wo\u001d\t\u0004y\u0005%\u0011bAA\u0006c\tAR\t_3dkRLwN\u001c$bS2,G-\u0012=dKB$\u0018n\u001c8$\u0005\u0005\u001d\u0011!E4fi\u000e+'\u000f^5gS\u0016\u00148oS3zgR1\u00111CA\u0012\u0003[\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003lKf\u001c(bAA\u000fk\u0005!2-\u001a:uS\u001aL7-\u0019;fgV\u0014W.\u001b;uKJLA!!\t\u0002\u0018\tq1)\u001a:uS\u001aLWM]:LKf\u001c\bbBA\u0013\u0013\u0001\u0007\u0011qE\u0001\tKB|7\r\u001b(v[B\u00191)!\u000b\n\u0007\u0005-BIA\u0002J]RDQ!]\u0005A\u0002I\f!cZ3u\u0019\u0006$Xm\u001d;NCN$XM]&fsRQ\u00111GA \u0003\u0003\n)%!\u0013\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f6\u0003-\u0001(o\u001c9pg&$\u0018n\u001c8\n\t\u0005u\u0012q\u0007\u0002\u0013'\u000eDgn\u001c:s!J|\u0007o\\:ji&|g\u000eC\u0003r\u0015\u0001\u0007!\u000fC\u0004\u0002D)\u0001\r!a\r\u0002\u0013\r|gNZ5h\u0017\u0016L\bbBA$\u0015\u0001\u0007\u0011qE\u0001\u000fe\u0016\fX/Z:uK\u0012,\u0005o\\2i\u0011\u001d\tYE\u0003a\u0001\u0003O\tQ!\u001b8eKb\f1cZ3u\u0019\u0006$Xm\u001d;TS\u001et\u0017N\\4LKf$\"\"a\r\u0002R\u0005M\u0013QKA,\u0011\u0015\t8\u00021\u0001s\u0011\u001d\t\u0019e\u0003a\u0001\u0003gAq!a\u0012\f\u0001\u0004\t9\u0003C\u0004\u0002L-\u0001\r!a\n\u0002'\u001d,GoS3z%>$\u0018\r^5p]B\u0013xn\u001c4\u0015\u0015\u0005u\u0013\u0011NA6\u0003[\n)\nE\u0003D\u0003?\n\u0019'C\u0002\u0002b\u0011\u0013aa\u00149uS>t\u0007\u0003BA\u000b\u0003KJA!a\u001a\u0002\u0018\t\u00012*Z=S_R\fG/[8o!J|wN\u001a\u0005\b\u0003Ka\u0001\u0019AA\u0014\u0011\u001d\tY\u0005\u0004a\u0001\u0003OAq!a\u001c\r\u0001\u0004\t\t(A\u0004lKf$\u0016\u0010]3\u0011\t\u0005M\u0014q\u0012\b\u0005\u0003k\nYI\u0004\u0003\u0002x\u0005%e\u0002BA=\u0003\u000fsA!a\u001f\u0002\u0006:!\u0011QPAB\u001b\t\tyHC\u0002\u0002\u0002f\na\u0001\u0010:p_Rt\u0014\"\u0001\u001d\n\u0005Y:\u0014bAA\u000fk%!\u0011\u0011DA\u000e\u0013\u0011\ti)a\u0006\u0002+-+\u0017PU8uCRLwN\u001c)s_>4G+\u001f9fg&!\u0011\u0011SAJ\u0005QYU-\u001f*pi\u0006$\u0018n\u001c8Qe>|g\rV=qK*!\u0011QRA\f\u0011\u0015\tH\u00021\u0001s\u0003Y9W\r^&fsN\u0014v\u000e^1uS>t\u0007*[:u_JLH\u0003CAN\u0003C\u000b\u0019+!*\u0011\u0007q\ni*C\u0002\u0002 F\u0012!cS3z%>$\u0018\r^5p]\"K7\u000f^8ss\"9\u0011qN\u0007A\u0002\u0005E\u0004bBA&\u001b\u0001\u0007\u0011q\u0005\u0005\u0006c6\u0001\rA]\u0001\u0016aV$8*Z=S_R\fG/[8o\u0011&\u001cHo\u001c:z))\tY+!-\u00024\u0006U\u0016q\u0017\t\u0004\u0007\u00065\u0016bAAX\t\n!QK\\5u\u0011\u001d\tyG\u0004a\u0001\u0003cBq!a\u0013\u000f\u0001\u0004\t9\u0003C\u0003r\u001d\u0001\u0007!\u000fC\u0004\u0002::\u0001\r!a'\u0002\u000f!L7\u000f^8ss\u0006\u0019\u0002/\u001e;LKf\u0014v\u000e^1uS>t\u0007K]8pMRA\u00111VA`\u0003\u0003\f\u0019\rC\u0004\u0002&=\u0001\r!a\n\t\u000bE|\u0001\u0019\u0001:\t\u000f\u0005\u0015w\u00021\u0001\u0002d\u0005\u00012.Z=S_R\fG/[8o!J|wNZ\u0001\u000eO\u0016$8+[4oS:<7*Z=\u0015\u0011\u0005-\u0017QZAi\u0003'\u0004RaQA0\u0003gAq!a4\u0011\u0001\u0004\t9#A\u0006fa>\u001c\u0007NT;nE\u0016\u0014\bbBA&!\u0001\u0007\u0011q\u0005\u0005\u0006cB\u0001\rA]\u0001\rO\u0016$X*Y:uKJ\\U-\u001f\u000b\t\u0003\u0017\fI.a7\u0002^\"9\u0011qZ\tA\u0002\u0005\u001d\u0002bBA&#\u0001\u0007\u0011q\u0005\u0005\u0006cF\u0001\rA]\u0001\u001eG\",7m[&fsJ{G/\u0019;j_:\u0004&o\\8g-\u0006d\u0017\u000eZ5usRQ\u00111]Ax\u0003c\u0014\tA!\u0002\u0011\r\u0005\u0015\u00181^AV\u001b\t\t9OC\u0002\u0002j\u0012\u000bA!\u001e;jY&!\u0011Q^At\u0005\r!&/\u001f\u0005\b\u0003\u000b\u0014\u0002\u0019AA2\u0011\u001d\t\u0019P\u0005a\u0001\u0003k\fqB\\3x\u0017\u0016L8+[4oCR,(/\u001a\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111`\u001b\u0002\u000bA\u0014xn\u001c4\n\t\u0005}\u0018\u0011 \u0002\r'\u000eDgn\u001c:s!J|wN\u001a\u0005\b\u0005\u0007\u0011\u0002\u0019AA\u0014\u0003=\u0019WO\u001d:f]R,\u0005o\\2i\u001dVl\u0007\"B9\u0013\u0001\u0004\u0011\u0018!F3yK\u000e\u001cVOY7ji.+\u0017PU8uCRLwN\u001c\u000b\bE\n-!Q\u0002B\b\u0011\u0015a7\u00031\u0001n\u0011\u0015\t8\u00031\u0001s\u0011\u001d\u0011\u0019a\u0005a\u0001\u0003O\tAc\u00195fG.lUm]:bO\u00164\u0016\r\\5eSRLH\u0003BAV\u0005+AQ\u0001\u001c\u000bA\u00025\fAbY1mGVd\u0017\r^3LKf$2A\u0019B\u000e\u0011\u0019\u0011i\"\u0006a\u0001E\u000691.Z=TK\u0016$\u0017AF4fi.+\u0017PU8uCRLwN\u001c)s_>47*Z=\u0015\u000f\t\u0014\u0019C!\n\u0003*!9\u0011q\u000e\fA\u0002\u0005E\u0004b\u0002B\u0014-\u0001\u0007\u0011qE\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQ\"9\u00111\n\fA\u0002\u0005\u001d\u0012\u0001E4fiNKwM\\5oO.+\u0017pS3z)\u0015\u0011'q\u0006B\u001a\u0011\u001d\u0011\td\u0006a\u0001\u0003O\tQ!\u001a9pG\"Dq!a\u0013\u0018\u0001\u0004\t9#A\bhKRl\u0015m\u001d;fe.+\u0017pS3z)\u0015\u0011'\u0011\bB\u001e\u0011\u001d\u0011\t\u0004\u0007a\u0001\u0003OAq!a\u0013\u0019\u0001\u0004\t9#A\rhKR\\U-_:S_R\fG/[8o\u0011&\u001cHo\u001c:z\u0017\u0016LH#\u00022\u0003B\t\r\u0003bBA83\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003\u0017J\u0002\u0019AA\u0014\u0003\u0011\u0019w\u000e]=\u0015\u0007U\u0013I\u0005C\u0004L5A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\n\u0016\u0004\u001b\nE3F\u0001B*!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tuC)\u0001\u0006b]:|G/\u0019;j_:LAA!\u0019\u0003X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0007\u0005\u0003\u0003j\tMTB\u0001B6\u0015\u0011\u0011iGa\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0005c\nAA[1wC&!!Q\u000fB6\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qE\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yH!\"\u0011\u0007\r\u0013\t)C\u0002\u0003\u0004\u0012\u00131!\u00118z\u0011%\u00119IHA\u0001\u0002\u0004\t9#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u001b\u0003bAa$\u0003\u0016\n}TB\u0001BI\u0015\r\u0011\u0019\nR\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BL\u0005#\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!Q\u0014BR!\r\u0019%qT\u0005\u0004\u0005C#%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u000f\u0003\u0013\u0011!a\u0001\u0005\u007f\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005O\na!Z9vC2\u001cH\u0003\u0002BO\u0005cC\u0011Ba\"$\u0003\u0003\u0005\rAa \u0002E\r+'\u000f^5gS\u000e\fG/Z&fsJ{G/\u0019;j_:l5o\u001a)s_\u000e,7o]8s!\taTe\u0005\u0003&\u0005sC\u0005cA\"\u0003<&\u0019!Q\u0018#\u0003\r\u0005s\u0017PU3g)\t\u0011),A\u0013DKJ$\u0018NZ5dCR,7*Z=S_R\fG/[8o\u0007>tGO]1di\u0006#GM]3tg\u000613)\u001a:uS\u001aL7-\u0019;f\u0017\u0016L(k\u001c;bi&|gnQ8oiJ\f7\r^!eIJ,7o\u001d\u0011\u0002E\r+'\u000f^5gS\u000e\fG/Z&fsJ{G/\u0019;j_:\u001cuN\u001c;sC\u000e$8i\u001c3f+\t\u0011I\r\u0005\u0003\u0003L\n%h\u0002\u0002Bg\u0005GtAAa4\u0003^:!!\u0011\u001bBl\u001d\u0011\tiHa5\n\u0005\tU\u0017AB:qCJ\\'0\u0003\u0003\u0003Z\nm\u0017AB2ssB$xN\u0003\u0002\u0003V&!!q\u001cBq\u0003\u0011A\u0017m\u001d5\u000b\t\te'1\\\u0005\u0005\u0005K\u00149/A\u0004qC\u000e\\\u0017mZ3\u000b\t\t}'\u0011]\u0005\u0005\u0005W\u0014iO\u0001\u0005ES\u001e,7\u000f^\u001a3\u0015\u0011\u0011)Oa:\u0002G\r+'\u000f^5gS\u000e\fG/Z&fsJ{G/\u0019;j_:\u001cuN\u001c;sC\u000e$8i\u001c3fA\u0005Q2+\u001e2nSR\\U-\u001f*pi\u0006$\u0018n\u001c8SKF\u001cU\u000eZ*jOV\u0011!Q\u001f\t\u0005\u0005o\u0014yP\u0004\u0003\u0003z\nm\bcAA?\t&\u0019!Q #\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011)h!\u0001\u000b\u0007\tuH)A\u000eTk\nl\u0017\u000e^&fsJ{G/\u0019;j_:\u0014V-]\"nINKw\rI\u0001\u0006CB\u0004H.\u001f\u000b\u0004+\u000e%\u0001\"B&.\u0001\u0004i\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0007\u001f\u0019\t\u0002\u0005\u0003D\u0003?j\u0005\u0002CB\n]\u0005\u0005\t\u0019A+\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\r!\u0011\u0011Iga\u0007\n\t\ru!1\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class CertificateKeyRotationMsgProcessor
extends NativeSmartContractMsgProcessor
implements CertificateKeysProvider,
Product,
scala.Serializable {
    private final NetworkParams params;
    private final Address contractAddress;
    private final byte[] contractCode;

    public static Option<NetworkParams> unapply(CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.unapply(certificateKeyRotationMsgProcessor);
    }

    public static CertificateKeyRotationMsgProcessor apply(NetworkParams networkParams) {
        return CertificateKeyRotationMsgProcessor$.MODULE$.apply(networkParams);
    }

    public static String SubmitKeyRotationReqCmdSig() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
    }

    public static byte[] CertificateKeyRotationContractCode() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }

    public static Address CertificateKeyRotationContractAddress() {
        return CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
    }

    public NetworkParams params() {
        return this.params;
    }

    @Override
    public Address contractAddress() {
        return this.contractAddress;
    }

    @Override
    public byte[] contractCode() {
        return this.contractCode;
    }

    @Override
    public byte[] process(Message msg, BaseAccountStateView view, GasPool gas, BlockContext blockContext) throws ExecutionFailedException {
        BaseAccountStateView gasView = view.getGasTrackedView(gas);
        String string = ABIUtil.getFunctionSignature(msg.getData());
        String string2 = CertificateKeyRotationMsgProcessor$.MODULE$.SubmitKeyRotationReqCmdSig();
        String string3 = string;
        if (string2 != null ? !string2.equals(string3) : string3 != null) {
            throw new ExecutionRevertedException(new StringBuilder(55).append("Requested function does not exist. Function signature: ").append(string).toString());
        }
        byte[] byArray = this.execSubmitKeyRotation(msg, gasView, blockContext.withdrawalEpochNumber);
        return byArray;
    }

    @Override
    public CertifiersKeys getCertifiersKeys(int epochNum, BaseAccountStateView view) {
        Vector singingKeys = ((TraversableOnce)((TraversableLike)this.params().signersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestSigningKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        Vector masterKeys = ((TraversableOnce)((TraversableLike)this.params().mastersPublicKeys().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)key_index -> this.getLatestMasterKey(view, (SchnorrProposition)key_index._1(), epochNum + 1, key_index._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).toVector();
        return new CertifiersKeys((Vector<SchnorrProposition>)singingKeys, (Vector<SchnorrProposition>)masterKeys);
    }

    private SchnorrProposition getLatestMasterKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory masterKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType(), index, view);
        return (SchnorrProposition)masterKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> this.getMasterKey(BoxesRunTime.unboxToInt((Object)x$2), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    private SchnorrProposition getLatestSigningKey(BaseAccountStateView view, SchnorrProposition configKey, int requestedEpoch, int index) {
        KeyRotationHistory signingKeyChangeHistory = this.getKeysRotationHistory(KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType(), index, view);
        return (SchnorrProposition)signingKeyChangeHistory.epochNumbers().find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 < requestedEpoch).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> this.getSigningKey(BoxesRunTime.unboxToInt((Object)x$4), index, view)).getOrElse((Function0 & Serializable & scala.Serializable)() -> configKey);
    }

    @Override
    public Option<KeyRotationProof> getKeyRotationProof(int epochNum, int index, Enumeration.Value keyType, BaseAccountStateView view) {
        byte[] key = this.getKeyRotationProofKey(keyType, epochNum, index);
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), key);
        return maybeData.length > 0 ? new Some(KeyRotationProofSerializer$.MODULE$.parseBytes(maybeData)) : None$.MODULE$;
    }

    public KeyRotationHistory getKeysRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view) {
        byte[] maybeData = view.getAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index));
        return maybeData.length > 0 ? (KeyRotationHistory)KeyRotationHistorySerializer$.MODULE$.parseBytes(maybeData) : new KeyRotationHistory((List<Object>)Nil$.MODULE$);
    }

    private void putKeyRotationHistory(Enumeration.Value keyType, int index, BaseAccountStateView view, KeyRotationHistory history) {
        view.updateAccountStorageBytes(this.contractAddress(), this.getKeysRotationHistoryKey(keyType, index), history.bytes());
    }

    private void putKeyRotationProof(int epochNum, BaseAccountStateView view, KeyRotationProof keyRotationProof) {
        byte[] key = this.getKeyRotationProofKey(keyRotationProof.keyType(), epochNum, keyRotationProof.index());
        view.updateAccountStorageBytes(this.contractAddress(), key, keyRotationProof.bytes());
    }

    private Option<SchnorrProposition> getSigningKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getSigningKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Option<SchnorrProposition> getMasterKey(int epochNumber, int index, BaseAccountStateView view) {
        byte[] bytes = view.getAccountStorageBytes(this.contractAddress(), this.getMasterKeyKey(epochNumber, index));
        return bytes.length > 0 ? new Some(SchnorrPropositionSerializer.getSerializer().parseBytes(bytes)) : None$.MODULE$;
    }

    private Try<BoxedUnit> checkKeyRotationProofValidity(KeyRotationProof keyRotationProof, SchnorrProof newKeySignature, int currentEpochNum, BaseAccountStateView view) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte[] byArray;
            int index = keyRotationProof.index();
            if (index < 0 || index >= this.params().signersPublicKeys().length()) {
                throw new ExecutionRevertedException(new StringBuilder(46).append("Key rotation proof - key index out for range: ").append(index).toString());
            }
            SchnorrProposition signingKeyFromConfig = (SchnorrProposition)this.params().signersPublicKeys().apply(index);
            SchnorrProposition masterKeyFromConfig = (SchnorrProposition)this.params().mastersPublicKeys().apply(index);
            Enumeration.Value value = keyRotationProof.keyType();
            Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForSigningKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
            } else {
                Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    byArray = CryptoLibProvider$.MODULE$.thresholdSignatureCircuitWithKeyRotation().getMsgToSignForMasterKeyUpdate(keyRotationProof.newKey().pubKeyBytes(), currentEpochNum, this.params().sidechainId());
                } else {
                    throw new MatchError((Object)value);
                }
            }
            byte[] newKeyAsMessage = byArray;
            SchnorrProposition latestSigningKey = this.getLatestSigningKey(view, signingKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.signingKeySignature().isValid(latestSigningKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(51).append("Key rotation proof - signing signature is invalid: ").append(index).toString());
            }
            SchnorrProposition latestMasterKey = this.getLatestMasterKey(view, masterKeyFromConfig, currentEpochNum, index);
            if (!keyRotationProof.masterKeySignature().isValid(latestMasterKey, newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(50).append("Key rotation proof - master signature is invalid: ").append(index).toString());
            }
            if (!newKeySignature.isValid(keyRotationProof.newKey(), newKeyAsMessage)) {
                throw new ExecutionRevertedException(new StringBuilder(48).append("Key rotation proof - self signature is invalid: ").append(index).toString());
            }
        });
    }

    private byte[] execSubmitKeyRotation(Message msg, BaseAccountStateView view, int currentEpochNum) {
        byte[] byArray;
        this.checkMessageValidity(msg);
        SubmitKeyRotationCmdInput inputData = (SubmitKeyRotationCmdInput)SubmitKeyRotationCmdInputDecoder$.MODULE$.decode(ABIUtil.getArgumentsFromData(msg.getData()));
        KeyRotationProof keyRotationProof = inputData.keyRotationProof();
        int keyIndex = keyRotationProof.index();
        Enumeration.Value keyType = keyRotationProof.keyType();
        Try<BoxedUnit> try_ = this.checkKeyRotationProofValidity(keyRotationProof, inputData.newKeySignature(), currentEpochNum, view);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new ExecutionRevertedException(new StringBuilder(31).append("Key Rotation Proof is invalid: ").append(ex.getMessage()).toString());
            }
            throw new MatchError(try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        this.putKeyRotationProof(currentEpochNum, view, keyRotationProof);
        Enumeration.Value value = keyType;
        Enumeration.Value value2 = KeyRotationProofTypes$.MODULE$.SigningKeyRotationProofType();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            byArray = this.getSigningKeyKey(currentEpochNum, keyIndex);
        } else {
            Enumeration.Value value4 = KeyRotationProofTypes$.MODULE$.MasterKeyRotationProofType();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                byArray = this.getMasterKeyKey(currentEpochNum, keyIndex);
            } else {
                throw new MatchError((Object)value);
            }
        }
        byte[] storageKey = byArray;
        view.updateAccountStorageBytes(this.contractAddress(), storageKey, keyRotationProof.newKey().bytes());
        KeyRotationHistory history = this.getKeysRotationHistory(keyType, keyIndex, view);
        if (!history.epochNumbers().headOption().exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> ((Object)BoxesRunTime.boxToInteger((int)x$5)).equals(BoxesRunTime.boxToInteger((int)currentEpochNum)))) {
            int n = currentEpochNum;
            this.putKeyRotationHistory(keyType, keyIndex, view, new KeyRotationHistory((List<Object>)history.epochNumbers().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))));
        }
        SubmitKeyRotation keyRotationEvent = SubmitKeyRotation$.MODULE$.apply(keyType, keyIndex, keyRotationProof.newKey(), currentEpochNum);
        EthereumConsensusDataLog evmLog = this.getEthereumConsensusDataLog(keyRotationEvent);
        view.addLog(evmLog);
        return keyRotationProof.encode();
    }

    private void checkMessageValidity(Message msg) {
        BigInteger msgValue = msg.getValue();
        if (msg.getData().length != 4 + SubmitKeyRotationCmdInputDecoder$.MODULE$.getABIDataParamsLengthInBytes()) {
            throw new ExecutionRevertedException(new StringBuilder(33).append("Wrong message data field length: ").append(msg.getData().length).toString());
        }
        if (msgValue.signum() != 0) {
            throw new ExecutionRevertedException(new StringBuilder(45).append("SubmitKeyRotation message value is non-zero: ").append(msg).toString());
        }
    }

    private byte[] calculateKey(byte[] keySeed) {
        return Keccak256$.MODULE$.hash(keySeed);
    }

    private byte[] getKeyRotationProofKey(Enumeration.Value keyType, int withdrawalEpoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyRotationProof".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getSigningKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"signingKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getMasterKeyKey(int epoch, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"masterKey".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)epoch), Ints.toByteArray((int)index)}));
    }

    private byte[] getKeysRotationHistoryKey(Enumeration.Value keyType, int index) {
        return this.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyHistory".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)keyType.id()), Ints.toByteArray((int)index)}));
    }

    public CertificateKeyRotationMsgProcessor copy(NetworkParams params) {
        return new CertificateKeyRotationMsgProcessor(params);
    }

    public NetworkParams copy$default$1() {
        return this.params();
    }

    public String productPrefix() {
        return "CertificateKeyRotationMsgProcessor";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.params();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CertificateKeyRotationMsgProcessor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CertificateKeyRotationMsgProcessor)) return false;
        boolean bl = true;
        if (!bl) return false;
        CertificateKeyRotationMsgProcessor certificateKeyRotationMsgProcessor = (CertificateKeyRotationMsgProcessor)x$1;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = certificateKeyRotationMsgProcessor.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        if (!certificateKeyRotationMsgProcessor.canEqual(this)) return false;
        return true;
    }

    public CertificateKeyRotationMsgProcessor(NetworkParams params) {
        this.params = params;
        Product.$init$((Product)this);
        this.contractAddress = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractAddress();
        this.contractCode = CertificateKeyRotationMsgProcessor$.MODULE$.CertificateKeyRotationContractCode();
    }
}

