/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.state;

import com.horizen.certnative.BackwardTransfer;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.history.validation.InvalidTransactionChainIdException;
import io.horizen.account.history.validation.InvalidTransactionChainIdException$;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.AccountForgingStakeInfo;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.ForgerStakeData;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.McAddrOwnershipData;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.OwnerScAddress;
import io.horizen.account.state.SenderNotEoaException;
import io.horizen.account.state.StateDbAccountStateView;
import io.horizen.account.state.WithdrawalRequest;
import io.horizen.account.state.receipt.EthereumConsensusDataLog;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.utils.Secp256k1;
import io.horizen.block.MainchainBackwardTransferCertificateOutput;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.evm.Address;
import io.horizen.evm.Database;
import io.horizen.evm.Hash;
import io.horizen.evm.ResourceHandle;
import io.horizen.evm.StateDB;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.state.State;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.package$;
import sparkz.core.transaction.Transaction;
import sparkz.core.transaction.state.TransactionValidation;
import sparkz.core.utils.NetworkTimeProvider;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005e\u0001B\"E\u00015C!\"a\n\u0001\u0005\u000b\u0007I\u0011AA\u0015\u0011)\t)\u0004\u0001B\u0001B\u0003%\u00111\u0006\u0005\u000b\u0003o\u0001!\u0011!Q\u0001\n\u0005e\u0002BCA\"\u0001\t\u0005\t\u0015!\u0003\u0002F!Q\u00111\n\u0001\u0003\u0006\u0004%\t%!\u0014\t\u0015\u0005-\u0004A!A!\u0002\u0013\ty\u0005\u0003\u0006\u0002n\u0001\u0011\t\u0011)A\u0005\u0003_B!\"a\u001f\u0001\u0005\u0003\u0005\u000b\u0011BA?\u0011)\tI\t\u0001B\u0001B\u0003%\u00111\u0012\u0005\b\u0003K\u0003A\u0011AAT\u000b\u0015\t9\f\u0001\u0011n\u0011\u001d\tI\f\u0001C\u0005\u0003wCq!a3\u0001\t\u0003\ni\rC\u0004\u0002T\u0002!I!!6\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005;\u0001A\u0011\tB\u0010\u0011\u001d\u00119\u0003\u0001C!\u0005SAqAa\u000b\u0001\t\u0003\u0011i\u0003C\u0004\u0003F\u0001!\tEa\u0012\t\u000f\tU\u0003\u0001\"\u0011\u0003X!9!q\u000e\u0001\u0005B\tE\u0004b\u0002BJ\u0001\u0011\u0005#Q\u0013\u0005\b\u0005C\u0003A\u0011\tBR\u0011\u001d\u00119\u000b\u0001C!\u0005SCqA!0\u0001\t\u0003\u0012y\fC\u0004\u0003H\u0002!\tE!3\t\u000f\t5\u0007\u0001\"\u0011\u0003P\"9!\u0011\u001b\u0001\u0005B\tM\u0007\"\u0003Bx\u0001E\u0005I\u0011\u0001By\u0011\u001d\u00199\u0001\u0001C!\u0007\u0013Aqaa\u0003\u0001\t\u0003\u001ai\u0001C\u0004\u0004.\u0001!\tea\f\t\u000f\rm\u0002\u0001\"\u0011\u0004>!911\n\u0001\u0005B\r5\u0003bBB5\u0001\u0011\u000531\u000e\u0005\b\u0007[\u0002A\u0011IB8\u0011\u001d\u0019\u0019\b\u0001C!\u0007kBqa!\u001f\u0001\t\u0003\u001aY\bC\u0004\u0004\u0006\u0002!\tea\"\t\u000f\r-\u0005\u0001\"\u0011\u0004\u000e\"911\u0016\u0001\u0005B\r5\u0006\"CB_\u0001E\u0005I\u0011AB`\u0011\u001d\u0019\u0019\r\u0001C!\u0007\u000bDqaa4\u0001\t\u0003\u001a\t\u000eC\u0004\u0004X\u0002!\te!7\t\u000f\r5\b\u0001\"\u0011\u0004l!91q\u001e\u0001\u0005B\rE\bbBB{\u0001\u0011\u00053q\u001f\u0005\b\u0007s\u0004A\u0011IB~\u0011\u001d!9\u0001\u0001C!\t\u0013Aq\u0001\"\u0005\u0001\t\u0003\"\u0019\u0002C\u0004\u0005\u001c\u0001!\t\u0005\"\b\t\u000f\u0011\r\u0002\u0001\"\u0011\u0005&!9A\u0011\u0006\u0001\u0005B\u0011-\u0002b\u0002C\u0018\u0001\u0011\u0005C\u0011\u0007\u0005\b\tk\u0001A\u0011\tC\u001c\u0011\u001d!y\u0004\u0001C!\t\u0003Bq\u0001b\u0011\u0001\t\u0003\"\t\u0005C\u0004\u0005F\u0001!\t\u0005b\u0012\b\u000f\u00115C\t#\u0001\u0005P\u001911\t\u0012E\u0001\t#Bq!!*@\t\u0003!I\u0006\u0003\u0005\u0005\\}\"\t\u0001\u0013C/\u0011!!ig\u0010C\u0001\u0011\u0012=$\u0001D!dG>,h\u000e^*uCR,'BA#G\u0003\u0015\u0019H/\u0019;f\u0015\t9\u0005*A\u0004bG\u000e|WO\u001c;\u000b\u0005%S\u0015a\u00025pe&TXM\u001c\u0006\u0002\u0017\u0006\u0011\u0011n\\\u0002\u0001')\u0001aj\\<\u0002\u0004\u0005=\u00111\u0004\t\u0007\u001fB\u0013FM[7\u000e\u0003!K!!\u0015%\u0003\u001b\u0005\u00137\u000f\u001e:bGR\u001cF/\u0019;f!\u0011\u0019f\u000b\u00170\u000e\u0003QS!!\u0016$\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003/R\u0013!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B\u0011\u0011\fX\u0007\u00025*\u00111\fS\u0001\faJ|\u0007o\\:ji&|g.\u0003\u0002^5\nY\u0001K]8q_NLG/[8o!\ry&\rW\u0007\u0002A*\u0011\u0011\rS\u0001\u0006aJ|wNZ\u0005\u0003G\u0002\u0014Q\u0001\u0015:p_\u001a\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a$\u0002\u000b\tdwnY6\n\u0005%4'AE!dG>,h\u000e\u001e\"m_\u000e\\\u0007*Z1eKJ\u0004\"!Z6\n\u000514'\u0001D!dG>,h\u000e\u001e\"m_\u000e\\\u0007C\u00018\u0001\u001b\u0005!\u0005C\u00029s%*$X.D\u0001r\u0015\t)\u0005*\u0003\u0002tc\n)1\u000b^1uKB\u0011a.^\u0005\u0003m\u0012\u0013\u0001#Q2d_VtGo\u0015;bi\u00164\u0016.Z<\u0011\u0007a|(+D\u0001z\u0015\t)%P\u0003\u0002Vw*\u0011A0`\u0001\u0005G>\u0014XMC\u0001\u007f\u0003\u0019\u0019\b/\u0019:lu&\u0019\u0011\u0011A=\u0003+Q\u0013\u0018M\\:bGRLwN\u001c,bY&$\u0017\r^5p]B!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0019\u000bAA\\8eK&!\u0011QBA\u0004\u0005Aqu\u000eZ3BG\u000e|WO\u001c;Ti\u0006$X\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\u0002S\u0001\u0006kRLGn]\u0005\u0005\u00033\t\u0019BA\fDY>\u001c\u0018M\u00197f%\u0016\u001cx.\u001e:dK\"\u000bg\u000e\u001a7feB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"u\fA!\u001e;jY&!\u0011QEA\u0010\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u00061\u0001/\u0019:b[N,\"!a\u000b\u0011\t\u00055\u0012\u0011G\u0007\u0003\u0003_Q1!a\nI\u0013\u0011\t\u0019$a\f\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\nA\u0002^5nKB\u0013xN^5eKJ\u0004B!a\u000f\u0002@5\u0011\u0011Q\b\u0006\u0004\u0003+Y\u0018\u0002BA!\u0003{\u00111CT3uo>\u00148\u000eV5nKB\u0013xN^5eKJ\f\u0011C\u00197pG.D\u0015m\u001d5Qe>4\u0018\u000eZ3s!\rq\u0017qI\u0005\u0004\u0003\u0013\"%\u0001\u0007%jgR|'/\u001f\"m_\u000e\\\u0007*Y:i!J|g/\u001b3fe\u00069a/\u001a:tS>tWCAA(!\u0011\t\t&!\u001a\u000f\t\u0005M\u0013\u0011\r\b\u0005\u0003+\nyF\u0004\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006T\u0001\u0007yI|w\u000e\u001e \n\u0003yL!\u0001`?\n\u0007\u0005\r40A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u000b-\u0016\u00148/[8o)\u0006<'bAA2w\u0006Aa/\u001a:tS>t\u0007%\u0001\u000bti\u0006$X-T3uC\u0012\fG/Y*u_J\fw-\u001a\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f$\u0002\u000fM$xN]1hK&!\u0011\u0011PA:\u0005m\t5mY8v]R\u001cF/\u0019;f\u001b\u0016$\u0018\rZ1uCN#xN]1hK\u0006q1\u000f^1uK\u0012\u00137\u000b^8sC\u001e,\u0007\u0003BA@\u0003\u000bk!!!!\u000b\u0007\u0005\r\u0005*A\u0002fm6LA!a\"\u0002\u0002\nAA)\u0019;bE\u0006\u001cX-A\tnKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004b!!$\u0002\u001a\u0006}e\u0002BAH\u0003+sA!a\u0016\u0002\u0012&\u0011\u00111S\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003G\n9J\u0003\u0002\u0002\u0014&!\u00111TAO\u0005\r\u0019V-\u001d\u0006\u0005\u0003G\n9\nE\u0002o\u0003CK1!a)E\u0005AiUm]:bO\u0016\u0004&o\\2fgN|'/\u0001\u0004=S:LGO\u0010\u000b\u0010[\u0006%\u00161VAW\u0003_\u000b\t,a-\u00026\"9\u0011q\u0005\u0006A\u0002\u0005-\u0002bBA\u001c\u0015\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u0007R\u0001\u0019AA#\u0011\u001d\tYE\u0003a\u0001\u0003\u001fBq!!\u001c\u000b\u0001\u0004\ty\u0007C\u0004\u0002|)\u0001\r!! \t\u000f\u0005%%\u00021\u0001\u0002\f\n!aJV\"U\u00039Ig.\u001b;Qe>\u001cWm]:peN$B!!0\u0002HB)\u0011qXAb[6\u0011\u0011\u0011\u0019\u0006\u0005\u0003C\t9*\u0003\u0003\u0002F\u0006\u0005'a\u0001+ss\"9\u0011\u0011\u001a\u0007A\u0002\u0005=\u0013AD5oSRL\u0017\r\u001c,feNLwN\\\u0001\u000eCB\u0004H._'pI&4\u0017.\u001a:\u0015\t\u0005u\u0016q\u001a\u0005\u0007\u0003#l\u0001\u0019\u00016\u0002\u00075|G-A\tfm\u0006dgi\u001c:hKJ\u001c(+Z<be\u0012$\u0002\"a6\u0002`\u0006\u0005\u00181\u001e\t\u0005\u00033\fY.\u0004\u0002\u0002\u0018&!\u0011Q\\AL\u0005\u0011)f.\u001b;\t\r\u0005Eg\u00021\u0001k\u0011\u001d\t\u0019O\u0004a\u0001\u0003K\fa#\\8e/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\u001c\t\u0005\u0003#\t9/\u0003\u0003\u0002j\u0006M!aE,ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|\u0007BBAw\u001d\u0001\u0007A/A\u0005ti\u0006$XMV5fo\u0006ib/\u00197jI\u0006$X\rV8q#V\fG.\u001b;z\u0007\u0016\u0014H/\u001b4jG\u0006$X\r\u0006\u0004\u0002X\u0006M(\u0011\u0001\u0005\b\u0003k|\u0001\u0019AA|\u0003U!x\u000e])vC2LG/_\"feRLg-[2bi\u0016\u0004B!!?\u0002~6\u0011\u00111 \u0006\u0003O\"KA!a@\u0002|\nQr+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ3si&4\u0017nY1uK\"1\u0011Q^\bA\u0002Q\f\u0011$[:To&$8\r[5oO\u000e{gn]3ogV\u001cX\t]8dQR!!q\u0001B\u0007!\u0011\tIN!\u0003\n\t\t-\u0011q\u0013\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011y\u0001\u0005a\u0001\u0005#\taB\u00197pG.$\u0016.\\3Ti\u0006l\u0007\u000f\u0005\u0003\u0002Z\nM\u0011\u0002\u0002B\u000b\u0003/\u0013A\u0001T8oO\u0006Q!o\u001c7mE\u0006\u001c7\u000eV8\u0015\t\u0005u&1\u0004\u0005\b\u0003\u0017\n\u0002\u0019AA(\u0003Ai\u0017\r\u001f*pY2\u0014\u0017mY6EKB$\b.\u0006\u0002\u0003\"A!\u0011\u0011\u001cB\u0012\u0013\u0011\u0011)#a&\u0003\u0007%sG/A\u0004hKR4\u0016.Z<\u0016\u0003Q\facZ3u'R\fG/\u001a#c-&,wO\u0012:p[J{w\u000e\u001e\u000b\u0005\u0005_\u0011)\u0004E\u0002o\u0005cI1Aa\rE\u0005]\u0019F/\u0019;f\t\n\f5mY8v]R\u001cF/\u0019;f-&,w\u000fC\u0004\u00038Q\u0001\rA!\u000f\u0002\u0013M$\u0018\r^3S_>$\bCBAm\u0005w\u0011y$\u0003\u0003\u0003>\u0005]%!B!se\u0006L\b\u0003BAm\u0005\u0003JAAa\u0011\u0002\u0018\n!!)\u001f;f\u0003U9W\r^,ji\"$'/Y<bYJ+\u0017/^3tiN$BA!\u0013\u0003RA1\u0011QRAM\u0005\u0017\u00022A\u001cB'\u0013\r\u0011y\u0005\u0012\u0002\u0012/&$\b\u000e\u001a:bo\u0006d'+Z9vKN$\bb\u0002B*+\u0001\u0007!\u0011E\u0001\u0010o&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u0006\t\"-Y2lo\u0006\u0014H\r\u0016:b]N4WM]:\u0015\t\te#Q\u000e\t\u0007\u0003\u001b\u000bIJa\u0017\u0011\t\tu#\u0011N\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005Q1-\u001a:u]\u0006$\u0018N^3\u000b\u0007%\u0013)G\u0003\u0002\u0003h\u0005\u00191m\\7\n\t\t-$q\f\u0002\u0011\u0005\u0006\u001c7n^1sIR\u0013\u0018M\\:gKJDqAa\u0015\u0017\u0001\u0004\u0011\t#\u0001\tlKf\u0014v\u000e^1uS>t\u0007K]8pMRA!1\u000fBE\u0005\u0017\u0013y\t\u0005\u0004\u0002Z\nU$\u0011P\u0005\u0005\u0005o\n9J\u0001\u0004PaRLwN\u001c\t\u0005\u0005w\u0012))\u0004\u0002\u0003~)!!q\u0010BA\u0003\u0011YW-_:\u000b\u0007\t\r\u0005*\u0001\u000bdKJ$\u0018NZ5dCR,7/\u001e2nSR$XM]\u0005\u0005\u0005\u000f\u0013iH\u0001\tLKf\u0014v\u000e^1uS>t\u0007K]8pM\"9!1K\fA\u0002\t\u0005\u0002b\u0002BG/\u0001\u0007!\u0011E\u0001\u000eS:$W\r_(g'&<g.\u001a:\t\u000f\tEu\u00031\u0001\u0003\"\u000591.Z=UsB,\u0017AD2feRLg-[3sg.+\u0017p\u001d\u000b\u0005\u0005/\u0013y\n\u0005\u0004\u0002Z\nU$\u0011\u0014\t\u0005\u0005w\u0012Y*\u0003\u0003\u0003\u001e\nu$AD\"feRLg-[3sg.+\u0017p\u001d\u0005\b\u0005'B\u0002\u0019\u0001B\u0011\u0003ya\u0017m\u001d;DKJ$\u0018NZ5dCR,'+\u001a4fe\u0016t7-\u001a3Fa>\u001c\u0007.\u0006\u0002\u0003&B1\u0011\u0011\u001cB;\u0005C\tq\u0004\\1ti\u000e+'\u000f^5gS\u000e\fG/Z*jI\u0016\u001c\u0007.Y5o\u00052|7m[%e)\t\u0011Y\u000b\u0005\u0004\u0002Z\nU$Q\u0016\t\u0005\u0005_\u00139L\u0004\u0003\u00032\nUf\u0002BA+\u0005gK1!!\t~\u0013\u0011\t\u0019'a\b\n\t\te&1\u0018\u0002\u000b\u001b>$\u0017NZ5fe&#'\u0002BA2\u0003?\t1bY3si&4\u0017nY1uKR!!\u0011\u0019Bb!\u0019\tIN!\u001e\u0002x\"9!QY\u000eA\u0002\t\u0005\u0012!\u0007:fM\u0016\u0014XM\\2fI^KG\u000f\u001b3sC^\fG.\u00129pG\"\f\u0001dZ3u)>\u0004\u0018+^1mSRL8)\u001a:uS\u001aL7-\u0019;f)\u0011\u0011\tMa3\t\u000f\t\u0015G\u00041\u0001\u0003\"\u0005I\u0001.Y:DK\u0006\u001cX\r\u001a\u000b\u0003\u0005\u000f\t!cZ3u\r\u0016,\u0007+Y=nK:$8/\u00138g_R1!Q\u001bBq\u0005G\u0004b!!$\u0002\u001a\n]\u0007\u0003\u0002Bm\u0005;l!Aa7\u000b\u0007\u0005Ua)\u0003\u0003\u0003`\nm'AD!dG>,h\u000e\u001e)bs6,g\u000e\u001e\u0005\b\u0005'r\u0002\u0019\u0001B\u0011\u0011%\u0011)O\bI\u0001\u0002\u0004\u00119/\u0001\u000bcY>\u001c7\u000eV8BaB,g\u000e\u001a$fK&sgm\u001c\t\u0007\u00033\u0014)H!;\u0011\t\te'1^\u0005\u0005\u0005[\u0014YNA\nBG\u000e|WO\u001c;CY>\u001c7NR3f\u0013:4w.\u0001\u000fhKR4U-\u001a)bs6,g\u000e^:J]\u001a|G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM(\u0006\u0002Bt\u0005k\\#Aa>\u0011\t\te81A\u0007\u0003\u0005wTAA!@\u0003\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0007\u0003\t9*\u0001\u0006b]:|G/\u0019;j_:LAa!\u0002\u0003|\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\u001d,GoV5uQ\u0012\u0014\u0018m^1m\u000bB|7\r[%oM>,\"!!:\u0002/\u001d,GoQ8og\u0016t7/^:Fa>\u001c\u0007NT;nE\u0016\u0014XCAB\b!\u0019\tIN!\u001e\u0004\u0012A!11CB\u0014\u001d\u0011\u0019)ba\t\u000f\t\r]1q\u0004\b\u0005\u00073\u0019iB\u0004\u0003\u0002X\rm\u0011\"A&\n\u0005%S\u0015bAB\u0011\u0011\u0006I1m\u001c8tK:\u001cXo]\u0005\u0005\u0003G\u001a)CC\u0002\u0004\"!KAa!\u000b\u0004,\t!2i\u001c8tK:\u001cXo]#q_\u000eDg*^7cKJTA!a\u0019\u0004&\u0005qr-\u001a;Pe\u0012,'/\u001a3G_J<\u0017N\\4Ti\u0006\\Wm]%oM>\u001cV-\u001d\u000b\u0003\u0007c\u0001b!!$\u0002\u001a\u000eM\u0002\u0003BB\u001b\u0007oi!a!\n\n\t\re2Q\u0005\u0002\u0011\r>\u0014x-\u001b8h'R\f7.Z%oM>\fAdZ3u\u0007V\u0014(/\u001a8u\u0007>t7/\u001a8tkN,\u0005o\\2i\u0013:4w.\u0006\u0002\u0004@AA\u0011\u0011\\B!\u0005[\u001b)%\u0003\u0003\u0004D\u0005]%A\u0002+va2,'\u0007\u0005\u0003\u00046\r\u001d\u0013\u0002BB%\u0007K\u0011!cQ8og\u0016t7/^:Fa>\u001c\u0007.\u00138g_\u0006Qq-\u001a;CC2\fgnY3\u0015\t\r=3q\f\t\u0005\u0007#\u001aY&\u0004\u0002\u0004T)!1QKB,\u0003\u0011i\u0017\r\u001e5\u000b\u0005\re\u0013\u0001\u00026bm\u0006LAa!\u0018\u0004T\tQ!)[4J]R,w-\u001a:\t\u000f\r\u0005D\u00051\u0001\u0004d\u00059\u0011\r\u001a3sKN\u001c\b\u0003BA@\u0007KJAaa\u001a\u0002\u0002\n9\u0011\t\u001a3sKN\u001c\u0018aE4fi\u0006\u001b7m\\;oiN#\u0018\r^3S_>$XC\u0001B\u001d\u0003-9W\r^\"pI\u0016D\u0015m\u001d5\u0015\t\te2\u0011\u000f\u0005\b\u0007C2\u0003\u0019AB2\u0003!9W\r\u001e(p]\u000e,G\u0003BB(\u0007oBqa!\u0019(\u0001\u0004\u0019\u0019'\u0001\fhKRd\u0015n\u001d;PM\u001a{'oZ3sgN#\u0018m[3t+\t\u0019i\b\u0005\u0004\u0002\u000e\u0006e5q\u0010\t\u0004]\u000e\u0005\u0015bABB\t\n9\u0012iY2pk:$hi\u001c:hS:<7\u000b^1lK&sgm\\\u0001\u0015O\u0016$\u0018\t\u001c7po\u0016$gi\u001c:hKJd\u0015n\u001d;\u0016\u0005\r%\u0005CBAG\u00033\u0013\t#\u0001\nhKR4uN]4feN#\u0018m[3ECR\fG\u0003BBH\u0007/\u0003b!!7\u0003v\rE\u0005c\u00018\u0004\u0014&\u00191Q\u0013#\u0003\u001f\u0019{'oZ3s'R\f7.\u001a#bi\u0006Dqa!'+\u0001\u0004\u0019Y*A\u0004ti\u0006\\W-\u00133\u0011\t\ru5Q\u0015\b\u0005\u0007?\u001b\t\u000b\u0005\u0003\u0002X\u0005]\u0015\u0002BBR\u0003/\u000ba\u0001\u0015:fI\u00164\u0017\u0002BBT\u0007S\u0013aa\u0015;sS:<'\u0002BBR\u0003/\u000b\u0011dZ3u\u0019&\u001cHo\u00144NG\u0006#GM](x]\u0016\u00148\u000f[5qgR!1qVB\\!\u0019\ti)!'\u00042B\u0019ana-\n\u0007\rUFIA\nNG\u0006#GM](x]\u0016\u00148\u000f[5q\t\u0006$\u0018\rC\u0005\u0004:.\u0002\n\u00111\u0001\u0004<\u0006a1oY!eIJ,7o](qiB1\u0011\u0011\u001cB;\u00077\u000b1eZ3u\u0019&\u001cHo\u00144NG\u0006#GM](x]\u0016\u00148\u000f[5qg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004B*\"11\u0018B{\u0003e9W\r\u001e'jgR|emT<oKJ\u001c6-\u00113ee\u0016\u001c8/Z:\u0015\u0005\r\u001d\u0007CBAG\u00033\u001bI\rE\u0002o\u0007\u0017L1a!4E\u00059yuO\\3s'\u000e\fE\r\u001a:fgN\f!c\\<oKJ\u001c\b.\u001b9ECR\fW\t_5tiR!!qABj\u0011\u001d\u0019)N\fa\u0001\u0005s\t1b\\<oKJ\u001c\b.\u001b9JI\u00069q-\u001a;M_\u001e\u001cH\u0003BBn\u0007S\u0004b!!7\u0003<\ru\u0007\u0003BBp\u0007Kl!a!9\u000b\u0007\r\rH)A\u0004sK\u000e,\u0017\u000e\u001d;\n\t\r\u001d8\u0011\u001d\u0002\u0019\u000bRDWM]3v[\u000e{gn]3ogV\u001cH)\u0019;b\u0019><\u0007bBBv_\u0001\u0007!\u0011H\u0001\u0007ibD\u0015m\u001d5\u0002'\u001d,G/\u00138uKJlW\rZ5bi\u0016\u0014vn\u001c;\u0002\u000f\u001d,GoQ8eKR!!\u0011HBz\u0011\u001d\u0019\t'\ra\u0001\u0007G\nabZ3u\u001d\u0016DHOQ1tK\u001a+W-\u0006\u0002\u0004P\u0005)r-\u001a;Ue\u0006t7/Y2uS>t'+Z2fSB$H\u0003BB\u007f\t\u000b\u0001b!!7\u0003v\r}\b\u0003BBp\t\u0003IA\u0001b\u0001\u0004b\nyQ\t\u001e5fe\u0016,XNU3dK&\u0004H\u000fC\u0004\u0004lN\u0002\rA!\u000f\u0002!\u001d,Go\u0015;bi\u0016$%\rS1oI2,WC\u0001C\u0006!\u0011\ty\b\"\u0004\n\t\u0011=\u0011\u0011\u0011\u0002\u000f%\u0016\u001cx.\u001e:dK\"\u000bg\u000e\u001a7f\u0003E9W\r^!dG>,h\u000e^*u_J\fw-\u001a\u000b\u0007\u0005s!)\u0002b\u0006\t\u000f\r\u0005T\u00071\u0001\u0004d!9A\u0011D\u001bA\u0002\te\u0012aA6fs\u00061r-\u001a;BG\u000e|WO\u001c;Ti>\u0014\u0018mZ3CsR,7\u000f\u0006\u0004\u0003:\u0011}A\u0011\u0005\u0005\b\u0007C2\u0004\u0019AB2\u0011\u001d!IB\u000ea\u0001\u0005s\tQ\"Y2d_VtG/\u0012=jgR\u001cH\u0003\u0002B\u0004\tOAqa!\u00198\u0001\u0004\u0019\u0019'\u0001\u0007jg\u0016{\u0017-Q2d_VtG\u000f\u0006\u0003\u0003\b\u00115\u0002bBB1q\u0001\u000711M\u0001\u0017SN\u001cV.\u0019:u\u0007>tGO]1di\u0006\u001b7m\\;oiR!!q\u0001C\u001a\u0011\u001d\u0019\t'\u000fa\u0001\u0007G\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\ts!Y\u0004\u0005\u0004\u0002@\u0006\r\u0017q\u001b\u0005\u0007\t{Q\u0004\u0019\u0001*\u0002\u0005QD\u0018AG5t/&$\b\u000e\u001a:bo\u0006dW\t]8dQ2\u000b7\u000f^%oI\u0016DXC\u0001B\u0004\u00035I7OR8sO&twm\u00149f]\u0006\u0011R\u000f\u001e=p\u001b\u0016\u00148\u000e\\3Ue\u0016,'k\\8u)\u0011!I\u0005b\u0013\u0011\r\u0005e'Q\u000fB\u001d\u0011\u001d\u0011\u0019&\u0010a\u0001\u0005C\tA\"Q2d_VtGo\u0015;bi\u0016\u0004\"A\\ \u0014\u000b}\"\u0019&a\u0007\u0011\t\u0005eGQK\u0005\u0005\t/\n9J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\t\u001f\nAB]3ti>\u0014Xm\u0015;bi\u0016$b\u0002b\u0018\u0005b\u0011\rDQ\rC4\tS\"Y\u0007E\u0003\u0002Z\nUT\u000eC\u0004\u0002n\u0005\u0003\r!a\u001c\t\u000f\u0005m\u0014\t1\u0001\u0002~!9\u0011\u0011R!A\u0002\u0005-\u0005bBA\u0014\u0003\u0002\u0007\u00111\u0006\u0005\b\u0003o\t\u0005\u0019AA\u001d\u0011\u001d\t\u0019%\u0011a\u0001\u0003\u000b\n!c\u0019:fCR,w)\u001a8fg&\u001c8\u000b^1uKR\u0001\u0012Q\u0018C9\tg\")\bb\u001e\u0005z\u0011mDQ\u0010\u0005\b\u0003[\u0012\u0005\u0019AA8\u0011\u001d\tYH\u0011a\u0001\u0003{Bq!!#C\u0001\u0004\tY\tC\u0004\u0002(\t\u0003\r!a\u000b\t\u000f\u0005]\"\t1\u0001\u0002:!9\u00111\t\"A\u0002\u0005\u0015\u0003B\u0002C@\u0005\u0002\u0007!.\u0001\u0007hK:,7/[:CY>\u001c7\u000e")
public class AccountState
extends AbstractState<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountState>
implements State<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlock, AccountStateView, AccountState>,
TransactionValidation<AccountTransaction<Proposition, Proof<Proposition>>>,
NodeAccountState,
ClosableResourceHandler,
SparkzLogging {
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final HistoryBlockHashProvider blockHashProvider;
    private final String version;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> messageProcessors;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    public boolean isValid(Transaction tx) {
        return TransactionValidation.isValid$((TransactionValidation)this, (Transaction)tx);
    }

    public Seq<AccountTransaction<Proposition, Proof<Proposition>>> filterValid(Seq<AccountTransaction<Proposition, Proof<Proposition>>> txs) {
        return TransactionValidation.filterValid$((TransactionValidation)this, txs);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public NetworkParams params() {
        return this.params;
    }

    public String version() {
        return this.version;
    }

    public Try<AccountState> io$horizen$account$state$AccountState$$initProcessors(String initialVersion) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)view -> {
            int consensusEpochNumber = view.getConsensusEpochNumberAsInt();
            $this.messageProcessors.foreach((Function1 & Serializable & scala.Serializable)processor -> {
                processor.init(view, consensusEpochNumber);
                return BoxedUnit.UNIT;
            });
            try {
                view.commit(initialVersion);
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(44).append("Could not commit view with initial version: ").append(initialVersion).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg, t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw t;
            }
            return this;
        }));
    }

    public Try<AccountState> applyModifier(AccountBlock mod) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(package$.MODULE$.versionToBytes(this.version()))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray((byte[])package$.MODULE$.idToBytes().apply((Object)mod.parentId()))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Incorrect state version!: ").append(mod.parentId()).append(" found, ").append(this.version()).append(" expected").toString());
            return (AccountState)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                BoxedUnit boxedUnit;
                if (stateView.hasCeased()) {
                    BoxedUnit boxedUnit2;
                    String errMsg = new StringBuilder(53).append("Can't apply Block ").append(mod.id()).append(", because the sidechain has ceased.").toString();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(errMsg);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    throw new IllegalStateException(errMsg);
                }
                mod.sidechainTransactions().foreach((Function1 & Serializable & scala.Serializable)tx -> {
                    tx.semanticValidity();
                    return BoxedUnit.UNIT;
                });
                WithdrawalEpochInfo currentWithdrawalEpochInfo = this.getWithdrawalEpochInfo();
                WithdrawalEpochInfo modWithdrawalEpochInfo = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mod, currentWithdrawalEpochInfo, this.params());
                if (this.params().isNonCeasing()) {
                    ((IterableLike)mod.mainchainBlockReferencesData().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(x$1.topQualityCertificate()), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)cert -> {
                        this.validateTopQualityCertificate(cert, stateView);
                        return BoxedUnit.UNIT;
                    });
                } else if (WithdrawalEpochUtils$.MODULE$.hasReachedCertificateSubmissionWindowEnd(mod, currentWithdrawalEpochInfo, this.params())) {
                    int certReferencedEpochNumber = modWithdrawalEpochInfo.epoch() - 1;
                    Option topQualityCertificateOpt = mod.topQualityCertificateOpt().orElse((Function0 & Serializable & scala.Serializable)() -> stateView.getTopQualityCertificate(certReferencedEpochNumber));
                    Option option = topQualityCertificateOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        WithdrawalEpochCertificate cert2 = (WithdrawalEpochCertificate)some.value();
                        this.validateTopQualityCertificate(cert2, (AccountStateView)stateView);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit4;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(131).append("In the end of the certificate submission window of epoch ").append(modWithdrawalEpochInfo.epoch()).append(" ").append("there are no certificates referenced to the epoch ").append(certReferencedEpochNumber).append(". Sidechain has ceased.").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        stateView.setCeased();
                        BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)option);
                    }
                }
                stateView.updateWithdrawalEpochInfo(modWithdrawalEpochInfo);
                int consensusEpochNumber = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), mod.timestamp());
                stateView.updateConsensusEpochNumber(consensusEpochNumber);
                mod.mainchainBlockReferencesData().foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountState.$anonfun$applyModifier$8(stateView, mod, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                int blockNumber = $this.stateMetadataStorage.getHeight() + 1;
                byte[] blockHash = (byte[])package$.MODULE$.idToBytes().apply((Object)mod.id());
                ObjectRef cumGasUsed = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumBaseFee = ObjectRef.create((Object)BigInteger.ZERO);
                ObjectRef cumForgerTips = ObjectRef.create((Object)BigInteger.ZERO);
                GasPool blockGasPool = new GasPool(mod.header().gasLimit());
                BlockContext blockContext = new BlockContext(mod.header(), blockNumber, consensusEpochNumber, modWithdrawalEpochInfo.epoch(), this.params().chainId(), $this.blockHashProvider);
                ((TraversableLike)mod.sidechainTransactions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountState.$anonfun$applyModifier$9(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    AccountState.$anonfun$applyModifier$10(this, stateView, blockGasPool, blockContext, cumGasUsed, blockHash, blockNumber, receiptList, cumBaseFee, cumForgerTips, x$3);
                    return BoxedUnit.UNIT;
                });
                if (this.log().underlying().isDebugEnabled()) {
                    this.log().underlying().debug("cumBaseFee={}, cumForgerTips={}", (Object[])new BigInteger[]{(BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                stateView.updateFeePaymentInfo(new AccountBlockFeeInfo((BigInteger)cumBaseFee.elem, (BigInteger)cumForgerTips.elem, mod.header().forgerAddress()));
                this.evalForgersReward(mod, modWithdrawalEpochInfo, (AccountStateView)stateView);
                mod.verifyLogsBloomConsistency((Seq<EthereumReceipt>)receiptList);
                mod.verifyReceiptDataConsistency((Seq<EthereumConsensusDataReceipt>)((Seq)receiptList.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.consensusDataReceipt(), ListBuffer$.MODULE$.canBuildFrom())));
                BigInteger gasUsed = (BigInteger)receiptList.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.consensusDataReceipt().cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
                mod.verifyGasUsedConsistency(gasUsed);
                byte[] stateRoot = stateView.getIntermediateRoot();
                mod.verifyStateRootDataConsistency(stateRoot);
                stateView.updateTransactionReceipts((Seq<EthereumReceipt>)receiptList);
                stateView.updateNextBaseFee(FeeUtils$.MODULE$.calculateNextBaseFee(mod, this.params()));
                stateView.commit(package$.MODULE$.idToVersion(mod.id()));
                return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, package$.MODULE$.idToVersion(mod.id()), $this.stateMetadataStorage, $this.stateDbStorage, $this.messageProcessors);
            });
        });
    }

    private void evalForgersReward(AccountBlock mod, WithdrawalEpochInfo modWithdrawalEpochInfo, AccountStateView stateView) {
        boolean isWithdrawalEpochFinished = WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(modWithdrawalEpochInfo, this.params());
        if (isWithdrawalEpochFinished) {
            BoxedUnit boxedUnit;
            Seq<AccountPayment> feePayments = stateView.getFeePaymentsInfo(modWithdrawalEpochInfo.epoch(), (Option<AccountBlockFeeInfo>)None$.MODULE$);
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("End of Withdrawal Epoch {} reached, added {} rewards with block {}", new Object[]{BoxesRunTime.boxToInteger((int)modWithdrawalEpochInfo.epoch()), BoxesRunTime.boxToInteger((int)feePayments.length()), mod.header().id()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash(feePayments);
            if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(feePaymentsHash))) {
                BoxedUnit boxedUnit2;
                String errMsg = new StringBuilder(72).append("Block ").append(mod.id()).append(": computed feePaymentsHash ").append(BytesUtils.toHexString(feePaymentsHash)).append(" is different from the one in the block").toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                AccountState.$anonfun$evalForgersReward$1(this, stateView, payment);
                return BoxedUnit.UNIT;
            });
        } else if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mod.feePaymentsHash())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(AccountFeePaymentsUtils$.MODULE$.DEFAULT_ACCOUNT_FEE_PAYMENTS_HASH()))) {
            String errMsg = new StringBuilder(66).append("Block ").append(mod.id()).append(" has feePaymentsHash ").append(BytesUtils.toHexString(mod.feePaymentsHash())).append(" defined when no fee payments expected.").toString();
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void validateTopQualityCertificate(WithdrawalEpochCertificate topQualityCertificate, AccountStateView stateView) {
        int certReferencedEpochNumber = topQualityCertificate.epochNumber();
        Seq<WithdrawalRequest> expectedWithdrawalRequests = stateView.getWithdrawalRequests(certReferencedEpochNumber);
        if (topQualityCertificate.backwardTransferOutputs().size() != expectedWithdrawalRequests.size()) {
            throw new IllegalStateException(new StringBuilder(139).append("Epoch ").append(certReferencedEpochNumber).append(" top quality certificate backward transfers ").append("number ").append(topQualityCertificate.backwardTransferOutputs().size()).append(" is different than expected ").append(expectedWithdrawalRequests.size()).append(". ").append("Node's active chain is the fork from MC perspective.").toString());
        }
        ((IterableLike)topQualityCertificate.backwardTransferOutputs().zip(expectedWithdrawalRequests, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountState.$anonfun$validateTopQualityCertificate$1(certReferencedEpochNumber, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isSwitchingConsensusEpoch(long blockTimeStamp) {
        int currentConsensusEpoch;
        int blockConsensusEpoch = TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(this.params().sidechainGenesisBlockTimestamp(), blockTimeStamp);
        return blockConsensusEpoch != (currentConsensusEpoch = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))));
    }

    public Try<AccountState> rollbackTo(String version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            AccountStateMetadataStorage newMetaState = (AccountStateMetadataStorage)$this.stateMetadataStorage.rollback(new ByteArrayWrapper(package$.MODULE$.versionToBytes(version))).get();
            return new AccountState(this.params(), $this.timeProvider, $this.blockHashProvider, version, newMetaState, $this.stateDbStorage, $this.messageProcessors);
        }).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isErrorEnabled()) {
                    this.$outer.log().underlying().error("Exception was thrown during rollback.", A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int maxRollbackDepth() {
        return this.stateMetadataStorage.rollbackVersions().size();
    }

    @Override
    public AccountStateView getView() {
        Hash stateRoot = new Hash(this.stateMetadataStorage.getAccountStateRoot());
        StateDB statedb = new StateDB(this.stateDbStorage, stateRoot);
        return new AccountStateView(this.stateMetadataStorage.getView(), statedb, this.messageProcessors);
    }

    public StateDbAccountStateView getStateDbViewFromRoot(byte[] stateRoot) {
        return new StateDbAccountStateView(new StateDB(this.stateDbStorage, new Hash(stateRoot)), this.messageProcessors);
    }

    @Override
    public Seq<WithdrawalRequest> getWithdrawalRequests(int withdrawalEpoch) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.getWithdrawalRequests(withdrawalEpoch));
    }

    @Override
    public Seq<BackwardTransfer> backwardTransfers(int withdrawalEpoch) {
        return (Seq)((TraversableLike)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$7 -> x$7.getWithdrawalRequests(withdrawalEpoch))).map((Function1 & Serializable & scala.Serializable)wr -> new BackwardTransfer(wr.proposition().bytes(), wr.valueInZennies()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<KeyRotationProof> keyRotationProof(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.keyRotationProof(withdrawalEpoch, indexOfSigner, keyType));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<CertifiersKeys> certifiersKeys(int withdrawalEpoch) {
        Some some;
        block3: {
            block2: {
                if (withdrawalEpoch == -1) break block2;
                Enumeration.Value value = this.params().circuitType();
                Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
                if (value != null ? !value.equals(value2) : value2 != null) break block3;
            }
            some = new Some((Object)new CertifiersKeys((Vector<SchnorrProposition>)this.params().signersPublicKeys().toVector(), (Vector<SchnorrProposition>)this.params().mastersPublicKeys().toVector()));
            return some;
        }
        some = (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$9 -> x$9.certifiersKeys(withdrawalEpoch));
        return some;
    }

    @Override
    public Option<Object> lastCertificateReferencedEpoch() {
        return this.stateMetadataStorage.lastCertificateReferencedEpoch();
    }

    @Override
    public Option<String> lastCertificateSidechainBlockId() {
        return this.stateMetadataStorage.lastCertificateSidechainBlockId();
    }

    @Override
    public Option<WithdrawalEpochCertificate> certificate(int referencedWithdrawalEpoch) {
        return this.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        return this.stateMetadataStorage.getTopQualityCertificate(referencedWithdrawalEpoch);
    }

    @Override
    public boolean hasCeased() {
        return this.stateMetadataStorage.hasCeased();
    }

    @Override
    public Seq<AccountPayment> getFeePaymentsInfo(int withdrawalEpoch, Option<AccountBlockFeeInfo> blockToAppendFeeInfo) {
        Seq<AccountBlockFeeInfo> feePaymentInfoSeq = this.stateMetadataStorage.getFeePayments(withdrawalEpoch);
        return AccountFeePaymentsUtils$.MODULE$.getForgersRewards(feePaymentInfoSeq);
    }

    @Override
    public Option<AccountBlockFeeInfo> getFeePaymentsInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public WithdrawalEpochInfo getWithdrawalEpochInfo() {
        return this.stateMetadataStorage.getWithdrawalEpochInfo();
    }

    @Override
    public Option<Object> getConsensusEpochNumber() {
        return this.stateMetadataStorage.getConsensusEpochNumber();
    }

    @Override
    public Seq<ForgingStakeInfo> getOrderedForgingStakesInfoSeq() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$10 -> x$10.getOrderedForgingStakesInfoSeq());
    }

    @Override
    public Tuple2<String, ConsensusEpochInfo> getCurrentConsensusEpochInfo() {
        Seq<ForgingStakeInfo> forgingStakes = this.getOrderedForgingStakesInfoSeq();
        if (forgingStakes.isEmpty()) {
            throw new IllegalStateException("ForgerStakes list can't be empty.");
        }
        Option<Object> option = this.getConsensusEpochNumber();
        if (!(option instanceof Some)) {
            throw new IllegalStateException("Can't retrieve Consensus Epoch related info form StateStorage.");
        }
        Some some = (Some)option;
        int consensusEpochNumber = BoxesRunTime.unboxToInt((Object)some.value());
        String lastBlockInEpoch = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)this.stateMetadataStorage.lastVersionId().get()).data());
        ConsensusEpochInfo consensusEpochInfo = new ConsensusEpochInfo(consensusEpochNumber, MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakes.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava()), BoxesRunTime.unboxToLong((Object)((TraversableOnce)forgingStakes.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.stakeAmount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Tuple2 tuple2 = new Tuple2((Object)lastBlockInEpoch, (Object)consensusEpochInfo);
        return tuple2;
    }

    @Override
    public BigInteger getBalance(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$12 -> x$12.getBalance(address));
    }

    @Override
    public byte[] getAccountStateRoot() {
        return this.stateMetadataStorage.getAccountStateRoot();
    }

    @Override
    public byte[] getCodeHash(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$13 -> x$13.getCodeHash(address));
    }

    @Override
    public BigInteger getNonce(Address address) {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$14 -> x$14.getNonce(address));
    }

    @Override
    public Seq<AccountForgingStakeInfo> getListOfForgersStakes() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$15 -> x$15.getListOfForgersStakes());
    }

    @Override
    public Seq<Object> getAllowedForgerList() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$16 -> x$16.getAllowedForgerList());
    }

    @Override
    public Option<ForgerStakeData> getForgerStakeData(String stakeId) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$17 -> x$17.getForgerStakeData(stakeId));
    }

    @Override
    public Seq<McAddrOwnershipData> getListOfMcAddrOwnerships(Option<String> scAddressOpt) {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$18 -> x$18.getListOfMcAddrOwnerships(scAddressOpt));
    }

    @Override
    public Option<String> getListOfMcAddrOwnerships$default$1() {
        return None$.MODULE$;
    }

    @Override
    public Seq<OwnerScAddress> getListOfOwnerScAddresses() {
        return (Seq)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$19 -> x$19.getListOfOwnerScAddresses());
    }

    @Override
    public boolean ownershipDataExist(byte[] ownershipId) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)x$20.ownershipDataExist(ownershipId))));
    }

    @Override
    public EthereumConsensusDataLog[] getLogs(byte[] txHash) {
        return (EthereumConsensusDataLog[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$21 -> x$21.getLogs(txHash));
    }

    @Override
    public byte[] getIntermediateRoot() {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$22 -> x$22.getIntermediateRoot());
    }

    @Override
    public byte[] getCode(Address address) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$23 -> x$23.getCode(address));
    }

    @Override
    public BigInteger getNextBaseFee() {
        return (BigInteger)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$24 -> x$24.getNextBaseFee());
    }

    @Override
    public Option<EthereumReceipt> getTransactionReceipt(byte[] txHash) {
        return (Option)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$25 -> x$25.getTransactionReceipt(txHash));
    }

    @Override
    public ResourceHandle getStateDbHandle() {
        return (ResourceHandle)this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$26 -> x$26.getStateDbHandle());
    }

    @Override
    public byte[] getAccountStorage(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$27 -> x$27.getAccountStorage(address, key));
    }

    @Override
    public byte[] getAccountStorageBytes(Address address, byte[] key) {
        return (byte[])this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$28 -> x$28.getAccountStorageBytes(address, key));
    }

    @Override
    public boolean accountExists(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)x$29.accountExists(address))));
    }

    @Override
    public boolean isEoaAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToBoolean((boolean)x$30.isEoaAccount(address))));
    }

    @Override
    public boolean isSmartContractAccount(Address address) {
        return BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.isSmartContractAccount(address))));
    }

    public Try<BoxedUnit> validate(AccountTransaction<Proposition, Proof<Proposition>> tx) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!(tx instanceof EthereumTransaction)) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(46).append("Transaction ").append(tx.id()).append(": instance of class ").append(tx.getClass().getName()).append(", not of type ").append(EthereumTransaction.class.getName()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new IllegalArgumentException(errMsg);
            }
            EthereumTransaction ethTx = (EthereumTransaction)tx;
            if ((ethTx.isEIP155() || ethTx.isEIP1559()) && !BoxesRunTime.equalsNumObject((Number)ethTx.getChainId(), (Object)BoxesRunTime.boxToLong((long)this.params().chainId()))) {
                BoxedUnit boxedUnit;
                String errMsg = new StringBuilder(61).append("Transaction ").append(ethTx.id()).append(": chainId=").append(ethTx.getChainId()).append(" is different from expected SC chainId ").append(this.params().chainId()).toString();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(errMsg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new InvalidTransactionChainIdException(errMsg, InvalidTransactionChainIdException$.MODULE$.$lessinit$greater$default$2());
            }
            ethTx.semanticValidity();
            Address sender = ethTx.getFrom().address();
            GasFeeFork feeFork = GasFeeFork$.MODULE$.get(BoxesRunTime.unboxToInt((Object)$this.stateMetadataStorage.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
            if (feeFork.blockGasLimit().compareTo(ethTx.getGasLimit()) < 0) {
                throw new IllegalArgumentException(new StringBuilder(78).append("Transaction gas limit exceeds block gas limit: tx gas limit ").append(ethTx.getGasLimit()).append(", block gas limit ").append(feeFork.blockGasLimit()).toString());
            }
            if (feeFork.baseFeeMinimum().compareTo(ethTx.getMaxFeePerGas()) > 0) {
                throw new IllegalArgumentException(new StringBuilder(64).append("max fee per gas below minimum: address ").append(sender).append(", maxFeePerGas ").append(ethTx.getMaxFeePerGas()).append(", minimum ").append(feeFork.baseFeeMinimum()).toString());
            }
            this.using(this.getView(), (Function1 & Serializable & scala.Serializable)stateView -> {
                AccountState.$anonfun$validate$3(sender, ethTx, stateView);
                return BoxedUnit.UNIT;
            });
        }).recoverWith((PartialFunction)new scala.Serializable(this, tx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AccountState $outer;
            private final AccountTransaction tx$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BoxedUnit boxedUnit;
                A1 A1 = x1;
                if (this.$outer.log().underlying().isDebugEnabled()) {
                    this.$outer.log().underlying().debug(new StringBuilder(22).append("Not valid transaction ").append(this.tx$1.id()).toString(), A1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tx$1 = tx$1;
            }
        });
    }

    @Override
    public boolean isWithdrawalEpochLastIndex() {
        return WithdrawalEpochUtils$.MODULE$.isEpochLastIndex(this.getWithdrawalEpochInfo(), this.params());
    }

    @Override
    public boolean isForgingOpen() {
        return this.params().restrictForgers() ? BoxesRunTime.unboxToBoolean(this.using(this.getView(), (Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)x$32.isForgingOpen()))) : true;
    }

    @Override
    public Option<byte[]> utxoMerkleTreeRoot(int withdrawalEpoch) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$8(AccountStateView stateView$1, AccountBlock mod$1, MainchainBlockReferenceData mcBlockRefData) {
        stateView$1.addTopQualityCertificates(mcBlockRefData, mod$1.id());
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData);
    }

    public static final /* synthetic */ boolean $anonfun$applyModifier$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$applyModifier$10(AccountState $this, AccountStateView stateView$1, GasPool blockGasPool$1, BlockContext blockContext$1, ObjectRef cumGasUsed$1, byte[] blockHash$1, int blockNumber$1, ListBuffer receiptList$1, ObjectRef cumBaseFee$1, ObjectRef cumForgerTips$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            Tuple2 tuple22;
            BigInteger txGasUsed;
            AccountTransaction tx = (AccountTransaction)tuple2._1();
            int txIndex = tuple2._2$mcI$sp();
            boolean bl = false;
            Failure failure = null;
            Try<EthereumConsensusDataReceipt> try_ = stateView$1.applyTransaction(tx, txIndex, blockGasPool$1, blockContext$1);
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                Success success = (Success)try_;
                EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract((BigInteger)cumGasUsed$1.elem);
                cumGasUsed$1.elem = consensusDataReceipt.cumulativeGasUsed();
                EthereumTransaction ethTx = (EthereumTransaction)tx;
                byte[] txHash = BytesUtils.fromHexString(ethTx.id());
                None$ contractAddress = ethTx.getTo().isEmpty() ? Option$.MODULE$.apply((Object)Secp256k1.generateContractAddress(ethTx.getFrom().address(), ethTx.getNonce())) : None$.MODULE$;
                EthereumReceipt fullReceipt = new EthereumReceipt(consensusDataReceipt, txHash, txIndex, blockHash$1, blockNumber$1, txGasUsed, (Option<Address>)contractAddress);
                if ($this.log().underlying().isDebugEnabled()) {
                    $this.log().underlying().debug("Adding to receipt list: {}", new Object[]{fullReceipt.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                receiptList$1.$plus$eq((Object)fullReceipt);
                Tuple2<BigInteger, BigInteger> tuple23 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                BigInteger txBaseFeePerGas = (BigInteger)tuple23._1();
                BigInteger txForgerTipPerGas = (BigInteger)tuple23._2();
                tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
            } else {
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable err = failure.exception();
                    if (err instanceof GasLimitReached) {
                        BoxedUnit boxedUnit;
                        GasLimitReached gasLimitReached = (GasLimitReached)err;
                        if ($this.log().underlying().isErrorEnabled()) {
                            $this.log().underlying().error("Could not apply tx, block gas limit exceeded");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new IllegalArgumentException("Could not apply tx, block gas limit exceeded", gasLimitReached);
                    }
                }
                if (bl) {
                    BoxedUnit boxedUnit;
                    Throwable err = failure.exception();
                    if ($this.log().underlying().isErrorEnabled()) {
                        $this.log().underlying().error("Could not apply tx", err);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new IllegalArgumentException(err);
                }
                throw new MatchError(try_);
            }
            Tuple2 tuple24 = tuple22;
            BigInteger txBaseFeePerGas = (BigInteger)tuple24._1();
            BigInteger txForgerTipPerGas = (BigInteger)tuple24._2();
            cumBaseFee$1.elem = ((BigInteger)cumBaseFee$1.elem).add(txBaseFeePerGas.multiply(txGasUsed));
            cumForgerTips$1.elem = ((BigInteger)cumForgerTips$1.elem).add(txForgerTipPerGas.multiply(txGasUsed));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$evalForgersReward$1(AccountState $this, AccountStateView stateView$2, AccountPayment payment) {
        BoxedUnit boxedUnit;
        stateView$2.addBalance(payment.address().address(), payment.value());
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug(" address: {} / value: {}", new Object[]{payment.address().address(), payment.value()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$validateTopQualityCertificate$1(int certReferencedEpochNumber$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            MainchainBackwardTransferCertificateOutput certOutput = (MainchainBackwardTransferCertificateOutput)tuple2._1();
            WithdrawalRequest expectedWithdrawalRequest = (WithdrawalRequest)tuple2._2();
            if (certOutput.amount() != expectedWithdrawalRequest.valueInZennies() || !Arrays.equals(certOutput.pubKeyHash(), expectedWithdrawalRequest.proposition().bytes())) {
                throw new IllegalStateException(new StringBuilder(135).append("Epoch ").append(certReferencedEpochNumber$2).append(" top quality certificate backward transfers ").append("data is different than expected. Node's active chain is the fork from MC perspective.").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validate$3(Address sender$1, EthereumTransaction ethTx$1, AccountStateView stateView) {
        BigInteger stateNonce = stateView.getNonce(sender$1);
        if (stateNonce.compareTo(ethTx$1.getNonce()) > 0) {
            throw new NonceTooLowException(sender$1, ethTx$1.getNonce(), stateNonce);
        }
        BigInteger maxTxCost = ethTx$1.maxCost();
        BigInteger currentBalance = stateView.getBalance(sender$1);
        if (currentBalance.compareTo(maxTxCost) < 0) {
            throw new IllegalArgumentException(new StringBuilder(64).append("Insufficient funds for executing transaction: balance ").append(currentBalance).append(", tx cost ").append(maxTxCost).toString());
        }
        if (!stateView.isEoaAccount(sender$1)) {
            throw new SenderNotEoaException(sender$1, stateView.getCodeHash(sender$1));
        }
    }

    public AccountState(NetworkParams params, NetworkTimeProvider timeProvider, HistoryBlockHashProvider blockHashProvider, String version, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> messageProcessors) {
        this.params = params;
        this.timeProvider = timeProvider;
        this.blockHashProvider = blockHashProvider;
        this.version = version;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.messageProcessors = messageProcessors;
        TransactionValidation.$init$((TransactionValidation)this);
        ClosableResourceHandler.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

