/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.proof;

import io.horizen.account.proof.SignatureSecp256k1;
import io.horizen.account.utils.BigIntegerUInt256;
import io.horizen.proof.ProofSerializer;
import java.math.BigInteger;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.Writer;

public final class SignatureSecp256k1Serializer
implements ProofSerializer<SignatureSecp256k1> {
    private static final SignatureSecp256k1Serializer serializer = new SignatureSecp256k1Serializer();

    private SignatureSecp256k1Serializer() {
    }

    public static SignatureSecp256k1Serializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(SignatureSecp256k1 signature, Writer writer) {
        byte[] byteArray_v = BigIntegerUInt256.getUnsignedByteArray(signature.getV());
        writer.putUShort(byteArray_v.length);
        writer.putBytes(byteArray_v);
        byte[] byteArray_r = BigIntegerUInt256.getUnsignedByteArray(signature.getR());
        writer.putUShort(byteArray_r.length);
        writer.putBytes(byteArray_r);
        byte[] byteArray_s = BigIntegerUInt256.getUnsignedByteArray(signature.getS());
        writer.putUShort(byteArray_s.length);
        writer.putBytes(byteArray_s);
    }

    @Override
    public SignatureSecp256k1 parse(Reader reader) {
        int byteArray_v_len = reader.getUShort();
        BigInteger v = new BigInteger(1, reader.getBytes(byteArray_v_len));
        int byteArray_r_len = reader.getUShort();
        BigInteger r = new BigInteger(1, reader.getBytes(byteArray_r_len));
        int byteArray_s_len = reader.getUShort();
        BigInteger s = new BigInteger(1, reader.getBytes(byteArray_s_len));
        return new SignatureSecp256k1(v, r, s);
    }
}

