/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.forger;

import akka.util.Timeout;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlock$;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.companion.SidechainAccountTransactionsCompanion;
import io.horizen.account.fork.GasFeeFork;
import io.horizen.account.fork.GasFeeFork$;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.mempool.MempoolMap;
import io.horizen.account.mempool.TransactionsByPriceAndNonceIter;
import io.horizen.account.proposition.AddressProposition;
import io.horizen.account.secret.PrivateKeySecp256k1;
import io.horizen.account.state.AccountState;
import io.horizen.account.state.AccountStateView;
import io.horizen.account.state.BlockContext;
import io.horizen.account.state.FeeCapTooLowException;
import io.horizen.account.state.GasLimitReached;
import io.horizen.account.state.GasPool;
import io.horizen.account.state.GasUtil$;
import io.horizen.account.state.HistoryBlockHashProvider;
import io.horizen.account.state.NonceTooLowException;
import io.horizen.account.state.receipt.EthereumConsensusDataReceipt;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockFeeInfo;
import io.horizen.account.utils.AccountFeePaymentsUtils$;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.utils.Bloom;
import io.horizen.account.utils.Bloom$;
import io.horizen.account.utils.FeeUtils$;
import io.horizen.account.wallet.AccountWallet;
import io.horizen.block.AccountOmmerSerializer$;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.Ommer;
import io.horizen.block.SidechainBlockBase;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.consensus.ForgingStakeInfo;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import io.horizen.forge.AbstractForgeMessageBuilder;
import io.horizen.forge.ForgeFailure;
import io.horizen.forge.ForgeResult;
import io.horizen.forge.ForgeSuccess;
import io.horizen.forge.MainchainSynchronizer;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.VrfProof;
import io.horizen.proposition.Proposition;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.VrfPublicKey;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.ClosableResourceHandler;
import io.horizen.utils.DynamicTypedSerializer;
import io.horizen.utils.ForgingStakeMerklePathInfo;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.MerklePath;
import io.horizen.utils.MerkleTree;
import io.horizen.utils.Pair;
import io.horizen.utils.TimeToEpochUtils$;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import io.horizen.vrf.VrfOutput;
import io.horizen.wallet.AbstractWallet;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;
import sparkz.core.NodeViewModifier$;
import sparkz.util.package$;

@ScalaSignature(bytes="\u0006\u0001\r-e\u0001B\r\u001b\u0001\rB\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"IQ\u000b\u0001B\u0001B\u0003%ak\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")1\r\u0001C\u0001I\u0016!1\u000e\u0001\u0001m\u000b\u0011\u0011\b\u0001A:\u0006\te\u0004\u0001A_\u0003\u0007\u0003\u0003\u0001\u0001!a\u0001\u0006\r\u0005=\u0001\u0001AA\t\u000b\u0019\ti\u0002\u0001\u0001\u0002 !9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003?\u0004A\u0011IAq\u0011%\u00119\rAI\u0001\n\u0003\u0011I\rC\u0004\u0003`\u0002!\tE!9\t\u000f\r\u0015\u0001\u0001\"\u0011\u0004\b!91Q\u0006\u0001\u0005B\r=\u0002bBB\u001a\u0001\u0011\u00051Q\u0007\u0005\b\u0007\u0017\u0002A\u0011IB'\u0011\u001d\u0019I\b\u0001C\u0001\u0007wBqa!!\u0001\t\u0003\u001a\u0019\tC\u0004\u0004\u0006\u0002!\tea!\t\u001b\r\u001d\u0005\u0001%A\u0002\u0002\u0003%Ia!#\\\u0005i\t5mY8v]R4uN]4f\u001b\u0016\u001c8/Y4f\u0005VLG\u000eZ3s\u0015\tYB$\u0001\u0004g_J<WM\u001d\u0006\u0003;y\tq!Y2d_VtGO\u0003\u0002 A\u00059\u0001n\u001c:ju\u0016t'\"A\u0011\u0002\u0005%|7\u0001A\n\u0004\u0001\u0011*\u0005#B\u0013)Uq\u0012U\"\u0001\u0014\u000b\u0005\u001dr\u0012!\u00024pe\u001e,\u0017BA\u0015'\u0005m\t%m\u001d;sC\u000e$hi\u001c:hK6+7o]1hK\n+\u0018\u000e\u001c3feB!1F\f\u00197\u001b\u0005a#BA\u0017\u001d\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\u0005=b#AE!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0010\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u0003kI\u00121\u0002\u0015:pa>\u001c\u0018\u000e^5p]B\u0019qG\u000f\u0019\u000e\u0003aR!!\u000f\u0010\u0002\u000bA\u0014xn\u001c4\n\u0005mB$!\u0002)s_>4\u0007CA\u001fA\u001b\u0005q$BA \u001d\u0003\u0015\u0011Gn\\2l\u0013\t\teH\u0001\nBG\u000e|WO\u001c;CY>\u001c7\u000eS3bI\u0016\u0014\bCA\u001fD\u0013\t!eH\u0001\u0007BG\u000e|WO\u001c;CY>\u001c7\u000e\u0005\u0002G\u00136\tqI\u0003\u0002I=\u0005)Q\u000f^5mg&\u0011!j\u0012\u0002\u0018\u00072|7/\u00192mKJ+7o\\;sG\u0016D\u0015M\u001c3mKJ\fQ#\\1j]\u000eD\u0017-\u001b8Ts:\u001c\u0007N]8oSj,'\u000f\u0005\u0002&\u001b&\u0011aJ\n\u0002\u0016\u001b\u0006Lgn\u00195bS:\u001c\u0016P\\2ie>t\u0017N_3s\u0003%\u0019w.\u001c9b]&|g\u000e\u0005\u0002R'6\t!K\u0003\u0002P9%\u0011AK\u0015\u0002&'&$Wm\u00195bS:\f5mY8v]R$&/\u00198tC\u000e$\u0018n\u001c8t\u0007>l\u0007/\u00198j_:\fa\u0001]1sC6\u001c\bCA,Z\u001b\u0005A&BA+\u001f\u0013\tQ\u0006LA\u0007OKR<xN]6QCJ\fWn]\u0005\u0003+\"\n1%\u00197m_^tunV3cg>\u001c7.\u001a;D_:tWm\u0019;j_:LeNU3hi\u0016\u001cH\u000f\u0005\u0002_C6\tqLC\u0001a\u0003\u0015\u00198-\u00197b\u0013\t\u0011wLA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0015)w\r[5k!\t1\u0007!D\u0001\u001b\u0011\u0015YU\u00011\u0001M\u0011\u0015yU\u00011\u0001Q\u0011\u0015)V\u00011\u0001W\u0011\u0015aV\u00011\u0001^\u0005\r1\u0005+\u0013\t\u0003[Bl\u0011A\u001c\u0006\u0003_r\tQa\u00195bS:L!!\u001d8\u0003-\u0005\u001b7m\\;oi\u001a+W\rU1z[\u0016tGo]%oM>\u0014Q\u0001S*U\u001fJ\u0003\"\u0001^<\u000e\u0003UT!A\u001e\u000f\u0002\u000fM$xN]1hK&\u0011\u00010\u001e\u0002\u0016\u0003\u000e\u001cw.\u001e8u\u0011&\u001cHo\u001c:z'R|'/Y4f\u0005\t1F\n\u0005\u0002|}6\tAP\u0003\u0002~9\u00051q/\u00197mKRL!a ?\u0003\u001b\u0005\u001b7m\\;oi^\u000bG\u000e\\3u\u0005\rA\u0015j\u0015\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u000f\u0002\u000f!L7\u000f^8ss&!\u0011QBA\u0004\u00059\t5mY8v]RD\u0015n\u001d;pef\u0014!!T*\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\u001d\u0003\u0015\u0019H/\u0019;f\u0013\u0011\tY\"!\u0006\u0003\u0019\u0005\u001b7m\\;oiN#\u0018\r^3\u0003\u00055\u0003\u0006\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015B$A\u0004nK6\u0004xn\u001c7\n\t\u0005%\u00121\u0005\u0002\u0012\u0003\u000e\u001cw.\u001e8u\u001b\u0016lwN]=Q_>d\u0017\u0001E2p[B,H/\u001a\"m_\u000e\\\u0017J\u001c4p)9\ty#!\u001a\u0002p\u0005e\u0014\u0011RAJ\u0003C\u0003\u0012BXA\u0019\u0003k\tI&a\u0017\n\u0007\u0005MrL\u0001\u0004UkBdWm\r\t\u0007\u0003o\t9%!\u0014\u000f\t\u0005e\u00121\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0017bAA#?\u00069\u0001/Y2lC\u001e,\u0017\u0002BA%\u0003\u0017\u00121aU3r\u0015\r\t)e\u0018\t\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)!\u00111KA\u000b\u0003\u001d\u0011XmY3jaRLA!a\u0016\u0002R\taR\t\u001e5fe\u0016,XnQ8og\u0016t7/^:ECR\f'+Z2fSB$\b#BA\u001c\u0003\u000fR\u0003\u0003BA/\u0003Cj!!a\u0018\u000b\u0005!c\u0012\u0002BA2\u0003?\u00121#Q2d_VtGO\u00117pG.4U-Z%oM>Dq!a\u001a\r\u0001\u0004\tI'\u0001\u0003wS\u0016<\b\u0003BA\n\u0003WJA!!\u001c\u0002\u0016\t\u0001\u0012iY2pk:$8\u000b^1uKZKWm\u001e\u0005\b\u0003cb\u0001\u0019AA:\u0003U\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]N\u0004R!a\u000e\u0002v)JA!a\u001e\u0002L\tA\u0011\n^3sC\ndW\rC\u0004\u0002|1\u0001\r!! \u000295\f\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,7\u000fR1uCB1\u0011qGA$\u0003\u007f\u0002B!!!\u0002\u00066\u0011\u00111\u0011\u0006\u0003\u007fyIA!a\"\u0002\u0004\nYR*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-\u001a#bi\u0006Dq!a#\r\u0001\u0004\ti)\u0001\u0007cY>\u001c7nQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0014\u0005=\u0015\u0002BAI\u0003+\u0011AB\u00117pG.\u001cuN\u001c;fqRDq!!&\r\u0001\u0004\t9*A\u0007g_J<WM]!eIJ,7o\u001d\t\u0005\u00033\u000bi*\u0004\u0002\u0002\u001c*\u00111\u0007H\u0005\u0005\u0003?\u000bYJ\u0001\nBI\u0012\u0014Xm]:Qe>\u0004xn]5uS>t\u0007bBAR\u0019\u0001\u0007\u0011QU\u0001\nE2|7m[*ju\u0016\u00042AXAT\u0013\r\tIk\u0018\u0002\u0005\u0019>tw-A\fuef\f\u0005\u000f\u001d7z\u0003:$w)\u001a;CY>\u001c7.\u00138g_Ra\u0011qVAi\u0003+\f9.!7\u0002\\B1\u0011\u0011WA\\\u0003wk!!a-\u000b\u0007\u0005Uv,\u0001\u0003vi&d\u0017\u0002BA]\u0003g\u00131\u0001\u0016:z!-q\u0016QXA\u001b\u00033\n\t-!1\n\u0007\u0005}vL\u0001\u0004UkBdW\r\u000e\t\u0005\u0003\u0007\fi-\u0004\u0002\u0002F*!\u0011qYAe\u0003\u0011i\u0017\r\u001e5\u000b\u0005\u0005-\u0017\u0001\u00026bm\u0006LA!a4\u0002F\nQ!)[4J]R,w-\u001a:\t\u000f\u0005MW\u00021\u0001\u0002j\u0005I1\u000f^1uKZKWm\u001e\u0005\b\u0003wj\u0001\u0019AA?\u0011\u001d\t\t(\u0004a\u0001\u0003gBq!a#\u000e\u0001\u0004\ti\tC\u0004\u0002^6\u0001\r!!*\u0002\u0017\tdwnY6TSj,\u0017J\\\u0001\u000fGJ,\u0017\r^3OK^\u0014En\\2l)\u0019\n\u0019/a;\u0002x\n\u0005!Q\u0001B\u0017\u0005o\u0011IDa\u000f\u0003H\tM#1\rB:\u0005{\u0012iIa&\u0003*\nM&1\u0019\t\u0007\u0003c\u000b9,!:\u0011\r\u0005\u0005\u0015q\u001d\u0016=\u0013\u0011\tI/a!\u0003%MKG-Z2iC&t'\t\\8dW\n\u000b7/\u001a\u0005\b\u0003[t\u0001\u0019AAx\u0003!qw\u000eZ3WS\u0016<\b\u0003BAy\u0003gl\u0011\u0001A\u0005\u0004\u0003kD#\u0001\u0002,jK^Dq!!?\u000f\u0001\u0004\tY0A\bce\u0006t7\r\u001b)pS:$\u0018J\u001c4p!\u0011\t\t0!@\n\u0007\u0005}\bFA\bCe\u0006t7\r\u001b)pS:$\u0018J\u001c4p\u0011\u0019\u0011\u0019A\u0004a\u0001;\u0006Q\u0012n],ji\"$'/Y<bY\u0016\u0003xn\u00195MCN$(\t\\8dW\"9!q\u0001\bA\u0002\t%\u0011\u0001\u00039be\u0016tG/\u00133\u0011\t\t-!q\u0005\b\u0005\u0005\u001b\u0011\tC\u0004\u0003\u0003\u0010\tua\u0002\u0002B\t\u0005/qA!a\u000f\u0003\u0014%\u0011!QC\u0001\u0007gB\f'o\u001b>\n\t\te!1D\u0001\u0005G>\u0014XM\u0003\u0002\u0003\u0016%\u0019qHa\b\u000b\t\te!1D\u0005\u0005\u0005G\u0011)#A\u0003CY>\u001c7NC\u0002@\u0005?IAA!\u000b\u0003,\t9!\t\\8dW&#'\u0002\u0002B\u0012\u0005KAqAa\f\u000f\u0001\u0004\u0011\t$A\u0005uS6,7\u000f^1naB!!1\u0002B\u001a\u0013\u0011\u0011)Da\u000b\u0003\u0013QKW.Z:uC6\u0004\bbBA>\u001d\u0001\u0007\u0011Q\u0010\u0005\b\u0003cr\u0001\u0019AA:\u0011\u001d\u0011iD\u0004a\u0001\u0005\u007f\t\u0001#\\1j]\u000eD\u0017-\u001b8IK\u0006$WM]:\u0011\r\u0005]\u0012q\tB!!\u0011\t\tIa\u0011\n\t\t\u0015\u00131\u0011\u0002\u0010\u001b\u0006Lgn\u00195bS:DU-\u00193fe\"9!\u0011\n\bA\u0002\t-\u0013AB8n[\u0016\u00148\u000f\u0005\u0004\u00028\u0005\u001d#Q\n\t\u0006\u0003\u0003\u0013y\u0005P\u0005\u0005\u0005#\n\u0019IA\u0003P[6,'\u000fC\u0004\u0003V9\u0001\rAa\u0016\u0002\u001f=<h.\u001a:Qe&4\u0018\r^3LKf\u0004BA!\u0017\u0003`5\u0011!1\f\u0006\u0004\u0005;r\u0012AB:fGJ,G/\u0003\u0003\u0003b\tm#a\u0004)sSZ\fG/Z&fsJ*T'M\u001d\t\u000f\t\u0015d\u00021\u0001\u0003h\u0005\u0001bm\u001c:hS:<7\u000b^1lK&sgm\u001c\t\u0005\u0005S\u0012y'\u0004\u0002\u0003l)\u0019!Q\u000e\u0010\u0002\u0013\r|gn]3ogV\u001c\u0018\u0002\u0002B9\u0005W\u0012\u0001CR8sO&twm\u0015;bW\u0016LeNZ8\t\u000f\tUd\u00021\u0001\u0003x\u0005AaO\u001d4Qe>|g\rE\u00028\u0005sJ1Aa\u001f9\u0005!1&O\u001a)s_>4\u0007b\u0002B@\u001d\u0001\u0007!\u0011Q\u0001\nmJ4w*\u001e;qkR\u0004BAa!\u0003\n6\u0011!Q\u0011\u0006\u0004\u0005\u000fs\u0012a\u0001<sM&!!1\u0012BC\u0005%1&OZ(viB,H\u000fC\u0004\u0003\u0010:\u0001\rA!%\u00025\u0019|'oZ5oON#\u0018m[3J]\u001a|W*\u001a:lY\u0016\u0004\u0016\r\u001e5\u0011\u0007\u0019\u0013\u0019*C\u0002\u0003\u0016\u001e\u0013!\"T3sW2,\u0007+\u0019;i\u0011\u0019ye\u00021\u0001\u0003\u001aB1aIa'+\u0005?K1A!(H\u0005Y!\u0015P\\1nS\u000e$\u0016\u0010]3e'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b#\u0002BQ\u0005KSSB\u0001BR\u0015\tic$\u0003\u0003\u0003(\n\r&!\u0006+sC:\u001c\u0018m\u0019;j_:\u001cVM]5bY&TXM\u001d\u0005\b\u0005Ws\u0001\u0019\u0001BW\u00039Ig\u000e];u\u00052|7m[*ju\u0016\u00042A\u0018BX\u0013\r\u0011\tl\u0018\u0002\u0004\u0013:$\b\"\u0003B[\u001dA\u0005\t\u0019\u0001B\\\u0003=\u0019\u0018n\u001a8biV\u0014Xm\u00149uS>t\u0007#\u00020\u0003:\nu\u0016b\u0001B^?\n1q\n\u001d;j_:\u00042a\u000eB`\u0013\r\u0011\t\r\u000f\u0002\u000f'&<g.\u0019;ve\u0016\u0014T'N\u0019:\u0011!\u0011)M\u0004I\u0001\u0002\u0004i\u0016!C5t!\u0016tG-\u001b8h\u0003e\u0019'/Z1uK:+wO\u00117pG.$C-\u001a4bk2$H%\r\u001d\u0016\u0005\t-'fA/\u0003N.\u0012!q\u001a\t\u0005\u0005#\u0014Y.\u0004\u0002\u0003T*!!Q\u001bBl\u0003%)hn\u00195fG.,GMC\u0002\u0003Z~\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011iNa5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000eqe\u0016\u001c\u0017\r\\2vY\u0006$XM\u00117pG.DU-\u00193feNK'0\u001a\u000b\u000b\u0005[\u0013\u0019Oa>\u0003z\u000e\r\u0001b\u0002B\u0004!\u0001\u0007!Q\u001d\t\u0005\u0005O\u0014\tP\u0004\u0003\u0003j\n5h\u0002\u0002B\t\u0005WLA!!.\u0003\u001c%!\u0011Q\tBx\u0015\u0011\t)La\u0007\n\t\tM(Q\u001f\u0002\u000b\u001b>$\u0017NZ5fe&#'\u0002BA#\u0005_DqAa\f\u0011\u0001\u0004\t)\u000bC\u0004\u0003|B\u0001\rA!@\u00025\u0019|'oZ5oON#\u0018m[3NKJ\\G.\u001a)bi\"LeNZ8\u0011\u0007\u0019\u0013y0C\u0002\u0004\u0002\u001d\u0013!DR8sO&twm\u0015;bW\u0016lUM]6mKB\u000bG\u000f[%oM>DqA!\u001e\u0011\u0001\u0004\u00119(\u0001\u0010d_2dWm\u0019;Ue\u0006t7/Y2uS>t7O\u0012:p[6+W\u000eU8pYRq1\u0011BB\u000b\u0007/\u0019Ib!\b\u0004(\r%\u0002\u0003BB\u0006\u0007#\u0001B!!\t\u0004\u000e%!1qBA\u0012\u0005)iU-\u001c9p_2l\u0015\r]\u0005\u0005\u0007'\u0019iAA\u000eUe\u0006t7/Y2uS>t7OQ=Qe&\u001cW-\u00118e\u001d>t7-\u001a\u0005\b\u0003[\f\u0002\u0019AAx\u0011\u001d\ti.\u0005a\u0001\u0005[Cqaa\u0007\u0012\u0001\u0004\ti(A\u000enC&t7\r[1j]\ncwnY6SK\u001a,'/\u001a8dK\u0012\u000bG/\u0019\u0005\b\u0007?\t\u0002\u0019AB\u0011\u0003M9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017J\u001c4p!\r151E\u0005\u0004\u0007K9%aE,ji\"$'/Y<bY\u0016\u0003xn\u00195J]\u001a|\u0007b\u0002B\u0018#\u0001\u0007!\u0011\u0007\u0005\b\u0007W\t\u0002\u0019AA:\u0003!1wN]2fIRC\u0018!D4fi>kW.\u001a:t'&TX\r\u0006\u0003\u0003.\u000eE\u0002b\u0002B%%\u0001\u0007!1J\u0001\rO\u0016$8\u000b^1uKJ{w\u000e\u001e\u000b\t\u0007o\u0019\u0019e!\u0012\u0004JA)al!\u000f\u0004>%\u001911H0\u0003\u000b\u0005\u0013(/Y=\u0011\u0007y\u001by$C\u0002\u0004B}\u0013AAQ=uK\"9\u0011\u0011B\nA\u0002\u0005\r\u0001bBB$'\u0001\u0007\u0011QU\u0001\u0015M>\u0014x-\u001a3CY>\u001c7\u000eV5nKN$\u0018-\u001c9\t\u000f\u0005e8\u00031\u0001\u0002|\u0006ir-\u001a;G_J<\u0017N\\4Ti\u0006\\W-T3sW2,\u0007+\u0019;i\u0013:4w\u000e\u0006\b\u0004P\rE3QNB8\u0007c\u001a\u0019h!\u001e\u0011\r\u0005]\u0012q\tB\u007f\u0011\u001d\u0019\u0019\u0006\u0006a\u0001\u0007+\n\u0001D\\3yi\u000e{gn]3ogV\u001cX\t]8dQ:+XNY3s!\u0011\u00199fa\u001a\u000f\t\re3Q\r\b\u0005\u00077\u001a\u0019G\u0004\u0003\u0004^\r\u0005d\u0002BA\u001e\u0007?J\u0011!I\u0005\u0003?\u0001J1A!\u001c\u001f\u0013\u0011\t)Ea\u001b\n\t\r%41\u000e\u0002\u0015\u0007>t7/\u001a8tkN,\u0005o\\2i\u001dVl'-\u001a:\u000b\t\u0005\u0015#1\u000e\u0005\u0006{R\u0001\rA\u001f\u0005\b\u0003\u0013!\u0002\u0019AA\u0002\u0011\u001d\t9\u0002\u0006a\u0001\u0003#Aq!!?\u0015\u0001\u0004\tY\u0010C\u0004\u0004xQ\u0001\r!!*\u0002%9,\u0007\u0010\u001e\"m_\u000e\\G+[7fgR\fW\u000e]\u0001\u0010O\u0016$\b+\u001a8eS:<'\t\\8dWR!1QPB@!\u0011q&\u0011\u0018\"\t\u000f\u00055X\u00031\u0001\u0002p\u00069r-\u001a;NCb\u0014En\\2l\u001fZ,'\u000f[3bINK'0\u001a\u000b\u0003\u0005[\u000bqbZ3u\u001b\u0006D(\t\\8dWNK'0Z\u0001\rgV\u0004XM\u001d\u0013qCJ\fWn]\u000b\u0002-\u0002")
public class AccountForgeMessageBuilder
extends AbstractForgeMessageBuilder<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock>
implements ClosableResourceHandler {
    @Override
    public <A extends AutoCloseable, B> B using(A resource, Function1<A, B> fun) {
        return (B)ClosableResourceHandler.using$(this, resource, fun);
    }

    private /* synthetic */ NetworkParams super$params() {
        return super.params();
    }

    public Tuple3<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, AccountBlockFeeInfo> computeBlockInfo(AccountStateView view, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, BlockContext blockContext, AddressProposition forgerAddress, long blockSize) {
        Tuple4 tuple4 = (Tuple4)this.tryApplyAndGetBlockInfo(view, mainchainBlockReferencesData, sidechainTransactions, blockContext, blockSize).get();
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Seq receiptList = (Seq)tuple4._1();
        Seq appliedTransactions = (Seq)tuple4._2();
        BigInteger cumBaseFee = (BigInteger)tuple4._3();
        BigInteger cumForgerTips = (BigInteger)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)receiptList, (Object)appliedTransactions, (Object)cumBaseFee, (Object)cumForgerTips);
        Tuple4 tuple43 = tuple42;
        Seq receiptList2 = (Seq)tuple43._1();
        Seq appliedTransactions2 = (Seq)tuple43._2();
        BigInteger cumBaseFee2 = (BigInteger)tuple43._3();
        BigInteger cumForgerTips2 = (BigInteger)tuple43._4();
        return new Tuple3((Object)receiptList2, (Object)appliedTransactions2, (Object)new AccountBlockFeeInfo(cumBaseFee2, cumForgerTips2, forgerAddress));
    }

    private Try<Tuple4<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, BigInteger, BigInteger>> tryApplyAndGetBlockInfo(AccountStateView stateView, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, BlockContext blockContext, long blockSizeIn) {
        Try try_;
        Object object = new Object();
        try {
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                mainchainBlockReferencesData.foreach((Function1 & Serializable & scala.Serializable)mcBlockRefData -> {
                    AccountForgeMessageBuilder.$anonfun$tryApplyAndGetBlockInfo$2(stateView, mcBlockRefData);
                    return BoxedUnit.UNIT;
                });
                ListBuffer receiptList = new ListBuffer();
                ListBuffer listOfTxsInBlock = new ListBuffer();
                BigInteger cumGasUsed = BigInteger.ZERO;
                BigInteger cumBaseFee = BigInteger.ZERO;
                BigInteger cumForgerTips = BigInteger.ZERO;
                GasPool blockGasPool = new GasPool(blockContext$1.blockGasLimit);
                long blockSize = blockSizeIn;
                Iterator iter = sidechainTransactions.iterator();
                while (iter.hasNext()) {
                    AccountTransaction accountTransaction;
                    AccountTransaction<Proposition, Proof<Proposition>> accountTransaction2;
                    if (blockGasPool.getGas().compareTo(GasUtil$.MODULE$.TxGas()) < 0) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Finishing forging because block cannot contain any additional tx");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        throw new NonLocalReturnControl(object, (Object)new Success((Object)new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips)));
                    }
                    TransactionsByPriceAndNonceIter priceAndNonceIter = (TransactionsByPriceAndNonceIter)iter;
                    AccountTransaction<Proposition, Proof<Proposition>> tx = priceAndNonceIter.peek();
                    long txSize = tx.size() + 1L;
                    if (blockSize + txSize > (long)this.getMaxBlockSize()) {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isTraceEnabled()) {
                            this.log().underlying().trace("Could not apply tx, reason: block size limit exceeded (block size: {}, tx size: {}, limit: {}", new Object[]{BoxesRunTime.boxToLong((long)blockSize), BoxesRunTime.boxToLong((long)txSize), BoxesRunTime.boxToInteger((int)this.getMaxBlockSize())});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        accountTransaction2 = priceAndNonceIter.removeAndSkipAccount();
                        continue;
                    }
                    Try<EthereumConsensusDataReceipt> try_ = stateView.applyTransaction(tx, listOfTxsInBlock.size(), blockGasPool, blockContext);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        EthereumConsensusDataReceipt consensusDataReceipt = (EthereumConsensusDataReceipt)success.value();
                        EthereumTransaction ethTx = (EthereumTransaction)tx;
                        receiptList.$plus$eq((Object)consensusDataReceipt);
                        listOfTxsInBlock.$plus$eq(tx);
                        BigInteger txGasUsed = consensusDataReceipt.cumulativeGasUsed().subtract(cumGasUsed);
                        cumGasUsed = consensusDataReceipt.cumulativeGasUsed();
                        Tuple2<BigInteger, BigInteger> tuple2 = GasUtil$.MODULE$.getTxFeesPerGas(ethTx, blockContext$1.baseFee);
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        BigInteger txBaseFeePerGas = (BigInteger)tuple2._1();
                        BigInteger txForgerTipPerGas = (BigInteger)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)txBaseFeePerGas, (Object)txForgerTipPerGas);
                        Tuple2 tuple23 = tuple22;
                        BigInteger txBaseFeePerGas2 = (BigInteger)tuple23._1();
                        BigInteger txForgerTipPerGas2 = (BigInteger)tuple23._2();
                        cumBaseFee = cumBaseFee.add(txBaseFeePerGas2.multiply(txGasUsed));
                        cumForgerTips = cumForgerTips.add(txForgerTipPerGas2.multiply(txGasUsed));
                        blockSize += txSize;
                        accountTransaction = (AccountTransaction)priceAndNonceIter.next();
                    } else if (try_ instanceof Failure) {
                        AccountTransaction accountTransaction3;
                        BoxedUnit boxedUnit;
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug("Could not apply tx {}, reason: {}", (Object[])new String[]{tx.id(), err.getMessage()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        Throwable throwable = err;
                        if (throwable instanceof GasLimitReached) {
                            accountTransaction3 = priceAndNonceIter.removeAndSkipAccount();
                        } else {
                            if (throwable instanceof FeeCapTooLowException) {
                                throw new NonLocalReturnControl(object, (Object)new Success((Object)new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips)));
                            }
                            if (throwable instanceof NonceTooLowException) {
                                BoxedUnit boxedUnit2;
                                NonceTooLowException nonceTooLowException = (NonceTooLowException)throwable;
                                if (this.log().underlying().isErrorEnabled()) {
                                    this.log().underlying().error("******** Could not apply tx for NonceTooLowException ******* : {}", new Object[]{nonceTooLowException.getMessage()});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                accountTransaction3 = (AccountTransaction)priceAndNonceIter.next();
                            } else {
                                BoxedUnit boxedUnit3;
                                if (this.log().underlying().isWarnEnabled()) {
                                    this.log().underlying().warn(new StringBuilder(28).append("Could not forge tx, reason: ").append(throwable.getMessage()).toString(), throwable);
                                    boxedUnit3 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                                accountTransaction3 = priceAndNonceIter.removeAndSkipAccount();
                            }
                        }
                        accountTransaction = accountTransaction3;
                    } else {
                        throw new MatchError(try_);
                    }
                    accountTransaction2 = accountTransaction;
                }
                return new Tuple4((Object)receiptList, (Object)listOfTxsInBlock, (Object)cumBaseFee, (Object)cumForgerTips);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                try_ = (Try)ex.value();
            }
            throw ex;
        }
        return try_;
    }

    @Override
    public Try<SidechainBlockBase<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader>> createNewBlock(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo, boolean isWithdrawalEpochLastBlock, String parentId, long timestamp, Seq<MainchainBlockReferenceData> mainchainBlockReferencesData, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> sidechainTransactions, Seq<MainchainHeader> mainchainHeaders, Seq<Ommer<AccountBlockHeader>> ommers, PrivateKey25519 ownerPrivateKey, ForgingStakeInfo forgingStakeInfo, VrfProof vrfProof, VrfOutput vrfOutput, MerklePath forgingStakeInfoMerklePath, DynamicTypedSerializer<AccountTransaction<Proposition, Proof<Proposition>>, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> companion, int inputBlockSize, Option<Signature25519> signatureOption, boolean isPending) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        List<Secret> addressList = ((AbstractWallet)nodeView.vault()).secretsOfType(PrivateKeySecp256k1.class);
        AddressProposition forgerAddress = (AddressProposition)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(addressList).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)x$3 -> (AddressProposition)x$3.publicImage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (!isPending) {
                throw new IllegalArgumentException("No addresses in wallet!");
            }
            return new AddressProposition(Address.ZERO);
        });
        BigInteger baseFee = FeeUtils$.MODULE$.calculateBaseFee((AccountHistory)nodeView.history(), parentId);
        GasFeeFork feeFork = GasFeeFork$.MODULE$.get(TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(super.params().sidechainGenesisBlockTimestamp(), timestamp));
        BigInteger gasLimit = feeFork.blockGasLimit();
        SidechainBlockInfo parentInfo = ((AbstractHistory)nodeView.history()).blockInfoById(parentId);
        BlockContext blockContext = new BlockContext(forgerAddress.address(), timestamp, baseFee, gasLimit, parentInfo.height() + 1, TimeToEpochUtils$.MODULE$.timeStampToEpochNumber(super.params().sidechainGenesisBlockTimestamp(), timestamp), WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mainchainBlockReferencesData.size(), parentInfo.withdrawalEpochInfo(), super.params()).epoch(), super.params().chainId(), (HistoryBlockHashProvider)nodeView.history(), new Hash(vrfOutput.bytes()));
        String string = ((AbstractHistory)nodeView.history()).bestBlockId();
        String string2 = branchPointInfo.branchPointId();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            tuple42 = (Tuple4)this.using(((AccountState)nodeView.state()).getView(), (Function1 & Serializable & scala.Serializable)dummyView -> {
                Seq<AccountPayment> seq;
                Tuple3<Seq<EthereumConsensusDataReceipt>, Seq<AccountTransaction<Proposition, Proof<Proposition>>>, AccountBlockFeeInfo> resultTuple = this.computeBlockInfo((AccountStateView)dummyView, sidechainTransactions, mainchainBlockReferencesData, blockContext, forgerAddress, inputBlockSize);
                Seq receiptList = (Seq)resultTuple._1();
                Seq appliedTxList = (Seq)resultTuple._2();
                AccountBlockFeeInfo currentBlockPayments = (AccountBlockFeeInfo)resultTuple._3();
                if (isWithdrawalEpochLastBlock) {
                    String string = ((AbstractHistory)nodeView.history()).bestBlockId();
                    String string2 = branchPointInfo.branchPointId();
                    Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Last block of the withdrawal epoch expect to be a continuation of the tip.");
                    Predef$.MODULE$.require(ommers.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No Ommers allowed for the last block of the withdrawal epoch.");
                    int withdrawalEpochNumber = WithdrawalEpochUtils$.MODULE$.getWithdrawalEpochInfo(mainchainBlockReferencesData.size(), dummyView.getWithdrawalEpochInfo(), this.super$params()).epoch();
                    Seq<AccountPayment> feePayments = dummyView.getFeePaymentsInfo(withdrawalEpochNumber, (Option<AccountBlockFeeInfo>)new Some((Object)currentBlockPayments));
                    feePayments.foreach((Function1 & Serializable & scala.Serializable)payment -> {
                        dummyView.addBalance(payment.address().address(), payment.value());
                        return BoxedUnit.UNIT;
                    });
                    seq = feePayments;
                } else {
                    seq = (Seq<AccountPayment>)Nil$.MODULE$;
                }
                Seq<AccountPayment> feePayments = seq;
                return new Tuple4((Object)dummyView.getIntermediateRoot(), (Object)receiptList, (Object)appliedTxList, (Object)feePayments);
            });
        } else {
            Predef$.MODULE$.require(ommers.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected ommers when branching point is not the blockchain tip");
            Predef$.MODULE$.require(sidechainTransactions.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No txs expected in a block with ommers");
            Predef$.MODULE$.require(mainchainBlockReferencesData.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No Mainchain reference data expected in a block with ommers");
            tuple42 = tuple4 = new Tuple4((Object)((AccountBlock)((AbstractHistory)nodeView.history()).getBlockById(parentId).get()).header().stateRoot(), (Object)Nil$.MODULE$, (Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        byte[] stateRoot = (byte[])tuple4._1();
        Seq receiptList = (Seq)tuple4._2();
        Seq appliedTxList = (Seq)tuple4._3();
        Seq feePayments = (Seq)tuple4._4();
        Tuple4 tuple43 = new Tuple4((Object)stateRoot, (Object)receiptList, (Object)appliedTxList, (Object)feePayments);
        Tuple4 tuple44 = tuple43;
        byte[] stateRoot2 = (byte[])tuple44._1();
        Seq receiptList2 = (Seq)tuple44._2();
        Seq appliedTxList2 = (Seq)tuple44._3();
        Seq feePayments2 = (Seq)tuple44._4();
        byte[] receiptsRoot = AccountBlock$.MODULE$.calculateReceiptRoot((Seq<EthereumConsensusDataReceipt>)receiptList2);
        BigInteger gasUsed = (BigInteger)receiptList2.lastOption().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.cumulativeGasUsed()).getOrElse((Function0 & Serializable & scala.Serializable)() -> BigInteger.ZERO);
        byte[] feePaymentsHash = AccountFeePaymentsUtils$.MODULE$.calculateFeePaymentsHash((Seq<AccountPayment>)feePayments2);
        Bloom logsBloom = Bloom$.MODULE$.fromReceipts((Seq<EthereumConsensusDataReceipt>)receiptList2);
        Try<AccountBlock> block = AccountBlock$.MODULE$.create(parentId, AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION(), timestamp, mainchainBlockReferencesData, (Seq<AccountTransaction<Proposition, Proof<Proposition>>>)appliedTxList2, mainchainHeaders, ommers, ownerPrivateKey, forgingStakeInfo, vrfProof, vrfOutput, forgingStakeInfoMerklePath, feePaymentsHash, stateRoot2, receiptsRoot, forgerAddress, baseFee, gasUsed, gasLimit, (SidechainAccountTransactionsCompanion)companion, logsBloom, AccountBlock$.MODULE$.create$default$22());
        return block;
    }

    @Override
    public boolean createNewBlock$default$18() {
        return false;
    }

    @Override
    public int precalculateBlockHeaderSize(String parentId, long timestamp, ForgingStakeMerklePathInfo forgingStakeMerklePathInfo, VrfProof vrfProof) {
        AccountBlockHeader header = new AccountBlockHeader(AccountBlock$.MODULE$.ACCOUNT_BLOCK_VERSION(), parentId, timestamp, forgingStakeMerklePathInfo.forgingStakeInfo(), forgingStakeMerklePathInfo.merklePath(), vrfProof, new VrfOutput(new byte[VrfOutput.OUTPUT_LENGTH]), new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], new byte[MerkleTree.ROOT_HASH_LENGTH], AddressProposition.ZERO, BigInteger.ONE.shiftLeft(256).subtract(BigInteger.ONE), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MAX_VALUE), new byte[MerkleTree.ROOT_HASH_LENGTH], Long.MAX_VALUE, new byte[NodeViewModifier$.MODULE$.ModifierIdSize()], new Bloom(), new Signature25519(new byte[Signature25519.SIGNATURE_LENGTH]));
        return header.bytes().length;
    }

    public MempoolMap.TransactionsByPriceAndNonce collectTransactionsFromMemPool(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView, int blockSizeIn, Seq<MainchainBlockReferenceData> mainchainBlockReferenceData, WithdrawalEpochInfo withdrawalEpochInfo, long timestamp, Iterable<AccountTransaction<Proposition, Proof<Proposition>>> forcedTx) {
        return ((AccountMemoryPool)nodeView.pool()).takeExecutableTxs(forcedTx);
    }

    @Override
    public int getOmmersSize(Seq<Ommer<AccountBlockHeader>> ommers) {
        ListSerializer<Ommer<AccountBlockHeader>> ommersSerializer = new ListSerializer<Ommer<AccountBlockHeader>>(AccountOmmerSerializer$.MODULE$);
        return ommersSerializer.toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(ommers).asJava()).length;
    }

    public byte[] getStateRoot(AccountHistory history, long forgedBlockTimestamp, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo) {
        String parentId = branchPointInfo.branchPointId();
        String lastBlockId = history.getLastBlockIdOfPrePreviousEpochs(forgedBlockTimestamp, parentId);
        Optional lastBlock = history.getBlockById(lastBlockId);
        return ((AccountBlock)lastBlock.get()).header().stateRoot();
    }

    public Seq<ForgingStakeMerklePathInfo> getForgingStakeMerklePathInfo(int nextConsensusEpochNumber, AccountWallet wallet, AccountHistory history, AccountState state, AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo, long nextBlockTimestamp) {
        Seq secrets;
        Seq walletPubKeys;
        byte[] stateRoot = this.getStateRoot(history, nextBlockTimestamp, branchPointInfo);
        Seq forgingStakeInfoSeq = (Seq)this.using(state.getStateDbViewFromRoot(stateRoot), (Function1 & Serializable & scala.Serializable)stateViewFromRoot -> stateViewFromRoot.getOrderedForgingStakesInfoSeq());
        Seq filteredForgingStakeInfoSeq = (Seq)forgingStakeInfoSeq.filter(arg_0 -> AccountForgeMessageBuilder.$anonfun$getForgingStakeMerklePathInfo$3$adapted(walletPubKeys = (Seq)(secrets = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allSecrets()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> e.publicImage(), Seq$.MODULE$.canBuildFrom()), arg_0));
        if (filteredForgingStakeInfoSeq.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        MerkleTree forgingStakeInfoTree = MerkleTree.createMerkleTree((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)forgingStakeInfoSeq.map((Function1 & Serializable & scala.Serializable)info -> info.hash(), Seq$.MODULE$.canBuildFrom())).asJava());
        Buffer merkleTreeLeaves = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(forgingStakeInfoTree.leaves()).asScala()).map((Function1 & Serializable & scala.Serializable)leaf -> new ByteArrayWrapper((byte[])leaf), Buffer$.MODULE$.canBuildFrom());
        Seq forgingStakeMerklePathInfoSeq = (Seq)filteredForgingStakeInfoSeq.flatMap((Function1 & Serializable & scala.Serializable)forgingStakeInfo -> {
            Iterable iterable;
            int n = merkleTreeLeaves.indexOf((Object)new ByteArrayWrapper(forgingStakeInfo.hash()));
            switch (n) {
                case -1: {
                    BoxedUnit boxedUnit;
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn("ForgingStakeInfo not a leaf in merkle tree: should never happen: {} ", new Object[]{forgingStakeInfo});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    break;
                }
                default: {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new ForgingStakeMerklePathInfo((ForgingStakeInfo)forgingStakeInfo, forgingStakeInfoTree.getMerklePathForLeaf(n))));
                    break;
                }
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        return forgingStakeMerklePathInfoSeq;
    }

    public Option<AccountBlock> getPendingBlock(NodeViewHolder.CurrentView<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> nodeView) {
        Option option;
        String bestBlockId = ((AbstractHistory)nodeView.history()).bestBlockId();
        AbstractForgeMessageBuilder.BranchPointInfo branchPointInfo = new AbstractForgeMessageBuilder.BranchPointInfo(this, bestBlockId, (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$), (Seq<ByteArrayWrapper>)((Seq)Nil$.MODULE$));
        PrivateKey25519 blockSignPrivateKey = new PrivateKey25519(new byte[PrivateKey25519.PRIVATE_KEY_LENGTH], new byte[PrivateKey25519.PUBLIC_KEY_LENGTH]);
        ForgingStakeInfo forgingStakeInfo = new ForgingStakeInfo(new PublicKey25519Proposition(new byte[PublicKey25519Proposition.KEY_LENGTH]), new VrfPublicKey(new byte[VrfPublicKey.KEY_LENGTH]), 0L);
        ForgingStakeMerklePathInfo forgingStakeMerklePathInfo = new ForgingStakeMerklePathInfo(forgingStakeInfo, new MerklePath(new ArrayList<Pair<Byte, byte[]>>()));
        VrfProof vrfProof = new VrfProof(new byte[VrfProof.PROOF_LENGTH]);
        SidechainBlockInfo bestBlockInfo = ((AbstractHistory)nodeView.history()).blockInfoById(bestBlockId);
        VrfOutput vrfOutput = (VrfOutput)bestBlockInfo.vrfOutputOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> new VrfOutput(new byte[VrfOutput.OUTPUT_LENGTH]));
        Timeout mcRefDataRetrievalTimeout = new Timeout(5L, TimeUnit.SECONDS);
        ForgeResult forgeResult = this.forgeBlock(nodeView, System.currentTimeMillis() / 1000L, branchPointInfo, forgingStakeMerklePathInfo, blockSignPrivateKey, vrfProof, vrfOutput, mcRefDataRetrievalTimeout, (Iterable)Nil$.MODULE$, true);
        if (forgeResult instanceof ForgeSuccess) {
            ForgeSuccess forgeSuccess = (ForgeSuccess)forgeResult;
            Object block = forgeSuccess.block();
            option = Option$.MODULE$.apply((Object)((AccountBlock)block));
        } else if (forgeResult instanceof ForgeFailure) {
            option = Option$.MODULE$.empty();
        } else {
            throw new MatchError((Object)forgeResult);
        }
        return option;
    }

    @Override
    public int getMaxBlockOverheadSize() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_OVERHEAD_SIZE();
    }

    @Override
    public int getMaxBlockSize() {
        return AccountBlock$.MODULE$.MAX_ACCOUNT_BLOCK_SIZE();
    }

    public static final /* synthetic */ void $anonfun$tryApplyAndGetBlockInfo$2(AccountStateView stateView$1, MainchainBlockReferenceData mcBlockRefData) {
        String dummyBlockId = package$.MODULE$.bytesToId(new byte[32]);
        stateView$1.addTopQualityCertificates(mcBlockRefData, dummyBlockId);
        stateView$1.applyMainchainBlockReferenceData(mcBlockRefData);
    }

    public static final /* synthetic */ boolean $anonfun$getForgingStakeMerklePathInfo$3(Seq walletPubKeys$1, ForgingStakeInfo p) {
        return walletPubKeys$1.contains((Object)p.blockSignPublicKey()) && walletPubKeys$1.contains((Object)p.vrfPublicKey());
    }

    public AccountForgeMessageBuilder(MainchainSynchronizer mainchainSynchronizer, SidechainAccountTransactionsCompanion companion, NetworkParams params, boolean allowNoWebsocketConnectionInRegtest) {
        super(mainchainSynchronizer, companion, params, allowNoWebsocketConnectionInRegtest);
        ClosableResourceHandler.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$getForgingStakeMerklePathInfo$3$adapted(Seq walletPubKeys$1, ForgingStakeInfo p) {
        return BoxesRunTime.boxToBoolean((boolean)AccountForgeMessageBuilder.$anonfun$getForgingStakeMerklePathInfo$3(walletPubKeys$1, p));
    }
}

