/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.horizen.account.api.rpc.handler.RpcException;
import io.horizen.account.api.rpc.utils.RpcCode;
import io.horizen.account.api.rpc.utils.RpcError;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class FilterQuery {
    public final Hash blockHash;
    public final String fromBlock;
    public final String toBlock;
    @JsonDeserialize(using=AddressFilterDeserializer.class)
    public final Address[] address;
    @JsonDeserialize(using=TopicFilterDeserializer.class)
    public final Hash[][] topics;

    public FilterQuery(@JsonProperty(value="blockHash") Hash blockHash, @JsonProperty(value="fromBlock") String fromBlock, @JsonProperty(value="toBlock") String toBlock, @JsonProperty(value="address") Address[] address, @JsonProperty(value="topics") Hash[][] topics) throws RpcException {
        if (blockHash != null && (fromBlock != null || toBlock != null)) {
            throw new RpcException(RpcError.fromCode(RpcCode.InvalidParams, "cannot specify both BlockHash and FromBlock/ToBlock, choose one or the other"));
        }
        if (blockHash == null) {
            if (fromBlock == null) {
                fromBlock = "earliest";
            }
            if (toBlock == null) {
                toBlock = "latest";
            }
        }
        this.blockHash = blockHash;
        this.fromBlock = fromBlock;
        this.toBlock = toBlock;
        this.address = Objects.requireNonNullElse(address, new Address[0]);
        this.topics = Objects.requireNonNullElse(topics, new Hash[0][0]);
    }

    public String toString() {
        return String.format("FilterQuery{fromBlock='%s', toBlock='%s', addresses=%s, topics=%s, blockHash=%s}", this.fromBlock, this.toBlock, Arrays.toString(this.address), Arrays.toString((Object[])this.topics), this.blockHash);
    }

    private static class TopicFilterDeserializer
    extends JsonDeserializer<Hash[][]> {
        private TopicFilterDeserializer() {
        }

        public Hash[][] deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (!node.isArray()) {
                throw new IOException("invalid topic filter, expected an array");
            }
            if (node.size() == 0) {
                return new Hash[0][0];
            }
            Hash[][] topics = new Hash[node.size()][];
            block5: for (int i = 0; i < node.size(); ++i) {
                JsonNode topic = node.get(i);
                switch (topic.getNodeType()) {
                    case NULL: {
                        topics[i] = new Hash[0];
                        continue block5;
                    }
                    case STRING: {
                        topics[i] = new Hash[]{(Hash)context.readTreeAsValue(topic, Hash.class)};
                        continue block5;
                    }
                    case ARRAY: {
                        topics[i] = new Hash[topic.size()];
                        for (int j = 0; j < topic.size(); ++j) {
                            JsonNode subTopic = topic.get(j);
                            if (subTopic.isNull()) {
                                topics[i] = new Hash[0];
                                continue block5;
                            }
                            if (!subTopic.isTextual()) {
                                throw new IOException("invalid topic(s)");
                            }
                            topics[i][j] = (Hash)context.readTreeAsValue(subTopic, Hash.class);
                        }
                        continue block5;
                    }
                    default: {
                        throw new IOException("invalid topic(s)");
                    }
                }
            }
            return topics;
        }
    }

    private static class AddressFilterDeserializer
    extends JsonDeserializer<Address[]> {
        private AddressFilterDeserializer() {
        }

        public Address[] deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            switch (node.getNodeType()) {
                case STRING: {
                    try {
                        return new Address[]{(Address)context.readTreeAsValue(node, Address.class)};
                    }
                    catch (Exception err) {
                        throw new IOException(String.format("invalid address: %s", err.getMessage()), err);
                    }
                }
                case ARRAY: {
                    Address[] addresses = new Address[node.size()];
                    for (int i = 0; i < node.size(); ++i) {
                        JsonNode address = node.get(i);
                        if (address.getNodeType() != JsonNodeType.STRING) {
                            throw new IOException(String.format("non-string address at index %d", i));
                        }
                        try {
                            addresses[i] = (Address)context.readTreeAsValue(address, Address.class);
                            continue;
                        }
                        catch (Exception err) {
                            throw new IOException(String.format("invalid address at index %d: %s", i, err.getMessage()), err);
                        }
                    }
                    return addresses;
                }
            }
            throw new IOException("invalid addresses in query");
        }
    }
}

