/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.evm.Address;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import scala.collection.JavaConverters;

public class FeePaymentsView {
    public final List<FeePaymentData> payments;

    public FeePaymentsView(AccountFeePaymentsInfo info) {
        this.payments = JavaConverters.seqAsJavaList(info.payments()).stream().map(payment -> new FeePaymentData(payment.address().address(), payment.value())).collect(Collectors.toList());
    }

    private static class FeePaymentData {
        public final Address address;
        public final BigInteger value;

        public FeePaymentData(Address address, BigInteger value) {
            this.address = address;
            this.value = value;
        }
    }
}

