/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account.api.rpc.types;

import io.horizen.account.api.rpc.types.EthereumTransactionView;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.state.receipt.EthereumReceipt;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountBlockUtil;
import io.horizen.evm.Address;
import io.horizen.evm.Hash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.web3j.utils.Numeric;

public class EthereumBlockView {
    public final BigInteger number;
    public final Hash hash;
    public final Hash parentHash;
    public final byte[] logsBloom;
    public final Hash transactionsRoot;
    public final Hash stateRoot;
    public final Hash receiptsRoot;
    public final Address miner;
    public final BigInteger size;
    public final BigInteger gasLimit;
    public final BigInteger gasUsed;
    public final BigInteger timestamp;
    public final List<?> transactions;
    public final BigInteger baseFeePerGas;
    public final Hash mixHash;
    public final Hash[] uncles = new Hash[0];
    public final String difficulty = "0x0";
    public final String totalDifficulty = "0x0";
    public final String nonce = "0x0000000000000000";
    public final String sha3Uncles = "0x0000000000000000000000000000000000000000000000000000000000000000";
    public final String extraData = "0x0000000000000000000000000000000000000000000000000000000000000000";

    private EthereumBlockView(Long blockNumber, Hash blockHash, AccountBlock block, List<?> txs) {
        AccountBlockHeader header = block.header();
        this.number = BigInteger.valueOf(blockNumber);
        this.hash = blockHash;
        this.parentHash = new Hash(Numeric.prependHexPrefix((String)header.parentId()));
        this.logsBloom = header.logsBloom().getBytes();
        this.transactionsRoot = new Hash(header.sidechainTransactionsMerkleRootHash());
        this.stateRoot = new Hash(header.stateRoot());
        this.receiptsRoot = new Hash(header.receiptsRoot());
        this.miner = header.forgerAddress().address();
        this.size = BigInteger.valueOf(block.bytes().length);
        this.gasLimit = header.gasLimit();
        this.gasUsed = header.gasUsed();
        this.timestamp = BigInteger.valueOf(block.timestamp());
        this.baseFeePerGas = header.baseFee();
        this.transactions = txs;
        this.mixHash = new Hash(header.vrfOutput().bytes());
    }

    public static EthereumBlockView notHydrated(Long blockNumber, Hash blockHash, AccountBlock block) {
        List<EthereumTransaction> transactions = AccountBlockUtil.ethereumTransactions(block);
        List txHashes = transactions.stream().map(t -> Numeric.prependHexPrefix((String)t.id())).collect(Collectors.toList());
        return new EthereumBlockView(blockNumber, blockHash, block, txHashes);
    }

    public static EthereumBlockView hydrated(Long blockNumber, Hash blockHash, AccountBlock block, List<EthereumReceipt> receipts) {
        List<EthereumTransaction> transactions = AccountBlockUtil.ethereumTransactions(block);
        assert (transactions.size() == receipts.size());
        List txViews = IntStream.range(0, transactions.size()).mapToObj(i -> new EthereumTransactionView((EthereumTransaction)transactions.get(i), (EthereumReceipt)receipts.get(i), block.header().baseFee())).collect(Collectors.toList());
        return new EthereumBlockView(blockNumber, blockHash, block, txViews);
    }

    public static EthereumBlockView withoutTransactions(Long blockNumber, Hash blockHash, AccountBlock block) {
        return new EthereumBlockView(blockNumber, blockHash, block, new ArrayList());
    }
}

