/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import io.horizen.AbstractSidechainNodeViewHolder;
import io.horizen.SidechainSettings;
import io.horizen.account.block.AccountBlock;
import io.horizen.account.block.AccountBlockHeader;
import io.horizen.account.chain.AccountFeePaymentsInfo;
import io.horizen.account.history.AccountHistory;
import io.horizen.account.history.AccountHistory$;
import io.horizen.account.history.validation.BaseFeeBlockValidator;
import io.horizen.account.history.validation.ChainIdBlockSemanticValidator;
import io.horizen.account.mempool.AccountMemoryPool;
import io.horizen.account.mempool.AccountMemoryPool$;
import io.horizen.account.node.AccountNodeView;
import io.horizen.account.node.NodeAccountHistory;
import io.horizen.account.node.NodeAccountMemoryPool;
import io.horizen.account.node.NodeAccountState;
import io.horizen.account.state.AccountEventNotifier;
import io.horizen.account.state.AccountState;
import io.horizen.account.state.AccountState$;
import io.horizen.account.state.AccountStateReader;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.state.MessageProcessorUtil$;
import io.horizen.account.storage.AccountHistoryStorage;
import io.horizen.account.storage.AccountStateMetadataStorage;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.account.utils.AccountPayment;
import io.horizen.account.wallet.AccountWallet;
import io.horizen.account.wallet.AccountWallet$;
import io.horizen.consensus.ConsensusDataStorage;
import io.horizen.consensus.ConsensusEpochInfo;
import io.horizen.consensus.StakeConsensusEpochInfo;
import io.horizen.evm.Database;
import io.horizen.history.AbstractHistory;
import io.horizen.history.validation.HistoryBlockValidator;
import io.horizen.history.validation.SemanticBlockValidator;
import io.horizen.node.NodeWalletBase;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.state.BaseStateReader;
import io.horizen.storage.AbstractHistoryStorage;
import io.horizen.storage.SidechainSecretStorage;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.utils.ByteArrayWrapper;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.core.network.NodeViewSynchronizer;
import sparkz.core.package$;
import sparkz.core.utils.NetworkTimeProvider;

@ScalaSignature(bytes="\u0006\u0001\r5e\u0001\u0002\u001e<\u0001\tC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A!\u000f\u0001B\u0001B\u0003%1\u000f\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003\u007f\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003/\u0001!\u0011!Q\u0001\n\u0005e\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011Q\u0006\u0001\u0003\u0002\u0003\u0006I!a\f\t\u0015\u0005E\u0003A!A!\u0002\u0013\t\u0019\u0006C\u0005\u0002^\u0001\u0011\t\u0011)A\u0005?\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005T!BA>\u0001\u0001rXABA?\u0001\u0001\ny(\u0002\u0004\u0002\f\u0002\u0001\u0013QR\u0003\u0007\u0003'\u0003\u0001%!&\u0006\r\u0005\u0005\u0006\u0001IAR\u000b\u0019\ty\u000b\u0001\u0011\u00022\u00161\u0011Q\u0018\u0001!\u0003\u007fCq!a3\u0001\t#\ti\rC\u0004\u0002R\u0002!\t%a5\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u0011Q\u001f\u0001\u0005B\u0005]\bb\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u0005;\u0001A\u0011\u000bB\u0010\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GAqA!\u0011\u0001\t\u0003\u0012\u0019\u0005C\u0004\u0003N\u0001!\tEa\u0014\t\u000f\t}\u0003\u0001\"\u0015\u0003b!I!1\r\u0001C\u0002\u0013\u0005#Q\r\u0005\t\u0005_\u0002\u0001\u0015!\u0003\u0003h!9!\u0011\u000f\u0001\u0005R\tM\u0004b\u0002BC\u0001\u0011E#q\u0011\u0005\b\u00053\u0003A\u0011\tBN\u000f\u001d\u0011\tk\u000fE\u0001\u0005G3aAO\u001e\t\u0002\t\u0015\u0006bBA0G\u0011\u0005!Q\u0016\u0004\u0007\u0005_\u001b\u0003I!-\t\u0015\t\u0015XE!f\u0001\n\u0003\u00119\u000f\u0003\u0006\u0003j\u0016\u0012\t\u0012)A\u0005\u0005\u007fBq!a\u0018&\t\u0003\u0011Y\u000fC\u0005\u0003t\u0016\n\t\u0011\"\u0001\u0003v\"I!\u0011`\u0013\u0012\u0002\u0013\u0005!1 \u0005\n\u0007#)\u0013\u0011!C!\u0007'A\u0011ba\t&\u0003\u0003%\ta!\n\t\u0013\r\u001dR%!A\u0005\u0002\r%\u0002\"CB\u001bK\u0005\u0005I\u0011IB\u001c\u0011%\u0019)%JA\u0001\n\u0003\u00199\u0005C\u0005\u0004R\u0015\n\t\u0011\"\u0011\u0004T!I1QK\u0013\u0002\u0002\u0013\u00053q\u000b\u0005\n\u00073*\u0013\u0011!C!\u00077:\u0011ba\u0018$\u0003\u0003E\ta!\u0019\u0007\u0013\t=6%!A\t\u0002\r\r\u0004bBA0i\u0011\u00051\u0011\u000f\u0005\n\u0007+\"\u0014\u0011!C#\u0007/B\u0011ba\u001d5\u0003\u0003%\ti!\u001e\t\u0013\reD'!A\u0005\u0002\u000em\u0004\"CBBi\u0005\u0005I\u0011BBC\u0005y\t5mY8v]R\u001c\u0016\u000eZ3dQ\u0006LgNT8eKZKWm\u001e%pY\u0012,'O\u0003\u0002={\u00059\u0011mY2pk:$(B\u0001 @\u0003\u001dAwN]5{K:T\u0011\u0001Q\u0001\u0003S>\u001c\u0001aE\u0002\u0001\u0007\n\u0004R\u0001R#H3~k\u0011!P\u0005\u0003\rv\u0012q$\u00112tiJ\f7\r^*jI\u0016\u001c\u0007.Y5o\u001d>$WMV5fo\"{G\u000eZ3s!\u0011A5*T*\u000e\u0003%S!AS\u001e\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003\u0019&\u0013!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B\u0011a*U\u0007\u0002\u001f*\u0011\u0001+P\u0001\faJ|\u0007o\\:ji&|g.\u0003\u0002S\u001f\nY\u0001K]8q_NLG/[8o!\r!v+T\u0007\u0002+*\u0011a+P\u0001\u0006aJ|wNZ\u0005\u00031V\u0013Q\u0001\u0015:p_\u001a\u0004\"AW/\u000e\u0003mS!\u0001X\u001e\u0002\u000b\tdwnY6\n\u0005y[&AE!dG>,h\u000e\u001e\"m_\u000e\\\u0007*Z1eKJ\u0004\"A\u00171\n\u0005\u0005\\&\u0001D!dG>,h\u000e\u001e\"m_\u000e\\\u0007CA2g\u001b\u0005!'BA3<\u0003\u0015\u0019H/\u0019;f\u0013\t9GM\u0001\u000bBG\u000e|WO\u001c;Fm\u0016tGOT8uS\u001aLWM]\u0001\u0012g&$Wm\u00195bS:\u001cV\r\u001e;j]\u001e\u001c\bC\u0001#k\u0013\tYWHA\tTS\u0012,7\r[1j]N+G\u000f^5oON\fa\u0001]1sC6\u001c\bC\u00018q\u001b\u0005y'B\u00017>\u0013\t\txNA\u0007OKR<xN]6QCJ\fWn]\u0001\ri&lW\r\u0015:pm&$WM\u001d\t\u0003inl\u0011!\u001e\u0006\u0003m^\fQ!\u001e;jYNT!\u0001_=\u0002\t\r|'/\u001a\u0006\u0002u\u000611\u000f]1sWjL!\u0001`;\u0003'9+Go^8sWRKW.\u001a)s_ZLG-\u001a:\u0002\u001d!L7\u000f^8ssN#xN]1hKB\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002w\u000591\u000f^8sC\u001e,\u0017\u0002BA\u0004\u0003\u0003\u0011Q#Q2d_VtG\u000fS5ti>\u0014\u0018p\u0015;pe\u0006<W-\u0001\u000bd_:\u001cXM\\:vg\u0012\u000bG/Y*u_J\fw-\u001a\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u001f\u0002\u0013\r|gn]3ogV\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011AcQ8og\u0016t7/^:ECR\f7\u000b^8sC\u001e,\u0017\u0001F:uCR,W*\u001a;bI\u0006$\u0018m\u0015;pe\u0006<W\rE\u0002\u0000\u00037IA!!\b\u0002\u0002\tY\u0012iY2pk:$8\u000b^1uK6+G/\u00193bi\u0006\u001cFo\u001c:bO\u0016\fab\u001d;bi\u0016$%m\u0015;pe\u0006<W\r\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9#P\u0001\u0004KZl\u0017\u0002BA\u0016\u0003K\u0011\u0001\u0002R1uC\n\f7/Z\u0001\u0018GV\u001cHo\\7NKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004b!!\r\u0002F\u0005-c\u0002BA\u001a\u0003\u007fqA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\t\u0015A\u0002\u001fs_>$h(\u0003\u0002\u0002>\u0005)1oY1mC&!\u0011\u0011IA\"\u0003\u001d\u0001\u0018mY6bO\u0016T!!!\u0010\n\t\u0005\u001d\u0013\u0011\n\u0002\u0004'\u0016\f(\u0002BA!\u0003\u0007\u00022aYA'\u0013\r\ty\u0005\u001a\u0002\u0011\u001b\u0016\u001c8/Y4f!J|7-Z:t_J\fQb]3de\u0016$8\u000b^8sC\u001e,\u0007\u0003BA+\u00033j!!a\u0016\u000b\u0007\u0005\rQ(\u0003\u0003\u0002\\\u0005]#AF*jI\u0016\u001c\u0007.Y5o'\u0016\u001c'/\u001a;Ti>\u0014\u0018mZ3\u0002\u0019\u001d,g.Z:jg\ncwnY6\u0002\rqJg.\u001b;?)Y\t\u0019'a\u001a\u0002j\u0005-\u0014QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u0004cAA3\u00015\t1\bC\u0003i\u0017\u0001\u0007\u0011\u000eC\u0003m\u0017\u0001\u0007Q\u000eC\u0003s\u0017\u0001\u00071\u000fC\u0003~\u0017\u0001\u0007a\u0010C\u0004\u0002\n-\u0001\r!a\u0003\t\u000f\u0005]1\u00021\u0001\u0002\u001a!9\u0011qD\u0006A\u0002\u0005\u0005\u0002bBA\u0017\u0017\u0001\u0007\u0011q\u0006\u0005\b\u0003#Z\u0001\u0019AA*\u0011\u0019\tif\u0003a\u0001?\n)\u0001j\u0015+P%\n\u0019\u0001*S*\u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"<\u0003\u001dA\u0017n\u001d;pefLA!!#\u0002\u0004\nq\u0011iY2pk:$\b*[:u_JL(AA'T!\r\u0019\u0017qR\u0005\u0004\u0003##'\u0001D!dG>,h\u000e^*uCR,'A\u0001,M!\u0011\t9*!(\u000e\u0005\u0005e%bAANw\u00051q/\u00197mKRLA!a(\u0002\u001a\ni\u0011iY2pk:$x+\u00197mKR\u0014!!\u0014)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+<\u0003\u001diW-\u001c9p_2LA!!,\u0002(\n\t\u0012iY2pk:$X*Z7pef\u0004vn\u001c7\u0003\u0007\u0019\u0003\u0016\n\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9lO\u0001\u0006G\"\f\u0017N\\\u0005\u0005\u0003w\u000b)L\u0001\fBG\u000e|WO\u001c;GK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p\u0005\tqe\u000b\u0005\u0003\u0002B\u0006\u001dWBAAb\u0015\r\t)mO\u0001\u0005]>$W-\u0003\u0003\u0002J\u0006\r'aD!dG>,h\u000e\u001e(pI\u00164\u0016.Z<\u0002#5,7o]1hKB\u0013xnY3tg>\u00148\u000f\u0006\u0003\u00020\u0005=\u0007\"\u00027\u0014\u0001\u0004i\u0017aF:f[\u0006tG/[2CY>\u001c7NV1mS\u0012\fGo\u001c:t)\u0011\t).!:\u0011\r\u0005E\u0012QIAl!\u0015\tI.!9`\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0017A\u0003<bY&$\u0017\r^5p]*\u0019\u0011QQ\u001f\n\t\u0005\r\u00181\u001c\u0002\u0017'\u0016l\u0017M\u001c;jG\ncwnY6WC2LG-\u0019;pe\")A\u000e\u0006a\u0001[\u00061\u0002.[:u_JL(\t\\8dWZ\u000bG.\u001b3bi>\u00148\u000f\u0006\u0003\u0002l\u0006M\bCBA\u0019\u0003\u000b\ni\u000f\u0005\u0007\u0002Z\u0006=x)W0\u00022z\fy(\u0003\u0003\u0002r\u0006m'!\u0006%jgR|'/\u001f\"m_\u000e\\g+\u00197jI\u0006$xN\u001d\u0005\u0006YV\u0001\r!\\\u0001\u0018G\",7m[!oIJ+7m\u001c<feN#xN]1hKN$B!!?\u0003\bA1\u00111`A\u007f\u0005\u0003i!!a\u0011\n\t\u0005}\u00181\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0019\u0005m(1AA@\u0003\u001b\u000b)*a)\n\t\t\u0015\u00111\t\u0002\u0007)V\u0004H.\u001a\u001b\t\u000f\t%a\u00031\u0001\u0002z\u0006a!/Z:u_J,G\rR1uC\u0006a!/Z:u_J,7\u000b^1uKR\u0011!q\u0002\t\u0007\u0003w\fiP!\u0005\u0011\u0019\u0005m(1\u0001B\n\u0005/\u0011IBa\u0007\u0011\u0007\tUQ\"D\u0001\u0001!\r\u0011)B\u0004\t\u0004\u0005+y\u0001c\u0001B\u000b!\u0005aq-\u001a8fg&\u001c8\u000b^1uKV\u0011!\u0011C\u0001\u0012E2|7m\u001b%bg\"\u0004&o\u001c<jI\u0016\u0014H\u0003\u0002B\u0013\u0005o\u0001b!a?\u0002~\n\u001d\u0002\u0003\u0002B\u0015\u0005cqAAa\u000b\u0003.A!\u0011QGA\"\u0013\u0011\u0011y#a\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019D!\u000e\u0003\rM#(/\u001b8h\u0015\u0011\u0011y#a\u0011\t\u000f\te\u0012\u00041\u0001\u0003<\u00051\u0001.Z5hQR\u0004B!a?\u0003>%!!qHA\"\u0005\rIe\u000e^\u0001\u0013O\u0016$h)Z3QCflWM\u001c;t\u0013:4w\u000e\u0006\u0004\u0003F\t\u001d#\u0011\n\t\u0004\u0005+\t\u0002BB3\u001b\u0001\u0004\u00119\u0002C\u0004\u0003Li\u0001\rAa\u000f\u0002\u0017\u0015\u0004xn\u00195Ok6\u0014WM]\u0001\u0018O\u0016$8kY1o!\u0016\u00148/[:uK:$x+\u00197mKR$\"B!\u0007\u0003R\tU#1\fB/\u0011\u0019\u0011\u0019f\u0007a\u0001?\u0006QQn\u001c3U_\u0006\u0003\b\u000f\\=\t\u000f\t]3\u00041\u0001\u0003Z\u000591\u000f^1uK>\u0003\bCBA~\u0003{\u00149\u0002C\u0004\u0003Lm\u0001\rAa\u000f\t\u000f\u0005m5\u00041\u0001\u0003\u001a\u0005Yq-\u001a;O_\u0012,g+[3x)\t\ty,A\tmSN$xJZ*u_J\fw-Z%oM>,\"Aa\u001a\u0011\r\u0005E\u0012Q\tB5!\u0011\t)Fa\u001b\n\t\t5\u0014q\u000b\u0002\u0015'&$Wm\u00195bS:\u001cFo\u001c:bO\u0016LeNZ8\u0002%1L7\u000f^(g'R|'/Y4f\u0013:4w\u000eI\u0001\"CB\u0004H.\u001f'pG\u0006dG._$f]\u0016\u0014\u0018\r^3e)J\fgn]1di&|gn\u001d\u000b\u0005\u0005k\u0012Y\b\u0005\u0003\u0002|\n]\u0014\u0002\u0002B=\u0003\u0007\u0012A!\u00168ji\"9!QP\u0010A\u0002\t}\u0014A\u00028foRC8\u000fE\u0003\u00022\t\u0005u)\u0003\u0003\u0003\u0004\u0006%#\u0001C%uKJ\f'\r\\3\u0002\u001bU\u0004H-\u0019;f\u001b\u0016l\u0007k\\8m))\u0011YB!#\u0003\u0010\nM%q\u0013\u0005\b\u0005\u0017\u0003\u0003\u0019\u0001BG\u00035\u0011X-\\8wK\u0012\u0014En\\2lgB)\u0011\u0011GA#?\"9!\u0011\u0013\u0011A\u0002\t5\u0015!D1qa2LW\r\u001a\"m_\u000e\\7\u000fC\u0004\u0003\u0016\u0002\u0002\rAa\u0007\u0002\u000f5,W\u000eU8pY\"1Q\r\ta\u0001\u0005/\t1c]3oI:+w/\u0012=fGRC8/\u0012<f]R$BA!\u001e\u0003\u001e\"9!qT\u0011A\u0002\t}\u0014\u0001\u00057jgR|eMT3x\u000bb,7\r\u0016=t\u0003y\t5mY8v]R\u001c\u0016\u000eZ3dQ\u0006LgNT8eKZKWm\u001e%pY\u0012,'\u000fE\u0002\u0002f\r\u001a2a\tBT!\u0011\tYP!+\n\t\t-\u00161\t\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\r&\u0001\u0007(fo\u0016CXm\u0019+sC:\u001c\u0018m\u0019;j_:\u001cXI^3oiNIQEa*\u00034\ne'q\u001c\t\u0005\u0005k\u0013\u0019N\u0004\u0003\u00038\n5g\u0002\u0002B]\u0005\u000ftAAa/\u0003D:!!Q\u0018Ba\u001d\u0011\t)Da0\n\u0003iL!\u0001_=\n\u0007\t\u0015w/A\u0004oKR<xN]6\n\t\t%'1Z\u0001\u0015\u001d>$WMV5foNKhn\u00195s_:L'0\u001a:\u000b\u0007\t\u0015w/\u0003\u0003\u0003P\nE\u0017A\u0005*fG\u0016Lg/\u00192mK6+7o]1hKNTAA!3\u0003L&!!Q\u001bBl\u0005Mqu\u000eZ3WS\u0016<\bj\u001c7eKJ,e/\u001a8u\u0015\u0011\u0011yM!5\u0011\t\u0005m(1\\\u0005\u0005\u0005;\f\u0019EA\u0004Qe>$Wo\u0019;\u0011\t\u0005m(\u0011]\u0005\u0005\u0005G\f\u0019E\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006oK^,\u00050Z2UqN,\"Aa \u0002\u00179,w/\u0012=fGRC8\u000f\t\u000b\u0005\u0005[\u0014\t\u0010E\u0002\u0003p\u0016j\u0011a\t\u0005\b\u0005KD\u0003\u0019\u0001B@\u0003\u0011\u0019w\u000e]=\u0015\t\t5(q\u001f\u0005\n\u0005KL\u0003\u0013!a\u0001\u0005\u007f\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003~*\"!q\u0010B\u0000W\t\u0019\t\u0001\u0005\u0003\u0004\u0004\r5QBAB\u0003\u0015\u0011\u00199a!\u0003\u0002\u0013Ut7\r[3dW\u0016$'\u0002BB\u0006\u0003\u0007\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0019ya!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007+\u0001Baa\u0006\u0004\"5\u00111\u0011\u0004\u0006\u0005\u00077\u0019i\"\u0001\u0003mC:<'BAB\u0010\u0003\u0011Q\u0017M^1\n\t\tM2\u0011D\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005w\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004,\rE\u0002\u0003BA~\u0007[IAaa\f\u0002D\t\u0019\u0011I\\=\t\u0013\rMR&!AA\u0002\tm\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004:A111HB!\u0007Wi!a!\u0010\u000b\t\r}\u00121I\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB\"\u0007{\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!1\u0011JB(!\u0011\tYpa\u0013\n\t\r5\u00131\t\u0002\b\u0005>|G.Z1o\u0011%\u0019\u0019dLA\u0001\u0002\u0004\u0019Y#\u0001\u0005iCND7i\u001c3f)\t\u0011Y$\u0001\u0005u_N#(/\u001b8h)\t\u0019)\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0007\u0013\u001ai\u0006C\u0005\u00044I\n\t\u00111\u0001\u0004,\u0005Ab*Z<Fq\u0016\u001cGK]1og\u0006\u001cG/[8og\u00163XM\u001c;\u0011\u0007\t=HgE\u00035\u0007K\u0012y\u000e\u0005\u0005\u0004h\r5$q\u0010Bw\u001b\t\u0019IG\u0003\u0003\u0004l\u0005\r\u0013a\u0002:v]RLW.Z\u0005\u0005\u0007_\u001aIGA\tBEN$(/Y2u\rVt7\r^5p]F\"\"a!\u0019\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t58q\u000f\u0005\b\u0005K<\u0004\u0019\u0001B@\u0003\u001d)h.\u00199qYf$Ba! \u0004\u0000A1\u00111`A\u007f\u0005\u007fB\u0011b!!9\u0003\u0003\u0005\rA!<\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCABD!\u0011\u00199b!#\n\t\r-5\u0011\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class AccountSidechainNodeViewHolder
extends AbstractSidechainNodeViewHolder<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock>
implements AccountEventNotifier {
    private final SidechainSettings sidechainSettings;
    private final NetworkParams params;
    private final NetworkTimeProvider timeProvider;
    private final AccountHistoryStorage historyStorage;
    private final ConsensusDataStorage consensusDataStorage;
    private final AccountStateMetadataStorage stateMetadataStorage;
    private final Database stateDbStorage;
    private final Seq<MessageProcessor> customMessageProcessors;
    private final SidechainSecretStorage secretStorage;
    private final AccountBlock genesisBlock;
    private final Seq<SidechainStorageInfo> listOfStorageInfo;

    public Seq<MessageProcessor> messageProcessors(NetworkParams params) {
        return MessageProcessorUtil$.MODULE$.getMessageProcessorSeq(params, this.customMessageProcessors);
    }

    @Override
    public Seq<SemanticBlockValidator<AccountBlock>> semanticBlockValidators(NetworkParams params) {
        return (Seq)super.semanticBlockValidators(params).$colon$plus((Object)new ChainIdBlockSemanticValidator(params), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<HistoryBlockValidator<AccountTransaction<Proposition, Proof<Proposition>>, AccountBlockHeader, AccountBlock, AccountFeePaymentsInfo, AccountHistoryStorage, AccountHistory>> historyBlockValidators(NetworkParams params) {
        return (Seq)super.historyBlockValidators(params).$colon$plus((Object)new BaseFeeBlockValidator(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> checkAndRecoverStorages(Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> restoredData) {
        return restoredData.flatMap((Function1 & Serializable & scala.Serializable)dataOpt -> {
            Some some;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            this.dumpStorages();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Checking state consistency...");
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            AccountHistory restoredHistory = (AccountHistory)dataOpt._1();
            AccountState restoredState = (AccountState)dataOpt._2();
            AccountWallet restoredWallet = (AccountWallet)dataOpt._3();
            AccountMemoryPool restoredMempool = (AccountMemoryPool)dataOpt._4();
            String historyVersion = restoredHistory.bestBlockId();
            String checkedStateVersion = sparkz.util.package$.MODULE$.bytesToId(((ByteArrayWrapper)$this.stateMetadataStorage.lastVersionId().get()).data());
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("history bestBlockId = {}, stateVersion = {}", (Object[])new String[]{historyVersion, checkedStateVersion});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            int height_h = restoredHistory.blockInfoById(restoredHistory.bestBlockId()).height();
            int height_s = restoredHistory.blockInfoById(checkedStateVersion).height();
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug("history height = {}, state height = {}", new Object[]{BoxesRunTime.boxToInteger((int)height_h), BoxesRunTime.boxToInteger((int)height_s)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            String string = historyVersion;
            String string2 = checkedStateVersion;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit4;
                if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("state and history storages are consistent");
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                some = new Some((Object)new Tuple4((Object)restoredHistory, (Object)restoredState, (Object)restoredWallet, (Object)restoredMempool));
            } else {
                None$ none$;
                BoxedUnit boxedUnit5;
                if (this.log().underlying().isWarnEnabled()) {
                    this.log().underlying().warn("Inconsistent state and history storages, trying to recover...");
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                Option<Seq<String>> option = restoredHistory.chainBack(checkedStateVersion, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)blockId -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$checkAndRecoverStorages$2(restoredHistory, blockId)), Integer.MAX_VALUE);
                if (option instanceof Some) {
                    None$ none$2;
                    BoxedUnit boxedUnit6;
                    BoxedUnit boxedUnit7;
                    Some some2 = (Some)option;
                    Seq nonChainSuffix = (Seq)some2.value();
                    if (this.log().underlying().isInfoEnabled()) {
                        this.log().underlying().info("sequence of blocks not in active chain (root included) = {}", new Object[]{nonChainSuffix});
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    String rollbackTo2 = (String)nonChainSuffix.head();
                    ((TraversableLike)nonChainSuffix.tail()).headOption().foreach((Function1 & Serializable & scala.Serializable)childBlock -> {
                        AccountSidechainNodeViewHolder.$anonfun$checkAndRecoverStorages$3(this, restoredHistory, childBlock);
                        return BoxedUnit.UNIT;
                    });
                    if (this.log().underlying().isWarnEnabled()) {
                        this.log().underlying().warn("Inconsistent storage and history, rolling back state to history best block id = {}", new Object[]{rollbackTo2});
                        boxedUnit6 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit6 = BoxedUnit.UNIT;
                    }
                    Try<AccountState> try_ = restoredState.rollbackTo(package$.MODULE$.idToVersion(rollbackTo2));
                    if (try_ instanceof Success) {
                        BoxedUnit boxedUnit8;
                        Success success = (Success)try_;
                        AccountState s = (AccountState)success.value();
                        if (this.log().underlying().isDebugEnabled()) {
                            this.log().underlying().debug("State successfully rolled back");
                            boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit8 = BoxedUnit.UNIT;
                        }
                        this.dumpStorages();
                        none$2 = new Some((Object)new Tuple4((Object)restoredHistory, (Object)s, (Object)restoredWallet, (Object)restoredMempool));
                    } else if (try_ instanceof Failure) {
                        BoxedUnit boxedUnit9;
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error("State roll back failed: ", e);
                            boxedUnit9 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit9 = BoxedUnit.UNIT;
                        }
                        this.context().system().eventStream().publish((Object)NodeViewSynchronizer.ReceivableMessages$.RollbackFailed$.MODULE$);
                        none$2 = None$.MODULE$;
                    } else {
                        throw new MatchError(try_);
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit10;
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Could not recover storages inconsistency, could not find a rollback point in history");
                        boxedUnit10 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit10 = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                some = none$;
            }
            return some;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> restoreState() {
        void var2_2;
        BoxedUnit boxedUnit;
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("Restoring persistent state from storage...");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option restoredData = AccountHistory$.MODULE$.restoreHistory(this.historyStorage, this.consensusDataStorage, this.params, this.semanticBlockValidators(this.params), this.historyBlockValidators(this.params)).flatMap((Function1 & Serializable & scala.Serializable)history -> AccountState$.MODULE$.restoreState($this.stateMetadataStorage, $this.stateDbStorage, this.messageProcessors($this.params), $this.params, $this.timeProvider, height -> this.blockHashProvider(height)).flatMap((Function1 & Serializable & scala.Serializable)state -> AccountWallet$.MODULE$.restoreWallet($this.sidechainSettings.wallet().seed().getBytes(StandardCharsets.UTF_8), $this.secretStorage).flatMap((Function1 & Serializable & scala.Serializable)wallet -> new Some((Object)AccountMemoryPool$.MODULE$.createEmptyMempool(() -> (AccountStateReader)this.minimalState(), () -> (BaseStateReader)this.minimalState(), $this.sidechainSettings.accountMempool(), () -> this)).map((Function1 & Serializable & scala.Serializable)pool -> new Tuple4(history, state, wallet, pool)))));
        Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>> result = this.checkAndRecoverStorages((Option<Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool>>)restoredData);
        return var2_2;
    }

    public Tuple4<AccountHistory, AccountState, AccountWallet, AccountMemoryPool> genesisState() {
        Try result = AccountState$.MODULE$.createGenesisState(this.stateMetadataStorage, this.stateDbStorage, this.messageProcessors(this.params), this.params, this.timeProvider, height -> this.blockHashProvider(height), this.genesisBlock).flatMap((Function1 & Serializable & scala.Serializable)state -> new Success(state.getCurrentConsensusEpochInfo()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$genesisState$3(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> {
            ConsensusEpochInfo consensusEpochInfo;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$1;
                    if (tuple2 == null) break block2;
                    String string = (String)tuple2._1();
                    consensusEpochInfo = (ConsensusEpochInfo)tuple2._2();
                    Option option = ClassTag$.MODULE$.apply(String.class).unapply((Object)string);
                    if (!option.isEmpty() && option.get() != null && consensusEpochInfo != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            ConsensusEpochInfo consensusEpochInfo2 = consensusEpochInfo;
            Try try_ = AccountHistory$.MODULE$.createGenesisHistory($this.historyStorage, $this.consensusDataStorage, $this.params, $this.genesisBlock, this.semanticBlockValidators($this.params), this.historyBlockValidators($this.params), new StakeConsensusEpochInfo(consensusEpochInfo2.forgingStakeInfoTree().rootHash(), consensusEpochInfo2.forgersStake())).flatMap((Function1 & Serializable & scala.Serializable)history -> AccountWallet$.MODULE$.createGenesisWallet($this.sidechainSettings.wallet().seed().getBytes(StandardCharsets.UTF_8), $this.secretStorage).flatMap((Function1 & Serializable & scala.Serializable)wallet -> new Success((Object)AccountMemoryPool$.MODULE$.createEmptyMempool(() -> (AccountStateReader)this.minimalState(), () -> (BaseStateReader)this.minimalState(), $this.sidechainSettings.accountMempool(), () -> this)).map((Function1 & Serializable & scala.Serializable)pool -> new Tuple4(history, state, wallet, pool))));
            return try_;
        }));
        return (Tuple4)result.get();
    }

    private Option<String> blockHashProvider(int height) {
        return ((AbstractHistory)this.history()).blockIdByHeight(height);
    }

    public AccountFeePaymentsInfo getFeePaymentsInfo(AccountState state, int epochNumber) {
        Seq<AccountPayment> feePayments = state.getFeePaymentsInfo(epochNumber, state.getFeePaymentsInfo$default$2());
        return new AccountFeePaymentsInfo(feePayments);
    }

    public AccountWallet getScanPersistentWallet(AccountBlock modToApply, Option<AccountState> stateOp, int epochNumber, AccountWallet wallet) {
        return wallet.scanPersistent(modToApply);
    }

    @Override
    public AccountNodeView getNodeView() {
        return new AccountNodeView((NodeAccountHistory)this.history(), (NodeAccountState)this.minimalState(), (NodeWalletBase)this.vault(), (NodeAccountMemoryPool)this.memoryPool());
    }

    @Override
    public Seq<SidechainStorageInfo> listOfStorageInfo() {
        return this.listOfStorageInfo;
    }

    @Override
    public void applyLocallyGeneratedTransactions(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newTxs) {
        newTxs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public AccountMemoryPool updateMemPool(Seq<AccountBlock> removedBlocks, Seq<AccountBlock> appliedBlocks, AccountMemoryPool memPool, AccountState state) {
        return memPool.updateMemPool(removedBlocks, appliedBlocks);
    }

    @Override
    public void sendNewExecTxsEvent(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> listOfNewExecTxs) {
        this.context().system().eventStream().publish((Object)new NewExecTransactionsEvent(listOfNewExecTxs));
    }

    public static final /* synthetic */ boolean $anonfun$checkAndRecoverStorages$2(AccountHistory restoredHistory$1, String blockId) {
        return ((AbstractHistoryStorage)restoredHistory$1.storage()).isInActiveChain(blockId);
    }

    public static final /* synthetic */ void $anonfun$checkAndRecoverStorages$3(AccountSidechainNodeViewHolder $this, AccountHistory restoredHistory$1, String childBlock) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug("Child {} is in history", new Object[]{childBlock});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if ($this.log().underlying().isDebugEnabled()) {
            $this.log().underlying().debug("Child info {}", new Object[]{restoredHistory$1.blockInfoById(childBlock)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$genesisState$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String string = (String)tuple2._1();
        ConsensusEpochInfo consensusEpochInfo = (ConsensusEpochInfo)tuple2._2();
        Option option = ClassTag$.MODULE$.apply(String.class).unapply((Object)string);
        if (option.isEmpty()) return false;
        if (option.get() == null) return false;
        if (consensusEpochInfo == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$applyLocallyGeneratedTransactions$2(AccountTransaction x$2) {
        return x$2 instanceof EthereumTransaction;
    }

    public static final /* synthetic */ boolean $anonfun$applyLocallyGeneratedTransactions$4(AccountSidechainNodeViewHolder $this, EthereumTransaction ethTx) {
        return !$this.sidechainSettings.accountMempool().allowUnprotectedTxs() && ethTx.isLegacy() && !ethTx.isEIP155();
    }

    public static final /* synthetic */ void $anonfun$applyLocallyGeneratedTransactions$1(AccountSidechainNodeViewHolder $this, AccountTransaction x0$1) {
        AccountTransaction accountTransaction = x0$1;
        if (new Some((Object)accountTransaction).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$2(x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> (EthereumTransaction)x$3).exists((Function1 & Serializable & scala.Serializable)ethTx -> BoxesRunTime.boxToBoolean((boolean)AccountSidechainNodeViewHolder.$anonfun$applyLocallyGeneratedTransactions$4($this, ethTx)))) {
            $this.context().system().eventStream().publish((Object)new NodeViewSynchronizer.ReceivableMessages$.FailedTransaction(accountTransaction.id(), (Throwable)new IllegalArgumentException("Legacy unprotected transactions are not allowed."), true));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if ($this.log().underlying().isInfoEnabled()) {
                $this.log().underlying().info("Got locally generated tx {} of type {}", new Object[]{accountTransaction.id(), BoxesRunTime.boxToByte((byte)accountTransaction.modifierTypeId())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.txModify(accountTransaction);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public AccountSidechainNodeViewHolder(SidechainSettings sidechainSettings, NetworkParams params, NetworkTimeProvider timeProvider, AccountHistoryStorage historyStorage, ConsensusDataStorage consensusDataStorage, AccountStateMetadataStorage stateMetadataStorage, Database stateDbStorage, Seq<MessageProcessor> customMessageProcessors, SidechainSecretStorage secretStorage, AccountBlock genesisBlock) {
        this.sidechainSettings = sidechainSettings;
        this.params = params;
        this.timeProvider = timeProvider;
        this.historyStorage = historyStorage;
        this.consensusDataStorage = consensusDataStorage;
        this.stateMetadataStorage = stateMetadataStorage;
        this.stateDbStorage = stateDbStorage;
        this.customMessageProcessors = customMessageProcessors;
        this.secretStorage = secretStorage;
        this.genesisBlock = genesisBlock;
        super(sidechainSettings, timeProvider);
        this.listOfStorageInfo = (Seq)new .colon.colon((Object)historyStorage, (List)new .colon.colon((Object)consensusDataStorage, (List)new .colon.colon((Object)stateMetadataStorage, (List)new .colon.colon((Object)secretStorage, (List)Nil$.MODULE$))));
    }

    public static class NewExecTransactionsEvent
    implements NodeViewSynchronizer.ReceivableMessages$.NodeViewHolderEvent,
    Product,
    scala.Serializable {
        private final Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs;

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs() {
            return this.newExecTxs;
        }

        public NewExecTransactionsEvent copy(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs) {
            return new NewExecTransactionsEvent(newExecTxs);
        }

        public Iterable<AccountTransaction<Proposition, Proof<Proposition>>> copy$default$1() {
            return this.newExecTxs();
        }

        public String productPrefix() {
            return "NewExecTransactionsEvent";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.newExecTxs();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof NewExecTransactionsEvent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof NewExecTransactionsEvent)) return false;
            boolean bl = true;
            if (!bl) return false;
            NewExecTransactionsEvent newExecTransactionsEvent = (NewExecTransactionsEvent)x$1;
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable = this.newExecTxs();
            Iterable<AccountTransaction<Proposition, Proof<Proposition>>> iterable2 = newExecTransactionsEvent.newExecTxs();
            if (iterable == null) {
                if (iterable2 != null) {
                    return false;
                }
            } else if (!iterable.equals(iterable2)) return false;
            if (!newExecTransactionsEvent.canEqual(this)) return false;
            return true;
        }

        public NewExecTransactionsEvent(Iterable<AccountTransaction<Proposition, Proof<Proposition>>> newExecTxs) {
            this.newExecTxs = newExecTxs;
            Product.$init$((Product)this);
        }
    }
}

