/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.account;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import io.horizen.AbstractSidechainApp;
import io.horizen.ChainInfo;
import io.horizen.SidechainAppStopper;
import io.horizen.SidechainSettings;
import io.horizen.account.AccountSidechainApp;
import io.horizen.account.api.http.AccountApplicationApiGroup;
import io.horizen.account.helper.AccountNodeViewHelper;
import io.horizen.account.helper.AccountNodeViewHelperImpl;
import io.horizen.account.helper.AccountTransactionSubmitHelper;
import io.horizen.account.helper.AccountTransactionSubmitHelperImpl;
import io.horizen.account.state.MessageProcessor;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.fork.ForkConfigurator;
import io.horizen.helper.SecretSubmitHelper;
import io.horizen.helper.SecretSubmitHelperImpl;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.secret.Secret;
import io.horizen.secret.SecretSerializer;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.utils.Pair;
import java.util.HashMap;
import java.util.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ef!\u0002\u0005\n\u0003\u0003\u0001\u0002\"B\u000e\u0001\t\u0003a\u0002bB\u0010\u0001\u0001\u0004%\t\u0001\t\u0005\bI\u0001\u0001\r\u0011\"\u0001&\u0011\u0019q\u0003\u0001)Q\u0005C!)q\u0006\u0001C!a!)\u0011\u0007\u0001D\u0001a!)!\u0007\u0001C\u0001g\t\u0001\u0012iY2pk:$\u0018\t\u001d9N_\u0012,H.\u001a\u0006\u0003\u0015-\tq!Y2d_VtGO\u0003\u0002\r\u001b\u00059\u0001n\u001c:ju\u0016t'\"\u0001\b\u0002\u0005%|7\u0001A\n\u0003\u0001E\u0001\"AE\r\u000e\u0003MQ!\u0001F\u000b\u0002\r%t'.Z2u\u0015\t1r#\u0001\u0004h_><G.\u001a\u0006\u00021\u0005\u00191m\\7\n\u0005i\u0019\"AD!cgR\u0014\u0018m\u0019;N_\u0012,H.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003%\t1!\u00199q+\u0005\t\u0003C\u0001\u0010#\u0013\t\u0019\u0013BA\nBG\u000e|WO\u001c;TS\u0012,7\r[1j]\u0006\u0003\b/A\u0004baB|F%Z9\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDq!L\u0002\u0002\u0002\u0003\u0007\u0011%A\u0002yIE\nA!\u00199qA\u0005I1m\u001c8gS\u001e,(/\u001a\u000b\u0002M\u0005a1m\u001c8gS\u001e,(/Z!qa\u0006\u0019q-\u001a;\u0015'\u0005\"D\tY?\u0002\u001c\u0005%\u0013\u0011LA9\u0003\u0003\u000b9*!)\t\u000bU:\u0001\u0019\u0001\u001c\u0002#MLG-Z2iC&t7+\u001a;uS:<7\u000f\u0005\u00028q5\t1\"\u0003\u0002:\u0017\t\t2+\u001b3fG\"\f\u0017N\\*fiRLgnZ:)\tQZ\u0014I\u0011\t\u0003y}j\u0011!\u0010\u0006\u0003}M\tAA\\1nK&\u0011\u0001)\u0010\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0002\u0007\u0006\t2+\u001b3fG\"\f\u0017N\\*fiRLgnZ:\t\u000b\u0015;\u0001\u0019\u0001$\u0002/\r,8\u000f^8n'\u0016\u001c'/\u001a;TKJL\u0017\r\\5{KJ\u001c\b\u0003B$M\u001dRk\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA!\u001e;jY*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u001dA\u0015m\u001d5NCB\u0004\"a\u0014*\u000e\u0003AS!!\u0015&\u0002\t1\fgnZ\u0005\u0003'B\u0013AAQ=uKB\u0019Q\u000b\u0017.\u000e\u0003YS!aV\u0006\u0002\rM,7M]3u\u0013\tIfK\u0001\tTK\u000e\u0014X\r^*fe&\fG.\u001b>feB\u0011QkW\u0005\u00039Z\u0013aaU3de\u0016$\b\u0006\u0002#<\u0003z\u000b\u0013aX\u0001\u0018\u0007V\u001cHo\\7TK\u000e\u0014X\r^*fe&\fG.\u001b>feNDQ!Y\u0004A\u0002\t\f1eY;ti>l\u0017iY2pk:$HK]1og\u0006\u001cG/[8o'\u0016\u0014\u0018.\u00197ju\u0016\u00148\u000f\u0005\u0003H\u0019:\u001b\u0007c\u00013hS6\tQM\u0003\u0002g\u0017\u0005YAO]1og\u0006\u001cG/[8o\u0013\tAWMA\u000bUe\u0006t7/Y2uS>t7+\u001a:jC2L'0\u001a:\u0011\t)dg\u000e^\u0007\u0002W*\u0011a-C\u0005\u0003[.\u0014!#Q2d_VtG\u000f\u0016:b]N\f7\r^5p]B\u0011qN]\u0007\u0002a*\u0011\u0011oC\u0001\faJ|\u0007o\\:ji&|g.\u0003\u0002ta\nY\u0001K]8q_NLG/[8o!\r)\bP\\\u0007\u0002m*\u0011qoC\u0001\u0006aJ|wNZ\u0005\u0003sZ\u0014Q\u0001\u0015:p_\u001aDC\u0001Y\u001eBw\u0006\nA0A\u0012DkN$x.\\!dG>,h\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cVM]5bY&TXM]:\t\u000by<\u0001\u0019A@\u0002\u001f\r,8\u000f^8n\u0003BLwI]8vaN\u0004RaRA\u0001\u0003\u000bI1!a\u0001I\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!\u0001\u000e\u001e;q\u0015\r\ty!C\u0001\u0004CBL\u0017\u0002BA\n\u0003\u0013\u0011!$Q2d_VtG/\u00119qY&\u001c\u0017\r^5p]\u0006\u0003\u0018n\u0012:pkBDS!`\u001eB\u0003/\t#!!\u0007\u0002\u001f\r+8\u000f^8n\u0003BLwI]8vaNDq!!\b\b\u0001\u0004\ty\"\u0001\tsK*,7\r^3e\u0003BL\u0007+\u0019;igB)q)!\u0001\u0002\"AA\u00111EA\u0015\u0003[\ti#\u0004\u0002\u0002&)\u0019\u0011qE\u0006\u0002\u000bU$\u0018\u000e\\:\n\t\u0005-\u0012Q\u0005\u0002\u0005!\u0006L'\u000f\u0005\u0003\u00020\u0005ub\u0002BA\u0019\u0003s\u00012!a\r)\u001b\t\t)DC\u0002\u00028=\ta\u0001\u0010:p_Rt\u0014bAA\u001eQ\u00051\u0001K]3eK\u001aLA!a\u0010\u0002B\t11\u000b\u001e:j]\u001eT1!a\u000f)Q\u0019\tYbO!\u0002F\u0005\u0012\u0011qI\u0001\u0011%\u0016TWm\u0019;fI\u0006\u0003\u0018\u000eU1uQNDq!a\u0013\b\u0001\u0004\ti%A\u0005dQ\u0006Lg.\u00138g_B\u0019q'a\u0014\n\u0007\u0005E3BA\u0005DQ\u0006Lg.\u00138g_\"2\u0011\u0011J\u001eB\u0003+\n#!a\u0016\u0002\u0013\rC\u0017-\u001b8J]\u001a|\u0007bBA.\u000f\u0001\u0007\u0011QL\u0001\u0018GV\u001cHo\\7NKN\u001c\u0018mZ3Qe>\u001cWm]:peN\u0004RaRA\u0001\u0003?\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0004\u0003KJ\u0011!B:uCR,\u0017\u0002BA5\u0003G\u0012\u0001#T3tg\u0006<W\r\u0015:pG\u0016\u001c8o\u001c:)\r\u0005e3(QA7C\t\ty'A\fDkN$x.\\'fgN\fw-\u001a)s_\u000e,7o]8sg\"9\u00111O\u0004A\u0002\u0005U\u0014AE1qa2L7-\u0019;j_:\u001cFo\u001c9qKJ\u00042aNA<\u0013\r\tIh\u0003\u0002\u0014'&$Wm\u00195bS:\f\u0005\u000f]*u_B\u0004XM\u001d\u0015\u0007\u0003cZ\u0014)! \"\u0005\u0005}\u0014AE!qa2L7-\u0019;j_:\u001cFo\u001c9qKJDq!a!\b\u0001\u0004\t))\u0001\tg_J\\7i\u001c8gS\u001e,(/\u0019;peB!\u0011qQAG\u001b\t\tIIC\u0002\u0002\f.\tAAZ8sW&!\u0011qRAE\u0005A1uN]6D_:4\u0017nZ;sCR|'\u000f\u000b\u0004\u0002\u0002n\n\u00151S\u0011\u0003\u0003+\u000b\u0011CR8sW\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\tIj\u0002a\u0001\u0003[\t!\"\u00199q-\u0016\u00148/[8oQ\u0019\t9jO!\u0002\u001e\u0006\u0012\u0011qT\u0001\u000b\u0003B\u0004h+\u001a:tS>t\u0007bBAR\u000f\u0001\u0007\u0011QU\u0001\u0016[\u000e\u0014En\\2l%\u00164WM]3oG\u0016$U\r\\1z!\r9\u0013qU\u0005\u0004\u0003SC#aA%oi\"2\u0011\u0011U\u001eB\u0003[\u000b#!a,\u000295\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u001a7bs\"\u001aq!a-\u0011\u0007I\t),C\u0002\u00028N\u0011\u0001\u0002\u0015:pm&$Wm\u001d")
public abstract class AccountAppModule
extends AbstractModule {
    private AccountSidechainApp app = null;

    public AccountSidechainApp app() {
        return this.app;
    }

    public void app_$eq(AccountSidechainApp x$1) {
        this.app = x$1;
    }

    public void configure() {
        this.bind(AccountTransactionSubmitHelper.class).to(AccountTransactionSubmitHelperImpl.class);
        this.bind(AbstractSidechainApp.class).to(AccountSidechainApp.class);
        this.bind(AccountNodeViewHelper.class).to(AccountNodeViewHelperImpl.class);
        this.bind(SecretSubmitHelper.class).to(SecretSubmitHelperImpl.class);
        this.configureApp();
    }

    public abstract void configureApp();

    @Provides
    public AccountSidechainApp get(@Named(value="SidechainSettings") SidechainSettings sidechainSettings, @Named(value="CustomSecretSerializers") HashMap<Byte, SecretSerializer<Secret>> customSecretSerializers, @Named(value="CustomAccountTransactionSerializers") HashMap<Byte, TransactionSerializer<AccountTransaction<Proposition, Proof<Proposition>>>> customAccountTransactionSerializers, @Named(value="CustomApiGroups") List<AccountApplicationApiGroup> customApiGroups, @Named(value="RejectedApiPaths") List<Pair<String, String>> rejectedApiPaths, @Named(value="ChainInfo") ChainInfo chainInfo, @Named(value="CustomMessageProcessors") List<MessageProcessor> customMessageProcessors, @Named(value="ApplicationStopper") SidechainAppStopper applicationStopper, @Named(value="ForkConfiguration") ForkConfigurator forkConfigurator, @Named(value="AppVersion") String appVersion, @Named(value="MainchainBlockReferenceDelay") int mcBlockReferenceDelay) {
        AccountAppModule accountAppModule = this;
        synchronized (accountAppModule) {
            if (this.app() == null) {
                this.app_$eq(new AccountSidechainApp(sidechainSettings, customSecretSerializers, customAccountTransactionSerializers, customApiGroups, rejectedApiPaths, customMessageProcessors, applicationStopper, forkConfigurator, chainInfo, appVersion, mcBlockReferenceDelay));
            }
        }
        return this.app();
    }
}

