/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.websocket.client;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.websocket.client.DisconnectionCode$;
import io.horizen.websocket.client.WebSocketChannel;
import io.horizen.websocket.client.WebSocketConnector;
import io.horizen.websocket.client.WebSocketMessageHandler;
import io.horizen.websocket.client.WebSocketReconnectionHandler;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.Serializable;
import java.net.URI;
import org.glassfish.tyrus.client.ClientManager;
import scala.Function0;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ClientEndpoint
@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\n\u0014\u0001qA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015y\u0005\u0001\"\u0001Q\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005`\u0001\u0001\u0007\t\u0019!C\u0005A\"Ia\r\u0001a\u0001\u0002\u0003\u0006K\u0001\u0017\u0005\b)\u0001\u0011\r\u0011\"\u0003h\u0011\u0019\u0019\b\u0001)A\u0005Q\"9A\u000f\u0001b\u0001\n\u0013)\bBB?\u0001A\u0003%a\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005B\u0005%\u0001bBA\u0012\u0001\u0011\u0005\u0013Q\u0005\u0002\u0017/\u0016\u00147k\\2lKR\u001cuN\u001c8fGR|'/S7qY*\u0011A#F\u0001\u0007G2LWM\u001c;\u000b\u0005Y9\u0012!C<fEN|7m[3u\u0015\tA\u0012$A\u0004i_JL'0\u001a8\u000b\u0003i\t!![8\u0004\u0001M)\u0001!H\u0012(UA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u0004\"\u0001J\u0013\u000e\u0003MI!AJ\n\u0003%]+'mU8dW\u0016$8i\u001c8oK\u000e$xN\u001d\t\u0003I!J!!K\n\u0003!]+'mU8dW\u0016$8\t[1o]\u0016d\u0007CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\naa\u001d9be.T\u0018BA\u0019-\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006Y!-\u001b8e\u0003\u0012$'/Z:t!\t!4H\u0004\u00026sA\u0011agH\u0007\u0002o)\u0011\u0001hG\u0001\u0007yI|w\u000e\u001e \n\u0005iz\u0012A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!AO\u0010\u0002#\r|gN\\3di&|g\u000eV5nK>,H\u000f\u0005\u0002A\u000b6\t\u0011I\u0003\u0002C\u0007\u0006AA-\u001e:bi&|gN\u0003\u0002E?\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0019\u000b%A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000f[\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\t!\u0013*\u0003\u0002K'\t9r+\u001a2T_\u000e\\W\r^'fgN\fw-\u001a%b]\u0012dWM]\u0001\u0014e\u0016\u001cwN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\t\u0003I5K!AT\n\u00039]+'mU8dW\u0016$(+Z2p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\u00061A(\u001b8jiz\"R!\u0015*T)V\u0003\"\u0001\n\u0001\t\u000bI*\u0001\u0019A\u001a\t\u000by*\u0001\u0019A \t\u000b\u001d+\u0001\u0019\u0001%\t\u000b-+\u0001\u0019\u0001'\u0002\u0017U\u001cXM]*fgNLwN\\\u000b\u00021B\u0011\u0011,X\u0007\u00025*\u0011ac\u0017\u0006\u00029\u00069!.Y6beR\f\u0017B\u00010[\u0005\u001d\u0019Vm]:j_:\fq\"^:feN+7o]5p]~#S-\u001d\u000b\u0003C\u0012\u0004\"A\b2\n\u0005\r|\"\u0001B+oSRDq!Z\u0004\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nA\"^:feN+7o]5p]\u0002*\u0012\u0001\u001b\t\u0003SFl\u0011A\u001b\u0006\u0003)-T!\u0001\\7\u0002\u000bQL(/^:\u000b\u00059|\u0017!C4mCN\u001ch-[:i\u0015\u0005\u0001\u0018aA8sO&\u0011!O\u001b\u0002\u000e\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u000f\rd\u0017.\u001a8uA\u0005\u0001\"/Z2p]:,7\r\u001e%b]\u0012dWM]\u000b\u0002mB\u0011qO\u001f\b\u0003SbL!!\u001f6\u0002\u001b\rc\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0013\tYHP\u0001\tSK\u000e|gN\\3di\"\u000bg\u000e\u001a7fe*\u0011\u0011P[\u0001\u0012e\u0016\u001cwN\u001c8fGRD\u0015M\u001c3mKJ\u0004\u0013!C5t'R\f'\u000f^3e)\t\t\t\u0001E\u0002\u001f\u0003\u0007I1!!\u0002 \u0005\u001d\u0011un\u001c7fC:\fQa\u001d;beR$\"!a\u0003\u0011\u000b\u00055\u0011\u0011C1\u000e\u0005\u0005=!BA\u0017 \u0013\u0011\t\u0019\"a\u0004\u0003\u0007Q\u0013\u00180\u0001\u0006bgft7m\u0015;beR$\"!!\u0007\u0011\r\u0005m\u0011QDA\u0006\u001b\u0005\u0019\u0015bAA\u0010\u0007\n1a)\u001e;ve\u0016\fAa\u001d;pa\u0006Y1/\u001a8e\u001b\u0016\u001c8/Y4f)\r\t\u0017q\u0005\u0005\u0007\u0003S\t\u0002\u0019A\u001a\u0002\u000f5,7o]1hK\"\u001a\u0001!!\f\u0011\u0007e\u000by#C\u0002\u00022i\u0013ab\u00117jK:$XI\u001c3q_&tG\u000f")
public class WebSocketConnectorImpl
implements WebSocketConnector,
WebSocketChannel,
SparkzLogging {
    private final String bindAddress;
    private final FiniteDuration connectionTimeout;
    public final WebSocketMessageHandler io$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler;
    public final WebSocketReconnectionHandler io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler;
    private Session userSession;
    private final ClientManager client;
    private final ClientManager.ReconnectHandler reconnectHandler;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Session userSession() {
        return this.userSession;
    }

    private void userSession_$eq(Session x$1) {
        this.userSession = x$1;
    }

    private ClientManager client() {
        return this.client;
    }

    private ClientManager.ReconnectHandler reconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public boolean isStarted() {
        return this.userSession() != null && this.userSession().isOpen();
    }

    @Override
    public Try<BoxedUnit> start() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.isStarted()) {
                throw new IllegalStateException("Connector is already started.");
            }
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", this.reconnectHandler());
            this.client().getProperties().put("org.glassfish.tyrus.client.ClientManager.ContainerTimeout", String.valueOf($this.connectionTimeout.toMillis()));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Starting web socket connector, ws address = {}...", new Object[]{$this.bindAddress});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession_$eq(this.client().connectToServer((Object)this, new URI($this.bindAddress)));
            $this.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onConnectionSuccess();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector started.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.userSession().addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(this){
                private final /* synthetic */ WebSocketConnectorImpl $outer;

                public void onMessage(String t) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.log().underlying().isTraceEnabled()) {
                        this.$outer.log().underlying().trace(new StringBuilder(30).append("Message received from server: ").append(t).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.$outer.io$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onReceivedMessage(t);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        });
    }

    @Override
    public Future<Try<BoxedUnit>> asyncStart() {
        Promise promise = Promise$.MODULE$.apply();
        new Thread(new Runnable(this, promise){
            private final /* synthetic */ WebSocketConnectorImpl $outer;
            private final Promise promise$1;

            public void run() {
                this.promise$1.success(this.$outer.start());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
            }
        }).start();
        return promise.future();
    }

    @Override
    public Try<BoxedUnit> stop() {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Stopping web socket connector...");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.userSession().close();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Web socket connector stopped.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    @Override
    public void sendMessage(String message) {
        try {
            this.userSession().getAsyncRemote().sendText(message, sendResult -> {
                BoxedUnit boxedUnit;
                if (!sendResult.isOK()) {
                    BoxedUnit boxedUnit2;
                    if (this.log().underlying().isInfoEnabled()) {
                        this.log().underlying().info("Send message failed.");
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    $this.io$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(message, sendResult.getException());
                } else if (this.log().underlying().isInfoEnabled()) {
                    this.log().underlying().info("Message sent");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            });
        }
        catch (Throwable e) {
            this.io$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler.onSendMessageErrorOccurred(message, e);
        }
    }

    public WebSocketConnectorImpl(String bindAddress, FiniteDuration connectionTimeout, WebSocketMessageHandler messageHandler, WebSocketReconnectionHandler reconnectionHandler) {
        this.bindAddress = bindAddress;
        this.connectionTimeout = connectionTimeout;
        this.io$horizen$websocket$client$WebSocketConnectorImpl$$messageHandler = messageHandler;
        this.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler = reconnectionHandler;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.client = ClientManager.createClient();
        this.reconnectHandler = new ClientManager.ReconnectHandler(this){
            private final /* synthetic */ WebSocketConnectorImpl $outer;

            public long getDelay() {
                return this.$outer.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.getDelay().toSeconds();
            }

            public boolean onDisconnect(CloseReason closeReason) {
                BoxedUnit boxedUnit;
                if (this.$outer.log().underlying().isInfoEnabled()) {
                    this.$outer.log().underlying().info(new StringBuilder(22).append("onDisconnect. Reason: ").append(closeReason.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return closeReason.getCloseCode().getCode() == 1000 ? this.$outer.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.ON_SUCCESS(), closeReason.getReasonPhrase()) : this.$outer.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onDisconnection(DisconnectionCode$.MODULE$.UNEXPECTED(), closeReason.getReasonPhrase());
            }

            public boolean onConnectFailure(Exception exception) {
                return this.$outer.io$horizen$websocket$client$WebSocketConnectorImpl$$reconnectionHandler.onConnectionFailed(exception);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

