/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.websocket.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.websocket.client.EventHandler;
import io.horizen.websocket.client.EventPayload;
import io.horizen.websocket.client.RequestPayload;
import io.horizen.websocket.client.RequestType;
import io.horizen.websocket.client.ResponsePayload;
import io.horizen.websocket.client.WebSocketChannel;
import io.horizen.websocket.client.WebSocketChannelCommunicationClient;
import io.horizen.websocket.client.WebSocketCommunicationClient$;
import io.horizen.websocket.client.WebSocketMessageHandler;
import io.horizen.websocket.client.WebSocketServerError;
import io.horizen.websocket.client.WebsocketErrorResponseException;
import io.horizen.websocket.client.WebsocketErrorResponseException$;
import io.horizen.websocket.client.WebsocketInvalidErrorMessageException;
import io.horizen.websocket.client.WebsocketInvalidErrorMessageException$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u0010!\u0001%B\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019Q\u0006\u0001)A\u0005\u001d\"91\f\u0001a\u0001\n\u0013a\u0006b\u0002?\u0001\u0001\u0004%I! \u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003^\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0005\u00028\u0001\u0001\r\u0011\"\u0003\u0002:!A\u0011Q\b\u0001!B\u0013\ti\u0001C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA%\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017B1\"a\u0014\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111\u000b\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002V!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003c\u0003A\u0011IAZ\u0011\u001d\tI\u000e\u0001C!\u00037Dq!!;\u0001\t\u0003\nY\u000fC\u0004\u0002r\u0002!I!a=\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!Q\u0001\u0001\u0005\n\t\u001d\u0001b\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011y\u0002\u0001C!\u0005C9\u0011Ba\t!\u0003\u0003E\tA!\n\u0007\u0011}\u0001\u0013\u0011!E\u0001\u0005OAa\u0001\u0013\u000f\u0005\u0002\t%\u0002\"\u0003B\u00169E\u0005I\u0011\u0001B\u0017\u0005q9VMY*pG.,GoQ8n[Vt\u0017nY1uS>t7\t\\5f]RT!!\t\u0012\u0002\r\rd\u0017.\u001a8u\u0015\t\u0019C%A\u0005xK\n\u001cxnY6fi*\u0011QEJ\u0001\bQ>\u0014\u0018N_3o\u0015\u00059\u0013AA5p\u0007\u0001\u0019R\u0001\u0001\u00161i]\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00193\u001b\u0005\u0001\u0013BA\u001a!\u0005\r:VMY*pG.,Go\u00115b]:,GnQ8n[Vt\u0017nY1uS>t7\t\\5f]R\u0004\"!M\u001b\n\u0005Y\u0002#aF,fEN{7m[3u\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003vi&d'\"\u0001\u001f\u0002\rM\u0004\u0018M]6{\u0013\tq\u0014HA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgnZ\u0001\u000fe\u0016\fX/Z:u)&lWmT;u!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0005ekJ\fG/[8o\u0015\t)E&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0012\"\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"\"AS&\u0011\u0005E\u0002\u0001bB \u0003!\u0003\u0005\r\u0001Q\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u00039\u0003\"a\u0014-\u000e\u0003AS!!\u0015*\u0002\u0011\u0011\fG/\u00192j]\u0012T!a\u0015+\u0002\u000f)\f7m[:p]*\u0011QKV\u0001\nM\u0006\u001cH/\u001a:y[2T\u0011aV\u0001\u0004G>l\u0017BA-Q\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\nAB]3rk\u0016\u001cHo\u001d)p_2,\u0012!\u0018\t\u0005=\n$w.D\u0001`\u0015\t)\u0005M\u0003\u0002bY\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\r|&a\u0002+sS\u0016l\u0015\r\u001d\t\u0003K2t!A\u001a6\u0011\u0005\u001ddS\"\u00015\u000b\u0005%D\u0013A\u0002\u001fs_>$h(\u0003\u0002lY\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tYG\u0006\u0005\u0003,aJL\u0018BA9-\u0005\u0019!V\u000f\u001d7feA\u00191\u000f\u001e<\u000e\u0003\u0011K!!\u001e#\u0003\u000fA\u0013x.\\5tKB\u0011\u0011g^\u0005\u0003q\u0002\u0012qBU3ta>t7/\u001a)bs2|\u0017\r\u001a\t\u0004Kj4\u0018BA>o\u0005\u0015\u0019E.Y:t\u0003A\u0011X-];fgR\u001c\bk\\8m?\u0012*\u0017\u000fF\u0002\u007f\u0003\u0007\u0001\"aK@\n\u0007\u0005\u0005AF\u0001\u0003V]&$\b\u0002CA\u0003\r\u0005\u0005\t\u0019A/\u0002\u0007a$\u0013'A\u0007sKF,Xm\u001d;t!>|G\u000eI\u0001\u0012KZ,g\u000e\u001e%b]\u0012dWM]:Q_>dWCAA\u0007!\u0019q&-a\u0004\u0002\u0016A\u00191&!\u0005\n\u0007\u0005MAFA\u0002J]R\u0004b!a\u0006\u0002\"\u0005\u001db\u0002BA\r\u0003;q1aZA\u000e\u0013\u0005i\u0013bAA\u0010Y\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0012\u0003K\u00111aU3r\u0015\r\ty\u0002\f\t\u0007WA\fI#!\u000e\u0011\u000bE\nY#a\f\n\u0007\u00055\u0002E\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000fE\u00022\u0003cI1!a\r!\u00051)e/\u001a8u!\u0006LHn\\1e!\u0011)'0a\f\u0002+\u00154XM\u001c;IC:$G.\u001a:t!>|Gn\u0018\u0013fcR\u0019a0a\u000f\t\u0013\u0005\u0015\u0011\"!AA\u0002\u00055\u0011AE3wK:$\b*\u00198eY\u0016\u00148\u000fU8pY\u0002\n\u0001c^3c'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u0016\u0005\u0005\r\u0003cA\u0019\u0002F%\u0019\u0011q\t\u0011\u0003!]+'mU8dW\u0016$8\t[1o]\u0016d\u0017\u0001F<fEN{7m[3u\u0007\"\fgN\\3m?\u0012*\u0017\u000fF\u0002\u007f\u0003\u001bB\u0011\"!\u0002\r\u0003\u0003\u0005\r!a\u0011\u0002#],'mU8dW\u0016$8\t[1o]\u0016d\u0007%A\u0004d_VtG/\u001a:\u0016\u0005\u0005U\u0003\u0003BA,\u0003Kj!!!\u0017\u000b\t\u0005m\u0013QL\u0001\u0007CR|W.[2\u000b\u0007\u0015\u000byFC\u0002;\u0003CR!!a\u0019\u0002\t)\fg/Y\u0005\u0005\u0003O\nIFA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\tG>,h\u000e^3sA\u0005\u00192/\u001a;XK\n\u001cvnY6fi\u000eC\u0017M\u001c8fYR\u0019a0a\u001c\t\u000f\u0005E\u0004\u00031\u0001\u0002D\u000591\r[1o]\u0016d\u0017aC:f]\u0012\u0014V-];fgR,b!a\u001e\u0002 \u0006\rE\u0003CA=\u0003\u001f\u000bI*a+\u0011\u000bM\fY(a \n\u0007\u0005uDI\u0001\u0004GkR,(/\u001a\t\u0005\u0003\u0003\u000b\u0019\t\u0004\u0001\u0005\u000f\u0005\u0015\u0015C1\u0001\u0002\b\n!!+Z:q#\r\tII\u001e\t\u0004W\u0005-\u0015bAAGY\t9aj\u001c;iS:<\u0007bBAI#\u0001\u0007\u00111S\u0001\fe\u0016\fX/Z:u)f\u0004X\rE\u00022\u0003+K1!a&!\u0005-\u0011V-];fgR$\u0016\u0010]3\t\u000f\u0005m\u0015\u00031\u0001\u0002\u001e\u00069!/Z9vKN$\b\u0003BAA\u0003?#q!!)\u0012\u0005\u0004\t\u0019KA\u0002SKF\fB!!#\u0002&B\u0019\u0011'a*\n\u0007\u0005%\u0006E\u0001\bSKF,Xm\u001d;QCfdw.\u00193\t\u000f\u00055\u0016\u00031\u0001\u00020\u0006i!/Z:q_:\u001cXm\u00117buj\u0004B!\u001a>\u0002\u0000\u0005!\"/Z4jgR,'/\u0012<f]RD\u0015M\u001c3mKJ,B!!.\u0002NRA\u0011qWAa\u0003\u000b\f\u0019\u000eE\u0003\u0002:\u0006uf0\u0004\u0002\u0002<*\u0011!\bL\u0005\u0005\u0003\u007f\u000bYLA\u0002UefDq!a1\u0013\u0001\u0004\ty!A\u0005fm\u0016tG\u000fV=qK\"9\u0011q\u0019\nA\u0002\u0005%\u0017a\u00025b]\u0012dWM\u001d\t\u0006c\u0005-\u00121\u001a\t\u0005\u0003\u0003\u000bi\rB\u0004\u0002PJ\u0011\r!!5\u0003\u0003\u0015\u000bB!!#\u00020!9\u0011Q\u001b\nA\u0002\u0005]\u0017AC3wK:$8\t\\1{uB!QM_Af\u0003Y)hN]3hSN$XM]#wK:$\b*\u00198eY\u0016\u0014X\u0003BAo\u0003O$RA`Ap\u0003CDq!a1\u0014\u0001\u0004\ty\u0001C\u0004\u0002HN\u0001\r!a9\u0011\u000bE\nY#!:\u0011\t\u0005\u0005\u0015q\u001d\u0003\b\u0003\u001f\u001c\"\u0019AAi\u0003EygNU3dK&4X\rZ'fgN\fw-\u001a\u000b\u0004}\u00065\bBBAx)\u0001\u0007A-A\u0004nKN\u001c\u0018mZ3\u0002\u0019A\u0014xnY3tg\u0016\u0013(o\u001c:\u0015\u0007y\f)\u0010C\u0004\u0002xV\u0001\r!!?\u0002\t)\u001cxN\u001c\t\u0004\u001f\u0006m\u0018bAA\u007f!\nA!j]8o\u001d>$W-\u0001\u0007qe>\u001cWm]:Fm\u0016tG\u000fF\u0002\u007f\u0005\u0007Aq!a>\u0017\u0001\u0004\tI0A\bqe>\u001cWm]:SKN\u0004xN\\:f)\rq(\u0011\u0002\u0005\b\u0003o<\u0002\u0019AA}\u0003iygnU3oI6+7o]1hK\u0016\u0013(o\u001c:PG\u000e,(O]3e)\u0015q(q\u0002B\t\u0011\u0019\ty\u000f\u0007a\u0001I\"9!1\u0003\rA\u0002\tU\u0011!B2bkN,\u0007\u0003BA\f\u0005/IAA!\u0007\u0002&\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0012O\u0016tWM]1uKJ+\u0017/^3ti&#W#\u00013\u0002-I,\u0017/^3tiRKW.Z8vi\u0012+(/\u0019;j_:$\u0012\u0001Q\u0001\u001d/\u0016\u00147k\\2lKR\u001cu.\\7v]&\u001c\u0017\r^5p]\u000ec\u0017.\u001a8u!\t\tDd\u0005\u0002\u001dUQ\u0011!QE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t=\"f\u0001!\u00032-\u0012!1\u0007\t\u0005\u0005k\u0011y$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0003>1\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tEa\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class WebSocketCommunicationClient
implements WebSocketChannelCommunicationClient,
WebSocketMessageHandler,
SparkzLogging {
    private final FiniteDuration requestTimeOut;
    private final ObjectMapper mapper;
    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool;
    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool;
    private WebSocketChannel webSocketChannel;
    private final AtomicInteger counter;
    private final Logger logger;

    public static FiniteDuration $lessinit$greater$default$1() {
        return WebSocketCommunicationClient$.MODULE$.$lessinit$greater$default$1();
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> requestsPool() {
        return this.requestsPool;
    }

    private void requestsPool_$eq(TrieMap<String, Tuple2<Promise<ResponsePayload>, Class<ResponsePayload>>> x$1) {
        this.requestsPool = x$1;
    }

    private TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> eventHandlersPool() {
        return this.eventHandlersPool;
    }

    private void eventHandlersPool_$eq(TrieMap<Object, Seq<Tuple2<EventHandler<EventPayload>, Class<EventPayload>>>> x$1) {
        this.eventHandlersPool = x$1;
    }

    private WebSocketChannel webSocketChannel() {
        return this.webSocketChannel;
    }

    private void webSocketChannel_$eq(WebSocketChannel x$1) {
        this.webSocketChannel = x$1;
    }

    private AtomicInteger counter() {
        return this.counter;
    }

    @Override
    public void setWebSocketChannel(WebSocketChannel channel) {
        this.webSocketChannel_$eq(channel);
    }

    @Override
    public <Req extends RequestPayload, Resp extends ResponsePayload> Future<Resp> sendRequest(RequestType requestType, Req request, Class<Resp> responseClazz) {
        Future future;
        if (this.webSocketChannel() != null) {
            String requestId = this.generateRequestId();
            ObjectNode json = this.mapper().createObjectNode();
            json.put("msgType", 1);
            json.put("requestType", requestType.code());
            json.put("requestId", requestId);
            json.set("requestPayload", this.mapper().valueToTree(request));
            String message = json.toString();
            Promise promise = Promise$.MODULE$.apply();
            this.requestsPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requestId), (Object)new Tuple2((Object)promise, responseClazz)));
            this.webSocketChannel().sendMessage(message);
            future = promise.future();
        } else {
            future = Promise$.MODULE$.apply().failure((Throwable)new IllegalStateException("The web socket channel must be not null.")).future();
        }
        return future;
    }

    @Override
    public <E extends EventPayload> Try<BoxedUnit> registerEventHandler(int eventType, EventHandler<E> handler, Class<E> eventClazz) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            WebSocketCommunicationClient webSocketCommunicationClient = this;
            synchronized (webSocketCommunicationClient) {
                Seq eventHandlers = (Seq)this.eventHandlersPool().getOrElse((Object)BoxesRunTime.boxToInteger((int)eventType), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                if (eventHandlers.exists((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$registerEventHandler$3(handler, h)))) {
                    throw new IllegalArgumentException("Handler is already registered.");
                }
                Seq updatedHandlers = (Seq)eventHandlers.$colon$plus((Object)new Tuple2((Object)handler, (Object)eventClazz), Seq$.MODULE$.canBuildFrom());
                this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
            }
        });
    }

    @Override
    public <E extends EventPayload> void unregisterEventHandler(int eventType, EventHandler<E> handler) {
        WebSocketCommunicationClient webSocketCommunicationClient = this;
        synchronized (webSocketCommunicationClient) {
            BoxedUnit boxedUnit;
            Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq handlers = (Seq)some.value();
                Seq updatedHandlers = (Seq)handlers.filter((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)WebSocketCommunicationClient.$anonfun$unregisterEventHandler$1(handler, h)));
                boxedUnit = this.eventHandlersPool().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)eventType)), (Object)updatedHandlers));
            } else if (None$.MODULE$.equals(option)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    @Override
    public void onReceivedMessage(String message) {
        block9: {
            try {
                JsonNode json = this.mapper().readTree(message);
                int n = json.get("msgType").asInt();
                switch (n) {
                    case 0: {
                        this.processEvent(json);
                        break;
                    }
                    case 2: {
                        this.processResponse(json);
                        break;
                    }
                    case 3: {
                        this.processError(json);
                        break;
                    }
                    default: {
                        BoxedUnit boxedUnit;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(37).append("Unknown message received with type = ").append(n).toString());
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                }
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error(new StringBuilder(51).append("On receive message processing exception occurred = ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void processError(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Promise promise = (Promise)tuple2._1();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (WebSocketServerError)this.mapper().convertValue((Object)json, WebSocketServerError.class));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WebSocketServerError errorResponse = (WebSocketServerError)success.value();
                promise.failure((Throwable)new WebsocketErrorResponseException(errorResponse.message(), WebsocketErrorResponseException$.MODULE$.$lessinit$greater$default$2()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                promise.failure((Throwable)new WebsocketInvalidErrorMessageException(json.toString(), WebsocketInvalidErrorMessageException$.MODULE$.$lessinit$greater$default$2()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(27).append("Unknown response received: ").append(json.toString()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private void processEvent(JsonNode json) {
        int eventType = json.get("eventType").asInt(-1);
        Option option = this.eventHandlersPool().get((Object)BoxesRunTime.boxToInteger((int)eventType));
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq handlers = (Seq)some.value();
            JsonNode eventPayload = json.get("eventPayload");
            handlers.foreach((Function1 & Serializable & scala.Serializable)h -> {
                WebSocketCommunicationClient.$anonfun$processEvent$1(this, eventPayload, h);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isDebugEnabled()) {
                this.log().underlying().debug(new StringBuilder(53).append("Event without defined handler received. Event type = ").append(eventType).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    private void processResponse(JsonNode json) {
        Some some;
        Tuple2 tuple2;
        String requestId = json.get("requestId").asText("");
        Option option = this.requestsPool().remove((Object)requestId);
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            BoxedUnit boxedUnit;
            Promise promise = (Promise)tuple2._1();
            Class responseClazz = (Class)tuple2._2();
            try {
                ResponsePayload resp = (ResponsePayload)this.mapper().convertValue((Object)json.get("responsePayload"), responseClazz);
                promise.success((Object)resp);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable ex) {
                promise.failure(ex);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error(new StringBuilder(46).append("Unknown response received with requested id = ").append(requestId).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Override
    public void onSendMessageErrorOccurred(String message, Throwable cause) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Some some;
            Tuple2 tuple2;
            BoxedUnit boxedUnit2;
            if (this.log().underlying().isErrorEnabled()) {
                this.log().underlying().error("Error from web socket channel", cause);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            JsonNode json = this.mapper().readTree(message);
            String requestId = json.get("requestId").asText("");
            Option option = this.requestsPool().remove((Object)requestId);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Promise promise = (Promise)tuple2._1();
                boxedUnit = promise.failure(cause);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    private String generateRequestId() {
        return String.valueOf(this.counter().addAndGet(1));
    }

    @Override
    public FiniteDuration requestTimeoutDuration() {
        return this.requestTimeOut;
    }

    public static final /* synthetic */ boolean $anonfun$registerEventHandler$3(EventHandler handler$1, Tuple2 h) {
        return h._1().equals(handler$1);
    }

    public static final /* synthetic */ boolean $anonfun$unregisterEventHandler$1(EventHandler handler$2, Tuple2 h) {
        return !h._1().equals(handler$2);
    }

    public static final /* synthetic */ void $anonfun$processEvent$1(WebSocketCommunicationClient $this, JsonNode eventPayload$1, Tuple2 h) {
        block3: {
            try {
                EventPayload resp = (EventPayload)$this.mapper().convertValue((Object)eventPayload$1, (Class)h._2());
                ((EventHandler)h._1()).onEvent(resp);
            }
            catch (Throwable ex) {
                BoxedUnit boxedUnit;
                if ($this.log().underlying().isErrorEnabled()) {
                    $this.log().underlying().error(new StringBuilder(37).append("Event parsing was failed by handler: ").append(ex.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public WebSocketCommunicationClient(FiniteDuration requestTimeOut) {
        this.requestTimeOut = requestTimeOut;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.requestsPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.eventHandlersPool = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.counter = new AtomicInteger();
    }
}

