/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.websocket.server;

import akka.actor.ActorRef;
import akka.pattern.AskableActorRef$;
import akka.util.Timeout;
import akka.util.Timeout$;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainSyncInfo;
import io.horizen.history.AbstractHistory;
import io.horizen.json.SerializationUtil;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.chain.SidechainFeePaymentsInfo;
import io.horizen.utxo.history.SidechainHistory;
import io.horizen.utxo.mempool.SidechainMemoryPool;
import io.horizen.utxo.state.SidechainState;
import io.horizen.utxo.wallet.SidechainWallet;
import io.horizen.utxo.websocket.server.SidechainNodeChannel;
import io.horizen.utxo.websocket.server.WebSocketServerRef$;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.NodeViewHolder;
import sparkz.util.SparkzLogging;
import sparkz.util.package;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\n\u0014\u0001yAQ!\r\u0001\u0005\u0002IBq\u0001\u000e\u0001C\u0002\u0013\rQ\u0007\u0003\u0004>\u0001\u0001\u0006IA\u000e\u0005\b}\u0001\u0011\r\u0011b\u0001@\u0011\u00191\u0005\u0001)A\u0005\u0001\"9q\t\u0001b\u0001\n\u0013A\u0005BB+\u0001A\u0003%\u0011*\u0002\u0003W\u0001\u00019\u0006BB@\u0001\t\u0003\t\t\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u00055\u0003\u0001\"\u0011\u0002P!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\ty\t\u0001C!\u0003\u001bCq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002$\u0002!I!!*\u00031MKG-Z2iC&tgj\u001c3f\u0007\"\fgN\\3m\u00136\u0004HN\u0003\u0002\u0015+\u000511/\u001a:wKJT!AF\f\u0002\u0013],'m]8dW\u0016$(B\u0001\r\u001a\u0003\u0011)H\u000f_8\u000b\u0005iY\u0012a\u00025pe&TXM\u001c\u0006\u00029\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001q$J\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u0014\u0013\tA3C\u0001\u000bTS\u0012,7\r[1j]:{G-Z\"iC:tW\r\u001c\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA!\u001e;jY*\ta&\u0001\u0004ta\u0006\u00148N_\u0005\u0003a-\u0012Qb\u00159be.THj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u00014!\t1\u0003!\u0001\u0005ekJ\fG/[8o+\u00051\u0004CA\u001c<\u001b\u0005A$B\u0001\u0017:\u0015\u0005Q\u0014\u0001B1lW\u0006L!\u0001\u0010\u001d\u0003\u000fQKW.Z8vi\u0006IA-\u001e:bi&|g\u000eI\u0001\u0003K\u000e,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u0006\n!bY8oGV\u0014(/\u001a8u\u0013\t)%I\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\r5\f\u0007\u000f]3s+\u0005I\u0005C\u0001&T\u001b\u0005Y%B\u0001'N\u0003!!\u0017\r^1cS:$'B\u0001(P\u0003\u001dQ\u0017mY6t_:T!\u0001U)\u0002\u0013\u0019\f7\u000f^3sq6d'\"\u0001*\u0002\u0007\r|W.\u0003\u0002U\u0017\naqJ\u00196fGRl\u0015\r\u001d9fe\u00069Q.\u00199qKJ\u0004#\u0001\u0002,jK^\u0004b\u0001\u00173h[NLhBA-b\u001d\tQvL\u0004\u0002\\=6\tAL\u0003\u0002^;\u00051AH]8pizJ\u0011AL\u0005\u0003A6\nAaY8sK&\u0011!mY\u0001\u000f\u001d>$WMV5fo\"{G\u000eZ3s\u0015\t\u0001W&\u0003\u0002fM\nY1)\u001e:sK:$h+[3x\u0015\t\u00117\r\u0005\u0002iW6\t\u0011N\u0003\u0002k/\u00059\u0001.[:u_JL\u0018B\u00017j\u0005A\u0019\u0016\u000eZ3dQ\u0006Lg\u000eS5ti>\u0014\u0018\u0010\u0005\u0002oc6\tqN\u0003\u0002q/\u0005)1\u000f^1uK&\u0011!o\u001c\u0002\u000f'&$Wm\u00195bS:\u001cF/\u0019;f!\t!x/D\u0001v\u0015\t1x#\u0001\u0004xC2dW\r^\u0005\u0003qV\u0014qbU5eK\u000eD\u0017-\u001b8XC2dW\r\u001e\t\u0003uvl\u0011a\u001f\u0006\u0003y^\tq!\\3na>|G.\u0003\u0002\u007fw\n\u00192+\u001b3fG\"\f\u0017N\\'f[>\u0014\u0018\u0010U8pY\u0006y\u0011\r\u001d9ms>sgj\u001c3f-&,w/\u0006\u0003\u0002\u0004\u0005%A\u0003BA\u0003\u00037\u0001B!a\u0002\u0002\n1\u0001AaBA\u0006\u0013\t\u0007\u0011Q\u0002\u0002\u0002%F!\u0011qBA\u000b!\r\u0001\u0013\u0011C\u0005\u0004\u0003'\t#a\u0002(pi\"Lgn\u001a\t\u0004A\u0005]\u0011bAA\rC\t\u0019\u0011I\\=\t\u000f\u0005u\u0011\u00021\u0001\u0002 \u0005\u0019b-\u001e8di&|g\u000eV8CK\u0006\u0003\b\u000f\\5fIB9\u0001%!\t\u0002&\u0005\u0015\u0011bAA\u0012C\tIa)\u001e8di&|g.\r\t\u0004\u0003OAQ\"\u0001\u0001\u0002)\u001d,GO\u00117pG.LeNZ8Cs\"+\u0017n\u001a5u)\u0011\ti#a\u0011\u0011\r\u0005=\u00121GA\u001c\u001b\t\t\tD\u0003\u0002-C%!\u0011QGA\u0019\u0005\r!&/\u001f\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH&\u0002\t9|G-Z\u0005\u0005\u0003\u0003\nYD\u0001\u0006PE*,7\r\u001e(pI\u0016Dq!!\u0012\u000b\u0001\u0004\t9%\u0001\u0004iK&<\u0007\u000e\u001e\t\u0004A\u0005%\u0013bAA&C\t\u0019\u0011J\u001c;\u0002%\u001d,GO\u00117pG.LeNZ8Cs\"\u000b7\u000f\u001b\u000b\u0005\u0003[\t\t\u0006C\u0004\u0002T-\u0001\r!!\u0016\u0002\t!\f7\u000f\u001b\t\u0005\u0003/\nyF\u0004\u0003\u0002Z\u0005m\u0003CA.\"\u0013\r\ti&I\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00141\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u\u0013%A\thKRtUm\u001e\"m_\u000e\\\u0007*Y:iKN$b!!\f\u0002j\u0005}\u0004bBA6\u0019\u0001\u0007\u0011QN\u0001\u000eY>\u001c\u0017\r^8s\u0011\u0006\u001c\b.Z:\u0011\r\u0005=\u0014\u0011PA+\u001d\u0011\t\t(!\u001e\u000f\u0007m\u000b\u0019(C\u0001#\u0013\r\t9(I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY(! \u0003\u0007M+\u0017OC\u0002\u0002x\u0005Bq!!!\r\u0001\u0004\t9%A\u0003mS6LG/A\u0007hKRlU-\u001c9p_2$\u0006p\u001d\u000b\u0005\u0003[\t9\tC\u0004\u0002\n6\u0001\r!!\u001c\u0002\u000bQD\u0018\u000eZ:\u0002\u001b\u001d,GOU1x\u001b\u0016l\u0007o\\8m)\t\ti#\u0001\thKR\u0014Um\u001d;CY>\u001c7.\u00138g_\u0006aq-\u001a;CY>\u001c7.\u00138g_R!\u0011QFAK\u0011\u001d\t9\n\u0005a\u0001\u00033\u000bQA\u00197pG.\u0004B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0004\u0003/;\u0012\u0002BAQ\u0003;\u0013abU5eK\u000eD\u0017-\u001b8CY>\u001c7.A\u000bdC2\u001cW\u000f\\1uK\ncwnY6QCfdw.\u00193\u0015\u0011\u0005]\u0012qUAU\u0003WCq!a&\u0012\u0001\u0004\tI\nC\u0004\u0002FE\u0001\r!a\u0012\t\u000f\u00055\u0016\u00031\u0001\u00020\u0006\u0011b-Z3QCflWM\u001c;t\u0013:4wn\u00149u!\u0015\u0001\u0013\u0011WA[\u0013\r\t\u0019,\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/\u0018\u0003\u0015\u0019\u0007.Y5o\u0013\u0011\ty,!/\u00031MKG-Z2iC&tg)Z3QCflWM\u001c;t\u0013:4w\u000e")
public class SidechainNodeChannelImpl
implements SidechainNodeChannel,
SparkzLogging {
    private final Timeout duration;
    private final ExecutionContext ec;
    private final ObjectMapper mapper;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Timeout duration() {
        return this.duration;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public <R> R applyOnNodeView(Function1<NodeViewHolder.CurrentView<SidechainHistory, SidechainState, SidechainWallet, SidechainMemoryPool>, R> functionToBeApplied) {
        Object object;
        try {
            Object result;
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(WebSocketServerRef$.MODULE$.sidechainNodeViewHolderRef());
            NodeViewHolder.ReceivableMessages.GetDataFromCurrentView x$1 = new NodeViewHolder.ReceivableMessages.GetDataFromCurrentView(functionToBeApplied);
            Timeout x$2 = this.duration();
            ActorRef x$3 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$1);
            Future res = AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$1, x$2, x$3);
            object = result = Await$.MODULE$.result((Awaitable)res, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5000)).millis());
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return (R)object;
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHeight(int height) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> sidechainBlockHash = ((AbstractHistory)sidechainNodeView.history()).blockIdByHeight(height);
            if (sidechainBlockHash.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(28).append("Block not found for height: ").append(height).toString());
            }
            String blockId = (String)package.ModifierId$.MODULE$.$at$at(sidechainBlockHash.get(), package.Tagger$.MODULE$.baseRaw());
            Option sblockOpt = ((AbstractHistory)sidechainNodeView.history()).modifierById(blockId);
            if (sblockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(sidechainBlockHash).toString());
            }
            Option feePaymentsInfoOpt = ((AbstractHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple2(sblockOpt.get(), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), height, (Option<SidechainFeePaymentsInfo>)((Option)blockInfo._2())));
    }

    @Override
    public Try<ObjectNode> getBlockInfoByHash(String hash) {
        return ((Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String blockId = (String)package.ModifierId$.MODULE$.$at$at((Object)hash, package.Tagger$.MODULE$.baseRaw());
            Option blockOpt = ((AbstractHistory)sidechainNodeView.history()).modifierById(blockId);
            if (blockOpt.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(26).append("Block not found for hash: ").append(hash).toString());
            }
            int height = ((AbstractHistory)sidechainNodeView.history()).blockInfoById(blockId).height();
            Option feePaymentsInfoOpt = ((AbstractHistory)sidechainNodeView.history()).feePaymentsInfo(blockId);
            return new Tuple3(blockOpt.get(), (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
        }))).map((Function1 & Serializable & scala.Serializable)blockInfo -> this.calculateBlockPayload((SidechainBlock)blockInfo._1(), BoxesRunTime.unboxToInt((Object)blockInfo._2()), (Option<SidechainFeePaymentsInfo>)((Option)blockInfo._3())));
    }

    @Override
    public Try<ObjectNode> getNewBlockHashes(Seq<String> locatorHashes, int limit) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            IntRef lastHeight = IntRef.create((int)-1);
            ObjectNode responsePayload = this.mapper().createObjectNode();
            SidechainSyncInfo scInfo = new SidechainSyncInfo(locatorHashes);
            Seq headerList = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Seq<Tuple2<Object, String>> headers;
                block0: {
                    headers = ((AbstractHistory)sidechainNodeView.history()).continuationIds(scInfo, limit);
                    if (!headers.nonEmpty()) break block0;
                    lastHeight$1.elem = ((AbstractHistory)sidechainNodeView.history()).blockInfoById((String)((Tuple2)headers.last())._2()).height();
                }
                return headers;
            });
            JsonNode hashes = this.mapper().readTree(SerializationUtil.serialize(headerList.map((Function1 & Serializable & scala.Serializable)el -> (String)el._2(), Seq$.MODULE$.canBuildFrom())));
            responsePayload.put("height", lastHeight.elem);
            responsePayload.set("hashes", hashes);
            return responsePayload;
        });
    }

    @Override
    public Try<ObjectNode> getMempoolTxs(Seq<String> txids) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            Seq txs = (Seq)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> ((SidechainMemoryPool)sidechainNodeView.pool()).getAll(txids));
            JsonNode txsJson = this.mapper().readTree(SerializationUtil.serialize(txs));
            responsePayload.set("transactions", txsJson);
            return var2_2;
        });
    }

    @Override
    public Try<ObjectNode> getRawMempool() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ObjectNode responsePayload = this.mapper().createObjectNode();
            ArrayList txids = (ArrayList)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                void var1_1;
                ArrayList txs = new ArrayList();
                ((SidechainMemoryPool)sidechainNodeView.pool()).take(((SidechainMemoryPool)sidechainNodeView.pool()).size()).foreach((Function1 & Serializable & scala.Serializable)tx -> BoxesRunTime.boxToBoolean((boolean)txs.add(tx.id())));
                return var1_1;
            });
            JsonNode json = this.mapper().readTree(SerializationUtil.serialize(txids.toArray()));
            responsePayload.set("transactions", json);
            responsePayload.put("size", txids.size());
            return var1_1;
        });
    }

    @Override
    public Try<ObjectNode> getBestBlockInfo() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            SidechainBlock sidechainBlock;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = (Tuple3)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        SidechainBlock bBlock = (SidechainBlock)((AbstractHistory)sidechainNodeView.history()).bestBlock();
                        int height = ((AbstractHistory)sidechainNodeView.history()).height();
                        Option feePaymentsInfoOpt = ((AbstractHistory)sidechainNodeView.history()).feePaymentsInfo(bBlock.id());
                        return new Tuple3((Object)bBlock, (Object)BoxesRunTime.boxToInteger((int)height), feePaymentsInfoOpt);
                    });
                    if (tuple3 == null) break block2;
                    SidechainBlock bestBlock = (SidechainBlock)tuple3._1();
                    int height = BoxesRunTime.unboxToInt((Object)tuple3._2());
                    feePaymentsInfoOpt = (Option)tuple3._3();
                    if (bestBlock == null) break block2;
                    sidechainBlock = bestBlock;
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Option option = feePaymentsInfoOpt;
            Tuple3 tuple3 = new Tuple3((Object)sidechainBlock, (Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple3 tuple32 = tuple3;
            SidechainBlock bestBlock = (SidechainBlock)tuple32._1();
            int height = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option feePaymentsInfoOpt2 = (Option)tuple32._3();
            return this.calculateBlockPayload(bestBlock, height, (Option<SidechainFeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    @Override
    public Try<ObjectNode> getBlockInfo(SidechainBlock block) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int n;
            Option feePaymentsInfoOpt;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = (Tuple2)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)((AbstractHistory)sidechainNodeView.history()).blockInfoById(block.id()).height()), ((AbstractHistory)sidechainNodeView.history()).feePaymentsInfo(block.id())));
                    if (tuple2 == null) break block2;
                    int height = tuple2._1$mcI$sp();
                    feePaymentsInfoOpt = (Option)tuple2._2();
                    n = height;
                    if (feePaymentsInfoOpt != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Option option = feePaymentsInfoOpt;
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)option);
            Tuple2 tuple22 = tuple2;
            int height = tuple22._1$mcI$sp();
            Option feePaymentsInfoOpt2 = (Option)tuple22._2();
            return this.calculateBlockPayload(block, height, (Option<SidechainFeePaymentsInfo>)feePaymentsInfoOpt2);
        });
    }

    private ObjectNode calculateBlockPayload(SidechainBlock block, int height, Option<SidechainFeePaymentsInfo> feePaymentsInfoOpt) {
        ObjectNode eventPayload = this.mapper().createObjectNode();
        JsonNode blockJson = this.mapper().readTree(SerializationUtil.serialize(block));
        eventPayload.put("height", height);
        eventPayload.put("hash", block.id());
        eventPayload.set("block", blockJson);
        feePaymentsInfoOpt.foreach((Function1 & Serializable & scala.Serializable)feePaymentsInfo -> {
            JsonNode feePaymentsTxJson = this.mapper().readTree(SerializationUtil.serialize(feePaymentsInfo.transaction()));
            return (ObjectNode)eventPayload.set("feePayments", feePaymentsTxJson);
        });
        return eventPayload;
    }

    public SidechainNodeChannelImpl() {
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.duration = Timeout$.MODULE$.durationToTimeout(new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds());
        this.ec = ExecutionContext.Implicits$.MODULE$.global();
        this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
    }
}

