/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofTypes;
import io.horizen.proof.Proof;
import io.horizen.proof.SchnorrProof;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.SchnorrProposition;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.transaction.TransactionSerializer;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utils.Pair;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.box.data.ZenBoxData;
import io.horizen.utxo.transaction.CertificateKeyRotationTransactionIncompatibilityChecker;
import io.horizen.utxo.transaction.CertificateKeyRotationTransactionSerializer;
import io.horizen.utxo.transaction.CoreTransactionsIdsEnum;
import io.horizen.utxo.transaction.SidechainNoncedTransaction;
import io.horizen.utxo.transaction.TransactionIncompatibilityChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.util.Arrays;
import scala.Array;
import scala.Enumeration;

public class CertificateKeyRotationTransaction
extends SidechainNoncedTransaction<PublicKey25519Proposition, ZenBox, ZenBoxData> {
    public static final byte CERTIFICATE_KEY_ROTATION_TRANSACTION_VERSION = 1;
    final byte[] inputId;
    final Optional<ZenBoxData> outputData;
    final Signature25519 proof;
    private final long fee;
    private final byte version;
    private List<BoxUnlocker<PublicKey25519Proposition>> unlockers;
    final KeyRotationProof keyRotationProof;
    private final SchnorrProof newKeySignature;

    public CertificateKeyRotationTransaction(byte[] inputId, Optional<ZenBoxData> outputData, Signature25519 proof, long fee, byte version, KeyRotationProof keyRotationProof, SchnorrProof newKeySignature) {
        this.inputId = inputId;
        this.outputData = outputData;
        this.proof = proof;
        this.fee = fee;
        this.version = version;
        this.keyRotationProof = keyRotationProof;
        this.newKeySignature = newKeySignature;
    }

    public TransactionSerializer serializer() {
        return CertificateKeyRotationTransactionSerializer.getSerializer();
    }

    @Override
    public synchronized List<BoxUnlocker<PublicKey25519Proposition>> unlockers() {
        if (this.unlockers == null) {
            this.unlockers = new ArrayList<BoxUnlocker<PublicKey25519Proposition>>();
            BoxUnlocker<PublicKey25519Proposition> unlocker = new BoxUnlocker<PublicKey25519Proposition>(){

                @Override
                public byte[] closedBoxId() {
                    return CertificateKeyRotationTransaction.this.inputId;
                }

                @Override
                public Proof<PublicKey25519Proposition> boxKey() {
                    return CertificateKeyRotationTransaction.this.proof;
                }
            };
            this.unlockers.add(unlocker);
        }
        return Collections.unmodifiableList(this.unlockers);
    }

    @Override
    protected List<ZenBoxData> getOutputData() {
        ArrayList<ZenBoxData> output = new ArrayList<ZenBoxData>();
        this.outputData.ifPresent(output::add);
        return output;
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public void transactionSemanticValidity() throws TransactionSemanticValidityException {
        if (this.version != 1) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: unsupported version number.", this.id()));
        }
        if (this.inputId == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no input data present.", this.id()));
        }
        if (this.proof == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no proof data present.", this.id()));
        }
        if (this.keyRotationProof.index() < 0) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: forgerList index negative.", this.id()));
        }
        if (this.keyRotationProof.newKey() == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no newKey data present.", this.id()));
        }
        if (this.keyRotationProof.signingKeySignature() == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no signingKeySignature data present.", this.id()));
        }
        if (this.keyRotationProof.masterKeySignature() == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no masterKeySignature data present.", this.id()));
        }
        if (this.newKeySignature == null) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no newKeySignature data present.", this.id()));
        }
    }

    @Override
    public byte transactionTypeId() {
        return CoreTransactionsIdsEnum.KeyRotationTransactionId.id();
    }

    @Override
    public byte version() {
        return this.version;
    }

    @Override
    public Boolean isCustom() {
        return false;
    }

    @Override
    public byte[] customFieldsData() {
        return Array.emptyByteArray();
    }

    @Override
    public byte[] customDataMessageToSign() {
        return Arrays.concatenate((byte[])this.keyRotationProof.bytes(), (byte[])this.newKeySignature.bytes());
    }

    public SchnorrProof getNewKeySignature() {
        return this.newKeySignature;
    }

    public KeyRotationProof getKeyRotationProof() {
        return this.keyRotationProof;
    }

    @Override
    public TransactionIncompatibilityChecker incompatibilityChecker() {
        return new CertificateKeyRotationTransactionIncompatibilityChecker();
    }

    public static CertificateKeyRotationTransaction create(Pair<ZenBox, PrivateKey25519> from, PublicKey25519Proposition changeAddress, long fee, int keyTypeEnumerationNumber, int indexOfKey, SchnorrProposition newKey, SchnorrProof signingKeySignature, SchnorrProof masterKeySignature, SchnorrProof newKeySignature) throws TransactionSemanticValidityException {
        if (from == null) {
            throw new IllegalArgumentException("Parameters can't be null.");
        }
        if (from.getKey().value() < fee) {
            throw new IllegalArgumentException("Fee can't be greater than the input!");
        }
        Optional<ZenBoxData> output = Optional.empty();
        if (from.getKey().value() > fee) {
            output = Optional.of(new ZenBoxData(changeAddress, from.getKey().value() - fee));
        }
        if (keyTypeEnumerationNumber < 0 || keyTypeEnumerationNumber >= KeyRotationProofTypes.maxId()) {
            throw new IllegalArgumentException("Key type enumeration value should be valid!");
        }
        Enumeration.Value keyRotationProofType = KeyRotationProofTypes.apply(keyTypeEnumerationNumber);
        KeyRotationProof keyRotationProof = new KeyRotationProof(keyRotationProofType, indexOfKey, newKey, signingKeySignature, masterKeySignature);
        CertificateKeyRotationTransaction unsignedTransaction = new CertificateKeyRotationTransaction(from.getKey().id(), output, null, fee, 1, keyRotationProof, newKeySignature);
        byte[] messageToSign = unsignedTransaction.messageToSign();
        Secret secret = from.getValue();
        CertificateKeyRotationTransaction transaction = new CertificateKeyRotationTransaction(from.getKey().id(), output, (Signature25519)secret.sign(messageToSign), fee, 1, keyRotationProof, newKeySignature);
        transaction.transactionSemanticValidity();
        return transaction;
    }
}

