/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.transaction;

import io.horizen.proof.Proof;
import io.horizen.proof.Signature25519;
import io.horizen.proof.Signature25519Serializer;
import io.horizen.proposition.Proposition;
import io.horizen.transaction.exception.TransactionSemanticValidityException;
import io.horizen.utils.ListSerializer;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.BoxUnlocker;
import io.horizen.utxo.box.data.BoxData;
import io.horizen.utxo.box.data.ZenBoxData;
import io.horizen.utxo.box.data.ZenBoxDataSerializer;
import io.horizen.utxo.transaction.SidechainNoncedTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRegularTransaction
extends SidechainNoncedTransaction<Proposition, Box<Proposition>, BoxData<Proposition, Box<Proposition>>> {
    protected final List<byte[]> inputZenBoxIds;
    protected final List<Signature25519> inputZenBoxProofs;
    protected final List<ZenBoxData> outputZenBoxesData;
    protected final long fee;
    List<BoxData<Proposition, Box<Proposition>>> allBoxesData;
    protected static ListSerializer<Signature25519> zenBoxProofsSerializer = new ListSerializer<Signature25519>(Signature25519Serializer.getSerializer(), 1000);
    protected static ListSerializer<ZenBoxData> zenBoxDataListSerializer = new ListSerializer<ZenBoxData>(ZenBoxDataSerializer.getSerializer(), 1000);

    public AbstractRegularTransaction(List<byte[]> inputZenBoxIds, List<Signature25519> inputZenBoxProofs, List<ZenBoxData> outputZenBoxesData, long fee) {
        this.inputZenBoxIds = inputZenBoxIds;
        this.inputZenBoxProofs = inputZenBoxProofs;
        this.outputZenBoxesData = outputZenBoxesData;
        this.fee = fee;
    }

    protected abstract List<BoxData<Proposition, Box<Proposition>>> getCustomOutputData();

    @Override
    protected final List<BoxData<Proposition, Box<Proposition>>> getOutputData() {
        if (this.allBoxesData == null) {
            this.allBoxesData = new ArrayList<BoxData<Proposition, Box<Proposition>>>();
            for (ZenBoxData zenBoxData : this.outputZenBoxesData) {
                this.allBoxesData.add(zenBoxData);
            }
            this.allBoxesData.addAll(this.getCustomOutputData());
        }
        return Collections.unmodifiableList(this.allBoxesData);
    }

    @Override
    public List<BoxUnlocker<Proposition>> unlockers() {
        ArrayList<BoxUnlocker<Proposition>> unlockers = new ArrayList<BoxUnlocker<Proposition>>();
        int i = 0;
        while (i < this.inputZenBoxIds.size() && i < this.inputZenBoxProofs.size()) {
            final int finalI = i++;
            BoxUnlocker<Proposition> unlocker = new BoxUnlocker<Proposition>(){

                @Override
                public byte[] closedBoxId() {
                    return AbstractRegularTransaction.this.inputZenBoxIds.get(finalI);
                }

                @Override
                public Proof boxKey() {
                    return AbstractRegularTransaction.this.inputZenBoxProofs.get(finalI);
                }
            };
            unlockers.add(unlocker);
        }
        return unlockers;
    }

    @Override
    public long fee() {
        return this.fee;
    }

    @Override
    public void transactionSemanticValidity() throws TransactionSemanticValidityException {
        if (this.inputZenBoxIds.size() != this.inputZenBoxProofs.size()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: inputs number is not consistent to proofs number.", this.id()));
        }
        if (this.inputZenBoxIds.isEmpty()) {
            throw new TransactionSemanticValidityException(String.format("Transaction [%s] is semantically invalid: no zen inputs found.", this.id()));
        }
    }
}

