/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.block.WithdrawalEpochCertificate;
import io.horizen.block.WithdrawalEpochCertificateSerializer$;
import io.horizen.certificatesubmitter.keys.CertifiersKeys;
import io.horizen.certificatesubmitter.keys.CertifiersKeysSerializer$;
import io.horizen.certificatesubmitter.keys.KeyRotationProof;
import io.horizen.certificatesubmitter.keys.KeyRotationProofSerializer$;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.storage.StorageIterator;
import io.horizen.storage.leveldb.package$Constants$;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.ListSerializer;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochInfoSerializer$;
import io.horizen.utils.package$;
import io.horizen.utxo.backup.BackupBox;
import io.horizen.utxo.backup.BoxIterator;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.WithdrawalRequestBoxSerializer;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.companion.SidechainBoxesCompanion;
import io.horizen.utxo.forge.ForgerList;
import io.horizen.utxo.forge.ForgerListSerializer$;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import io.horizen.utxo.utils.BlockFeeInfo;
import io.horizen.utxo.utils.BlockFeeInfoSerializer$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\rEc\u0001\u0002\u001d:\u0001\tC\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"AA\r\u0001B\u0001B\u0003%Q\rC\u0003k\u0001\u0011\u00051\u000e\u0003\u0005r\u0001\t\u0007I\u0011A\u001fs\u0011\u0019I\b\u0001)A\u0005g\"9!\u0010\u0001b\u0001\n\u0013Y\bbBA\u0006\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u001b\u0001!\u0019!C\u0001{IDq!a\u0004\u0001A\u0003%1\u000fC\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001>e\"9\u00111\u0003\u0001!\u0002\u0013\u0019\b\"CA\u000b\u0001\t\u0007I\u0011A\u001fs\u0011\u001d\t9\u0002\u0001Q\u0001\nMD\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\t\u0011\u0005\r\u0002\u0001)A\u0005\u0003;A\u0001\"!\n\u0001\t\u0003i\u0014q\u0005\u0005\t\u0003[\u0001A\u0011A\u001f\u00020!A\u0011q\u0007\u0001\u0005\u0002u\nI\u0004\u0003\u0005\u0002>\u0001!\t!PA \u0011!\tY\u0005\u0001C\u0001{\u00055\u0003\"CA*\u0001\t\u0007I\u0011A\u001fs\u0011\u001d\t)\u0006\u0001Q\u0001\nMD\u0011\"a\u0016\u0001\u0005\u0004%\t!\u0010:\t\u000f\u0005e\u0003\u0001)A\u0005g\"I\u00111\f\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002\u001e!A\u0011q\f\u0001\u0005\u0002u\n\t\u0007\u0003\u0005\u0002h\u0001!\t!PA5\u0011!\ty\u0007\u0001C\u0001{\u0005E\u0004bBA;\u0001\u0011\u0005\u0011q\u000f\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\ti\u000b\u0001C\u0001\u0003_Cq!!.\u0001\t\u0013\t9\fC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u00111\u001e\u0001\u0005\u0002\u00055\bb\u0002B\u0002\u0001\u0011\u0005!Q\u0001\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B?\u0001\u0011\u0005!q\u0010\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0011%\u0011Y\u000fAI\u0001\n\u0003\u0011i\u000fC\u0005\u0004\u0004\u0001\t\n\u0011\"\u0001\u0004\u0006!91\u0011\u0002\u0001\u0005B\r-\u0001bBB\b\u0001\u0011\u00051\u0011\u0003\u0005\b\u0007\u001f\u0001A\u0011AB\u000b\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007GAqaa\n\u0001\t\u0003\u0011\u0019\u0006C\u0004\u0004*\u0001!\taa\u000b\t\u000f\rM\u0002\u0001\"\u0001\u00046\t)2+\u001b3fG\"\f\u0017N\\*uCR,7\u000b^8sC\u001e,'B\u0001\u001e<\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001P\u001f\u0002\tU$\bp\u001c\u0006\u0003}}\nq\u0001[8sSj,gNC\u0001A\u0003\tIwn\u0001\u0001\u0014\u000b\u0001\u0019\u0015*\u0015,\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\tQu*D\u0001L\u0015\taU*\u0001\u0003vi&d'\"\u0001(\u0002\rM\u0004\u0018M]6{\u0013\t\u00016JA\u0007Ta\u0006\u00148N\u001f'pO\u001eLgn\u001a\t\u0003%Rk\u0011a\u0015\u0006\u0003uuJ!!V*\u0003)MKG-Z2iC&t7\u000b^8sC\u001e,\u0017J\u001c4p!\t9\u0006,D\u0001>\u0013\tIVH\u0001\bTS\u0012,7\r[1j]RK\b/Z:\u0011\u0005I[\u0016B\u0001/T\u0005\u001d\u0019Fo\u001c:bO\u0016\fqc]5eK\u000eD\u0017-\u001b8C_b,7oQ8na\u0006t\u0017n\u001c8\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\\\u0014!C2p[B\fg.[8o\u0013\t\u0019\u0007MA\fTS\u0012,7\r[1j]\n{\u00070Z:D_6\u0004\u0018M\\5p]\u00061\u0001/\u0019:b[N\u0004\"A\u001a5\u000e\u0003\u001dT!\u0001Z\u001f\n\u0005%<'!\u0004(fi^|'o\u001b)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u0005Y:|\u0007\u000f\u0005\u0002n\u00015\t\u0011\bC\u0003;\t\u0001\u0007!\fC\u0003^\t\u0001\u0007a\fC\u0003e\t\u0001\u0007Q-A\u000fxSRDGM]1xC2,\u0005o\\2i\u0013:4wN]7bi&|gnS3z+\u0005\u0019\bC\u0001;x\u001b\u0005)(B\u0001<>\u0003\u0015)H/\u001b7t\u0013\tAXO\u0001\tCsR,\u0017I\u001d:bs^\u0013\u0018\r\u001d9fe\u0006qr/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_Jl\u0017\r^5p].+\u0017\u0010I\u0001\u001co&$\b\u000e\u001a:bo\u0006d'+Z9vKN$8+\u001a:jC2L'0\u001a:\u0016\u0003q\u00042\u0001^?\u0000\u0013\tqXO\u0001\bMSN$8+\u001a:jC2L'0\u001a:\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002<\u0003\r\u0011w\u000e_\u0005\u0005\u0003\u0013\t\u0019A\u0001\u000bXSRDGM]1xC2\u0014V-];fgR\u0014u\u000e_\u0001\u001do&$\b\u000e\u001a:bo\u0006d'+Z9vKN$8+\u001a:jC2L'0\u001a:!\u0003E\u0019wN\\:f]N,8/\u00129pG\"\\U-_\u0001\u0013G>t7/\u001a8tkN,\u0005o\\2i\u0017\u0016L\b%A\bdK\u0006\u001c\u0018N\\4Ti\u0006$XmS3z\u0003A\u0019W-Y:j]\u001e\u001cF/\u0019;f\u0017\u0016L\b%\u0001\ng_J<WM\u001d'jgRLe\u000eZ3y\u0017\u0016L\u0018a\u00054pe\u001e,'\u000fT5ti&sG-\u001a=LKf\u0004\u0013aH;oI\u00164\u0017N\\3e/&$\b\u000e\u001a:bo\u0006dW\t]8dQ\u000e{WO\u001c;feV\u0011\u0011Q\u0004\t\u0004\t\u0006}\u0011bAA\u0011\u000b\n\u0019\u0011J\u001c;\u0002AUtG-\u001a4j]\u0016$w+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ8v]R,'\u000fI\u0001\u001dO\u0016$x+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ8v]R,'oS3z)\r\u0019\u0018\u0011\u0006\u0005\b\u0003W\t\u0002\u0019AA\u000f\u0003=9\u0018\u000e\u001e5ee\u0006<\u0018\r\\#q_\u000eD\u0017\u0001G4fi^KG\u000f\u001b3sC^\fGNU3rk\u0016\u001cHo]&fsR)1/!\r\u00024!9\u00111\u0006\nA\u0002\u0005u\u0001bBA\u001b%\u0001\u0007\u0011QD\u0001\bG>,h\u000e^3s\u0003]9W\r^\"feRLg-[3sgN#xN]1hK.+\u0017\u0010F\u0002t\u0003wAq!a\u000b\u0014\u0001\u0004\ti\"\u0001\fhKR\\U-\u001f*pi\u0006$\u0018n\u001c8Qe>|gmS3z)\u001d\u0019\u0018\u0011IA\"\u0003\u000fBq!a\u000b\u0015\u0001\u0004\ti\u0002C\u0004\u0002FQ\u0001\r!!\b\u0002\u001b%tG-\u001a=PMNKwM\\3s\u0011\u001d\tI\u0005\u0006a\u0001\u0003;\tqa[3z)f\u0004X-A\u000ehKR$v\u000e])vC2LG/_\"feRLg-[2bi\u0016\\U-\u001f\u000b\u0004g\u0006=\u0003bBA)+\u0001\u0007\u0011QD\u0001\u001ae\u00164WM]3oG\u0016$w+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u0001\u0011hKRd\u0015m\u001d;DKJ$\u0018NZ5dCR,W\t]8dQ:+XNY3s\u0017\u0016L\u0018!I4fi2\u000b7\u000f^\"feRLg-[2bi\u0016,\u0005o\\2i\u001dVl'-\u001a:LKf\u0004\u0013!J4fi2\u000b7\u000f^\"feRLg-[2bi\u0016\u001c\u0016\u000eZ3dQ\u0006LgN\u00117pG.LEmS3z\u0003\u0019:W\r\u001e'bgR\u001cUM\u001d;jM&\u001c\u0017\r^3TS\u0012,7\r[1j]\ncwnY6JI.+\u0017\u0010I\u0001\u001dk:$WMZ5oK\u0012\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0007>,h\u000e^3s\u0003u)h\u000eZ3gS:,GM\u00117pG.4U-Z%oM>\u001cu.\u001e8uKJ\u0004\u0013!G4fi\ncwnY6GK\u0016LeNZ8D_VtG/\u001a:LKf$2a]A2\u0011\u001d\t)\u0007\ba\u0001\u0003;\tQc^5uQ\u0012\u0014\u0018m^1m\u000bB|7\r\u001b(v[\n,'/\u0001\nhKR\u0014En\\2l\r\u0016,\u0017J\u001c4p\u0017\u0016LH#B:\u0002l\u00055\u0004bBA3;\u0001\u0007\u0011Q\u0004\u0005\b\u0003ki\u0002\u0019AA\u000f\u0003a9W\r^+uq>lUM]6mKR\u0013X-\u001a*p_R\\U-\u001f\u000b\u0004g\u0006M\u0004bBA3=\u0001\u0007\u0011QD\u0001\u0007O\u0016$(i\u001c=\u0015\t\u0005e\u0014\u0011\u0013\t\u0006\t\u0006m\u0014qP\u0005\u0004\u0003{*%AB(qi&|g\u000e\u0005\u0004\u0002\u0002\u0005\u0005\u0015QQ\u0005\u0005\u0003\u0007\u000b\u0019AA\u0002C_b\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017k\u0014a\u00039s_B|7/\u001b;j_:LA!a$\u0002\n\nY\u0001K]8q_NLG/[8o\u0011\u001d\t\u0019j\ba\u0001\u0003+\u000bQAY8y\u0013\u0012\u0004R\u0001RAL\u00037K1!!'F\u0005\u0015\t%O]1z!\r!\u0015QT\u0005\u0004\u0003?+%\u0001\u0002\"zi\u0016\facZ3u/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\\\u000b\u0003\u0003K\u0003R\u0001RA>\u0003O\u00032\u0001^AU\u0013\r\tY+\u001e\u0002\u0014/&$\b\u000e\u001a:bo\u0006dW\t]8dQ&sgm\\\u0001\u001aO\u0016$x+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ8v]R,'\u000f\u0006\u0003\u0002\u001e\u0005E\u0006bBAZC\u0001\u0007\u0011QD\u0001\u0006KB|7\r[\u0001\u0017O\u0016$(\t\\8dW\u001a+W-\u00138g_\u000e{WO\u001c;feR!\u0011QDA]\u0011\u001d\t)G\ta\u0001\u0003;\tabZ3u\r\u0016,\u0007+Y=nK:$8\u000f\u0006\u0003\u0002@\u0006\u0005\bCBAa\u0003#\f9N\u0004\u0003\u0002D\u00065g\u0002BAc\u0003\u0017l!!a2\u000b\u0007\u0005%\u0017)\u0001\u0004=e>|GOP\u0005\u0002\r&\u0019\u0011qZ#\u0002\u000fA\f7m[1hK&!\u00111[Ak\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u001f,\u0005\u0003BAm\u0003;l!!a7\u000b\u0005Y\\\u0014\u0002BAp\u00037\u0014AB\u00117pG.4U-Z%oM>Dq!!\u001a$\u0001\u0004\ti\"A\u000bhKR<\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f^:\u0015\t\u0005\u001d\u0018\u0011\u001e\t\u0006\u0003\u0003\f\tn \u0005\b\u0003W!\u0003\u0019AA\u000f\u0003E9W\r^\"feRLg-[3sg.+\u0017p\u001d\u000b\u0005\u0003_\u0014\t\u0001E\u0003E\u0003w\n\t\u0010\u0005\u0003\u0002t\u0006uXBAA{\u0015\u0011\t90!?\u0002\t-,\u0017p\u001d\u0006\u0004\u0003wl\u0014\u0001F2feRLg-[2bi\u0016\u001cXOY7jiR,'/\u0003\u0003\u0002\u0000\u0006U(AD\"feRLg-[3sg.+\u0017p\u001d\u0005\b\u0003W)\u0003\u0019AA\u000f\u0003M9W\r^&fsJ{G/\u0019;j_:\u0004&o\\8g)!\u00119Aa\u0004\u0003\u0012\tM\u0001#\u0002#\u0002|\t%\u0001\u0003BAz\u0005\u0017IAA!\u0004\u0002v\n\u00012*Z=S_R\fG/[8o!J|wN\u001a\u0005\b\u0003K2\u0003\u0019AA\u000f\u0011\u001d\t)E\na\u0001\u0003;Aq!!\u0013'\u0001\u0004\ti\"\u0001\rhKR$v\u000e])vC2LG/_\"feRLg-[2bi\u0016$BA!\u0007\u0003(A)A)a\u001f\u0003\u001cA!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"u\nQA\u00197pG.LAA!\n\u0003 \tQr+\u001b;iIJ\fw/\u00197Fa>\u001c\u0007nQ3si&4\u0017nY1uK\"9\u0011\u0011K\u0014A\u0002\u0005u\u0011!I4fi2\u000b7\u000f^\"feRLg-[2bi\u0016\u0014VMZ3sK:\u001cW\rZ#q_\u000eDGC\u0001B\u0017!\u0015!\u00151PA\u000f\u0003\t:W\r\u001e'bgR\u001cUM\u001d;jM&\u001c\u0017\r^3TS\u0012,7\r[1j]\ncwnY6JIR\u0011!1\u0007\t\u0006\t\u0006m$Q\u0007\t\u0005\u0005o\u0011\u0019E\u0004\u0003\u0003:\t\u0005c\u0002\u0002B\u001e\u0005\u007fqA!!2\u0003>%\ta*\u0003\u0002M\u001b&\u0019\u0011qZ&\n\t\t\u0015#q\t\u0002\u000b\u001b>$\u0017NZ5fe&#'bAAh\u0017\u0006)r-\u001a;Vib|W*\u001a:lY\u0016$&/Z3S_>$H\u0003\u0002B'\u0005\u001f\u0002R\u0001RA>\u0003+Cq!a\u000b+\u0001\u0004\ti\"A\u0005iCN\u001cU-Y:fIV\u0011!Q\u000b\t\u0004\t\n]\u0013b\u0001B-\u000b\n9!i\\8mK\u0006t\u0017aF4fi\u000e{gn]3ogV\u001cX\t]8dQ:+XNY3s+\t\u0011y\u0006E\u0003E\u0003w\u0012\t\u0007\u0005\u0003\u0003d\t]d\u0002\u0002B3\u0005grAAa\u001a\u0003p9!!\u0011\u000eB7\u001d\u0011\t)Ma\u001b\n\u0003\u0001K!AP \n\u0007\tET(A\u0005d_:\u001cXM\\:vg&!\u0011q\u001aB;\u0015\r\u0011\t(P\u0005\u0005\u0005s\u0012YH\u0001\u000bD_:\u001cXM\\:vg\u0016\u0003xn\u00195Ok6\u0014WM\u001d\u0006\u0005\u0003\u001f\u0014)(A\u0007hKR4uN]4fe2K7\u000f^\u000b\u0003\u0005\u0003\u0003R\u0001RA>\u0005\u0007\u0003BA!\"\u0003\f6\u0011!q\u0011\u0006\u0004\u0005\u0013[\u0014!\u00024pe\u001e,\u0017\u0002\u0002BG\u0005\u000f\u0013!BR8sO\u0016\u0014H*[:u\u0003\u0019)\b\u000fZ1uKRq\"1\u0013BO\u0005C\u0013)K!/\u0003@\n\r'q\u0019Bf\u0005\u001f\u0014\u0019Na6\u0003^\n\u0005(q\u001d\t\u0006\u0005+\u0013I\n\\\u0007\u0003\u0005/S!\u0001T#\n\t\tm%q\u0013\u0002\u0004)JL\bB\u0002BP]\u0001\u00071/A\u0004wKJ\u001c\u0018n\u001c8\t\u000f\t\rf\u00061\u0001\u0002(\u0006\u0019r/\u001b;iIJ\fw/\u00197Fa>\u001c\u0007.\u00138g_\"9!q\u0015\u0018A\u0002\t%\u0016!\u00042pqV\u0003H-\u0019;f\u0019&\u001cH\u000f\u0005\u0004\u0003,\nM\u0016q\u0010\b\u0005\u0005[\u0013y\u000bE\u0002\u0002F\u0016K1A!-F\u0003\u0019\u0001&/\u001a3fM&!!Q\u0017B\\\u0005\r\u0019V\r\u001e\u0006\u0004\u0005c+\u0005b\u0002B^]\u0001\u0007!QX\u0001\u0010E>D\u0018\nZ:SK6|g/Z*fiB)!1\u0016BZg\"9!\u0011\u0019\u0018A\u0002\u0005\u001d\u0018AG<ji\"$'/Y<bYJ+\u0017/^3ti\u0006\u0003\b/\u001a8e'\u0016\f\bb\u0002Bc]\u0001\u0007!\u0011M\u0001\u000fG>t7/\u001a8tkN,\u0005o\\2i\u0011\u001d\u0011IM\fa\u0001\u00053\t\u0001\u0004^8q#V\fG.\u001b;z\u0007\u0016\u0014H/\u001b4jG\u0006$Xm\u00149u\u0011\u001d\u0011iM\fa\u0001\u0003/\fAB\u00197pG.4U-Z%oM>DqA!5/\u0001\u0004\u0011i%A\u000bvib|W*\u001a:lY\u0016$&/Z3S_>$x\n\u001d;\t\u000f\tUg\u00061\u0001\u0003V\u0005Y1o\u0019%bg\u000e+\u0017m]3e\u0011\u001d\u0011IN\fa\u0001\u00057\f\u0011CZ8sO\u0016\u0014H*[:u\u0013:$W\r_3t!\u0015!\u0015qSA\u000f\u0011\u001d\u0011yN\fa\u0001\u0003;\taBZ8sO\u0016\u0014H*[:u'&TX\rC\u0005\u0003d:\u0002\n\u00111\u0001\u0003f\u0006\t2.Z=S_R\fG/[8o!J|wNZ:\u0011\r\u0005\u0005\u0017\u0011\u001bB\u0005\u0011%\u0011IO\fI\u0001\u0002\u0004\ty/\u0001\u000bdKJ$\u0018NZ5feN\\U-_:PaRLwN\\\u0001\u0012kB$\u0017\r^3%I\u00164\u0017-\u001e7uIE\u001aTC\u0001BxU\u0011\u0011)O!=,\u0005\tM\b\u0003\u0002B{\u0005\u007fl!Aa>\u000b\t\te(1`\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!@F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0003\u00119PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011#\u001e9eCR,G\u0005Z3gCVdG\u000fJ\u00195+\t\u00199A\u000b\u0003\u0002p\nE\u0018!\u00047bgR4VM]:j_:LE-\u0006\u0002\u0004\u000eA!A)a\u001ft\u0003A\u0011x\u000e\u001c7cC\u000e\\g+\u001a:tS>t7\u000f\u0006\u0002\u0004\u0014A)\u0011\u0011YAigR!1qCB\u000f!\u0015\t\tm!\u0007t\u0013\u0011\u0019Y\"!6\u0003\t1K7\u000f\u001e\u0005\b\u0007?\u0019\u0004\u0019AA\u000f\u0003Mi\u0017\r\u001f(v[\n,'o\u00144WKJ\u001c\u0018n\u001c8t\u0003!\u0011x\u000e\u001c7cC\u000e\\G\u0003\u0002BJ\u0007KAaAa(5\u0001\u0004\u0019\u0018aB5t\u000b6\u0004H/_\u0001\fO\u0016$\u0018\n^3sCR|'/\u0006\u0002\u0004.A\u0019!ka\f\n\u0007\rE2KA\bTi>\u0014\u0018mZ3Ji\u0016\u0014\u0018\r^8s\u00035\u0011Xm\u001d;pe\u0016\u0014\u0015mY6vaR11qGB\u001f\u0007\u001b\u00022\u0001RB\u001d\u0013\r\u0019Y$\u0012\u0002\u0005+:LG\u000fC\u0004\u0004@]\u0002\ra!\u0011\u00021\t\f7m[;q'R|'/Y4f\u0005>D\u0018\n^3sCR|'\u000f\u0005\u0003\u0004D\r%SBAB#\u0015\r\u00199eO\u0001\u0007E\u0006\u001c7.\u001e9\n\t\r-3Q\t\u0002\f\u0005>D\u0018\n^3sCR|'\u000fC\u0004\u0004P]\u0002\r!!&\u0002\u00171\f7\u000f\u001e,feNLwN\u001c")
public class SidechainStateStorage
implements SparkzLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final NetworkParams params;
    private final ByteArrayWrapper withdrawalEpochInformationKey;
    private final ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer;
    private final ByteArrayWrapper consensusEpochKey;
    private final ByteArrayWrapper ceasingStateKey;
    private final ByteArrayWrapper forgerListIndexKey;
    private final int undefinedWithdrawalEpochCounter;
    private final ByteArrayWrapper getLastCertificateEpochNumberKey;
    private final ByteArrayWrapper getLastCertificateSidechainBlockIdKey;
    private final int undefinedBlockFeeInfoCounter;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ByteArrayWrapper withdrawalEpochInformationKey() {
        return this.withdrawalEpochInformationKey;
    }

    private ListSerializer<WithdrawalRequestBox> withdrawalRequestSerializer() {
        return this.withdrawalRequestSerializer;
    }

    public ByteArrayWrapper consensusEpochKey() {
        return this.consensusEpochKey;
    }

    public ByteArrayWrapper ceasingStateKey() {
        return this.ceasingStateKey;
    }

    public ByteArrayWrapper forgerListIndexKey() {
        return this.forgerListIndexKey;
    }

    private int undefinedWithdrawalEpochCounter() {
        return this.undefinedWithdrawalEpochCounter;
    }

    public ByteArrayWrapper getWithdrawalEpochCounterKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalEpochCounter".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getWithdrawalRequestsKey(int withdrawalEpoch, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"withdrawalRequests".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getCertifiersStorageKey(int withdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"certificateKeys".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch)}));
    }

    public ByteArrayWrapper getKeyRotationProofKey(int withdrawalEpoch, int indexOfSigner, int keyType) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"keyRotationProof".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpoch), Ints.toByteArray((int)indexOfSigner), Ints.toByteArray((int)keyType)}));
    }

    public ByteArrayWrapper getTopQualityCertificateKey(int referencedWithdrawalEpoch) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"topQualityCertificate".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)referencedWithdrawalEpoch)}));
    }

    public ByteArrayWrapper getLastCertificateEpochNumberKey() {
        return this.getLastCertificateEpochNumberKey;
    }

    public ByteArrayWrapper getLastCertificateSidechainBlockIdKey() {
        return this.getLastCertificateSidechainBlockIdKey;
    }

    private int undefinedBlockFeeInfoCounter() {
        return this.undefinedBlockFeeInfoCounter;
    }

    public ByteArrayWrapper getBlockFeeInfoCounterKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfoCounter".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public ByteArrayWrapper getBlockFeeInfoKey(int withdrawalEpochNumber, int counter) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"blockFeeInfo".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpochNumber), Ints.toByteArray((int)counter)}));
    }

    public ByteArrayWrapper getUtxoMerkleTreeRootKey(int withdrawalEpochNumber) {
        return Utils.calculateKey(Bytes.concat((byte[][])new byte[][]{"utxoMerkleTreeRoot".getBytes(StandardCharsets.UTF_8), Ints.toByteArray((int)withdrawalEpochNumber)}));
    }

    public Option<Box<Proposition>> getBox(byte[] boxId) {
        Option option;
        Optional<ByteArrayWrapper> optional = this.storage.get(Utils.calculateKey(boxId));
        if (optional.isPresent()) {
            Option option2;
            Try try_ = this.sidechainBoxesCompanion.parseBytesTry(optional.get().data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Box box = (Box)success.value();
                option2 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while WalletBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option2;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<WithdrawalEpochInfo> getWithdrawalEpochInfo() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.withdrawalEpochInformationKey())));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochInfo> try_ = WithdrawalEpochInfoSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochInfo withdrawalEpochInfo = (WithdrawalEpochInfo)success.value();
                option3 = Option$.MODULE$.apply((Object)withdrawalEpochInfo);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch info information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public int getWithdrawalEpochCounter(int epoch) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getWithdrawalEpochCounterKey(epoch))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedWithdrawalEpochCounter()));
        } else {
            n = this.undefinedWithdrawalEpochCounter();
        }
        return n;
    }

    private int getBlockFeeInfoCounter(int withdrawalEpochNumber) {
        int n;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getBlockFeeInfoCounterKey(withdrawalEpochNumber))));
        if (option instanceof Some) {
            Some some = (Some)option;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            n = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data())).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.undefinedBlockFeeInfoCounter()));
        } else {
            n = this.undefinedBlockFeeInfoCounter();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<BlockFeeInfo> getFeePayments(int withdrawalEpochNumber) {
        void var2_2;
        ListBuffer blockFees = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getBlockFeeInfoCounter(withdrawalEpochNumber);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getBlockFeeInfoKey(withdrawalEpochNumber, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try<BlockFeeInfo> try_ = BlockFeeInfoSerializer$.MODULE$.parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while fee payment parsing.", exception);
                    }
                    throw new MatchError(try_);
                }
                Success success = (Success)try_;
                BlockFeeInfo info = (BlockFeeInfo)success.value();
                blockFees.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BlockFeeInfo[]{info}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while fee payments retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<WithdrawalRequestBox> getWithdrawalRequests(int withdrawalEpoch) {
        void var2_2;
        ListBuffer withdrawalRequests = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int lastCounter = this.getWithdrawalEpochCounter(withdrawalEpoch);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), lastCounter).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.storage.get(this.getWithdrawalRequestsKey(withdrawalEpoch, counter))));
            if (option instanceof Some) {
                Some some = (Some)option;
                ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
                Try try_ = this.withdrawalRequestSerializer().parseBytesTry(baw.data());
                if (!(try_ instanceof Success)) {
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        throw new IllegalStateException("Error while withdrawal requests parsing.", exception);
                    }
                    throw new MatchError((Object)try_);
                }
                Success success = (Success)try_;
                java.util.List wr = (java.util.List)success.value();
                withdrawalRequests.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(wr).asScala());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Error while withdrawal requests retrieving: record expected to exist.");
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public Option<CertifiersKeys> getCertifiersKeys(int withdrawalEpoch) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getCertifiersStorageKey(withdrawalEpoch))));
        if (option2 instanceof Some) {
            Option option3;
            Success success;
            CertifiersKeys actualKeys;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<CertifiersKeys> try_ = CertifiersKeysSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success && (actualKeys = (CertifiersKeys)(success = (Success)try_).value()) != null) {
                CertifiersKeys certifiersKeys = actualKeys;
                option3 = Option$.MODULE$.apply((Object)certifiersKeys);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch certificate public keys parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<KeyRotationProof> getKeyRotationProof(int withdrawalEpochNumber, int indexOfSigner, int keyType) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getKeyRotationProofKey(withdrawalEpochNumber, indexOfSigner, keyType))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<KeyRotationProof> try_ = KeyRotationProofSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                KeyRotationProof keyRotationProof = (KeyRotationProof)success.value();
                option3 = Option$.MODULE$.apply((Object)keyRotationProof);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while key rotation proofs parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<WithdrawalEpochCertificate> getTopQualityCertificate(int referencedWithdrawalEpoch) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getTopQualityCertificateKey(referencedWithdrawalEpoch))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try<WithdrawalEpochCertificate> try_ = WithdrawalEpochCertificateSerializer$.MODULE$.parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                WithdrawalEpochCertificate certificate = (WithdrawalEpochCertificate)success.value();
                option3 = Option$.MODULE$.apply((Object)certificate);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while withdrawal epoch certificate information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError(try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<Object> getLastCertificateReferencedEpoch() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getLastCertificateEpochNumberKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)epoch));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while last certificate epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<String> getLastCertificateSidechainBlockId() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getLastCertificateSidechainBlockIdKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sparkz.util.package$.MODULE$.bytesToId(baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String id = (String)success.value();
                some = new Some((Object)id);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while last certificate sidechain block id parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Option<byte[]> getUtxoMerkleTreeRoot(int withdrawalEpoch) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.getUtxoMerkleTreeRootKey(withdrawalEpoch)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    public boolean hasCeased() {
        return this.storage.get(this.ceasingStateKey()).isPresent();
    }

    public Option<Object> getConsensusEpochNumber() {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.consensusEpochKey())));
        if (option2 instanceof Some) {
            Some some;
            Some some2 = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some2.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Ints.fromByteArray((byte[])baw.data()));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int epoch = BoxesRunTime.unboxToInt((Object)success.value());
                some = new Some((Object)BoxesRunTime.boxToInteger((int)io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(epoch)));
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while consensus epoch information parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = some;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    /*
     * Unable to fully structure code
     */
    public Option<ForgerList> getForgerList() {
        block13: {
            block12: {
                var3_1 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.forgerListIndexKey())));
                if (!(var3_1 instanceof Some)) break block12;
                var4_2 = (Some)var3_1;
                baw = (ByteArrayWrapper)var4_2.value();
                var6_4 = false;
                var7_5 = null;
                var8_6 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$getForgerList$1(io.horizen.utils.ByteArrayWrapper ), ()Lscala/util/Try;)((ByteArrayWrapper)baw));
                if (!(var8_6 instanceof Success)) ** GOTO lbl-1000
                var6_4 = true;
                var7_5 = (Success)var8_6;
                var9_7 = (Try)var7_5.value();
                if (var9_7 instanceof Success) {
                    var10_8 = (Success)var9_7;
                    forgerIndexes = (ForgerList)var10_8.value();
                    var2_10 = new Some((Object)forgerIndexes);
                } else if (var6_4 && (var12_11 = (Try)var7_5.value()) instanceof Failure) {
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Error while forger list indexes information parsing.");
                        v0 = BoxedUnit.UNIT;
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    var2_10 = Option$.MODULE$.empty();
                } else if (var8_6 instanceof Failure) {
                    var13_12 = (Failure)var8_6;
                    exception = var13_12.exception();
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error("Error while forger list indexes information parsing.", exception);
                        v1 = BoxedUnit.UNIT;
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    var2_10 = Option$.MODULE$.empty();
                } else {
                    throw new MatchError((Object)var8_6);
                }
                var1_14 = var2_10;
                break block13;
            }
            if (None$.MODULE$.equals(var3_1)) {
                var1_14 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)var3_1);
            }
        }
        return var1_14;
    }

    public Try<SidechainStateStorage> update(ByteArrayWrapper version, WithdrawalEpochInfo withdrawalEpochInfo, Set<Box<Proposition>> boxUpdateList, Set<ByteArrayWrapper> boxIdsRemoveSet, Seq<WithdrawalRequestBox> withdrawalRequestAppendSeq, int consensusEpoch, Option<WithdrawalEpochCertificate> topQualityCertificateOpt, BlockFeeInfo blockFeeInfo, Option<byte[]> utxoMerkleTreeRootOpt, boolean scHasCeased, int[] forgerListIndexes, int forgerListSize, Seq<KeyRotationProof> keyRotationProofs, Option<CertifiersKeys> certifiersKeysOption) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            Object object2;
            Some some;
            WithdrawalEpochInfo storedEpochInfo;
            Object object3;
            Some some2;
            CertifiersKeys actualKeys;
            Object object4;
            Predef$.MODULE$.require(withdrawalEpochInfo != null, (Function0 & Serializable & scala.Serializable)() -> "WithdrawalEpochInfo must be NOT NULL.");
            Predef$.MODULE$.require(boxUpdateList != null, (Function0 & Serializable & scala.Serializable)() -> "List of Boxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(!boxUpdateList.contains(null), (Function0 & Serializable & scala.Serializable)() -> "Box to add/update must be NOT NULL.");
            Predef$.MODULE$.require(!boxIdsRemoveSet.contains(null), (Function0 & Serializable & scala.Serializable)() -> "BoxId to remove must be NOT NULL.");
            Predef$.MODULE$.require(withdrawalRequestAppendSeq != null, (Function0 & Serializable & scala.Serializable)() -> "Seq of WithdrawalRequests to append must be NOT NULL. Use empty Seq instead.");
            Predef$.MODULE$.require(!withdrawalRequestAppendSeq.contains(null), (Function0 & Serializable & scala.Serializable)() -> "WithdrawalRequest to append must be NOT NULL.");
            Predef$.MODULE$.require(blockFeeInfo != null, (Function0 & Serializable & scala.Serializable)() -> "BlockFeeInfo must be NOT NULL.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)removeList.add(Utils.calculateKey(r.data()))));
            boxUpdateList.foreach((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(b.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(b))))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.withdrawalEpochInformationKey(), new ByteArrayWrapper(WithdrawalEpochInfoSerializer$.MODULE$.toBytes(withdrawalEpochInfo))));
            if (withdrawalRequestAppendSeq.nonEmpty()) {
                int nextWithdrawalEpochCounter = this.getWithdrawalEpochCounter(withdrawalEpochInfo.epoch()) + 1;
                updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalEpochCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextWithdrawalEpochCounter))));
                object4 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getWithdrawalRequestsKey(withdrawalEpochInfo.epoch(), nextWithdrawalEpochCounter), new ByteArrayWrapper(this.withdrawalRequestSerializer().toBytes(JavaConverters$.MODULE$.seqAsJavaListConverter(withdrawalRequestAppendSeq).asJava())))));
            } else {
                object4 = BoxedUnit.UNIT;
            }
            Option option = certifiersKeysOption;
            if (option instanceof Some && (actualKeys = (CertifiersKeys)(some2 = (Some)option).value()) != null) {
                CertifiersKeys certifiersKeys = actualKeys;
                object3 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getCertifiersStorageKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(CertifiersKeysSerializer$.MODULE$.toBytes(certifiersKeys)))));
            } else if (None$.MODULE$.equals(option)) {
                object3 = Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
            } else {
                throw new MatchError((Object)option);
            }
            keyRotationProofs.foreach((Function1 & Serializable & scala.Serializable)keyRotationProof -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getKeyRotationProofKey(withdrawalEpochInfo.epoch(), keyRotationProof.index(), keyRotationProof.keyType().id()), new ByteArrayWrapper(KeyRotationProofSerializer$.MODULE$.toBytes(keyRotationProof))))));
            utxoMerkleTreeRootOpt.foreach((Function1 & Serializable & scala.Serializable)merkleRoot -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getUtxoMerkleTreeRootKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(merkleRoot)))));
            Option<WithdrawalEpochInfo> option2 = this.getWithdrawalEpochInfo();
            boolean bl = option2 instanceof Some ? (storedEpochInfo = (WithdrawalEpochInfo)(some = (Some)option2).value()).epoch() != withdrawalEpochInfo.epoch() : false;
            boolean isWithdrawalEpochSwitched = bl;
            if (isWithdrawalEpochSwitched) {
                if (!$this.params.isNonCeasing()) {
                    int wrEpochNumberToRemove = withdrawalEpochInfo.epoch() - 2;
                    RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getWithdrawalEpochCounter(wrEpochNumberToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getWithdrawalRequestsKey(wrEpochNumberToRemove, counter)));
                    removeList.add(this.getWithdrawalEpochCounterKey(wrEpochNumberToRemove));
                    int certEpochNumberToRemove = withdrawalEpochInfo.epoch() - 4;
                    removeList.add(this.getTopQualityCertificateKey(certEpochNumberToRemove));
                    removeList.add(this.getUtxoMerkleTreeRootKey(certEpochNumberToRemove));
                    removeList.add(this.getCertifiersStorageKey(certEpochNumberToRemove));
                    $this.params.signersPublicKeys().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexOfSigner -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), CircuitTypes$.MODULE$.maxId()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)typeOfKey -> removeList.add(this.getKeyRotationProofKey(certEpochNumberToRemove, indexOfSigner, typeOfKey))));
                }
                int blockFeeInfoEpochToRemove = withdrawalEpochInfo.epoch() - 1;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.getBlockFeeInfoCounter(blockFeeInfoEpochToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList.add(this.getBlockFeeInfoKey(blockFeeInfoEpochToRemove, counter)));
                object2 = BoxesRunTime.boxToBoolean((boolean)removeList.add(this.getBlockFeeInfoCounterKey(blockFeeInfoEpochToRemove)));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            if ($this.params.isNonCeasing()) {
                topQualityCertificateOpt.foreach((Function1 & Serializable & scala.Serializable)certificate -> {
                    SidechainStateStorage.$anonfun$update$18(this, updateList, version, removeList, certificate);
                    return BoxedUnit.UNIT;
                });
            }
            topQualityCertificateOpt.foreach((Function1 & Serializable & scala.Serializable)certificate -> BoxesRunTime.boxToBoolean((boolean)SidechainStateStorage.$anonfun$update$24(this, updateList, certificate)));
            int nextBlockFeeInfoCounter = this.getBlockFeeInfoCounter(withdrawalEpochInfo.epoch()) + 1;
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoCounterKey(withdrawalEpochInfo.epoch()), new ByteArrayWrapper(Ints.toByteArray((int)nextBlockFeeInfoCounter))));
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.getBlockFeeInfoKey(withdrawalEpochInfo.epoch(), nextBlockFeeInfoCounter), new ByteArrayWrapper(BlockFeeInfoSerializer$.MODULE$.toBytes(blockFeeInfo))));
            Object object5 = BoxesRunTime.unboxToInt((Object)this.getConsensusEpochNumber().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> io.horizen.consensus.package$.MODULE$.intToConsensusEpochNumber(0))) != consensusEpoch ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.consensusEpochKey(), new ByteArrayWrapper(Ints.toByteArray((int)consensusEpoch))))) : BoxedUnit.UNIT;
            Object object6 = scHasCeased ? BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.ceasingStateKey(), new ByteArrayWrapper(Array$.MODULE$.emptyByteArray())))) : BoxedUnit.UNIT;
            Option<ForgerList> option3 = this.getForgerList();
            if (option3 instanceof Some) {
                Object object7;
                Some some3 = (Some)option3;
                ForgerList forgerList = (ForgerList)some3.value();
                if (forgerListIndexes.length != 0) {
                    ForgerList updatedForgerList = forgerList.updateIndexes(forgerListIndexes);
                    object7 = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerListIndexKey(), package$.MODULE$.byteArrayToWrapper(ForgerListSerializer$.MODULE$.toBytes(updatedForgerList)))));
                } else {
                    object7 = BoxedUnit.UNIT;
                }
                object = object7;
            } else if (None$.MODULE$.equals(option3)) {
                ForgerList emptyForgerListIndex = new ForgerList(new int[forgerListSize]);
                object = BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.forgerListIndexKey(), package$.MODULE$.byteArrayToWrapper(ForgerListSerializer$.MODULE$.toBytes(emptyForgerListIndex)))));
            } else {
                throw new MatchError(option3);
            }
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    public Seq<KeyRotationProof> update$default$13() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<CertifiersKeys> update$default$14() {
        return None$.MODULE$;
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public List<ByteArrayWrapper> rollbackVersions(int maxNumberOfVersions) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions(maxNumberOfVersions)).asScala()).toList();
    }

    public Try<SidechainStateStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public StorageIterator getIterator() {
        return this.storage.getIterator();
    }

    public void restoreBackup(BoxIterator backupStorageBoxIterator, byte[] lastVersion) {
        BoxedUnit boxedUnit;
        ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
        ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
        ByteArrayWrapper lastVersionWrapper = new ByteArrayWrapper(lastVersion);
        Optional<BackupBox> optionalBox = backupStorageBoxIterator.nextBox();
        while (optionalBox.isPresent()) {
            BoxedUnit boxedUnit2;
            Box<Proposition> box = optionalBox.get().getBox();
            updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(box.id()), new ByteArrayWrapper(this.sidechainBoxesCompanion.toBytes(box))));
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info(new StringBuilder(15).append("Restore Box id ").append(box.boxTypeId()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            optionalBox = backupStorageBoxIterator.nextBox();
            if (updateList.size() != package$Constants$.MODULE$.BatchSize()) continue;
            if (optionalBox.isPresent()) {
                this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), updateList, removeList);
            } else {
                this.storage.update(lastVersionWrapper, updateList, removeList);
            }
            updateList.clear();
        }
        if (updateList.size() != 0) {
            this.storage.update(lastVersionWrapper, updateList, removeList);
        }
        if (this.log().underlying().isInfoEnabled()) {
            this.log().underlying().info("SidechainStateStorage restore completed successfully!");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Try $anonfun$getForgerList$1(ByteArrayWrapper baw$6) {
        return ForgerListSerializer$.MODULE$.parseBytesTry(baw$6.data());
    }

    public static final /* synthetic */ void $anonfun$update$18(SidechainStateStorage $this, ArrayList updateList$1, ByteArrayWrapper version$1, ArrayList removeList$1, WithdrawalEpochCertificate certificate) {
        updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getLastCertificateSidechainBlockIdKey(), version$1));
        int prevCertReferencedEpoch = BoxesRunTime.unboxToInt((Object)$this.getLastCertificateReferencedEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(prevCertReferencedEpoch + 1), certificate.epochNumber()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)outdatedEpochNumber -> {
            int wrEpochNumberToRemove = outdatedEpochNumber;
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), $this.getWithdrawalEpochCounter(wrEpochNumberToRemove)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)counter -> removeList$1.add($this.getWithdrawalRequestsKey(wrEpochNumberToRemove, counter)));
            removeList$1.add($this.getWithdrawalEpochCounterKey(wrEpochNumberToRemove));
            removeList$1.add($this.getTopQualityCertificateKey(wrEpochNumberToRemove));
            removeList$1.add($this.getCertifiersStorageKey(wrEpochNumberToRemove));
            $this.params.signersPublicKeys().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexOfSigner -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), CircuitTypes$.MODULE$.maxId()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)typeOfKey -> removeList$1.add($this.getKeyRotationProofKey(wrEpochNumberToRemove, indexOfSigner, typeOfKey))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$24(SidechainStateStorage $this, ArrayList updateList$1, WithdrawalEpochCertificate certificate) {
        updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getLastCertificateEpochNumberKey(), new ByteArrayWrapper(Ints.toByteArray((int)certificate.epochNumber()))));
        return updateList$1.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>($this.getTopQualityCertificateKey(certificate.epochNumber()), package$.MODULE$.byteArrayToWrapper(WithdrawalEpochCertificateSerializer$.MODULE$.toBytes(certificate))));
    }

    public SidechainStateStorage(Storage storage, SidechainBoxesCompanion sidechainBoxesCompanion, NetworkParams params) {
        this.storage = storage;
        this.sidechainBoxesCompanion = sidechainBoxesCompanion;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(sidechainBoxesCompanion != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainBoxesCompanion must be NOT NULL.");
        this.withdrawalEpochInformationKey = Utils.calculateKey("withdrawalEpochInformation".getBytes(StandardCharsets.UTF_8));
        this.withdrawalRequestSerializer = new ListSerializer<WithdrawalRequestBox>(WithdrawalRequestBoxSerializer.getSerializer());
        this.consensusEpochKey = Utils.calculateKey("consensusEpoch".getBytes(StandardCharsets.UTF_8));
        this.ceasingStateKey = Utils.calculateKey("ceasingStateKey".getBytes(StandardCharsets.UTF_8));
        this.forgerListIndexKey = Utils.calculateKey("forgerListIndexKey".getBytes(StandardCharsets.UTF_8));
        this.undefinedWithdrawalEpochCounter = -1;
        this.getLastCertificateEpochNumberKey = Utils.calculateKey("lastCertificateEpochNumber".getBytes(StandardCharsets.UTF_8));
        this.getLastCertificateSidechainBlockIdKey = Utils.calculateKey("getLastCertificateSidechainBlockId".getBytes(StandardCharsets.UTF_8));
        this.undefinedBlockFeeInfoCounter = -1;
    }
}

