/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.proof.Proof;
import io.horizen.proposition.Proposition;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.ForgerBoxSerializer;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001\u0002\u0007\u000e\u0001YA\u0001B\u0004\u0001\u0003\u0002\u0003\u0006IA\f\u0005\u0006c\u0001!\tA\r\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0011\u0019q\u0004\u0001)A\u0005q!)q\b\u0001C\u0001\u0001\")q\n\u0001C\u0001!\")Q\f\u0001C\u0001=\")\u0001\u0010\u0001C!s\")1\u0010\u0001C\u0001y\")a\u0010\u0001C\u0001\u007f\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015!AH*jI\u0016\u001c\u0007.Y5o'R\fG/\u001a$pe\u001e,'OQ8y'R|'/Y4f\u0015\tqq\"A\u0004ti>\u0014\u0018mZ3\u000b\u0005A\t\u0012\u0001B;uq>T!AE\n\u0002\u000f!|'/\u001b>f]*\tA#\u0001\u0002j_\u000e\u00011#\u0002\u0001\u0018;\u0015R\u0003C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!Q\u000f^5m\u0015\u0005\u0011\u0013AB:qCJ\\'0\u0003\u0002%?\ti1\u000b]1sWjdunZ4j]\u001e\u0004\"A\n\u0015\u000e\u0003\u001dR!AD\t\n\u0005%:#\u0001F*jI\u0016\u001c\u0007.Y5o'R|'/Y4f\u0013:4w\u000e\u0005\u0002,Y5\t\u0011#\u0003\u0002.#\tq1+\u001b3fG\"\f\u0017N\u001c+za\u0016\u001c\bC\u0001\u00140\u0013\t\u0001tEA\u0004Ti>\u0014\u0018mZ3\u0002\rqJg.\u001b;?)\t\u0019T\u0007\u0005\u00025\u00015\tQ\u0002C\u0003\u000f\u0005\u0001\u0007a&A\ng_J<WM\u001d\"pqN+'/[1mSj,'/F\u00019!\tID(D\u0001;\u0015\tYt\"A\u0002c_bL!!\u0010\u001e\u0003'\u0019{'oZ3s\u0005>D8+\u001a:jC2L'0\u001a:\u0002)\u0019|'oZ3s\u0005>D8+\u001a:jC2L'0\u001a:!\u000319W\r\u001e$pe\u001e,'OQ8y)\t\tu\tE\u0002\u0019\u0005\u0012K!aQ\r\u0003\r=\u0003H/[8o!\tIT)\u0003\u0002Gu\tIai\u001c:hKJ\u0014u\u000e\u001f\u0005\u0006\u0011\u0016\u0001\r!S\u0001\u0006E>D\u0018\n\u001a\t\u00041)c\u0015BA&\u001a\u0005\u0015\t%O]1z!\tAR*\u0003\u0002O3\t!!)\u001f;f\u0003E9W\r^!mY\u001a{'oZ3s\u0005>DXm]\u000b\u0002#B\u0019!K\u0017#\u000f\u0005MCfB\u0001+X\u001b\u0005)&B\u0001,\u0016\u0003\u0019a$o\\8u}%\t!$\u0003\u0002Z3\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005\r\u0019V-\u001d\u0006\u00033f\ta!\u001e9eCR,G\u0003B0eY:\u00042\u0001\u001924\u001b\u0005\t'B\u0001\u0011\u001a\u0013\t\u0019\u0017MA\u0002UefDQ!Z\u0004A\u0002\u0019\fqA^3sg&|g\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002j#\u0005)Q\u000f^5mg&\u00111\u000e\u001b\u0002\u0011\u0005f$X-\u0011:sCf<&/\u00199qKJDQ!\\\u0004A\u0002E\u000b!CZ8sO\u0016\u0014(i\u001c=Va\u0012\fG/Z*fc\")qn\u0002a\u0001a\u0006y!m\u001c=JIN\u0014V-\\8wKN+G\u000fE\u0002rk\u001at!A]:\u0011\u0005QK\u0012B\u0001;\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0004'\u0016$(B\u0001;\u001a\u00035a\u0017m\u001d;WKJ\u001c\u0018n\u001c8JIV\t!\u0010E\u0002\u0019\u0005\u001a\f\u0001C]8mY\n\f7m\u001b,feNLwN\\:\u0016\u0003u\u00042A\u0015.g\u0003!\u0011x\u000e\u001c7cC\u000e\\GcA0\u0002\u0002!)QM\u0003a\u0001M\u00069\u0011n]#naRLXCAA\u0004!\rA\u0012\u0011B\u0005\u0004\u0003\u0017I\"a\u0002\"p_2,\u0017M\u001c")
public class SidechainStateForgerBoxStorage
implements SparkzLogging,
SidechainStorageInfo,
SidechainTypes {
    private final Storage storage;
    private final ForgerBoxSerializer forgerBoxSerializer;
    private final Logger logger;

    @Override
    public BoxTransaction<Proposition, Box<Proposition>> sidechainTxToScbt(SidechainTransaction<Proposition, Box<Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<Proposition, Proof<Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<Proposition, Box<Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<Proposition, Box<Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ForgerBoxSerializer forgerBoxSerializer() {
        return this.forgerBoxSerializer;
    }

    public Option<ForgerBox> getForgerBox(byte[] boxId) {
        Option option;
        Option option2 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(Utils.calculateKey(boxId))));
        if (option2 instanceof Some) {
            Option option3;
            Some some = (Some)option2;
            ByteArrayWrapper baw = (ByteArrayWrapper)some.value();
            Try try_ = this.forgerBoxSerializer().parseBytesTry(baw.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                ForgerBox box = (ForgerBox)success.value();
                option3 = Option$.MODULE$.apply((Object)box);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("SidechainStateForgerBoxStorage: Error while ForgerBox parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option3 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            option = option3;
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public Seq<ForgerBox> getAllForgerBoxes() {
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.getAll()).asScala()).map((Function1 & Serializable & scala.Serializable)pair -> (ForgerBox)this.forgerBoxSerializer().parseBytes(((ByteArrayWrapper)pair.getValue()).data()), Buffer$.MODULE$.canBuildFrom());
    }

    public Try<SidechainStateForgerBoxStorage> update(ByteArrayWrapper version, Seq<ForgerBox> forgerBoxUpdateSeq, Set<ByteArrayWrapper> boxIdsRemoveSet) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(forgerBoxUpdateSeq != null, (Function0 & Serializable & scala.Serializable)() -> "List of ForgerBoxes to add/update must be NOT NULL. Use empty List instead.");
            Predef$.MODULE$.require(boxIdsRemoveSet != null, (Function0 & Serializable & scala.Serializable)() -> "List of Box IDs to remove must be NOT NULL. Use empty List instead.");
            ArrayList<ByteArrayWrapper> removeList = new ArrayList<ByteArrayWrapper>();
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> updateList = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            boxIdsRemoveSet.foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)removeList.add(Utils.calculateKey(id.data()))));
            forgerBoxUpdateSeq.foreach((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)updateList.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(Utils.calculateKey(box.id()), new ByteArrayWrapper(this.forgerBoxSerializer().toBytes(box))))));
            $this.storage.update(version, updateList, removeList);
            return this;
        });
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public Seq<ByteArrayWrapper> rollbackVersions() {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.storage.rollbackVersions()).asScala()).toList();
    }

    public Try<SidechainStateForgerBoxStorage> rollback(ByteArrayWrapper version) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version != null, (Function0 & Serializable & scala.Serializable)() -> "SidechainStateForgerBoxStorage: Version to rollback to must be NOT NULL.");
            $this.storage.rollback(version);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public SidechainStateForgerBoxStorage(Storage storage) {
        this.storage = storage;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        SidechainStorageInfo.$init$(this);
        SidechainTypes.$init$(this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        this.forgerBoxSerializer = ForgerBoxSerializer.getSerializer();
    }
}

