/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.state;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.params.NetworkParams;
import io.horizen.proposition.Proposition;
import io.horizen.storage.Storage;
import io.horizen.storage.StorageIterator;
import io.horizen.storage.leveldb.VersionedLevelDbStorageAdapter;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.BytesUtils;
import io.horizen.utxo.backup.BoxIterator;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.BoxSerializer;
import io.horizen.utxo.companion.SidechainBoxesCompanion;
import io.horizen.utxo.storage.BackupStorage;
import io.horizen.utxo.storage.BoxBackupInterface;
import io.horizen.utxo.storage.SidechainStateStorage;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0006\u0004%\t!\u000b\u0005\t\r\u0002\u0011\t\u0011)A\u0005U!Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003J\u0011!\u0001\u0006A!b\u0001\n\u0003\t\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011a\u0003!Q1A\u0005\u0002eC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006A\u0002!\t!\u0019\u0005\n\u0003\u001b\u0001!\u0019!C\t\u0003\u001fA\u0001\"!\b\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003?\u0001!\u0019!C\t\u0003CA\u0001\"!\u000b\u0001A\u0003%\u00111\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0005=\u0019\u0016\u000eZ3dQ\u0006LgNQ1dWV\u0004(BA\t\u0013\u0003\u0015\u0019H/\u0019;f\u0015\t\u0019B#\u0001\u0003vib|'BA\u000b\u0017\u0003\u001dAwN]5{K:T\u0011aF\u0001\u0003S>\u001c\u0001aE\u0002\u00015\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a!\u00118z%\u00164\u0007CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011)H/\u001b7\u000b\u0003\u0015\naa\u001d9be.T\u0018BA\u0014#\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006!2-^:u_6\u0014u\u000e_*fe&\fG.\u001b>feN,\u0012A\u000b\t\u0005W=\nt'D\u0001-\u0015\t\u0019SFC\u0001/\u0003\u0011Q\u0017M^1\n\u0005Ab#a\u0002%bg\"l\u0015\r\u001d\t\u0003eUj\u0011a\r\u0006\u0003i5\nA\u0001\\1oO&\u0011ag\r\u0002\u0005\u0005f$X\rE\u00029wuj\u0011!\u000f\u0006\u0003uI\t1AY8y\u0013\ta\u0014HA\u0007C_b\u001cVM]5bY&TXM\u001d\t\u0004qy\u0002\u0015BA :\u0005\r\u0011u\u000e\u001f\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007R\t1\u0002\u001d:pa>\u001c\u0018\u000e^5p]&\u0011QI\u0011\u0002\f!J|\u0007o\\:ji&|g.A\u000bdkN$x.\u001c\"pqN+'/[1mSj,'o\u001d\u0011\u0002\u001b\t\f7m[+q'R|'/Y4f+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0015\u0003\u001d\u0019Ho\u001c:bO\u0016L!AT&\u0003\u000fM#xN]1hK\u0006q!-Y2l+B\u001cFo\u001c:bO\u0016\u0004\u0013!\u00032bG.,\u0006\u000f]3s+\u0005\u0011\u0006CA*V\u001b\u0005!&B\u0001'\u0013\u0013\t1FK\u0001\nC_b\u0014\u0015mY6va&sG/\u001a:gC\u000e,\u0017A\u00032bG.,\u0006\u000f]3sA\u00051\u0001/\u0019:b[N,\u0012A\u0017\t\u00037vk\u0011\u0001\u0018\u0006\u00031RI!A\u0018/\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\na\u0001P5oSRtD#\u00022ekfl\bCA2\u0001\u001b\u0005\u0001\u0002\"\u0002\u0015\n\u0001\u0004Q\u0003\u0006\u00023geN\u0004\"a\u001a9\u000e\u0003!T!!\u001b6\u0002\t9\fW.\u001a\u0006\u0003W2\fa!\u001b8kK\u000e$(BA7o\u0003\u00199wn\\4mK*\tq.A\u0002d_6L!!\u001d5\u0003\u000b9\u000bW.\u001a3\u0002\u000bY\fG.^3\"\u0003Q\fAcQ;ti>l'i\u001c=TKJL\u0017\r\\5{KJ\u001c\b\"B$\n\u0001\u0004I\u0005\u0006B;ge^\f\u0013\u0001_\u0001\u000e\u0005\u0006\u001c7.\u001e9Ti>\u0014\u0018mZ3\t\u000bAK\u0001\u0019\u0001*)\te4'o_\u0011\u0002y\u0006I!)Y2l+B\u0004XM\u001d\u0005\u00061&\u0001\rA\u0017\u0015\u0005{\u001a\u0014x0\t\u0002\u0002\u0002\u00051\u0001+\u0019:b[ND3!CA\u0003!\u0011\t9!!\u0003\u000e\u0003)L1!a\u0003k\u0005\u0019IeN[3di\u000692/\u001b3fG\"\f\u0017N\u001c\"pq\u0016\u001c8i\\7qC:LwN\\\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/\u0011\u0012!C2p[B\fg.[8o\u0013\u0011\tY\"!\u0006\u0003/MKG-Z2iC&t'i\u001c=fg\u000e{W\u000e]1oS>t\u0017\u0001G:jI\u0016\u001c\u0007.Y5o\u0005>DXm]\"p[B\fg.[8oA\u0005i!-Y2lkB\u001cFo\u001c:bO\u0016,\"!a\t\u0011\u0007M\u000b)#C\u0002\u0002(Q\u0013QBQ1dWV\u00048\u000b^8sC\u001e,\u0017A\u00042bG.,\bo\u0015;pe\u0006<W\rI\u0001\rGJ,\u0017\r^3CC\u000e\\W\u000f\u001d\u000b\t\u0003_\t)$a\u0014\u0002TA\u00191$!\r\n\u0007\u0005MBD\u0001\u0003V]&$\bbBA\u001c\u001d\u0001\u0007\u0011\u0011H\u0001\u0011gR\fG/Z*u_J\fw-\u001a)bi\"\u0004B!a\u000f\u0002J9!\u0011QHA#!\r\ty\u0004H\u0007\u0003\u0003\u0003R1!a\u0011\u0019\u0003\u0019a$o\\8u}%\u0019\u0011q\t\u000f\u0002\rA\u0013X\rZ3g\u0013\u0011\tY%!\u0014\u0003\rM#(/\u001b8h\u0015\r\t9\u0005\b\u0005\b\u0003#r\u0001\u0019AA\u001d\u0003i\u0019\u0018\u000eZ3dQ\u0006LgN\u00117pG.LE\rV8S_2d'-Y2l\u0011\u001d\t)F\u0004a\u0001\u0003/\n\u0001cY8qsN#\u0018\r^3Ti>\u0014\u0018mZ3\u0011\u0007m\tI&C\u0002\u0002\\q\u0011qAQ8pY\u0016\fg\u000e")
public class SidechainBackup
implements SparkzLogging {
    private final HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers;
    private final Storage backUpStorage;
    private final BoxBackupInterface backUpper;
    private final NetworkParams params;
    private final SidechainBoxesCompanion sidechainBoxesCompanion;
    private final BackupStorage backupStorage;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers() {
        return this.customBoxSerializers;
    }

    public Storage backUpStorage() {
        return this.backUpStorage;
    }

    public BoxBackupInterface backUpper() {
        return this.backUpper;
    }

    public NetworkParams params() {
        return this.params;
    }

    public SidechainBoxesCompanion sidechainBoxesCompanion() {
        return this.sidechainBoxesCompanion;
    }

    public BackupStorage backupStorage() {
        return this.backupStorage;
    }

    public void createBackup(String stateStoragePath, String sidechainBlockIdToRollback, boolean copyStateStorage) {
        VersionedLevelDbStorageAdapter storage;
        SidechainStateStorage sidechainStateStorage;
        Try<SidechainStateStorage> try_;
        String storagePath = stateStoragePath;
        if (copyStateStorage) {
            File stateStorage = new File(stateStoragePath);
            File stateStorageBackup = new File(new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString());
            try {
                FileUtils.copyDirectory((File)stateStorage, (File)stateStorageBackup);
                storagePath = new StringBuilder(16).append(stateStoragePath).append("_copy_for_backup").toString();
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit;
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the copy of the StateStorage: ", new Object[]{t.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(43).append("Error during the copy of the StateStorage: ").append(t.getMessage()).toString());
            }
        }
        if ((try_ = (sidechainStateStorage = new SidechainStateStorage(storage = new VersionedLevelDbStorageAdapter(new File(storagePath)), this.sidechainBoxesCompanion(), this.params())).rollback(new ByteArrayWrapper(BytesUtils.fromHexString(sidechainBlockIdToRollback)))) instanceof Success) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Success success = (Success)try_;
            SidechainStateStorage stateStorage = (SidechainStateStorage)success.value();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage completed successfully!");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            StorageIterator stateIterator = stateStorage.getIterator();
            stateIterator.seekToFirst();
            try {
                this.backUpper().backup(new BoxIterator(stateIterator, this.sidechainBoxesCompanion()), this.backupStorage());
                storage.close();
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable t) {
                BoxedUnit boxedUnit3;
                storage.close();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error during the Backup generation: ", new Object[]{t.getMessage()});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                throw new RuntimeException(new StringBuilder(36).append("Error during the Backup generation: ").append(t.getMessage()).toString());
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (try_ instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("Rollback of the SidechainStateStorage couldn't end successfully...", new Object[]{e.getMessage()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(try_);
        }
    }

    @Inject
    public SidechainBackup(@Named(value="CustomBoxSerializers") HashMap<Byte, BoxSerializer<Box<Proposition>>> customBoxSerializers, @Named(value="BackupStorage") Storage backUpStorage, @Named(value="BackUpper") BoxBackupInterface backUpper, @Named(value="Params") NetworkParams params) {
        this.customBoxSerializers = customBoxSerializers;
        this.backUpStorage = backUpStorage;
        this.backUpper = backUpper;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        this.sidechainBoxesCompanion = new SidechainBoxesCompanion(customBoxSerializers);
        this.backupStorage = new BackupStorage(backUpStorage, this.sidechainBoxesCompanion());
    }
}

