/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utxo.api.http.route;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.server.util.TupleOps;
import io.horizen.SidechainTypes;
import io.horizen.account.transaction.AccountTransaction;
import io.horizen.account.transaction.EthereumTransaction;
import io.horizen.api.http.ApiResponseUtil$;
import io.horizen.api.http.JacksonSupport$;
import io.horizen.api.http.route.TransactionBaseApiRoute;
import io.horizen.api.http.route.TransactionBaseErrorResponse;
import io.horizen.api.http.route.TransactionBaseRestScheme;
import io.horizen.cryptolibprovider.CircuitTypes$;
import io.horizen.params.NetworkParams;
import io.horizen.proof.Proof;
import io.horizen.proof.SchnorrProof;
import io.horizen.proof.SchnorrSignatureSerializer;
import io.horizen.proof.Signature25519;
import io.horizen.proposition.MCPublicKeyHashProposition;
import io.horizen.proposition.MCPublicKeyHashPropositionSerializer;
import io.horizen.proposition.PublicKey25519Proposition;
import io.horizen.proposition.PublicKey25519PropositionSerializer;
import io.horizen.proposition.SchnorrPropositionSerializer;
import io.horizen.proposition.VrfPublicKeySerializer;
import io.horizen.secret.PrivateKey25519;
import io.horizen.secret.Secret;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Pair;
import io.horizen.utils.ZenCoinsUtils;
import io.horizen.utxo.api.http.route.SidechainTransactionApiRoute$;
import io.horizen.utxo.api.http.route.SidechainTransactionRestScheme;
import io.horizen.utxo.block.SidechainBlock;
import io.horizen.utxo.block.SidechainBlockHeader;
import io.horizen.utxo.box.Box;
import io.horizen.utxo.box.ForgerBox;
import io.horizen.utxo.box.WithdrawalRequestBox;
import io.horizen.utxo.box.ZenBox;
import io.horizen.utxo.box.data.BoxData;
import io.horizen.utxo.box.data.ForgerBoxData;
import io.horizen.utxo.box.data.WithdrawalRequestBoxData;
import io.horizen.utxo.box.data.ZenBoxData;
import io.horizen.utxo.chain.SidechainFeePaymentsInfo;
import io.horizen.utxo.companion.SidechainTransactionsCompanion;
import io.horizen.utxo.node.NodeHistory;
import io.horizen.utxo.node.NodeMemoryPool;
import io.horizen.utxo.node.NodeState;
import io.horizen.utxo.node.NodeWallet;
import io.horizen.utxo.node.SidechainNodeView;
import io.horizen.utxo.transaction.BoxTransaction;
import io.horizen.utxo.transaction.CertificateKeyRotationTransaction;
import io.horizen.utxo.transaction.OpenStakeTransaction;
import io.horizen.utxo.transaction.SidechainCoreTransaction;
import io.horizen.utxo.transaction.SidechainTransaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;
import sparkz.core.settings.RESTApiSettings;
import sparkz.core.transaction.box.proposition.Proposition;

@ScalaSignature(bytes="\u0006\u0001\r\u0015h\u0001B\u001e=\u0001&C!\"a\t\u0001\u0005+\u0007I\u0011IA\u0013\u0011)\tI\u0004\u0001B\tB\u0003%\u0011q\u0005\u0005\u000b\u0003w\u0001!Q3A\u0005\u0002\u0005u\u0002BCA(\u0001\tE\t\u0015!\u0003\u0002@!Q\u0011\u0011\u000b\u0001\u0003\u0016\u0004%\t!!\u0010\t\u0015\u0005M\u0003A!E!\u0002\u0013\ty\u0004\u0003\u0006\u0002V\u0001\u0011)\u001a!C\u0001\u0003/B!\"a\u0019\u0001\u0005#\u0005\u000b\u0011BA-\u0011)\t)\u0007\u0001BK\u0002\u0013\u0005\u0011q\r\u0005\u000b\u0003g\u0002!\u0011#Q\u0001\n\u0005%\u0004BCA;\u0001\tU\r\u0011\"\u0001\u0002x!Q\u0011Q\u0014\u0001\u0003\u0012\u0003\u0006I!!\u001f\t\u0015\u0005}\u0005A!b\u0001\n\u0007\n\t\u000b\u0003\u0007\u0002*\u0002\u0011\t\u0011)A\u0005\u0003G\u000bY\u000b\u0003\u0006\u0002.\u0002\u0011)\u0019!C\"\u0003_CA\"!0\u0001\u0005\u0003\u0005\u000b\u0011BAY\u0003\u007fCq!!1\u0001\t\u0003\t\u0019\rC\u0005\u0002\\\u0002\u0011\r\u0011b\u0011\u0002^\"A\u00111\u001e\u0001!\u0002\u0013\ty\u000e\u0003\u0005>\u0001\t\u0007I\u0011IAw\u0011!\u00119\u0002\u0001Q\u0001\n\u0005=\bb\u0002B\r\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u00057\u0001A\u0011AAw\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003[DqAa\b\u0001\t\u0003\ti\u000fC\u0004\u0003\"\u0001!\t!!<\t\u000f\t\r\u0002\u0001\"\u0001\u0002n\"9!Q\u0005\u0001\u0005\u0002\u00055\bb\u0002B\u0014\u0001\u0011\u0005\u0011Q\u001e\u0005\b\u0005S\u0001A\u0011AAw\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0003[DqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0003f\u0001!IAa\u001a\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!q\u0017\u0001\u0005\n\te\u0006b\u0002B\u000e\u0001\u0011%!q\u0019\u0005\n\u0007#\u0001\u0011\u0011!C\u0001\u0007'A\u0011ba\n\u0001#\u0003%\ta!\u000b\t\u0013\r}\u0002!%A\u0005\u0002\r\u0005\u0003\"CB#\u0001E\u0005I\u0011AB!\u0011%\u00199\u0005AI\u0001\n\u0003\u0019I\u0005C\u0005\u0004N\u0001\t\n\u0011\"\u0001\u0004P!I11\u000b\u0001\u0012\u0002\u0013\u00051Q\u000b\u0005\n\u00073\u0002\u0011\u0011!C!\u00077B\u0011ba\u001b\u0001\u0003\u0003%\ta!\u001c\t\u0013\r=\u0004!!A\u0005\u0002\rE\u0004\"CB?\u0001\u0005\u0005I\u0011IB@\u0011%\u0019i\tAA\u0001\n\u0003\u0019y\tC\u0005\u0004\u001a\u0002\t\t\u0011\"\u0011\u0004\u001c\"I1Q\u0014\u0001\u0002\u0002\u0013\u00053q\u0014\u0005\n\u0007C\u0003\u0011\u0011!C!\u0007G;\u0011ba*=\u0003\u0003E\ta!+\u0007\u0011mb\u0014\u0011!E\u0001\u0007WCq!!16\t\u0003\u0019\u0019\fC\u0005\u0004\u001eV\n\t\u0011\"\u0012\u0004 \"I1QW\u001b\u0002\u0002\u0013\u00055q\u0017\u0005\n\u0007\u0017,\u0014\u0011!CA\u0007\u001bD\u0011ba76\u0003\u0003%Ia!8\u00039MKG-Z2iC&tGK]1og\u0006\u001cG/[8o\u0003BL'k\\;uK*\u0011QHP\u0001\u0006e>,H/\u001a\u0006\u0003\u007f\u0001\u000bA\u0001\u001b;ua*\u0011\u0011IQ\u0001\u0004CBL'BA\"E\u0003\u0011)H\u000f_8\u000b\u0005\u00153\u0015a\u00025pe&TXM\u001c\u0006\u0002\u000f\u0006\u0011\u0011n\\\u0002\u0001'!\u0001!*!\u0003\u0002\u0012\u0005u\u0001\u0003D&P#\u000eLGN\u001d=|}\u0006\rQ\"\u0001'\u000b\u0005uj%BA O\u0015\t\tE)\u0003\u0002Q\u0019\n9BK]1og\u0006\u001cG/[8o\u0005\u0006\u001cX-\u00119j%>,H/\u001a\t\u0005%V;V,D\u0001T\u0015\t!&)A\u0006ue\u0006t7/Y2uS>t\u0017B\u0001,T\u00059\u0011u\u000e\u001f+sC:\u001c\u0018m\u0019;j_:\u0004\"\u0001W.\u000e\u0003eS!A\u0017#\u0002\u0017A\u0014x\u000e]8tSRLwN\\\u0005\u00039f\u00131\u0002\u0015:pa>\u001c\u0018\u000e^5p]B\u0019a,Y,\u000e\u0003}S!\u0001\u0019\"\u0002\u0007\t|\u00070\u0003\u0002c?\n\u0019!i\u001c=\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\u0014\u0015!\u00022m_\u000e\\\u0017B\u00015f\u0005Q\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.DU-\u00193feB\u0011AM[\u0005\u0003W\u0016\u0014abU5eK\u000eD\u0017-\u001b8CY>\u001c7\u000e\u0005\u0002na6\taN\u0003\u0002p\u0005\u0006)1\r[1j]&\u0011\u0011O\u001c\u0002\u0019'&$Wm\u00195bS:4U-\u001a)bs6,g\u000e^:J]\u001a|\u0007CA:w\u001b\u0005!(BA;C\u0003\u0011qw\u000eZ3\n\u0005]$(a\u0003(pI\u0016D\u0015n\u001d;pef\u0004\"a]=\n\u0005i$(!\u0003(pI\u0016\u001cF/\u0019;f!\t\u0019H0\u0003\u0002~i\nQaj\u001c3f/\u0006dG.\u001a;\u0011\u0005M|\u0018bAA\u0001i\nqaj\u001c3f\u001b\u0016lwN]=Q_>d\u0007cA:\u0002\u0006%\u0019\u0011q\u0001;\u0003#MKG-Z2iC&tgj\u001c3f-&,w\u000f\u0005\u0003\u0002\f\u00055Q\"\u0001#\n\u0007\u0005=AI\u0001\bTS\u0012,7\r[1j]RK\b/Z:\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q!!a\u0006\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005m\u0011Q\u0003\u0002\b!J|G-^2u!\u0011\t\u0019\"a\b\n\t\u0005\u0005\u0012Q\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011q\u0005\t\u0005\u0003S\t)$\u0004\u0002\u0002,)!\u00111EA\u0017\u0015\u0011\ty#!\r\u0002\t\r|'/\u001a\u0006\u0003\u0003g\taa\u001d9be.T\u0018\u0002BA\u001c\u0003W\u0011qBU#T)\u0006\u0003\u0018nU3ui&twm]\u0001\ng\u0016$H/\u001b8hg\u0002\n!d]5eK\u000eD\u0017-\u001b8O_\u0012,g+[3x\u0011>dG-\u001a:SK\u001a,\"!a\u0010\u0011\t\u0005\u0005\u00131J\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u0005)\u0011m\u0019;pe*\u0011\u0011\u0011J\u0001\u0005C.\\\u0017-\u0003\u0003\u0002N\u0005\r#\u0001C!di>\u0014(+\u001a4\u00027MLG-Z2iC&tgj\u001c3f-&,w\u000fS8mI\u0016\u0014(+\u001a4!\u0003q\u0019\u0018\u000eZ3dQ\u0006Lg\u000e\u0016:b]N\f7\r^5p]\u0006\u001bGo\u001c:SK\u001a\fQd]5eK\u000eD\u0017-\u001b8Ue\u0006t7/Y2uS>t\u0017i\u0019;peJ+g\rI\u0001\nG>l\u0007/\u00198j_:,\"!!\u0017\u0011\t\u0005m\u0013qL\u0007\u0003\u0003;R1!!\u0016C\u0013\u0011\t\t'!\u0018\u0003=MKG-Z2iC&tGK]1og\u0006\u001cG/[8og\u000e{W\u000e]1oS>t\u0017AC2p[B\fg.[8oA\u00051\u0001/\u0019:b[N,\"!!\u001b\u0011\t\u0005-\u0014qN\u0007\u0003\u0003[R1!!\u001aE\u0013\u0011\t\t(!\u001c\u0003\u001b9+Go^8sWB\u000b'/Y7t\u0003\u001d\u0001\u0018M]1ng\u0002\n1bY5sGVLG\u000fV=qKV\u0011\u0011\u0011\u0010\t\u0005\u0003w\n9J\u0004\u0003\u0002~\u0005Ee\u0002BA@\u0003\u001bsA!!!\u0002\f:!\u00111QAE\u001b\t\t)IC\u0002\u0002\b\"\u000ba\u0001\u0010:p_Rt\u0014\"A$\n\u0005\u00153\u0015bAAH\t\u0006\t2M]=qi>d\u0017N\u00199s_ZLG-\u001a:\n\t\u0005M\u0015QS\u0001\r\u0007&\u00148-^5u)f\u0004Xm\u001d\u0006\u0004\u0003\u001f#\u0015\u0002BAM\u00037\u0013AbQ5sGVLG\u000fV=qKNTA!a%\u0002\u0016\u0006a1-\u001b:dk&$H+\u001f9fA\u000591m\u001c8uKb$XCAAR!\u0011\t\t%!*\n\t\u0005\u001d\u00161\t\u0002\u0010\u0003\u000e$xN\u001d*fM\u001a\u000b7\r^8ss\u0006A1m\u001c8uKb$\b%C\u0002\u0002 >\u000b!!Z2\u0016\u0005\u0005E\u0006\u0003BAZ\u0003sk!!!.\u000b\t\u0005]\u0016QC\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA^\u0003k\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%C\u0002\u0002.>\u000ba\u0001P5oSRtDCDAc\u0003\u001f\f\t.a5\u0002V\u0006]\u0017\u0011\u001c\u000b\u0007\u0003\u000f\fY-!4\u0011\u0007\u0005%\u0007!D\u0001=\u0011\u001d\ty*\u0005a\u0002\u0003GCq!!,\u0012\u0001\b\t\t\fC\u0004\u0002$E\u0001\r!a\n\t\u000f\u0005m\u0012\u00031\u0001\u0002@!9\u0011\u0011K\tA\u0002\u0005}\u0002bBA+#\u0001\u0007\u0011\u0011\f\u0005\b\u0003K\n\u0002\u0019AA5\u0011\u001d\t)(\u0005a\u0001\u0003s\n1\u0001^1h+\t\ty\u000e\u0005\u0004\u0002b\u0006\u001d\u00181A\u0007\u0003\u0003GTA!!:\u0002\u0016\u00059!/\u001a4mK\u000e$\u0018\u0002BAu\u0003G\u0014\u0001b\u00117bgN$\u0016mZ\u0001\u0005i\u0006<\u0007%\u0006\u0002\u0002pB!\u0011\u0011\u001fB\t\u001d\u0011\t\u0019Pa\u0003\u000f\t\u0005U(Q\u0001\b\u0005\u0003o\fyP\u0004\u0003\u0002z\u0006uh\u0002BAB\u0003wL!!!\u0013\n\u0007}\n9%\u0003\u0003\u0003\u0002\t\r\u0011\u0001C:dC2\fGm\u001d7\u000b\u0007}\n9%\u0003\u0003\u0003\b\t%\u0011AB:feZ,'O\u0003\u0003\u0003\u0002\t\r\u0011\u0002\u0002B\u0007\u0005\u001f\tq\u0001]1dW\u0006<WM\u0003\u0003\u0003\b\t%\u0011\u0002\u0002B\n\u0005+\u0011QAU8vi\u0016TAA!\u0004\u0003\u0010\u00051!o\\;uK\u0002\n\u0001BZ5oI\nK\u0018\nZ\u0001\u0016GJ,\u0017\r^3D_J,GK]1og\u0006\u001cG/[8o\u0003}\u0019'/Z1uK\u000e{'/\u001a+sC:\u001c\u0018m\u0019;j_:\u001c\u0016.\u001c9mS\u001aLW\rZ\u0001\u0013g\u0016tGmQ8j]N$v.\u00113ee\u0016\u001c8/A\u0007xSRDGM]1x\u0007>Lgn]\u0001\u0010[\u0006\\WMR8sO\u0016\u00148\u000b^1lK\u0006\t2\u000f]3oI\u001a{'oZ5oON#\u0018m[3\u00025\r\u0014X-\u0019;f\u001fB,gn\u0015;bW\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0002I\r\u0014X-\u0019;f\u001fB,gn\u0015;bW\u0016$&/\u00198tC\u000e$\u0018n\u001c8TS6\u0004H.\u001b4jK\u0012\fAd\u0019:fCR,7*Z=S_R\fG/[8o)J\fgn]1di&|g.A\u0012ck&dGm\u00149f]N#\u0018m[3Ue\u0006t7/Y2uS>t7+[7qY&4\u0017.\u001a3\u0015\t\tE\"1\t\t\u0007\u0005g\u0011ID!\u0010\u000e\u0005\tU\"\u0002\u0002B\u001c\u0003+\tA!\u001e;jY&!!1\bB\u001b\u0005\r!&/\u001f\t\u0004%\n}\u0012b\u0001B!'\n!r\n]3o'R\f7.\u001a+sC:\u001c\u0018m\u0019;j_:DqA!\u0012!\u0001\u0004\u00119%\u0001\u0003c_\u0012L\b\u0003\u0002B%\u0005?rAAa\u0013\u0003\\9!!Q\nB-\u001d\u0011\u0011yEa\u0016\u000f\t\tE#Q\u000b\b\u0005\u0003\u007f\u0012\u0019&\u0003\u0002D\t&\u0011\u0011IQ\u0005\u0003\u007f\u0001K!!\u0010 \n\u0007\tuC(\u0001\u0010TS\u0012,7\r[1j]R\u0013\u0018M\\:bGRLwN\u001c*fgR\u001c6\r[3nK&!!\u0011\rB2\u0005Y\u0011V-](qK:\u001cF/Y6f'&l\u0007\u000f\\5gS\u0016$'b\u0001B/y\u0005I\"-^5mI>\u0003XM\\*uC.,GK]1og\u0006\u001cG/[8o)\u0011\u0011\tD!\u001b\t\u000f\t\u0015\u0013\u00051\u0001\u0003lA!!\u0011\nB7\u0013\u0011\u0011yGa\u0019\u0003\u0019I+\u0017o\u00149f]N#\u0018m[3\u0002C\r\u0014X-\u0019;f\u0003:$7+[4o\u001fB,gn\u0015;bW\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0019\tE\"Q\u000fB=\u0005\u0013\u0013iJa*\t\r\t]$\u00051\u0001^\u0003!Ig\u000e];u\u0005>D\bb\u0002B>E\u0001\u0007!QP\u0001\u0010S:\u0004X\u000f\u001e)sSZ\fG/Z&fsB!!q\u0010BC\u001b\t\u0011\tIC\u0002\u0003\u0004\u0012\u000baa]3de\u0016$\u0018\u0002\u0002BD\u0005\u0003\u0013q\u0002\u0015:jm\u0006$XmS3zeU*\u0014'\u000f\u0005\b\u0005\u0017\u0013\u0003\u0019\u0001BG\u0003EyW\u000f\u001e9viB\u0013x\u000e]8tSRLwN\u001c\t\u0005\u0005\u001f\u00139J\u0004\u0003\u0003\u0012\nM\u0005\u0003BAB\u0003+IAA!&\u0002\u0016\u00051\u0001K]3eK\u001aLAA!'\u0003\u001c\n11\u000b\u001e:j]\u001eTAA!&\u0002\u0016!9!q\u0014\u0012A\u0002\t\u0005\u0016a\u00034pe\u001e,'/\u00138eKb\u0004B!a\u0005\u0003$&!!QUA\u000b\u0005\rIe\u000e\u001e\u0005\b\u0005S\u0013\u0003\u0019\u0001BV\u0003!Ig\u000e];u\r\u0016,\u0007CBA\n\u0005[\u0013\t,\u0003\u0003\u00030\u0006U!AB(qi&|g\u000e\u0005\u0003\u0002\u0014\tM\u0016\u0002\u0002B[\u0003+\u0011A\u0001T8oO\u0006\u0001r-\u001a;DQ\u0006tw-Z!eIJ,7o\u001d\u000b\u0005\u0005w\u0013\u0019\r\u0005\u0004\u0002\u0014\t5&Q\u0018\t\u00041\n}\u0016b\u0001Ba3\nI\u0002+\u001e2mS\u000e\\U-\u001f\u001a6kEJ\u0004K]8q_NLG/[8o\u0011\u0019\u0011)m\ta\u0001w\u00061q/\u00197mKR$\u0002C!3\u0003R\n-(q_B\u0002\u0007\u000f\u0019Ya!\u0004\u0011\r\tM\"\u0011\bBf!\r\u0011&QZ\u0005\u0004\u0005\u001f\u001c&\u0001G*jI\u0016\u001c\u0007.Y5o\u0007>\u0014X\r\u0016:b]N\f7\r^5p]\"9!1\u001b\u0013A\u0002\tU\u0017A\u0004>f]\n{\u0007\u0010R1uC2K7\u000f\u001e\t\u0007\u0005/\u0014yN!:\u000f\t\te'Q\u001c\b\u0005\u0003\u0007\u0013Y.\u0003\u0002\u0002\u0018%!!QBA\u000b\u0013\u0011\u0011\tOa9\u0003\t1K7\u000f\u001e\u0006\u0005\u0005\u001b\t)\u0002\u0005\u0003\u0003J\t\u001d\u0018\u0002\u0002Bu\u0005G\u0012\u0011\u0003\u0016:b]N\f7\r^5p]>+H\u000f];u\u0011\u001d\u0011i\u000f\na\u0001\u0005_\fAd^5uQ\u0012\u0014\u0018m^1m%\u0016\fX/Z:u\u0005>DH)\u0019;b\u0019&\u001cH\u000f\u0005\u0004\u0003X\n}'\u0011\u001f\t\u0005\u0005\u0013\u0012\u00190\u0003\u0003\u0003v\n\r$A\t+sC:\u001c\u0018m\u0019;j_:<\u0016\u000e\u001e5ee\u0006<\u0018\r\u001c*fcV,7\u000f^(viB,H\u000fC\u0004\u0003z\u0012\u0002\rAa?\u0002#\u0019|'oZ3s\u0005>DH)\u0019;b\u0019&\u001cH\u000f\u0005\u0004\u0003X\n}'Q \t\u0005\u0005\u0013\u0012y0\u0003\u0003\u0004\u0002\t\r$a\u0006+sC:\u001c\u0018m\u0019;j_:4uN]4fe>+H\u000f];u\u0011\u001d\u0019)\u0001\na\u0001\u0005c\u000b1AZ3f\u0011\u001d\u0019I\u0001\na\u0001\u0005{\u000bQb\u00195b]\u001e,\u0017\t\u001a3sKN\u001c\bB\u0002BcI\u0001\u00071\u0010C\u0004\u0004\u0010\u0011\u0002\r!a\u0001\u0002#MLG-Z2iC&tgj\u001c3f-&,w/\u0001\u0003d_BLHCDB\u000b\u00077\u0019iba\b\u0004\"\r\r2Q\u0005\u000b\u0007\u0003\u000f\u001c9b!\u0007\t\u000f\u0005}U\u0005q\u0001\u0002$\"9\u0011QV\u0013A\u0004\u0005E\u0006\"CA\u0012KA\u0005\t\u0019AA\u0014\u0011%\tY$\nI\u0001\u0002\u0004\ty\u0004C\u0005\u0002R\u0015\u0002\n\u00111\u0001\u0002@!I\u0011QK\u0013\u0011\u0002\u0003\u0007\u0011\u0011\f\u0005\n\u0003K*\u0003\u0013!a\u0001\u0003SB\u0011\"!\u001e&!\u0003\u0005\r!!\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0006\u0016\u0005\u0003O\u0019ic\u000b\u0002\u00040A!1\u0011GB\u001e\u001b\t\u0019\u0019D\u0003\u0003\u00046\r]\u0012!C;oG\",7m[3e\u0015\u0011\u0019I$!\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004>\rM\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAB\"U\u0011\tyd!\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAB&U\u0011\tIf!\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u00111\u0011\u000b\u0016\u0005\u0003S\u001ai#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r]#\u0006BA=\u0007[\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB/!\u0011\u0019yf!\u001b\u000e\u0005\r\u0005$\u0002BB2\u0007K\nA\u0001\\1oO*\u00111qM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u001a\u000e\u0005\u0014\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001BQ\u00039\u0001(o\u001c3vGR,E.Z7f]R$Baa\u001d\u0004zA!\u00111CB;\u0013\u0011\u00199(!\u0006\u0003\u0007\u0005s\u0017\u0010C\u0005\u0004|9\n\t\u00111\u0001\u0003\"\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!!\u0011\r\r\r5\u0011RB:\u001b\t\u0019)I\u0003\u0003\u0004\b\u0006U\u0011AC2pY2,7\r^5p]&!11RBC\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\rE5q\u0013\t\u0005\u0003'\u0019\u0019*\u0003\u0003\u0004\u0016\u0006U!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0007w\u0002\u0014\u0011!a\u0001\u0007g\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005C\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007;\na!Z9vC2\u001cH\u0003BBI\u0007KC\u0011ba\u001f4\u0003\u0003\u0005\raa\u001d\u00029MKG-Z2iC&tGK]1og\u0006\u001cG/[8o\u0003BL'k\\;uKB\u0019\u0011\u0011Z\u001b\u0014\u000bU\u001ai+!\b\u0011\t\u0005M1qV\u0005\u0005\u0007c\u000b)B\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0007S\u000bQ!\u00199qYf$bb!/\u0004@\u000e\u000571YBc\u0007\u000f\u001cI\r\u0006\u0004\u0002H\u000em6Q\u0018\u0005\b\u0003?C\u00049AAR\u0011\u001d\ti\u000b\u000fa\u0002\u0003cCq!a\t9\u0001\u0004\t9\u0003C\u0004\u0002<a\u0002\r!a\u0010\t\u000f\u0005E\u0003\b1\u0001\u0002@!9\u0011Q\u000b\u001dA\u0002\u0005e\u0003bBA3q\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003kB\u0004\u0019AA=\u0003\u001d)h.\u00199qYf$Baa4\u0004XB1\u00111\u0003BW\u0007#\u0004\u0002#a\u0005\u0004T\u0006\u001d\u0012qHA \u00033\nI'!\u001f\n\t\rU\u0017Q\u0003\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\re\u0017(!AA\u0002\u0005\u001d\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019y\u000e\u0005\u0003\u0004`\r\u0005\u0018\u0002BBr\u0007C\u0012aa\u00142kK\u000e$\b")
public class SidechainTransactionApiRoute
extends TransactionBaseApiRoute<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>, SidechainBlockHeader, SidechainBlock, SidechainFeePaymentsInfo, NodeHistory, NodeState, NodeWallet, NodeMemoryPool, SidechainNodeView>
implements SidechainTypes,
Product,
scala.Serializable {
    private final RESTApiSettings settings;
    private final ActorRef sidechainNodeViewHolderRef;
    private final ActorRef sidechainTransactionActorRef;
    private final SidechainTransactionsCompanion companion;
    private final NetworkParams params;
    private final Enumeration.Value circuitType;
    private final ClassTag<SidechainNodeView> tag;
    private final Function1<RequestContext, Future<RouteResult>> route;

    public static Option<Tuple6<RESTApiSettings, ActorRef, ActorRef, SidechainTransactionsCompanion, NetworkParams, Enumeration.Value>> unapply(SidechainTransactionApiRoute sidechainTransactionApiRoute) {
        return SidechainTransactionApiRoute$.MODULE$.unapply(sidechainTransactionApiRoute);
    }

    public static SidechainTransactionApiRoute apply(RESTApiSettings rESTApiSettings, ActorRef actorRef, ActorRef actorRef2, SidechainTransactionsCompanion sidechainTransactionsCompanion, NetworkParams networkParams, Enumeration.Value value, ActorRefFactory actorRefFactory, ExecutionContext executionContext) {
        return SidechainTransactionApiRoute$.MODULE$.apply(rESTApiSettings, actorRef, actorRef2, sidechainTransactionsCompanion, networkParams, value, actorRefFactory, executionContext);
    }

    @Override
    public BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> sidechainTxToScbt(SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>> t) {
        return SidechainTypes.sidechainTxToScbt$(this, t);
    }

    @Override
    public AccountTransaction<io.horizen.proposition.Proposition, Proof<io.horizen.proposition.Proposition>> ethereumTxToScat(EthereumTransaction t) {
        return SidechainTypes.ethereumTxToScat$(this, t);
    }

    @Override
    public java.util.List<BoxTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> sidechainTxListToScbtList(java.util.List<SidechainTransaction<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> tl) {
        return SidechainTypes.sidechainTxListToScbtList$(this, tl);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> zenBoxToScb(ZenBox b) {
        return SidechainTypes.zenBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> withdrawalRequestBoxToScb(WithdrawalRequestBox b) {
        return SidechainTypes.withdrawalRequestBoxToScb$(this, b);
    }

    @Override
    public Box<io.horizen.proposition.Proposition> forgerBoxToScb(ForgerBox b) {
        return SidechainTypes.forgerBoxToScb$(this, b);
    }

    @Override
    public java.util.List<Box<io.horizen.proposition.Proposition>> zenBoxJavaListToScbtJavaList(java.util.List<ZenBox> bl) {
        return SidechainTypes.zenBoxJavaListToScbtJavaList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> zenBoxListToScbtList(List<ZenBox> bl) {
        return SidechainTypes.zenBoxListToScbtList$(this, bl);
    }

    @Override
    public List<Box<io.horizen.proposition.Proposition>> forgerBoxListToScbtList(List<ForgerBox> bl) {
        return SidechainTypes.forgerBoxListToScbtList$(this, bl);
    }

    @Override
    public Set<Box<io.horizen.proposition.Proposition>> zenBoxSetToScbSet(Set<ZenBox> bs) {
        return SidechainTypes.zenBoxSetToScbSet$(this, bs);
    }

    @Override
    public ForgerBox scbToForgerBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToForgerBox$(this, b);
    }

    @Override
    public WithdrawalRequestBox scbToWithdrawalRequestBox(Box<io.horizen.proposition.Proposition> b) {
        return SidechainTypes.scbToWithdrawalRequestBox$(this, b);
    }

    public RESTApiSettings settings() {
        return this.settings;
    }

    @Override
    public ActorRef sidechainNodeViewHolderRef() {
        return this.sidechainNodeViewHolderRef;
    }

    public ActorRef sidechainTransactionActorRef() {
        return this.sidechainTransactionActorRef;
    }

    public SidechainTransactionsCompanion companion() {
        return this.companion;
    }

    public NetworkParams params() {
        return this.params;
    }

    public Enumeration.Value circuitType() {
        return this.circuitType;
    }

    @Override
    public ActorRefFactory context() {
        return super.context();
    }

    @Override
    public ExecutionContext ec() {
        return super.ec();
    }

    @Override
    public ClassTag<SidechainNodeView> tag() {
        return this.tag;
    }

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.route;
    }

    public Function1<RequestContext, Future<RouteResult>> findById() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("findById")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqFindById.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
            NodeHistory history = sidechainNodeView.getNodeHistory();
            String txId = body2.transactionId();
            boolean format = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
            None$ transaction = None$.MODULE$;
            String error = "";
            Option<String> option = body2.blockHash();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                String hash = (String)some.value();
                transaction = SidechainTransactionApiRoute.searchTransactionInBlock$1(txId, hash, history);
                if (transaction.isEmpty()) {
                    error = new StringBuilder(41).append("Transaction ").append(txId).append(" not found in specified block").toString();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                transaction = SidechainTransactionApiRoute.searchTransactionInMemoryPool$1(txId, memoryPool);
                if (transaction.isEmpty()) {
                    error = new StringBuilder(37).append("Transaction ").append(txId).append(" not found in memory pool").toString();
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError(option);
            }
            None$ none$ = transaction;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                BoxTransaction t = (BoxTransaction)some.value();
                function1 = format ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<BoxTransaction>(t)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(t))));
            } else if (None$.MODULE$.equals(none$)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionId(error, Optional.empty()));
            } else {
                throw new MatchError((Object)none$);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createCoreTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createCoreTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$1 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateCoreTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            block7: {
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Buffer inputBoxes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$5(body2, box)));
                if (inputBoxes.length() < body2.transactionInputs().size()) {
                    function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Unable to find input(s)", Optional.empty()));
                } else {
                    ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
                    body2.regularOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
                    body2.withdrawalRequests().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new WithdrawalRequestBoxData((MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(BytesUtils.fromHorizenPublicKeyAddress(element.mainchainAddress(), this.params())), element.value()))));
                    body2.forgerOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$9(outputs, element)));
                    long inputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long fee = inputsTotalAmount - outputsTotalAmount;
                    if (fee < 0L) {
                        function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(new IllegalArgumentException("Total inputs amount is less then total outputs amount."))));
                    } else {
                        try {
                            java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id(), Buffer$.MODULE$.canBuildFrom())).asJava();
                            java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
                            body2.withdrawalRequests().foreach((Function1 & Serializable & scala.Serializable)element -> {
                                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$14(element);
                                return BoxedUnit.UNIT;
                            });
                            SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
                            byte[] messageToSign = unsignedTransaction.messageToSign();
                            Buffer proofs = (Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)box -> {
                                Proposition proposition = box.proposition();
                                if (!(proposition instanceof PublicKey25519Proposition)) {
                                    throw new IllegalArgumentException(new StringBuilder(91).append("Unexpected box locking proposition for box id [").append(BytesUtils.toHexString(box.id())).append("]. Expected: PublicKey25519Proposition, got ").append(box.proposition().getClass()).toString());
                                }
                                PublicKey25519Proposition publicKey25519Proposition = (PublicKey25519Proposition)proposition;
                                Signature25519 signature25519 = wallet.secretByPublicKey25519Proposition(publicKey25519Proposition).get().sign(messageToSign);
                                return signature25519;
                            }, Buffer$.MODULE$.canBuildFrom());
                            SidechainCoreTransaction transaction = new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(proofs).asJava(), fee, 1);
                            if (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) {
                                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction));
                                break block7;
                            }
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction))));
                        }
                        catch (Throwable t) {
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(t)));
                        }
                    }
                }
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> createCoreTransactionSimplified() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createCoreTransactionSimplified")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$5 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateCoreTransactionSimplified.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            List<SidechainTransactionRestScheme.TransactionOutput> outputList = body2.regularOutputs();
            List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalRequestList = body2.withdrawalRequests();
            List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerOutputList = body2.forgerOutputs();
            long fee = body2.fee();
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
            if (option instanceof Some) {
                Function1<RequestContext, Future<RouteResult>> function12;
                Some some = (Some)option;
                PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                Try<SidechainCoreTransaction> try_ = this.createCoreTransaction(outputList, withdrawalRequestList, forgerOutputList, fee, changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                    function12 = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction))));
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    function12 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
                } else {
                    throw new MatchError(try_);
                }
                function1 = function12;
            } else if (None$.MODULE$.equals(option)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."))));
            } else {
                throw new MatchError(option);
            }
            return function1;
        }))));
    }

    public Function1<RequestContext, Future<RouteResult>> sendCoinsToAddress() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("sendCoinsToAddress")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$6 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqSendCoinsToAddress.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionOutput> outputList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction(outputList, (List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput>)Nil$.MODULE$, (List<SidechainTransactionRestScheme.TransactionForgerOutput>)Nil$.MODULE$, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<SidechainCoreTransaction>(transaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(transaction)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> withdrawCoins() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("withdrawCoins")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$7 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqWithdrawCoins.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalOutputsList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction((List<SidechainTransactionRestScheme.TransactionOutput>)Nil$.MODULE$, withdrawalOutputsList, (List<SidechainTransactionRestScheme.TransactionForgerOutput>)Nil$.MODULE$, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> makeForgerStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("makeForgerStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$8 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateForgerStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try try_ = (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Try<SidechainCoreTransaction> try_;
                List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerOutputsList = body2.outputs();
                Option<Object> fee = body2.fee();
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Option<PublicKey25519Proposition> option = this.getChangeAddress(wallet);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    PublicKey25519Proposition changeAddress = (PublicKey25519Proposition)some.value();
                    try_ = this.createCoreTransaction((List<SidechainTransactionRestScheme.TransactionOutput>)Nil$.MODULE$, (List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput>)Nil$.MODULE$, forgerOutputsList, BoxesRunTime.unboxToLong((Object)fee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), changeAddress, wallet, (SidechainNodeView)sidechainNodeView);
                } else if (None$.MODULE$.equals(option)) {
                    try_ = new Try<SidechainCoreTransaction>((Throwable)new IllegalStateException("Can't find change address in wallet. Please, create a PrivateKey secret first."));
                } else {
                    throw new MatchError(option);
                }
                return try_;
            });
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)success.value();
                function1 = this.validateAndSendTransaction(transaction, this.validateAndSendTransaction$default$2());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(e)));
            } else {
                throw new MatchError((Object)try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> spendForgingStake() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("spendForgingStake")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$9 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqSpendForgingStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Right right;
            Tuple2 tuple2;
            Function1<RequestContext, Future<RouteResult>> function1;
            Either either = (Either)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                Left left;
                NodeWallet wallet = sidechainNodeView.getNodeWallet();
                Buffer inputBoxes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).filter((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$5(body2, box)));
                if (inputBoxes.length() < body2.transactionInputs().size()) {
                    left = package$.MODULE$.Left().apply(ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Unable to find input(s)", Optional.empty())));
                } else {
                    ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
                    body2.regularOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
                    body2.forgerOutputs().foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$8(outputs, element)));
                    long inputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    long fee = inputsTotalAmount - outputsTotalAmount;
                    try {
                        java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.id(), Buffer$.MODULE$.canBuildFrom())).asJava();
                        java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
                        SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
                        byte[] messageToSign = unsignedTransaction.messageToSign();
                        Buffer proofs = (Buffer)inputBoxes.map((Function1 & Serializable & scala.Serializable)box -> {
                            Proposition proposition = box.proposition();
                            if (!(proposition instanceof PublicKey25519Proposition)) {
                                throw new IllegalArgumentException(new StringBuilder(91).append("Unexpected box locking proposition for box id [").append(BytesUtils.toHexString(box.id())).append("]. Expected: PublicKey25519Proposition, got ").append(box.proposition().getClass()).toString());
                            }
                            PublicKey25519Proposition publicKey25519Proposition = (PublicKey25519Proposition)proposition;
                            Signature25519 signature25519 = wallet.secretByPublicKey25519Proposition(publicKey25519Proposition).get().sign(messageToSign);
                            return signature25519;
                        }, Buffer$.MODULE$.canBuildFrom());
                        SidechainCoreTransaction transaction = new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(proofs).asJava(), fee, 1);
                        Function1 & Serializable & scala.Serializable txRepresentation = BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? (Function1 & Serializable & scala.Serializable)tx -> new TransactionBaseRestScheme.TransactionDTO<BoxTransaction>((BoxTransaction)tx) : (Function1 & Serializable & scala.Serializable)tx -> new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)));
                        left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)transaction, (Object)txRepresentation));
                    }
                    catch (Throwable t) {
                        left = package$.MODULE$.Left().apply(ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(t))));
                    }
                }
                return left;
            });
            if (either instanceof Left) {
                Function1<RequestContext, Future<RouteResult>> errorResponse;
                Left left = (Left)either;
                function1 = errorResponse = (Function1<RequestContext, Future<RouteResult>>)left.value();
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                SidechainCoreTransaction transaction = (SidechainCoreTransaction)tuple2._1();
                Function1 txRepresentation = (Function1)tuple2._2();
                function1 = this.validateAndSendTransaction(transaction, txRepresentation);
            } else {
                throw new MatchError((Object)either);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createOpenStakeTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createOpenStakeTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$13 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqOpenStake.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try<OpenStakeTransaction> try_ = this.buildOpenStakeTransaction((SidechainTransactionRestScheme.ReqOpenStake)body2);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                OpenStakeTransaction tx = (OpenStakeTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(tx, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<OpenStakeTransaction>(tx)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(exception)));
            } else {
                throw new MatchError(try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createOpenStakeTransactionSimplified() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createOpenStakeTransactionSimplified")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$14 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqOpenStakeSimplified.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1<RequestContext, Future<RouteResult>> function1;
            Try<OpenStakeTransaction> try_ = this.buildOpenStakeTransactionSimplified((SidechainTransactionRestScheme.ReqOpenStakeSimplified)body2);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                OpenStakeTransaction tx = (OpenStakeTransaction)success.value();
                function1 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(tx, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<OpenStakeTransaction>(tx)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(tx)))));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(exception)));
            } else {
                throw new MatchError(try_);
            }
            return function1;
        })));
    }

    public Function1<RequestContext, Future<RouteResult>> createKeyRotationTransaction() {
        return (Function1)Directive$.MODULE$.addByNameNullaryApply((Directive)this.post().$amp(ConjunctionMagnet$.MODULE$.fromDirective(this.path(this._segmentStringToPathMatcher("createKeyRotationTransaction")), TupleOps.Join$.MODULE$.join0P()))).apply((Function0 & Serializable & scala.Serializable)() -> (Function1)Directive$.MODULE$.addDirectiveApply((Directive)this.withBasicAuth(), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)x$15 -> (Function1)Directive$.MODULE$.addDirectiveApply(this.entity(this.as(JacksonSupport$.MODULE$.JacksonRequestUnmarshaller(ClassTag$.MODULE$.apply(SidechainTransactionRestScheme.ReqCreateKeyRotationTransaction.class)))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)body2 -> {
            Function1 function1;
            Enumeration.Value value = this.circuitType();
            Enumeration.Value value2 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuit();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorBadCircuit("The current circuit doesn't support key rotation transaction!", Optional.empty()));
            } else {
                Enumeration.Value value4 = CircuitTypes$.MODULE$.NaiveThresholdSignatureCircuitWithKeyRotation();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    function1 = (Function1)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
                        Function1<RequestContext, Future<RouteResult>> function1;
                        NodeWallet wallet = sidechainNodeView.getNodeWallet();
                        long fee = BoxesRunTime.unboxToLong((Object)body2.fee().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
                        ArrayList<byte[]> boxIdsToExclude = new ArrayList<byte[]>();
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(memoryPool.getTransactions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)transaction -> {
                            SidechainTransactionApiRoute.$anonfun$createKeyRotationTransaction$6(boxIdsToExclude, transaction);
                            return BoxedUnit.UNIT;
                        });
                        Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.boxesOfType(ZenBox.class, boxIdsToExclude)).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createKeyRotationTransaction$8(fee, box)));
                        if (option instanceof Some) {
                            Function1<RequestContext, Future<RouteResult>> function12;
                            Some some = (Some)option;
                            Box inputBox = (Box)some.value();
                            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> CertificateKeyRotationTransaction.create(new Pair<ZenBox, PrivateKey25519>((ZenBox)inputBox, wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get()), (PublicKey25519Proposition)inputBox.proposition(), fee, body2.keyType(), body2.keyIndex(), SchnorrPropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(body2.newKey())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.signingKeySignature())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.masterKeySignature())), (SchnorrProof)SchnorrSignatureSerializer.getSerializer().parseBytes(BytesUtils.fromHexString(body2.newKeySignature()))));
                            if (try_ instanceof Success) {
                                Success success = (Success)try_;
                                CertificateKeyRotationTransaction keyRotationTransaction = (CertificateKeyRotationTransaction)success.value();
                                function12 = BoxesRunTime.unboxToBoolean((Object)body2.automaticSend().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true)) ? this.validateAndSendTransaction(keyRotationTransaction, this.validateAndSendTransaction$default$2()) : (BoxesRunTime.unboxToBoolean((Object)body2.format().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionDTO<CertificateKeyRotationTransaction>(keyRotationTransaction)) : ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseRestScheme.TransactionBytesDTO(BytesUtils.toHexString(this.companion().toBytes(keyRotationTransaction)))));
                            } else if (try_ instanceof Failure) {
                                Failure failure = (Failure)try_;
                                Throwable ex = failure.exception();
                                function12 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.GenericTransactionError("GenericTransactionError", Optional.of(ex)));
                            } else {
                                throw new MatchError((Object)try_);
                            }
                            function1 = function12;
                        } else if (None$.MODULE$.equals(option)) {
                            function1 = ApiResponseUtil$.MODULE$.toResponse(new TransactionBaseErrorResponse.ErrorNotFoundTransactionInput("Not found input box to pay the fee", Optional.empty()));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return function1;
                    });
                } else {
                    throw new MatchError((Object)value);
                }
            }
            return function1;
        })));
    }

    private Try<OpenStakeTransaction> buildOpenStakeTransactionSimplified(SidechainTransactionRestScheme.ReqOpenStakeSimplified body2) {
        return (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$buildOpenStakeTransactionSimplified$2(body2, box)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unable to find input for Proposition ").append(body2.forgerProposition()).toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Box inputBox = (Box)some.value();
            PrivateKey25519 inputPrivateKey = wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get();
            Try<OpenStakeTransaction> try_ = this.createAndSignOpenStakeTransaction(inputBox, inputPrivateKey, body2.forgerProposition(), body2.forgerIndex(), body2.fee());
            return try_;
        });
    }

    private Try<OpenStakeTransaction> buildOpenStakeTransaction(SidechainTransactionRestScheme.ReqOpenStake body2) {
        return (Try)this.applyOnNodeView((Function1 & Serializable & scala.Serializable)sidechainNodeView -> {
            NodeWallet wallet = sidechainNodeView.getNodeWallet();
            Option option = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allBoxes()).asScala()).find((Function1 & Serializable & scala.Serializable)box -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$buildOpenStakeTransaction$2(body2, box)));
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException("Unable to find input!");
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            Box inputBox = (Box)some.value();
            PrivateKey25519 inputPrivateKey = wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)inputBox.proposition()).get();
            Try<OpenStakeTransaction> try_ = this.createAndSignOpenStakeTransaction(inputBox, inputPrivateKey, body2.regularOutputProposition(), body2.forgerIndex(), body2.fee());
            return try_;
        });
    }

    private Try<OpenStakeTransaction> createAndSignOpenStakeTransaction(Box<io.horizen.proposition.Proposition> inputBox, PrivateKey25519 inputPrivateKey, String outputProposition, int forgerIndex, Option<Object> inputFee) {
        long fee = BoxesRunTime.unboxToLong((Object)inputFee.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        if (fee < 0L) {
            throw new IllegalArgumentException("Fee can't be negative!");
        }
        if (fee > inputBox.value()) {
            throw new IllegalArgumentException("Fee can't be greater than the input!");
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> OpenStakeTransaction.create(new Pair<ZenBox, PrivateKey25519>((ZenBox)inputBox, inputPrivateKey), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(outputProposition)), forgerIndex, fee));
    }

    private Option<PublicKey25519Proposition> getChangeAddress(NodeWallet wallet) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.allSecrets()).asScala()).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$getChangeAddress$1(s))).map((Function1 & Serializable & scala.Serializable)x$16 -> (PublicKey25519Proposition)x$16.publicImage());
    }

    private Try<SidechainCoreTransaction> createCoreTransaction(List<SidechainTransactionRestScheme.TransactionOutput> zenBoxDataList, List<SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput> withdrawalRequestBoxDataList, List<SidechainTransactionRestScheme.TransactionForgerOutput> forgerBoxDataList, long fee, PublicKey25519Proposition changeAddress, NodeWallet wallet, SidechainNodeView sidechainNodeView) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            NodeMemoryPool memoryPool = sidechainNodeView.getNodeMemoryPool();
            ArrayList boxIdsToExclude = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(memoryPool.getTransactions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)transaction -> {
                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$18(boxIdsToExclude, transaction);
                return BoxedUnit.UNIT;
            });
            ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>> outputs = new ArrayList<BoxData<io.horizen.proposition.Proposition, Box<io.horizen.proposition.Proposition>>>();
            zenBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value()))));
            withdrawalRequestBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$21(this, outputs, element)));
            forgerBoxDataList.foreach((Function1 & Serializable & scala.Serializable)element -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$22(outputs, element)));
            long outputsTotalAmount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(outputs).asScala()).map((Function1 & Serializable & scala.Serializable)boxData -> BoxesRunTime.boxToLong((long)boxData.value()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long inputsMinimumExpectedAmount = outputsTotalAmount + fee;
            LongRef inputsTotalAmount = LongRef.create((long)0L);
            ArrayBuffer boxes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(wallet.boxesOfType(ZenBox.class, boxIdsToExclude)).asScala()).foreach((Function1 & Serializable & scala.Serializable)box -> {
                SidechainTransactionApiRoute.$anonfun$createCoreTransaction$26(boxes, inputsTotalAmount, inputsMinimumExpectedAmount, box);
                return BoxedUnit.UNIT;
            }));
            if (inputsTotalAmount.elem < inputsMinimumExpectedAmount) {
                throw new IllegalArgumentException("Not enough balances in the wallet to create transaction.");
            }
            Object object = inputsTotalAmount.elem > inputsMinimumExpectedAmount ? BoxesRunTime.boxToBoolean((boolean)outputs.add(new ZenBoxData(changeAddress, inputsTotalAmount.elem - inputsMinimumExpectedAmount))) : BoxedUnit.UNIT;
            java.util.List boxIds = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)boxes.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.id(), ArrayBuffer$.MODULE$.canBuildFrom())).asJava();
            java.util.List<Object> fakeProofs = Collections.nCopies(boxIds.size(), null);
            SidechainCoreTransaction unsignedTransaction = new SidechainCoreTransaction(boxIds, outputs, fakeProofs, fee, 1);
            byte[] messageToSign = unsignedTransaction.messageToSign();
            ArrayBuffer proofs = (ArrayBuffer)boxes.map((Function1 & Serializable & scala.Serializable)box -> wallet.secretByPublicKey25519Proposition((PublicKey25519Proposition)box.proposition()).get().sign(messageToSign), ArrayBuffer$.MODULE$.canBuildFrom());
            return new SidechainCoreTransaction(boxIds, outputs, (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)proofs).asJava(), fee, 1);
        });
    }

    public SidechainTransactionApiRoute copy(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        return new SidechainTransactionApiRoute(settings, sidechainNodeViewHolderRef, sidechainTransactionActorRef, companion, params, circuitType, context, ec);
    }

    public RESTApiSettings copy$default$1() {
        return this.settings();
    }

    public ActorRef copy$default$2() {
        return this.sidechainNodeViewHolderRef();
    }

    public ActorRef copy$default$3() {
        return this.sidechainTransactionActorRef();
    }

    public SidechainTransactionsCompanion copy$default$4() {
        return this.companion();
    }

    public NetworkParams copy$default$5() {
        return this.params();
    }

    public Enumeration.Value copy$default$6() {
        return this.circuitType();
    }

    public String productPrefix() {
        return "SidechainTransactionApiRoute";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.settings();
                break;
            }
            case 1: {
                object = this.sidechainNodeViewHolderRef();
                break;
            }
            case 2: {
                object = this.sidechainTransactionActorRef();
                break;
            }
            case 3: {
                object = this.companion();
                break;
            }
            case 4: {
                object = this.params();
                break;
            }
            case 5: {
                object = this.circuitType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SidechainTransactionApiRoute;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SidechainTransactionApiRoute)) return false;
        boolean bl = true;
        if (!bl) return false;
        SidechainTransactionApiRoute sidechainTransactionApiRoute = (SidechainTransactionApiRoute)x$1;
        RESTApiSettings rESTApiSettings = this.settings();
        RESTApiSettings rESTApiSettings2 = sidechainTransactionApiRoute.settings();
        if (rESTApiSettings == null) {
            if (rESTApiSettings2 != null) {
                return false;
            }
        } else if (!rESTApiSettings.equals(rESTApiSettings2)) return false;
        ActorRef actorRef = this.sidechainNodeViewHolderRef();
        ActorRef actorRef2 = sidechainTransactionApiRoute.sidechainNodeViewHolderRef();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        ActorRef actorRef3 = this.sidechainTransactionActorRef();
        ActorRef actorRef4 = sidechainTransactionApiRoute.sidechainTransactionActorRef();
        if (actorRef3 == null) {
            if (actorRef4 != null) {
                return false;
            }
        } else if (!actorRef3.equals(actorRef4)) return false;
        SidechainTransactionsCompanion sidechainTransactionsCompanion = this.companion();
        SidechainTransactionsCompanion sidechainTransactionsCompanion2 = sidechainTransactionApiRoute.companion();
        if (sidechainTransactionsCompanion == null) {
            if (sidechainTransactionsCompanion2 != null) {
                return false;
            }
        } else if (!((Object)sidechainTransactionsCompanion).equals(sidechainTransactionsCompanion2)) return false;
        NetworkParams networkParams = this.params();
        NetworkParams networkParams2 = sidechainTransactionApiRoute.params();
        if (networkParams == null) {
            if (networkParams2 != null) {
                return false;
            }
        } else if (!networkParams.equals(networkParams2)) return false;
        Enumeration.Value value = this.circuitType();
        Enumeration.Value value2 = sidechainTransactionApiRoute.circuitType();
        if (value == null) {
            if (value2 != null) {
                return false;
            }
        } else if (!value.equals(value2)) return false;
        if (!sidechainTransactionApiRoute.canEqual(this)) return false;
        return true;
    }

    private static final Option searchTransactionInMemoryPool$1(String id, NodeMemoryPool memoryPool$1) {
        Optional opt = memoryPool$1.getTransactionById(id);
        return opt.isPresent() ? Option$.MODULE$.apply(opt.get()) : None$.MODULE$;
    }

    private static final Option searchTransactionInBlock$1(String id, String blockHash, NodeHistory history$1) {
        Optional opt = history$1.searchTransactionInsideSidechainBlock(id, blockHash);
        return opt.isPresent() ? Option$.MODULE$.apply(opt.get()) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$6(Box box$1, SidechainTransactionRestScheme.TransactionInput p) {
        return p.boxId().contentEquals(BytesUtils.toHexString(box$1.id()));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$5(SidechainTransactionRestScheme.ReqCreateCoreTransaction body$2, Box box) {
        return (box instanceof ZenBox || box instanceof ForgerBox) && body$2.transactionInputs().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$createCoreTransaction$6(box, p)));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$9(java.util.List outputs$1, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgerBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$1.add(forgerBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$14(SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput element) {
        if (element.value() < ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)) {
            throw new IllegalArgumentException("Withdrawal transaction amount is below the MC dust threshold value.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$6(Box box$2, SidechainTransactionRestScheme.TransactionInput p) {
        return p.boxId().contentEquals(BytesUtils.toHexString(box$2.id()));
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$5(SidechainTransactionRestScheme.ReqSpendForgingStake body$7, Box box) {
        return (box instanceof ZenBox || box instanceof ForgerBox) && body$7.transactionInputs().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)SidechainTransactionApiRoute.$anonfun$spendForgingStake$6(box, p)));
    }

    public static final /* synthetic */ boolean $anonfun$spendForgingStake$8(java.util.List outputs$2, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgerBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$2.add(forgerBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createKeyRotationTransaction$6(ArrayList boxIdsToExclude$1, BoxTransaction transaction) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(transaction.boxIdsToOpen()).asScala()).foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)boxIdsToExclude$1.add(id.data())));
    }

    public static final /* synthetic */ boolean $anonfun$createKeyRotationTransaction$8(long fee$1, Box box) {
        return box.value() >= fee$1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOpenStakeTransactionSimplified$2(SidechainTransactionRestScheme.ReqOpenStakeSimplified body$9, Box box) {
        return box.proposition().equals(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(body$9.forgerProposition()))) && box.value() >= BoxesRunTime.unboxToLong((Object)body$9.fee().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$buildOpenStakeTransaction$2(SidechainTransactionRestScheme.ReqOpenStake body$10, Box box) {
        return BytesUtils.toHexString(box.id()).equals(body$10.transactionInput().boxId());
    }

    public static final /* synthetic */ boolean $anonfun$getChangeAddress$1(Secret s) {
        return s.publicImage() instanceof PublicKey25519Proposition;
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$18(ArrayList boxIdsToExclude$2, BoxTransaction transaction) {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(transaction.boxIdsToOpen()).asScala()).foreach((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)boxIdsToExclude$2.add(id.data())));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$21(SidechainTransactionApiRoute $this, java.util.List outputs$3, SidechainTransactionRestScheme.TransactionWithdrawalRequestOutput element) {
        if (element.value() < ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)) {
            throw new IllegalArgumentException(new StringBuilder(69).append("Withdrawal transaction amount ").append(element.value()).append(" is below the MC dust threshold value: ").append(ZenCoinsUtils.getMinDustThreshold(ZenCoinsUtils.MC_DEFAULT_FEE_RATE)).toString());
        }
        return outputs$3.add(new WithdrawalRequestBoxData((MCPublicKeyHashProposition)MCPublicKeyHashPropositionSerializer.getSerializer().parseBytes(BytesUtils.fromHorizenPublicKeyAddress(element.mainchainAddress(), $this.params())), element.value()));
    }

    public static final /* synthetic */ boolean $anonfun$createCoreTransaction$22(java.util.List outputs$3, SidechainTransactionRestScheme.TransactionForgerOutput element) {
        ForgerBoxData forgingBoxToAdd = new ForgerBoxData(PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.publicKey())), element.value(), PublicKey25519PropositionSerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString((String)element.blockSignPublicKey().getOrElse((Function0 & Serializable & scala.Serializable)() -> element.publicKey()))), VrfPublicKeySerializer.getSerializer().parseBytesAndCheck(BytesUtils.fromHexString(element.vrfPubKey())));
        return outputs$3.add(forgingBoxToAdd);
    }

    public static final /* synthetic */ void $anonfun$createCoreTransaction$26(ArrayBuffer boxes$1, LongRef inputsTotalAmount$1, long inputsMinimumExpectedAmount$1, Box box) {
        boxes$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZenBox[]{(ZenBox)box}));
        inputsTotalAmount$1.elem += box.value();
        if (inputsTotalAmount$1.elem >= inputsMinimumExpectedAmount$1) {
            throw Breaks$.MODULE$.break();
        }
    }

    public SidechainTransactionApiRoute(RESTApiSettings settings, ActorRef sidechainNodeViewHolderRef, ActorRef sidechainTransactionActorRef, SidechainTransactionsCompanion companion, NetworkParams params, Enumeration.Value circuitType, ActorRefFactory context, ExecutionContext ec) {
        this.settings = settings;
        this.sidechainNodeViewHolderRef = sidechainNodeViewHolderRef;
        this.sidechainTransactionActorRef = sidechainTransactionActorRef;
        this.companion = companion;
        this.params = params;
        this.circuitType = circuitType;
        super(sidechainTransactionActorRef, companion, context, ec);
        SidechainTypes.$init$(this);
        Product.$init$((Product)this);
        this.tag = ClassTag$.MODULE$.apply(SidechainNodeView.class);
        this.route = (Function1)Directive$.MODULE$.addByNameNullaryApply(this.pathPrefix(this._segmentStringToPathMatcher("transaction"))).apply((Function0 & Serializable & scala.Serializable)() -> this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation((Function1<RequestContext, Future<RouteResult>>)this._enhanceRouteWithConcatenation(this.allTransactions()).$tilde(this.findById())).$tilde(this.decodeTransactionBytes())).$tilde(this.createCoreTransaction())).$tilde(this.createCoreTransactionSimplified())).$tilde(this.sendCoinsToAddress())).$tilde(this.sendTransaction())).$tilde(this.withdrawCoins())).$tilde(this.makeForgerStake())).$tilde(this.spendForgingStake())).$tilde(this.createOpenStakeTransaction())).$tilde(this.createOpenStakeTransactionSimplified())).$tilde(this.createKeyRotationTransaction()));
    }
}

