/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.params.NetworkParams;
import io.horizen.transaction.Transaction;
import io.horizen.utils.WithdrawalEpochInfo;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;

public final class WithdrawalEpochUtils$ {
    public static WithdrawalEpochUtils$ MODULE$;
    private final int MaxWithdrawalReqsNumPerEpoch;

    static {
        new WithdrawalEpochUtils$();
    }

    public int MaxWithdrawalReqsNumPerEpoch() {
        return this.MaxWithdrawalReqsNumPerEpoch;
    }

    public WithdrawalEpochInfo getWithdrawalEpochInfo(int mainchainBlockReferenceSize, WithdrawalEpochInfo parentEpochInfo, NetworkParams params) {
        int withdrawalEpoch;
        Predef$.MODULE$.require(mainchainBlockReferenceSize >= 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(32).append("Negative number of MC ref : ").append(mainchainBlockReferenceSize).append(" < 0").toString());
        Predef$.MODULE$.require(mainchainBlockReferenceSize <= params.withdrawalEpochLength(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("Number of MC ref greater than withdrawalEpoch length: ").append(mainchainBlockReferenceSize).append(" > ").append(params.withdrawalEpochLength()).toString());
        int n = parentEpochInfo.lastEpochIndex() == params.withdrawalEpochLength() ? parentEpochInfo.epoch() + 1 : (withdrawalEpoch = parentEpochInfo.lastEpochIndex() + mainchainBlockReferenceSize > params.withdrawalEpochLength() ? parentEpochInfo.epoch() + 1 : parentEpochInfo.epoch());
        int withdrawalEpochIndex = withdrawalEpoch > parentEpochInfo.epoch() ? (mainchainBlockReferenceSize == params.withdrawalEpochLength() && parentEpochInfo.lastEpochIndex() == params.withdrawalEpochLength() ? mainchainBlockReferenceSize : (parentEpochInfo.lastEpochIndex() + mainchainBlockReferenceSize) % params.withdrawalEpochLength()) : parentEpochInfo.lastEpochIndex() + mainchainBlockReferenceSize;
        return new WithdrawalEpochInfo(withdrawalEpoch, withdrawalEpochIndex);
    }

    public WithdrawalEpochInfo getWithdrawalEpochInfo(SidechainBlockBase<? extends Transaction, ? extends SidechainBlockHeaderBase> block, WithdrawalEpochInfo parentEpochInfo, NetworkParams params) {
        return this.getWithdrawalEpochInfo(block.mainchainBlockReferencesData().size(), parentEpochInfo, params);
    }

    public boolean hasReachedCertificateSubmissionWindowEnd(WithdrawalEpochInfo newEpochInfo, WithdrawalEpochInfo parentEpochInfo, NetworkParams params) {
        return newEpochInfo.epoch() > 0 && (parentEpochInfo.lastEpochIndex() < this.certificateSubmissionWindowLength(params) || this.isEpochLastIndex(parentEpochInfo, params)) && newEpochInfo.lastEpochIndex() >= this.certificateSubmissionWindowLength(params);
    }

    public boolean hasReachedCertificateSubmissionWindowEnd(SidechainBlockBase<? extends Transaction, ? extends SidechainBlockHeaderBase> block, WithdrawalEpochInfo parentEpochInfo, NetworkParams params) {
        WithdrawalEpochInfo newEpochInfo = this.getWithdrawalEpochInfo(block, parentEpochInfo, params);
        return this.hasReachedCertificateSubmissionWindowEnd(newEpochInfo, parentEpochInfo, params);
    }

    public boolean isEpochLastIndex(WithdrawalEpochInfo epochInfo, NetworkParams params) {
        return epochInfo.lastEpochIndex() == params.withdrawalEpochLength();
    }

    public boolean inSubmitCertificateWindow(WithdrawalEpochInfo withdrawalEpochInfo, NetworkParams params) {
        return withdrawalEpochInfo.epoch() > 0 && withdrawalEpochInfo.lastEpochIndex() <= this.certificateSubmissionWindowLength(params);
    }

    public int certificateSubmissionWindowLength(NetworkParams params) {
        return this.certificateSubmissionWindowLength(params.withdrawalEpochLength());
    }

    public int certificateSubmissionWindowLength(int withdrawalEpochLength) {
        return Math.max(2, withdrawalEpochLength / 5);
    }

    public int ceasedAtMcBlockHeight(int withdrawalEpochNumber, NetworkParams params) {
        return params.mainchainCreationBlockHeight() + withdrawalEpochNumber * params.withdrawalEpochLength() + this.certificateSubmissionWindowLength(params) - 1;
    }

    private WithdrawalEpochUtils$() {
        MODULE$ = this;
        this.MaxWithdrawalReqsNumPerEpoch = 3999;
    }
}

