/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.utils;

import io.horizen.utils.ChaChaPrngSecureRandomProvider;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import sparkz.crypto.hash.Blake2b256;

public class ChaChaPrngSecureRandom
extends SecureRandomSpi
implements SecureRandomParameters {
    private int[] mState = new int[16];
    private final int[] mWorkingState = new int[16];
    private static final int ROUNDS = 20;
    private int mWordIndex;
    private long mStream = 0L;
    private static final int DEFAULT_WORD_INDEX = 16;
    protected static final String ALGO = "ChaCha20PRNG";

    @NotNull
    public static SecureRandom getInstance(byte[] seed) throws SecurityException {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance(ALGO, "HorizenCrypto");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new SecurityException("ChaCha20PRNG/HorizenCrypto not available", e);
        }
        if (!ChaChaPrngSecureRandomProvider.class.equals(rng.getProvider().getClass())) {
            throw new SecurityException("SecureRandom.getInstance(\"ChaCha20PRNG\", \"HorizenCrypto\") backed by wrong provider: " + rng.getProvider().getClass());
        }
        rng.setSeed(seed);
        return rng;
    }

    private void block() {
        int i;
        int[] x = new int[16];
        System.arraycopy(this.mState, 0, x, 0, 16);
        for (i = 0; i < 20; i += 2) {
            ChaChaPrngSecureRandom.quarterRound(x, 0, 4, 8, 12);
            ChaChaPrngSecureRandom.quarterRound(x, 1, 5, 9, 13);
            ChaChaPrngSecureRandom.quarterRound(x, 2, 6, 10, 14);
            ChaChaPrngSecureRandom.quarterRound(x, 3, 7, 11, 15);
            ChaChaPrngSecureRandom.quarterRound(x, 0, 5, 10, 15);
            ChaChaPrngSecureRandom.quarterRound(x, 1, 6, 11, 12);
            ChaChaPrngSecureRandom.quarterRound(x, 2, 7, 8, 13);
            ChaChaPrngSecureRandom.quarterRound(x, 3, 4, 9, 14);
        }
        for (i = 0; i < 16; ++i) {
            this.mWorkingState[i] = x[i] + this.mState[i];
        }
    }

    private void incrementCounter() {
        this.mState[12] = this.mState[12] + 1;
        if (this.mState[12] == 0) {
            this.mState[13] = this.mState[13] + 1;
            if (this.mState[13] == 0) {
                ++this.mStream;
                if (this.mStream == 0L) {
                    this.repackState();
                } else {
                    this.mState[14] = (int)this.mStream;
                    this.mState[15] = (int)(this.mStream >>> 32);
                }
            }
        }
    }

    private static void quarterRound(@NotNull int[] x, int a, int b, int c, int d) {
        int n = a;
        x[n] = x[n] + x[b];
        x[d] = ChaChaPrngSecureRandom.rotateLeft32(x[d] ^ x[a], 16);
        int n2 = c;
        x[n2] = x[n2] + x[d];
        x[b] = ChaChaPrngSecureRandom.rotateLeft32(x[b] ^ x[c], 12);
        int n3 = a;
        x[n3] = x[n3] + x[b];
        x[d] = ChaChaPrngSecureRandom.rotateLeft32(x[d] ^ x[a], 8);
        int n4 = c;
        x[n4] = x[n4] + x[d];
        x[b] = ChaChaPrngSecureRandom.rotateLeft32(x[b] ^ x[c], 7);
    }

    private static int rotateLeft32(int x, int k) {
        return x << k | x >>> 32 - k;
    }

    private static int[] defaultState(int[] seed, long stream) {
        return new int[]{1634760805, 857760878, 2036477234, 1797285236, seed[0], seed[1], seed[2], seed[3], seed[4], seed[5], seed[6], seed[7], 0, 0, (int)stream, (int)(stream >>> 32)};
    }

    private void repackState() {
        byte[] seed = new byte[32];
        int i = 0;
        int j = 0;
        while (i < 32) {
            seed[i] = (byte)this.mState[j + 4];
            seed[i + 1] = (byte)(this.mState[j + 4] >> 8);
            seed[i + 2] = (byte)(this.mState[j + 4] >> 16);
            seed[i + 3] = (byte)(this.mState[j + 4] >>> 24);
            i += 4;
            ++j;
        }
        seed = Blake2b256.hash((byte[])seed);
        this.engineSetSeed(seed);
    }

    private int getInt() {
        if (this.mWordIndex == 16) {
            this.block();
            this.incrementCounter();
            this.mWordIndex = 0;
        }
        int result = this.mWorkingState[this.mWordIndex];
        ++this.mWordIndex;
        return result;
    }

    @Override
    protected void engineSetSeed(byte[] seed) {
        int[] intSeed = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (seed.length != 32) {
            byte[] toHash = new byte[32 + seed.length];
            Arrays.fill(toHash, 0, 32, (byte)-1);
            System.arraycopy(seed, 0, toHash, 32, seed.length);
            seed = Blake2b256.hash((byte[])toHash);
        }
        int j = 0;
        for (int i = 0; i < 32; i += 4) {
            intSeed[j] = seed[i] & 0xFF;
            int n = j;
            intSeed[n] = intSeed[n] | (seed[i + 1] & 0xFF) << 8;
            int n2 = j;
            intSeed[n2] = intSeed[n2] | (seed[i + 2] & 0xFF) << 16;
            int n3 = j++;
            intSeed[n3] = intSeed[n3] | (seed[i + 3] & 0xFF) << 24;
        }
        this.mStream = 0L;
        this.mState = ChaChaPrngSecureRandom.defaultState(intSeed, this.mStream);
        this.mWordIndex = 16;
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        int count = bytes.length;
        int tail = count % 4;
        for (int i = 0; i < count - tail; i += 4) {
            int word = this.getInt();
            bytes[i] = (byte)word;
            bytes[i + 1] = (byte)(word >>> 8);
            bytes[i + 2] = (byte)(word >>> 16);
            bytes[i + 3] = (byte)(word >>> 24);
        }
        if (tail > 0) {
            int word = this.getInt();
            for (int i = tail; i > 0; --i) {
                bytes[count - i] = (byte)word;
                word >>>= 8;
            }
        }
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] seed = new byte[numBytes];
        this.engineNextBytes(seed);
        return seed;
    }

    static {
        ChaChaPrngSecureRandomProvider.init();
    }
}

