/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.transaction.mainchain;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import io.horizen.block.MainchainTxBwtRequestCrosschainOutput;
import io.horizen.transaction.mainchain.BwtRequestSerializer;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutput;
import io.horizen.transaction.mainchain.SidechainRelatedMainchainOutputSerializer;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.Utils;
import io.horizen.utxo.box.WithdrawalRequestBox;

public final class BwtRequest
implements SidechainRelatedMainchainOutput<WithdrawalRequestBox> {
    private final MainchainTxBwtRequestCrosschainOutput output;
    private final byte[] containingTxHash;
    private final int index;

    public BwtRequest(MainchainTxBwtRequestCrosschainOutput output, byte[] containingTxHash, int index) {
        this.output = output;
        this.containingTxHash = containingTxHash;
        this.index = index;
    }

    @Override
    public byte[] hash() {
        return BytesUtils.reverseBytes(Utils.doubleSHA256Hash(Bytes.concat((byte[][])new byte[][]{this.output.hash(), this.containingTxHash, BytesUtils.reverseBytes(Ints.toByteArray((int)this.index))})));
    }

    @Override
    public byte[] transactionHash() {
        return this.containingTxHash;
    }

    @Override
    public byte[] sidechainId() {
        return this.output.sidechainId();
    }

    @Override
    public WithdrawalRequestBox getBox() {
        throw new UnsupportedOperationException("There is no support of BwtRequest processing at the moment.");
    }

    @Override
    public int transactionIndex() {
        return this.index;
    }

    public MainchainTxBwtRequestCrosschainOutput getBwtOutput() {
        return this.output;
    }

    @Override
    public SidechainRelatedMainchainOutputSerializer serializer() {
        return BwtRequestSerializer.getSerializer();
    }
}

