/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.storage;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.block.MainchainBlockReference;
import io.horizen.block.MainchainBlockReferenceData;
import io.horizen.block.MainchainHeader;
import io.horizen.block.SidechainBlockBase;
import io.horizen.block.SidechainBlockHeaderBase;
import io.horizen.chain.AbstractFeePaymentsInfo;
import io.horizen.chain.ActiveChain;
import io.horizen.chain.ActiveChain$;
import io.horizen.chain.MainchainBlockReferenceDataInfo;
import io.horizen.chain.MainchainBlockReferenceInfo;
import io.horizen.chain.MainchainHeaderBaseInfo;
import io.horizen.chain.MainchainHeaderInfo;
import io.horizen.chain.MainchainHeaderMetadata;
import io.horizen.chain.SidechainBlockInfo;
import io.horizen.chain.SidechainBlockInfoSerializer$;
import io.horizen.params.NetworkParams;
import io.horizen.storage.SidechainBlockInfoProvider;
import io.horizen.storage.SidechainStorageInfo;
import io.horizen.storage.Storage;
import io.horizen.transaction.Transaction;
import io.horizen.utils.ByteArrayWrapper;
import io.horizen.utils.Pair;
import io.horizen.utils.Utils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.package$;
import io.horizen.vrf.VrfOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sparkz.core.consensus.ModifierSemanticValidity;
import sparkz.core.serialization.SparkzSerializer;
import sparkz.crypto.hash.Blake2b256$;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\r5ca\u0002\u001c8\u0003\u0003q\u0014Q\u0006\u0005\tq\u0001\u0011\t\u0011)A\u0005+\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0006\u0002\u0004\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011\u001d\t9\u0003\u0001C\u0001\u0003SA\u0011\"!\u0010\u0001\u0005\u0004%I!a\u0010\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u0003B\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005e\u0003\u0001)A\u0005\u0003'Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\r\u0005\u0001\"\u0005\u0002\u0006\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0005bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003?\u0003A\u0011AAQ\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003KCq!a*\u0001\t\u0003\tI\u000bC\u0004\u00022\u0002!\t!a-\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002h\u0002!\t!!;\t\u000f\u0005U\b\u0001\"\u0001\u0002x\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005!\u0011\u0002\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WAqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003D\u0001!\tA!\u0012\t\u000f\tE\u0003\u0001\"\u0001\u0003T!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B7\u0001\u0011\u0005!q\u000e\u0005\b\u0005{\u0002A\u0011\u0001B@\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqAa\"\u0001\t\u0013\u0011I\tC\u0004\u0003>\u0002!\tAa0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Bn\u0001\u0011\u0005!Q\u001c\u0005\b\u0005C\u0004A\u0011\u0001Br\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_DqAa=\u0001\t\u0003\u0011)\u0010C\u0004\u0003z\u0002!\tAa?\t\u000f\r5\u0001\u0001\"\u0001\u0004\u0010!91q\u0003\u0001\u0005\u0002\re\u0001bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\b\u0007c\u0001A\u0011AB\u001a\u0011\u001d\u0019Y\u0004\u0001C\u0001\u0007{Aqaa\u0011\u0001\t\u0003\u0019)\u0005C\u0004\u0004H\u0001!\te!\u0013\u0003-\u0005\u00137\u000f\u001e:bGRD\u0015n\u001d;pef\u001cFo\u001c:bO\u0016T!\u0001O\u001d\u0002\u000fM$xN]1hK*\u0011!hO\u0001\bQ>\u0014\u0018N_3o\u0015\u0005a\u0014AA5p\u0007\u0001)baP2\u0002\n\u0005=2#\u0002\u0001A\r*k\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\r\u0005\u0002H\u00116\tq'\u0003\u0002Jo\tQ2+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\\u0017J\u001c4p!J|g/\u001b3feB\u0011qiS\u0005\u0003\u0019^\u0012AcU5eK\u000eD\u0017-\u001b8Ti>\u0014\u0018mZ3J]\u001a|\u0007C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000baa\u001d9be.T\u0018B\u0001+P\u00055\u0019\u0006/\u0019:lu2{wmZ5oOB\u0011qIV\u0005\u0003/^\u0012qa\u0015;pe\u0006<W-A\bcY>\u001c7nU3sS\u0006d\u0017N_3s!\rQv,Y\u0007\u00027*\u0011A,X\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005y\u000b\u0016\u0001B2pe\u0016L!\u0001Y.\u0003!M\u0003\u0018M]6{'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u00012d\u0019\u0001!Q\u0001\u001a\u0001C\u0002\u0015\u0014!\u0001U'\u0012\u0005\u0019L\u0007CA!h\u0013\tA'IA\u0004O_RD\u0017N\\41\u0007)\f8\u0010\u0005\u0003l]BTX\"\u00017\u000b\u00055L\u0014!\u00022m_\u000e\\\u0017BA8m\u0005I\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.\u0014\u0015m]3\u0011\u0005\t\fH!\u0003:d\u0003\u0003\u0005\tQ!\u0001t\u0005\ryF%M\t\u0003MR\u0004\"!\u001e=\u000e\u0003YT!a^\u001d\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0003sZ\u00141\u0002\u0016:b]N\f7\r^5p]B\u0011!m\u001f\u0003\ny\u000e\f\t\u0011!A\u0003\u0002u\u00141a\u0018\u00133#\t1g\u0010\u0005\u0002l\u007f&\u0019\u0011\u0011\u00017\u00031MKG-Z2iC&t'\t\\8dW\"+\u0017\rZ3s\u0005\u0006\u001cX-A\rgK\u0016\u0004\u0016-_7f]R\u001c\u0018J\u001c4p'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0003\u0002.`\u0003\u000f\u00012AYA\u0005\t\u001d\tY\u0001\u0001b\u0001\u0003\u001b\u00111A\u0012)J#\r1\u0017q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC\u001d\u0002\u000b\rD\u0017-\u001b8\n\t\u0005e\u00111\u0003\u0002\u0018\u0003\n\u001cHO]1di\u001a+W\rU1z[\u0016tGo]%oM>\fa\u0001]1sC6\u001c\b\u0003BA\u0010\u0003Gi!!!\t\u000b\u0007\u0005m\u0011(\u0003\u0003\u0002&\u0005\u0005\"!\u0004(fi^|'o\u001b)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003W\t)$a\u000e\u0002:\u0005m\u0002cB$\u0001C\u0006\u001d\u0011Q\u0006\t\u0004E\u0006=BaBA\u0019\u0001\t\u0007\u00111\u0007\u0002\u0002'F\u0019a-a\u000b\t\u000ba*\u0001\u0019A+\t\u000ba+\u0001\u0019A-\t\u000f\u0005\rQ\u00011\u0001\u0002\u0006!9\u00111D\u0003A\u0002\u0005u\u0011A\u00042fgR\u0014En\\2l\u0013\u0012\\U-_\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fJ\u0014!B;uS2\u001c\u0018\u0002BA&\u0003\u000b\u0012\u0001CQ=uK\u0006\u0013(/Y=Xe\u0006\u0004\b/\u001a:\u0002\u001f\t,7\u000f\u001e\"m_\u000e\\\u0017\nZ&fs\u0002\n1\"Y2uSZ,7\t[1j]V\u0011\u00111\u000b\t\u0005\u0003#\t)&\u0003\u0003\u0002X\u0005M!aC!di&4Xm\u00115bS:\fA\"Y2uSZ,7\t[1j]\u0002\nq\u0002\\8bI\u0006\u001bG/\u001b<f\u0007\"\f\u0017N\u001c\u000b\u0003\u0003'\nAB\u00197pG.LeNZ8LKf$B!!\u0011\u0002d!9\u0011QM\u0006A\u0002\u0005\u001d\u0014a\u00022m_\u000e\\\u0017\n\u001a\t\u0005\u0003S\niH\u0004\u0003\u0002l\u0005ed\u0002BA7\u0003orA!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003gj\u0014A\u0002\u001fs_>$h(C\u0001S\u0013\t\u0001\u0016+C\u0002\u0002|=\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0000\u0005\u0005%AC'pI&4\u0017.\u001a:JI*\u0019\u00111P(\u0002%\u0019,W\rU1z[\u0016tGo]%oM>\\U-\u001f\u000b\u0005\u0003\u0003\n9\tC\u0004\u0002f1\u0001\r!a\u001a\u0002\r!,\u0017n\u001a5u+\t\ti\tE\u0002B\u0003\u001fK1!!%C\u0005\rIe\u000e^\u0001\tQ\u0016Lw\r\u001b;PMR!\u0011qSAO!\u0015\t\u0015\u0011TAG\u0013\r\tYJ\u0011\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015d\u00021\u0001\u0002h\u0005Y!-Z:u\u00052|7m[%e+\t\t9'A\u0005cKN$(\t\\8dWV\t\u0011-A\u0007cKN$(\t\\8dW&sgm\\\u000b\u0003\u0003W\u0003B!!\u0005\u0002.&!\u0011qVA\n\u0005I\u0019\u0016\u000eZ3dQ\u0006LgN\u00117pG.LeNZ8\u0002\u0013\tdwnY6Cs&#G\u0003BA[\u0003o\u0003B!QAMC\"9\u0011Q\r\nA\u0002\u0005\u001d\u0014!\u00042m_\u000e\\\u0017J\u001c4p\u0005fLE\r\u0006\u0003\u0002,\u0006u\u0006bBA3'\u0001\u0007\u0011qM\u0001\u0014E2|7m[%oM>|\u0005\u000f^5p]\nK\u0018\n\u001a\u000b\u0005\u0003\u0007\f)\rE\u0003B\u00033\u000bY\u000bC\u0004\u0002fQ\u0001\r!a\u001a\u0002=\tdwnY6J]\u001a|w\n\u001d;j_:\u0014\u00150\u00133Ge>l7\u000b^8sC\u001e,G\u0003BAb\u0003\u0017Dq!!\u001a\u0016\u0001\u0004\t9'\u0001\rcY>\u001c7.\u00138g_\nK\u0018\n\u001a$s_6\u001cFo\u001c:bO\u0016$B!a+\u0002R\"9\u0011Q\r\fA\u0002\u0005\u001d\u0014aJ4fi2\u000b7\u000f^'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:CCN,\u0017J\u001c4p\u0013:\u001cG.^:j_:$B!a6\u0002^B!\u0011\u0011CAm\u0013\u0011\tY.a\u0005\u0003/5\u000b\u0017N\\2iC&t\u0007*Z1eKJ\u0014\u0015m]3J]\u001a|\u0007bBA3/\u0001\u0007\u0011qM\u0001\u000ea\u0006\u0014XM\u001c;CY>\u001c7.\u00133\u0015\t\u0005\r\u0018Q\u001d\t\u0006\u0003\u0006e\u0015q\r\u0005\b\u0003KB\u0002\u0019AA4\u00035\u0019\u0007.Y5o'\u000e|'/\u001a$peR!\u00111^Az!\u0015\t\u0015\u0011TAw!\r\t\u0015q^\u0005\u0004\u0003c\u0014%\u0001\u0002'p]\u001eDq!!\u001a\u001a\u0001\u0004\t9'A\bjg&s\u0017i\u0019;jm\u0016\u001c\u0005.Y5o)\u0011\tI0a@\u0011\u0007\u0005\u000bY0C\u0002\u0002~\n\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002fi\u0001\r!a\u001a\u0002%\u0005\u001cG/\u001b<f\u0007\"\f\u0017N\u001c\"m_\u000e\\\u0017\n\u001a\u000b\u0005\u0003G\u0014)\u0001C\u0004\u0002\nn\u0001\r!!$\u0002!\u0005\u001cG/\u001b<f\u0007\"\f\u0017N\\*j]\u000e,GC\u0002B\u0006\u00057\u0011i\u0002\u0005\u0004\u0003\u000e\tU\u0011q\r\b\u0005\u0005\u001f\u0011\u0019B\u0004\u0003\u0002p\tE\u0011\"A\"\n\u0007\u0005m$)\u0003\u0003\u0003\u0018\te!aA*fc*\u0019\u00111\u0010\"\t\u000f\u0005\u0015D\u00041\u0001\u0002h!9!q\u0004\u000fA\u0002\u0005]\u0015!\u00027j[&$\u0018\u0001E1di&4Xm\u00115bS:\fe\r^3s)\u0019\u0011YA!\n\u0003(!9\u0011QM\u000fA\u0002\u0005\u001d\u0004b\u0002B\u0010;\u0001\u0007\u0011qS\u0001+O\u0016$8+\u001b3fG\"\f\u0017N\u001c\"m_\u000e\\7i\u001c8uC&t\u0017N\\4NC&t7\r[1j]\"+\u0017\rZ3s)\u0011\t)L!\f\t\u000f\t=b\u00041\u0001\u00032\u0005\u0019R.Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000fS1tQB)\u0011Ia\r\u00038%\u0019!Q\u0007\"\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0005\u0013I$C\u0002\u0003<\t\u0013AAQ=uK\u0006\tt-\u001a;TS\u0012,7\r[1j]\ncwnY6D_:$\u0018-\u001b8j]\u001el\u0015-\u001b8dQ\u0006LgNU3gKJ,gnY3ECR\fG\u0003BA[\u0005\u0003BqAa\f \u0001\u0004\u0011\t$\u0001\u0011hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cWMQ=ICNDG\u0003\u0002B$\u0005\u001f\u0002R!QAM\u0005\u0013\u00022a\u001bB&\u0013\r\u0011i\u0005\u001c\u0002\u0018\u001b\u0006Lgn\u00195bS:\u0014En\\2l%\u00164WM]3oG\u0016DqAa\f!\u0001\u0004\u0011\t$\u0001\rhKRl\u0015-\u001b8dQ\u0006Lg\u000eS3bI\u0016\u0014()\u001f%bg\"$BA!\u0016\u0003^A)\u0011)!'\u0003XA\u00191N!\u0017\n\u0007\tmCNA\bNC&t7\r[1j]\"+\u0017\rZ3s\u0011\u001d\u0011y#\ta\u0001\u0005c\tqdZ3u\u001b\u0006Lgn\u00195bS:\u0014VMZ3sK:\u001cW\rR1uC\nK\b*Y:i)\u0011\u0011\u0019Ga\u001b\u0011\u000b\u0005\u000bIJ!\u001a\u0011\u0007-\u00149'C\u0002\u0003j1\u00141$T1j]\u000eD\u0017-\u001b8CY>\u001c7NU3gKJ,gnY3ECR\f\u0007b\u0002B\u0018E\u0001\u0007!\u0011G\u00015O\u0016$X*Y5oG\"\f\u0017N\u001c\"m_\u000e\\'+\u001a4fe\u0016t7-Z%oM>\u0014\u00150T1j]\u000eD\u0017-\u001b8CY>\u001c7\u000eS3jO\"$H\u0003\u0002B9\u0005s\u0002R!QAM\u0005g\u0002B!!\u0005\u0003v%!!qOA\n\u0005mi\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW-\u00138g_\"9!1P\u0012A\u0002\u00055\u0015aD7bS:\u001c\u0007.Y5o\u0011\u0016Lw\r\u001b;\u0002E\u001d,GOQ3ti6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0017J\u001c4p+\t\u0011\t(\u0001\u0013hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW-\u00138g_\nK\b*Y:i)\u0011\u0011\tH!\"\t\u000f\t=R\u00051\u0001\u00032\u0005\u0001#-^5mI6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,\u0017J\u001c4p)1\u0011\u0019Ha#\u0003(\nE&Q\u0017B]\u0011\u001d\u0011iI\na\u0001\u0005\u001f\u000ba!\\2ICND\u0007\u0003\u0002BI\u0005CsAAa%\u0003 :!!Q\u0013BO\u001d\u0011\u00119Ja'\u000f\t\u0005=$\u0011T\u0005\u0002y%\u0011!hO\u0005\u0004\u0003+I\u0014\u0002BA>\u0003'IAAa)\u0003&\n\u0019R*Y5oG\"\f\u0017N\u001c%fC\u0012,'\u000fS1tQ*!\u00111PA\n\u0011\u001d\u0011IK\na\u0001\u0005W\u000bQB]3gKJ,gnY3J]\u001a|\u0007\u0003BA\t\u0005[KAAa,\u0002\u0014\t9R*Y5oG\"\f\u0017N\u001c%fC\u0012,'/T3uC\u0012\fG/\u0019\u0005\b\u0005g3\u0003\u0019AAG\u00035i7M\u00117pG.DU-[4ii\"9!q\u0017\u0014A\u0002\u0005\u001d\u0014aH7bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:TS\u0012,7\r[1j]\ncwnY6JI\"9!1\u0018\u0014A\u0002\u0005\u001d\u0014AJ7bS:\u001c\u0007.Y5o%\u00164WM]3oG\u0016$\u0015\r^1TS\u0012,7\r[1j]\ncwnY6JI\u0006ar-\u001a;NC&t7\r[1j]\"\u000b7\u000f[3t\r>\u0014\u0018J\u001c3fq\u0016\u001cH\u0003\u0002Ba\u0005\u0007\u0004bA!\u0004\u0003\u0016\t=\u0005b\u0002BcO\u0001\u0007!qY\u0001\u0011[\u0006Lgn\u00195bS:DU-[4iiN\u0004bA!\u0004\u0003\u0016\u00055\u0015AG4fi\n+7\u000f^'bS:\u001c\u0007.Y5o\u0011\u0016\fG-\u001a:J]\u001a|WC\u0001Bg!\u0015\t\u0015\u0011\u0014Bh!\u0011\t\tB!5\n\t\tM\u00171\u0003\u0002\u0014\u001b\u0006Lgn\u00195bS:DU-\u00193fe&sgm\\\u0001\u001fO\u0016$X*Y5oG\"\f\u0017N\u001c%fC\u0012,'/\u00138g_\nK\b*Z5hQR$BA!4\u0003Z\"9!1P\u0015A\u0002\u00055\u0015\u0001H4fi6\u000b\u0017N\\2iC&t\u0007*Z1eKJLeNZ8Cs\"\u000b7\u000f\u001b\u000b\u0005\u0005\u001b\u0014y\u000eC\u0004\u00030)\u0002\rA!\r\u0002M\u001d,GOQ3ti6\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4w.\u0006\u0002\u0003fB)\u0011)!'\u0003hB!\u0011\u0011\u0003Bu\u0013\u0011\u0011Y/a\u0005\u0003?5\u000b\u0017N\\2iC&t'\t\\8dWJ+g-\u001a:f]\u000e,G)\u0019;b\u0013:4w.\u0001\u0016hKRl\u0015-\u001b8dQ\u0006LgN\u00117pG.\u0014VMZ3sK:\u001cW\rR1uC&sgm\u001c\"z\u0011\u0016Lw\r\u001b;\u0015\t\t\u0015(\u0011\u001f\u0005\b\u0005wb\u0003\u0019AAG\u0003!:W\r^'bS:\u001c\u0007.Y5o\u00052|7m\u001b*fM\u0016\u0014XM\\2f\t\u0006$\u0018-\u00138g_\nK\b*Y:i)\u0011\u0011)Oa>\t\u000f\t=R\u00061\u0001\u00032\u00051Q\u000f\u001d3bi\u0016$bA!@\u0004\b\r%\u0001C\u0002B\u0000\u0007\u0007\ti#\u0004\u0002\u0004\u0002)\u0011\u0001KQ\u0005\u0005\u0007\u000b\u0019\tAA\u0002UefDQ!\u001c\u0018A\u0002\u0005Dqaa\u0003/\u0001\u0004\tY+A\u0005cY>\u001c7.\u00138g_\u0006)R\u000f\u001d3bi\u00164U-\u001a)bs6,g\u000e^:J]\u001a|GC\u0002B\u007f\u0007#\u0019\u0019\u0002C\u0004\u0002f=\u0002\r!a\u001a\t\u000f\rUq\u00061\u0001\u0002\b\u0005ya-Z3QCflWM\u001c;t\u0013:4w.\u0001\nhKR4U-\u001a)bs6,g\u000e^:J]\u001a|G\u0003BB\u000e\u0007;\u0001R!QAM\u0003\u000fAq!!\u001a1\u0001\u0004\t9'\u0001\ttK6\fg\u000e^5d-\u0006d\u0017\u000eZ5usR!11EB\u0018!\u0011\u0019)ca\u000b\u000e\u0005\r\u001d\"bAB\u0015;\u0006I1m\u001c8tK:\u001cXo]\u0005\u0005\u0007[\u00199C\u0001\rN_\u0012Lg-[3s'\u0016l\u0017M\u001c;jGZ\u000bG.\u001b3jifDq!!\u001a2\u0001\u0004\t9'\u0001\fva\u0012\fG/Z*f[\u0006tG/[2WC2LG-\u001b;z)\u0019\u0011ip!\u000e\u00048!)QN\ra\u0001C\"91\u0011\b\u001aA\u0002\r\r\u0012AB:uCR,8/\u0001\btKR\f5OQ3ti\ncwnY6\u0015\r\tu8qHB!\u0011\u0015i7\u00071\u0001b\u0011\u001d\u0019Ya\ra\u0001\u0003W\u000bq![:F[B$\u00180\u0006\u0002\u0002z\u0006iA.Y:u-\u0016\u00148/[8o\u0013\u0012,\"aa\u0013\u0011\u000b\u0005\u000bI*!\u0011")
public abstract class AbstractHistoryStorage<PM extends SidechainBlockBase<? extends Transaction, ? extends SidechainBlockHeaderBase>, FPI extends AbstractFeePaymentsInfo, S extends AbstractHistoryStorage<PM, FPI, S>>
implements SidechainBlockInfoProvider,
SidechainStorageInfo,
SparkzLogging {
    private final Storage storage;
    private final SparkzSerializer<PM> blockSerializer;
    private final SparkzSerializer<FPI> feePaymentsInfoSerializer;
    private final NetworkParams params;
    private final ByteArrayWrapper bestBlockIdKey;
    private final ActiveChain activeChain;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    @Override
    public String getStorageName() {
        return SidechainStorageInfo.getStorageName$(this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ByteArrayWrapper bestBlockIdKey() {
        return this.bestBlockIdKey;
    }

    private ActiveChain activeChain() {
        return this.activeChain;
    }

    private ActiveChain loadActiveChain() {
        if (this.storage.isEmpty()) {
            return ActiveChain$.MODULE$.apply(this.params.mainchainCreationBlockHeight());
        }
        ArrayBuffer activeChainBlocksInfo = new ArrayBuffer();
        activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)this.bestBlockId(), (Object)this.blockInfoByIdFromStorage(this.bestBlockId()))}));
        while (((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).height() > 1) {
            String id = ((SidechainBlockInfo)((Tuple2)activeChainBlocksInfo.last())._2()).parentId();
            activeChainBlocksInfo.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)id, (Object)this.blockInfoByIdFromStorage(id))}));
        }
        ArrayBuffer orderedChainBlocks = (ArrayBuffer)activeChainBlocksInfo.reverse();
        Option mainchainBlockParent = orderedChainBlocks.headOption().flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlockInfo -> this.blockById((String)firstSidechainBlockInfo._1()).flatMap((Function1 & Serializable & scala.Serializable)firstSidechainBlock -> firstSidechainBlock.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)firstMainchainHeader -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(firstMainchainHeader.hashPrevBlock()))));
        return ActiveChain$.MODULE$.apply((ArrayBuffer<Tuple2<String, SidechainBlockInfo>>)orderedChainBlocks, (ByteArrayWrapper)mainchainBlockParent.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Loaded active chain miss mainchain parent");
        }), this.params.mainchainCreationBlockHeight());
    }

    private ByteArrayWrapper blockInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(9).append("blockInfo").append(blockId).toString()));
    }

    public ByteArrayWrapper feePaymentsInfoKey(String blockId) {
        return new ByteArrayWrapper(Blake2b256$.MODULE$.apply(new StringBuilder(15).append("feePaymentsInfo").append(blockId).toString()));
    }

    public int height() {
        return this.activeChain().height();
    }

    public Option<Object> heightOf(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.height()));
    }

    public String bestBlockId() {
        return (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.bestBlockIdKey()))).map((Function1 & Serializable & scala.Serializable)d -> sparkz.util.package$.MODULE$.bytesToId(d.data())).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.params.sidechainGenesisBlockId());
    }

    public PM bestBlock() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return (PM)((SidechainBlockBase)this.blockById(this.bestBlockId()).get());
    }

    public SidechainBlockInfo bestBlockInfo() {
        Predef$.MODULE$.require(this.height() > 0, (Function0 & Serializable & scala.Serializable)() -> "SidechainHistoryStorage is empty. Cannot retrieve best block.");
        return this.blockInfoById(this.bestBlockId());
    }

    public Option<PM> blockById(String blockId) {
        None$ none$;
        ByteArrayWrapper blockIdBytes = new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(blockId));
        Option baw = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(blockIdBytes)));
        Option option = baw;
        if (option instanceof Some) {
            Option option2;
            Some some = (Some)option;
            ByteArrayWrapper value = (ByteArrayWrapper)some.value();
            Try try_ = this.blockSerializer.parseBytesTry(value.data());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SidechainBlockBase block = (SidechainBlockBase)success.value();
                option2 = Option$.MODULE$.apply((Object)block);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.log().underlying().isErrorEnabled()) {
                    this.log().underlying().error("Error while sidechain block parsing.", exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option2 = Option$.MODULE$.empty();
            } else {
                throw new MatchError((Object)try_);
            }
            none$ = option2;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.log().underlying().isInfoEnabled()) {
                this.log().underlying().info("SidechainHistoryStorage:blockById: byte array is empty");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    @Override
    public SidechainBlockInfo blockInfoById(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionById(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(24).append("No block info for block ").append(blockId).toString());
        });
    }

    public Option<SidechainBlockInfo> blockInfoOptionById(String blockId) {
        return this.activeChain().blockInfoById(blockId).orElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoOptionByIdFromStorage(blockId));
    }

    private Option<SidechainBlockInfo> blockInfoOptionByIdFromStorage(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.blockInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> SidechainBlockInfoSerializer$.MODULE$.parseBytesTry(baw.data()).toOption());
    }

    private SidechainBlockInfo blockInfoByIdFromStorage(String blockId) {
        return (SidechainBlockInfo)this.blockInfoOptionByIdFromStorage(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(36).append("No blockInfo in storage for blockId ").append(blockId).toString());
        });
    }

    public MainchainHeaderBaseInfo getLastMainchainHeaderBaseInfoInclusion(String blockId) {
        SidechainBlockInfo sidechainBlockInfo = this.blockInfoById(blockId);
        while (sidechainBlockInfo.mainchainHeaderBaseInfo().isEmpty()) {
            sidechainBlockInfo = this.blockInfoById(sidechainBlockInfo.parentId());
        }
        return (MainchainHeaderBaseInfo)sidechainBlockInfo.mainchainHeaderBaseInfo().last();
    }

    public Option<String> parentBlockId(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parentId());
    }

    public Option<Object> chainScoreFor(String blockId) {
        return this.blockInfoOptionById(blockId).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.score()));
    }

    public boolean isInActiveChain(String blockId) {
        return this.activeChain().contains(blockId);
    }

    public Option<String> activeChainBlockId(int height) {
        return this.activeChain().idByHeight(height);
    }

    public Seq<String> activeChainSince(String blockId, Option<Object> limit) {
        return this.activeChain().chainSince(blockId, limit);
    }

    public Seq<String> activeChainAfter(String blockId, Option<Object> limit) {
        return this.activeChain().chainAfter(blockId, limit);
    }

    public Option<PM> getSidechainBlockContainingMainchainHeader(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcHeader(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<PM> getSidechainBlockContainingMainchainReferenceData(byte[] mainchainHeaderHash) {
        return this.activeChain().idByMcReferenceData(io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash)).flatMap((Function1 & Serializable & scala.Serializable)blockId -> this.blockById((String)blockId));
    }

    public Option<MainchainBlockReference> getMainchainBlockReferenceByHash(byte[] mainchainHeaderHash) {
        return this.getMainchainHeaderByHash(mainchainHeaderHash).flatMap((Function1 & Serializable & scala.Serializable)header -> this.getMainchainReferenceDataByHash(mainchainHeaderHash).map((Function1 & Serializable & scala.Serializable)data -> new MainchainBlockReference((MainchainHeader)header, (MainchainBlockReferenceData)data)));
    }

    public Option<MainchainHeader> getMainchainHeaderByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainHeader(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.mainchainHeaders().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderByHash$2(mainchainHeaderHash, header))));
    }

    public Option<MainchainBlockReferenceData> getMainchainReferenceDataByHash(byte[] mainchainHeaderHash) {
        Option<PM> block = this.getSidechainBlockContainingMainchainReferenceData(mainchainHeaderHash);
        return block.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mainchainBlockReferencesData().find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainReferenceDataByHash$2(mainchainHeaderHash, data))));
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByMainchainBlockHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).flatMap((Function1 & Serializable & scala.Serializable)hash -> this.getMainchainBlockReferenceInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)hash)));
    }

    public Option<MainchainBlockReferenceInfo> getBestMainchainBlockReferenceInfo() {
        return this.getMainchainBlockReferenceInfoByMainchainBlockHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceInfo> getMainchainBlockReferenceInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    private MainchainBlockReferenceInfo buildMainchainBlockReferenceInfo(ByteArrayWrapper mcHash, MainchainHeaderMetadata referenceInfo, int mcBlockHeight, String mainchainHeaderSidechainBlockId, String mainchainReferenceDataSidechainBlockId) {
        return new MainchainBlockReferenceInfo(package$.MODULE$.wrapperToByteArray(mcHash), package$.MODULE$.wrapperToByteArray(referenceInfo.getParentId()), mcBlockHeight, sparkz.util.package$.MODULE$.idToBytes(mainchainHeaderSidechainBlockId), sparkz.util.package$.MODULE$.idToBytes(mainchainReferenceDataSidechainBlockId));
    }

    public Seq<ByteArrayWrapper> getMainchainHashesForIndexes(Seq<Object> mainchainHeights) {
        return (Seq)mainchainHeights.flatMap((Function1 & Serializable & scala.Serializable)mainchainHeight -> Option$.MODULE$.option2Iterable(this.activeChain().mcHashByMcHeight(BoxesRunTime.unboxToInt((Object)mainchainHeight))), Seq$.MODULE$.canBuildFrom());
    }

    public Option<MainchainHeaderInfo> getBestMainchainHeaderInfo() {
        return this.getMainchainHeaderInfoByHeight(this.activeChain().heightOfMcHeaders());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainHeaderInfo)this.getMainchainHeaderInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainHeaderInfo> getMainchainHeaderInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcHeadersHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Option<MainchainBlockReferenceDataInfo> getBestMainchainBlockReferenceDataInfo() {
        return this.getMainchainBlockReferenceDataInfoByHeight(this.activeChain().heightOfMcReferencesData());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHeight(int mainchainHeight) {
        return this.activeChain().mcHashByMcHeight(mainchainHeight).map((Function1 & Serializable & scala.Serializable)mcHash -> (MainchainBlockReferenceDataInfo)this.getMainchainBlockReferenceDataInfoByHash(package$.MODULE$.wrapperToByteArray((ByteArrayWrapper)mcHash)).get());
    }

    public Option<MainchainBlockReferenceDataInfo> getMainchainBlockReferenceDataInfoByHash(byte[] mainchainHeaderHash) {
        ByteArrayWrapper mcHash = io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(mainchainHeaderHash);
        return this.activeChain().mcRefDataHeightByMcHash(mcHash).flatMap((Function1 & Serializable & scala.Serializable)mcHeight -> AbstractHistoryStorage.$anonfun$getMainchainBlockReferenceDataInfoByHash$1(this, mcHash, BoxesRunTime.unboxToInt((Object)mcHeight)));
    }

    public Try<S> update(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(block != null, (Function0 & Serializable & scala.Serializable)() -> "Block must be NOT NULL.");
            String string = block.parentId();
            String string2 = blockInfo.parentId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Passed BlockInfo data conflicts to passed Block.");
            ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>> toUpdate = new ArrayList<Pair<ByteArrayWrapper, ByteArrayWrapper>>();
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes())));
            toUpdate.add(new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())), new ByteArrayWrapper(block.bytes())));
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), toUpdate, new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> updateFeePaymentsInfo(String blockId, FPI feePaymentsInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.feePaymentsInfoKey(blockId)), new ByteArrayWrapper(feePaymentsInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Option<FPI> getFeePaymentsInfo(String blockId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.get(this.feePaymentsInfoKey(blockId)))).flatMap((Function1 & Serializable & scala.Serializable)baw -> $this.feePaymentsInfoSerializer.parseBytesTry(baw.data()).toOption());
    }

    public ModifierSemanticValidity semanticValidity(String blockId) {
        ModifierSemanticValidity.Absent$ absent$;
        Option<SidechainBlockInfo> option = this.blockInfoOptionById(blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            SidechainBlockInfo info = (SidechainBlockInfo)some.value();
            absent$ = info.semanticValidity();
        } else if (None$.MODULE$.equals(option)) {
            absent$ = ModifierSemanticValidity.Absent$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return absent$;
    }

    public Try<S> updateSemanticValidity(PM block, ModifierSemanticValidity status) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            SidechainBlockInfo oldInfo = (SidechainBlockInfo)this.activeChain().blockInfoById(block.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockInfoById(block.id()));
            ModifierSemanticValidity x$1 = status;
            int x$2 = oldInfo.copy$default$1();
            long x$3 = oldInfo.copy$default$2();
            String x$4 = oldInfo.copy$default$3();
            long x$5 = oldInfo.copy$default$4();
            Seq<MainchainHeaderBaseInfo> x$6 = oldInfo.copy$default$6();
            Seq<ByteArrayWrapper> x$7 = oldInfo.copy$default$7();
            WithdrawalEpochInfo x$8 = oldInfo.copy$default$8();
            Option<VrfOutput> x$9 = oldInfo.copy$default$9();
            String x$10 = oldInfo.copy$default$10();
            SidechainBlockInfo blockInfo = oldInfo.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10);
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(new ByteArrayWrapper(this.blockInfoKey(block.id())), new ByteArrayWrapper(blockInfo.bytes()))}), new ArrayList<ByteArrayWrapper>());
            return this;
        });
    }

    public Try<S> setAsBestBlock(PM block, SidechainBlockInfo blockInfo) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            $this.storage.update(new ByteArrayWrapper(Utils.nextVersion()), Arrays.asList((Object[])new Pair[]{new Pair<ByteArrayWrapper, ByteArrayWrapper>(this.bestBlockIdKey(), new ByteArrayWrapper(sparkz.util.package$.MODULE$.idToBytes(block.id())))}), new ArrayList<ByteArrayWrapper>());
            Option mainchainParent = block.mainchainHeaders().headOption().map((Function1 & Serializable & scala.Serializable)header -> io.horizen.chain.package$.MODULE$.byteArrayToMainchainHeaderHash(header.hashPrevBlock()));
            this.activeChain().setBestBlock(block.id(), blockInfo, (Option<ByteArrayWrapper>)mainchainParent);
            return this;
        });
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public Option<ByteArrayWrapper> lastVersionId() {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.storage.lastVersionID()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderByHash$2(byte[] mainchainHeaderHash$2, MainchainHeader header) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$2)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(header.hash()));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainReferenceDataByHash$2(byte[] mainchainHeaderHash$3, MainchainBlockReferenceData data) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(mainchainHeaderHash$3)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(data.headerHash()));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$1, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)headerContainingId -> $this.activeChain().idByMcReferenceData(mcHash$1).flatMap((Function1 & Serializable & scala.Serializable)dataContainingId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$1).map((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.buildMainchainBlockReferenceInfo(mcHash$1, (MainchainHeaderMetadata)mcMetadata, mcHeight, (String)headerContainingId, (String)dataContainingId))));
    }

    public static final /* synthetic */ boolean $anonfun$getMainchainHeaderInfoByHash$5(ByteArrayWrapper mcHash$2, MainchainHeaderBaseInfo info) {
        return info.hash().equals(mcHash$2);
    }

    public static final /* synthetic */ Option $anonfun$getMainchainHeaderInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$2, int mcHeight) {
        return $this.activeChain().idByMcHeader(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)sidechainBlockId -> $this.activeChain().mcHeaderMetadataByMcHash(mcHash$2).flatMap((Function1 & Serializable & scala.Serializable)mcMetadata -> $this.activeChain().blockInfoById((String)sidechainBlockId).flatMap((Function1 & Serializable & scala.Serializable)blockInfo -> blockInfo.mainchainHeaderBaseInfo().find((Function1 & Serializable & scala.Serializable)info -> BoxesRunTime.boxToBoolean((boolean)AbstractHistoryStorage.$anonfun$getMainchainHeaderInfoByHash$5(mcHash$2, info))).map((Function1 & Serializable & scala.Serializable)mainchainBaseInfo -> new MainchainHeaderInfo(mcHash$2, mcMetadata.getParentId(), mcHeight, (String)sidechainBlockId, mainchainBaseInfo.cumulativeCommTreeHash())))));
    }

    public static final /* synthetic */ Option $anonfun$getMainchainBlockReferenceDataInfoByHash$1(AbstractHistoryStorage $this, ByteArrayWrapper mcHash$3, int mcHeight) {
        return $this.activeChain().idByMcReferenceData(mcHash$3).map((Function1 & Serializable & scala.Serializable)sidechainBlockId -> new MainchainBlockReferenceDataInfo(mcHash$3, mcHeight, (String)sidechainBlockId));
    }

    public AbstractHistoryStorage(Storage storage, SparkzSerializer<PM> blockSerializer, SparkzSerializer<FPI> feePaymentsInfoSerializer, NetworkParams params) {
        this.storage = storage;
        this.blockSerializer = blockSerializer;
        this.feePaymentsInfoSerializer = feePaymentsInfoSerializer;
        this.params = params;
        SidechainStorageInfo.$init$(this);
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
        Predef$.MODULE$.require(storage != null, (Function0 & Serializable & scala.Serializable)() -> "Storage must be NOT NULL.");
        Predef$.MODULE$.require(blockSerializer != null, (Function0 & Serializable & scala.Serializable)() -> "Block serializer must be NOT NULL.");
        Predef$.MODULE$.require(params != null, (Function0 & Serializable & scala.Serializable)() -> "params must be NOT NULL.");
        this.bestBlockIdKey = new ByteArrayWrapper((byte[])Array$.MODULE$.fill(32, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Byte()));
        this.activeChain = this.loadActiveChain();
    }
}

