/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.proposition;

import io.horizen.proposition.PropositionSerializer;
import io.horizen.proposition.SchnorrProposition;
import java.nio.ByteBuffer;
import sparkz.util.serialization.Reader;
import sparkz.util.serialization.VLQByteBufferReader;
import sparkz.util.serialization.Writer;

public class SchnorrPropositionSerializer
implements PropositionSerializer<SchnorrProposition> {
    private static SchnorrPropositionSerializer serializer = new SchnorrPropositionSerializer();

    private SchnorrPropositionSerializer() {
    }

    public static SchnorrPropositionSerializer getSerializer() {
        return serializer;
    }

    @Override
    public void serialize(SchnorrProposition proposition, Writer writer) {
        writer.putBytes(proposition.pubKeyBytes());
    }

    @Override
    public SchnorrProposition parse(Reader reader) {
        return this.parse(reader, false);
    }

    public SchnorrProposition parse(Reader reader, boolean checkPublicKey) {
        return new SchnorrProposition(reader.getBytes(SchnorrProposition.KEY_LENGTH), checkPublicKey);
    }

    public SchnorrProposition parseBytesAndCheck(byte[] propositionBytes) {
        VLQByteBufferReader bufferReader = new VLQByteBufferReader(ByteBuffer.wrap(propositionBytes));
        return this.parse((Reader)bufferReader, true);
    }
}

