/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.network;

import io.horizen.chain.SidechainBlockInfo;
import io.horizen.history.AbstractHistory;
import sparkz.core.NodeViewHolder;
import sparkz.core.utils.NetworkTimeProvider;

public final class SyncStatusUtil$ {
    public static SyncStatusUtil$ MODULE$;
    private final int calculationThreshold;
    private final double defaultCorrectionParameter;
    private final double averageWeightFromGenesis;
    private final double averageWeightFromHalf;

    static {
        new SyncStatusUtil$();
    }

    private int calculationThreshold() {
        return this.calculationThreshold;
    }

    private double defaultCorrectionParameter() {
        return this.defaultCorrectionParameter;
    }

    private double averageWeightFromGenesis() {
        return this.averageWeightFromGenesis;
    }

    private double averageWeightFromHalf() {
        return this.averageWeightFromHalf;
    }

    public <V extends NodeViewHolder.CurrentView<? extends AbstractHistory<?, ?, ?, ?, ?, ?>, ?, ?, ?>> int calculateEstimatedHighestBlock(V sidechainNodeView, NetworkTimeProvider timeProvider, int consensusSecondsInSlot, long genesisBlockTimestamp, int currentBlockHeight, long currentBlockTimestamp) {
        double d;
        if (currentBlockHeight > this.calculationThreshold()) {
            double blockCorrection;
            long timestampDifference = currentBlockTimestamp - genesisBlockTimestamp;
            double maxBlocksInRangeFromGenesis = (double)timestampDifference / (double)consensusSecondsInSlot;
            double blockCorrectionFromGenesis = (double)currentBlockHeight / maxBlocksInRangeFromGenesis;
            int sidechainHalfHeight = currentBlockHeight / 2;
            String halfBlockId = ((AbstractHistory)sidechainNodeView.history()).getBlockIdByHeight(sidechainHalfHeight).get();
            SidechainBlockInfo halfBlockInfo = ((AbstractHistory)sidechainNodeView.history()).getBlockInfoById(halfBlockId).get();
            timestampDifference = currentBlockTimestamp - halfBlockInfo.timestamp();
            double maxBlocksInRangeFromHalf = (double)timestampDifference / (double)consensusSecondsInSlot;
            double blockCorrectionFromHalf = (double)sidechainHalfHeight / maxBlocksInRangeFromHalf;
            d = blockCorrection = (blockCorrectionFromGenesis * this.averageWeightFromGenesis() + blockCorrectionFromHalf * this.averageWeightFromHalf()) / (this.averageWeightFromGenesis() + this.averageWeightFromHalf());
        } else {
            d = this.defaultCorrectionParameter();
        }
        double blockCorrection = d;
        long currentTime = timeProvider.time() / 1000L;
        long timestampDifference = currentTime - currentBlockTimestamp;
        int estimatedHighestBlock = (int)((double)timestampDifference / (double)consensusSecondsInSlot * blockCorrection) + currentBlockHeight;
        return estimatedHighestBlock;
    }

    private SyncStatusUtil$() {
        MODULE$ = this;
        this.calculationThreshold = 15000;
        this.defaultCorrectionParameter = 0.65;
        this.averageWeightFromGenesis = 0.5;
        this.averageWeightFromHalf = 1.0;
    }
}

