/*
 * Decompiled with CFR 0.152.
 */
package io.horizen.certificatesubmitter.strategies;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.horizen.AbstractState;
import io.horizen.certificatesubmitter.AbstractCertificateSubmitter;
import io.horizen.certificatesubmitter.AbstractCertificateSubmitter$ObsoleteWithdrawalEpochException$;
import io.horizen.certificatesubmitter.strategies.CertificateSubmissionStrategy;
import io.horizen.certificatesubmitter.strategies.SubmissionWindowStatus;
import io.horizen.history.AbstractHistory;
import io.horizen.params.NetworkParams;
import io.horizen.utils.BytesUtils;
import io.horizen.utils.WithdrawalEpochInfo;
import io.horizen.utils.WithdrawalEpochUtils$;
import io.horizen.websocket.client.ChainTopQualityCertificateInfo;
import io.horizen.websocket.client.MainchainNodeChannel;
import io.horizen.websocket.client.MempoolTopQualityCertificateInfo;
import io.horizen.websocket.client.TopQualityCertificates;
import io.horizen.websocket.client.WebsocketErrorResponseException;
import io.horizen.websocket.client.WebsocketInvalidErrorMessageException;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sparkz.util.SparkzLogging;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0004\t\u0001EA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)1\u0007\u0001C\u0001i!)\u0001\b\u0001C!s!9\u0011q\u0003\u0001\u0005B\u0005e\u0001bBA \u0001\u0011%\u0011\u0011\t\u0002\u0011\u0007\u0016\f7/\u001b8h'&$Wm\u00195bS:T!!\u0003\u0006\u0002\u0015M$(/\u0019;fO&,7O\u0003\u0002\f\u0019\u0005!2-\u001a:uS\u001aL7-\u0019;fgV\u0014W.\u001b;uKJT!!\u0004\b\u0002\u000f!|'/\u001b>f]*\tq\"\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001\u00131q\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005A\u0011BA\u000e\t\u0005u\u0019UM\u001d;jM&\u001c\u0017\r^3Tk\nl\u0017n]:j_:\u001cFO]1uK\u001eL\bCA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011)H/\u001b7\u000b\u0003\u0005\naa\u001d9be.T\u0018BA\u0012\u001f\u00055\u0019\u0006/\u0019:lu2{wmZ5oO\u0006\u0001R.Y5oG\"\f\u0017N\\\"iC:tW\r\u001c\t\u0003M-j\u0011a\n\u0006\u0003Q%\naa\u00197jK:$(B\u0001\u0016\r\u0003%9XMY:pG.,G/\u0003\u0002-O\t!R*Y5oG\"\f\u0017N\u001c(pI\u0016\u001c\u0005.\u00198oK2\fa\u0001]1sC6\u001c\bCA\u00182\u001b\u0005\u0001$BA\u0017\r\u0013\t\u0011\u0004GA\u0007OKR<xN]6QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U2t\u0007\u0005\u0002\u001a\u0001!)Ae\u0001a\u0001K!)Qf\u0001a\u0001]\u0005Iq-\u001a;Ti\u0006$Xo]\u000b\u0004u\t;G\u0003B\u001e?In\u0004\"!\u0007\u001f\n\u0005uB!AF*vE6L7o]5p]^Kg\u000eZ8x'R\fG/^:\t\u000b}\"\u0001\u0019\u0001!\u0002\u000f!L7\u000f^8ssB\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019EA1\u0001E\u0005\u0005A\u0015CA#I!\t\u0019b)\u0003\u0002H)\t9aj\u001c;iS:<\u0007gB%P-fcvL\u0019\t\t\u00152sU\u000bW._C6\t1J\u0003\u0002@\u0019%\u0011Qj\u0013\u0002\u0010\u0003\n\u001cHO]1di\"K7\u000f^8ssB\u0011\u0011i\u0014\u0003\n!\n\u000b\t\u0011!A\u0003\u0002E\u00131a\u0018\u00132#\t)%\u000b\u0005\u0002\u0014'&\u0011A\u000b\u0006\u0002\u0004\u0003:L\bCA!W\t%9&)!A\u0001\u0002\u000b\u0005\u0011KA\u0002`II\u0002\"!Q-\u0005\u0013i\u0013\u0015\u0011!A\u0001\u0006\u0003\t&aA0%gA\u0011\u0011\t\u0018\u0003\n;\n\u000b\t\u0011!A\u0003\u0002E\u00131a\u0018\u00135!\t\tu\fB\u0005a\u0005\u0006\u0005\t\u0011!B\u0001#\n\u0019q\fJ\u001b\u0011\u0005\u0005\u0013G!C2C\u0003\u0003\u0005\tQ!\u0001R\u0005\ryFE\u000e\u0005\u0006K\u0012\u0001\rAZ\u0001\u0006gR\fG/\u001a\t\u0003\u0003\u001e$Q\u0001\u001b\u0003C\u0002%\u0014\u0011aU\t\u0003\u000b*\u0004Ta\u001b9tmf\u0004b\u0001\\7peVDX\"\u0001\u0007\n\u00059d!!D!cgR\u0014\u0018m\u0019;Ti\u0006$X\r\u0005\u0002Ba\u0012I\u0011oZA\u0001\u0002\u0003\u0015\t!\u0015\u0002\u0004?\u0012:\u0004CA!t\t%!x-!A\u0001\u0002\u000b\u0005\u0011KA\u0002`Ia\u0002\"!\u0011<\u0005\u0013]<\u0017\u0011!A\u0001\u0006\u0003\t&aA0%sA\u0011\u0011)\u001f\u0003\nu\u001e\f\t\u0011!A\u0003\u0002E\u0013Aa\u0018\u00132a!)A\u0010\u0002a\u0001{\u0006\u0011\u0011\u000e\u001a\t\u0004}\u0006EabA@\u0002\u000e9!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004!\u00051AH]8pizJ\u0011!I\u0005\u0003?\u0001J1!a\u0004\u001f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0005\u0002\u0016\tQQj\u001c3jM&,'/\u00133\u000b\u0007\u0005=a$\u0001\u0007dQ\u0016\u001c7.U;bY&$\u0018\u0010\u0006\u0003\u0002\u001c\u0005\u0005\u0002cA\n\u0002\u001e%\u0019\u0011q\u0004\u000b\u0003\u000f\t{w\u000e\\3b]\"9\u00111E\u0003A\u0002\u0005\u0015\u0012AB:uCR,8\u000f\u0005\u0003\u0002(\u0005eb\u0002BA\u0015\u0003kqA!a\u000b\u000249!\u0011QFA\u0019\u001d\u0011\t\u0019!a\f\n\u0003=I!!\u0004\b\n\u0005-a\u0011bAA\u001c\u0015\u0005a\u0012IY:ue\u0006\u001cGoQ3si&4\u0017nY1uKN+(-\\5ui\u0016\u0014\u0018\u0002BA\u001e\u0003{\u0011\u0001cU5h]\u0006$XO]3t'R\fG/^:\u000b\u0007\u0005]\"\"\u0001\rhKR\u001cUM\u001d;jM&\u001c\u0017\r^3U_B\fV/\u00197jif$B!a\u0011\u0002TA1\u0011QIA%\u0003\u001bj!!a\u0012\u000b\u0005}!\u0012\u0002BA&\u0003\u000f\u00121\u0001\u0016:z!\r\u0019\u0012qJ\u0005\u0004\u0003#\"\"\u0001\u0002'p]\u001eDq!!\u0016\u0007\u0001\u0004\t9&A\u0003fa>\u001c\u0007\u000eE\u0002\u0014\u00033J1!a\u0017\u0015\u0005\rIe\u000e\u001e")
public class CeasingSidechain
implements CertificateSubmissionStrategy,
SparkzLogging {
    private final MainchainNodeChannel mainchainChannel;
    private final NetworkParams params;
    private final Logger logger;

    public Logger log() {
        return SparkzLogging.log$((SparkzLogging)this);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public <H extends AbstractHistory<?, ?, ?, ?, ?, ?>, S extends AbstractState<?, ?, ?, ?>> SubmissionWindowStatus getStatus(H history, S state, String id) {
        WithdrawalEpochInfo withdrawalEpochInfo = history.blockInfoById(id).withdrawalEpochInfo();
        int referencedWithdrawalEpochNumber = withdrawalEpochInfo.epoch() - 1;
        return new SubmissionWindowStatus(referencedWithdrawalEpochNumber, WithdrawalEpochUtils$.MODULE$.inSubmitCertificateWindow(withdrawalEpochInfo, this.params));
    }

    @Override
    public boolean checkQuality(AbstractCertificateSubmitter.SignaturesStatus status) {
        if (status.knownSigs().size() >= this.params.signersThreshold()) {
            Try<Object> try_ = this.getCertificateTopQuality(status.referencedEpoch());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long currentCertificateTopQuality = BoxesRunTime.unboxToLong((Object)success.value());
                if ((long)status.knownSigs().size() > currentCertificateTopQuality) {
                    return true;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    Throwable throwable = e;
                    if (throwable instanceof WebsocketErrorResponseException) {
                        BoxedUnit boxedUnit2;
                        WebsocketErrorResponseException websocketErrorResponseException = (WebsocketErrorResponseException)throwable;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(75).append("Mainchain error occurred while processed top quality certificates request(").append(websocketErrorResponseException).append(")").toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        return true;
                    }
                    if (throwable instanceof AbstractCertificateSubmitter.ObsoleteWithdrawalEpochException) {
                        BoxedUnit boxedUnit3;
                        AbstractCertificateSubmitter.ObsoleteWithdrawalEpochException obsoleteWithdrawalEpochException = (AbstractCertificateSubmitter.ObsoleteWithdrawalEpochException)throwable;
                        if (this.log().underlying().isInfoEnabled()) {
                            this.log().underlying().info(new StringBuilder(35).append("Sidechain is behind the Mainchain(").append(obsoleteWithdrawalEpochException).append(")").toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        return false;
                    }
                    if (throwable instanceof WebsocketInvalidErrorMessageException) {
                        BoxedUnit boxedUnit4;
                        WebsocketInvalidErrorMessageException websocketInvalidErrorMessageException = (WebsocketInvalidErrorMessageException)throwable;
                        if (this.log().underlying().isErrorEnabled()) {
                            this.log().underlying().error(new StringBuilder(62).append("Mainchain error message is inconsistent to SC implementation(").append(websocketInvalidErrorMessageException).append(")").toString());
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        return true;
                    }
                    if (this.log().underlying().isErrorEnabled()) {
                        this.log().underlying().error(new StringBuilder(67).append("Unable to retrieve actual top quality certificates from Mainchain(").append(throwable).append(")").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return false;
                }
                throw new MatchError(try_);
            }
        }
        return false;
    }

    private Try<Object> getCertificateTopQuality(int epoch) {
        return this.mainchainChannel.getTopQualityCertificates(BytesUtils.toHexString(BytesUtils.reverseBytes(this.params.sidechainId()))).map((Function1 & Serializable & scala.Serializable)topQualityCertificates -> BoxesRunTime.boxToLong((long)CeasingSidechain.$anonfun$getCertificateTopQuality$1(epoch, topQualityCertificates)));
    }

    public static final /* synthetic */ long $anonfun$getCertificateTopQuality$1(int epoch$1, TopQualityCertificates topQualityCertificates) {
        long l;
        Some some;
        MempoolTopQualityCertificateInfo mempoolInfo;
        Option option;
        Tuple2 tuple2 = new Tuple2(topQualityCertificates.mempoolCertInfo(), topQualityCertificates.chainCertInfo());
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some && (mempoolInfo = (MempoolTopQualityCertificateInfo)(some = (Some)option).value()).epoch() == epoch$1) {
            l = mempoolInfo.quality();
        } else {
            Some some2;
            ChainTopQualityCertificateInfo chainInfo;
            Option option2;
            Some some3;
            MempoolTopQualityCertificateInfo mempoolInfo2;
            Option option3;
            if (tuple2 != null && (option3 = (Option)tuple2._1()) instanceof Some && (mempoolInfo2 = (MempoolTopQualityCertificateInfo)(some3 = (Some)option3).value()).epoch() > epoch$1) {
                throw new AbstractCertificateSubmitter.ObsoleteWithdrawalEpochException(new StringBuilder(47).append("Requested epoch ").append(epoch$1).append(" is obsolete. Current epoch is ").append(mempoolInfo2.quality()).toString(), AbstractCertificateSubmitter$ObsoleteWithdrawalEpochException$.MODULE$.apply$default$2());
            }
            if (tuple2 != null && (option2 = (Option)tuple2._2()) instanceof Some && (chainInfo = (ChainTopQualityCertificateInfo)(some2 = (Some)option2).value()).epoch() == epoch$1) {
                l = chainInfo.quality();
            } else {
                Some some4;
                ChainTopQualityCertificateInfo chainInfo2;
                Option option4;
                if (tuple2 != null && (option4 = (Option)tuple2._2()) instanceof Some && (chainInfo2 = (ChainTopQualityCertificateInfo)(some4 = (Some)option4).value()).epoch() > epoch$1) {
                    throw new AbstractCertificateSubmitter.ObsoleteWithdrawalEpochException(new StringBuilder(47).append("Requested epoch ").append(epoch$1).append(" is obsolete. Current epoch is ").append(chainInfo2.quality()).toString(), AbstractCertificateSubmitter$ObsoleteWithdrawalEpochException$.MODULE$.apply$default$2());
                }
                l = 0L;
            }
        }
        return l;
    }

    public CeasingSidechain(MainchainNodeChannel mainchainChannel, NetworkParams params) {
        this.mainchainChannel = mainchainChannel;
        this.params = params;
        StrictLogging.$init$((StrictLogging)this);
        SparkzLogging.$init$((SparkzLogging)this);
    }
}

